/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.service.ViewService;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ProcessLogger;
import org.kuali.rice.krad.uif.util.UifUnitTestUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.web.bind.UifServletRequestDataBinder;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.login.DummyLoginForm;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.ModelAndView;

public class ViewLifecycleTest
extends KRADTestCase {
    @BeforeClass
    public static void setUpClass() throws Throwable {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("POST");
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletWebRequest((HttpServletRequest)request));
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        UifUnitTestUtils.establishMockUserSession((String)"admin");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        UifUnitTestUtils.tearDownMockUserSession();
        super.tearDown();
    }

    @Test
    public void testSanity() throws Throwable {
        DummyLoginForm form = new DummyLoginForm();
        this.testFormView((UifFormBase)form, "DummyLoginView");
        View view = form.getView();
        Assert.assertEquals((Object)"LoginPage", (Object)view.getCurrentPage().getId());
        Assert.assertEquals((Object)"Rice-UserName", (Object)ObjectPropertyUtils.getPropertyValue((Object)view, (String)"currentPage.items[0].items[1].items[1].items[1].items[3].id"));
    }

    @Test
    public void testMutability() throws Throwable {
        ViewService viewService = KRADServiceLocatorWeb.getViewService();
        View view = viewService.getViewById("DummyLoginView");
        Group group = ComponentFactory.getGroupWithDisclosureGridLayout();
        group.setId("foo");
        group.setHeaderText("bar");
        group.setItems(new ArrayList());
        view.getItems().add(group);
        Assert.assertSame((Object)group, view.getItems().get(view.getItems().size() - 1));
    }

    @Test
    public void testPagedView() throws Throwable {
        UifFormBase form = new UifFormBase();
        this.testFormView(form, "TestPagedView");
        form.setFormKey(null);
        form.setPageId("TestPagedView-Page2");
        this.testFormView(form, "TestPagedView");
        form.setFormKey(null);
        form.setPageId("TestPagedView-Page3");
        this.testFormView(form, "TestPagedView");
    }

    @Test
    public void testInitializationPhase() throws Throwable {
        ViewService viewService = KRADServiceLocatorWeb.getViewService();
        final View view = viewService.getViewById("TestPagedView");
        final UifFormBase form = new UifFormBase();
        ViewLifecycle.encapsulateLifecycle((View)view, (Object)form, null, (Runnable)new Runnable(){

            @Override
            public void run() {
                View currentView = ViewLifecycle.getView();
                Assert.assertSame((Object)view, (Object)currentView);
                Assert.assertEquals((Object)"TestPagedView", (Object)currentView.getId());
                ProcessLogger.trace((String)"begin-init");
                ViewLifecycle.getHelper().populateViewFromRequestParameters(Collections.emptyMap());
                ProcessLogger.trace((String)"populate-request");
                form.setViewRequestParameters(currentView.getViewRequestParameters());
                ViewLifecycle.getHelper().performCustomViewInitialization((Object)form);
                ViewLifecyclePhase phase = KRADServiceLocatorWeb.getViewLifecyclePhaseBuilder().buildPhase("INITIALIZE", (LifecycleElement)view, null, "", null);
                ViewLifecycle.getProcessor().performPhase(phase);
                ProcessLogger.trace((String)"end-init");
            }
        });
    }

    private UifFormBase testFormView(UifFormBase form, String viewName) throws Throwable {
        ViewService viewService = KRADServiceLocatorWeb.getViewService();
        View view = viewService.getViewById(viewName);
        form.setView(view);
        Assert.assertEquals((Object)"C", (Object)view.getViewStatus());
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("viewId", viewName);
        new UifServletRequestDataBinder((Object)form).bind((ServletRequest)request);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addObject("KualiForm", (Object)form);
        KRADServiceLocatorWeb.getModelAndViewService().prepareView((HttpServletRequest)request, modelAndView);
        view = form.getView();
        Assert.assertEquals((Object)"F", (Object)view.getViewStatus());
        return form;
    }
}

