/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.bind;

import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.maintenance.Maintainable;
import org.kuali.rice.krad.maintenance.MaintainableImpl;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentBase;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.conference.ConferenceSession;
import org.kuali.rice.krad.test.conference.ConferenceSessionForm;
import org.kuali.rice.krad.test.conference.SessionCoordinator;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.web.bind.UifBeanPropertyBindingResult;
import org.kuali.rice.krad.web.bind.UifServletRequestDataBinder;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;
import org.kuali.rice.krad.web.form.UifFormManager;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletWebRequest;

public class UifServletRequestDataBinderIntegrationTest
extends KRADTestCase {
    @Test
    public void testAutoLinking_UsingForeignKey() {
        MaintenanceDocumentForm form = this.buildMaintenanceDocumentForm();
        ViewPostMetadata viewPostMetadata = new ViewPostMetadata();
        form.setViewPostMetadata(viewPostMetadata);
        MaintenanceDocumentBase maintDoc = (MaintenanceDocumentBase)form.getDocument();
        UifServletRequestDataBinder binder = new UifServletRequestDataBinder((Object)form, "form");
        Assert.assertTrue((boolean)binder.isChangeTracking());
        Assert.assertTrue((boolean)binder.isAutoLinking());
        SessionCoordinator sc = new SessionCoordinator();
        sc.setName("admin");
        sc = (SessionCoordinator)this.getDataObjectService().save((Object)sc, new PersistenceOption[0]);
        Assert.assertNotNull((Object)sc.getId());
        ConferenceSession session = (ConferenceSession)maintDoc.getNewMaintainableObject().getDataObject();
        Assert.assertNull((Object)session.getAltCoordinator1());
        MockHttpServletRequest request = this.setupMockRequest();
        String basePath = "document.newMaintainableObject.dataObject.";
        String altCoordIdPath = basePath + "altCoordinator1Id";
        this.addAccessibleRequestParameter(altCoordIdPath, sc.getId().toString(), request, viewPostMetadata);
        binder.bind((ServletRequest)request);
        this.assertAltSessionCoordinator(sc, session);
    }

    @Test
    public void testAutoLinking_UsingIdentity() {
        MaintenanceDocumentForm form = this.buildMaintenanceDocumentForm();
        ViewPostMetadata viewPostMetadata = new ViewPostMetadata();
        form.setViewPostMetadata(viewPostMetadata);
        MaintenanceDocumentBase maintDoc = (MaintenanceDocumentBase)form.getDocument();
        UifServletRequestDataBinder binder = new UifServletRequestDataBinder((Object)form, "form");
        Assert.assertTrue((boolean)binder.isChangeTracking());
        Assert.assertTrue((boolean)binder.isAutoLinking());
        SessionCoordinator sc = new SessionCoordinator();
        sc.setName("admin");
        sc = (SessionCoordinator)this.getDataObjectService().save((Object)sc, new PersistenceOption[0]);
        Assert.assertNotNull((Object)sc.getId());
        ConferenceSession session = (ConferenceSession)maintDoc.getNewMaintainableObject().getDataObject();
        Assert.assertNull((Object)session.getAltCoordinator1());
        MockHttpServletRequest request = this.setupMockRequest();
        String basePath = "document.newMaintainableObject.dataObject.";
        String altCoordIdPath = basePath + "altCoordinator1.id";
        this.addAccessibleRequestParameter(altCoordIdPath, sc.getId().toString(), request, viewPostMetadata);
        binder.bind((ServletRequest)request);
        this.assertAltSessionCoordinator(sc, session);
    }

    @Test
    public void testAutoLinking_ListTarget() {
        ConferenceSessionForm form = new ConferenceSessionForm();
        ViewPostMetadata viewPostMetadata = new ViewPostMetadata();
        form.setViewPostMetadata(viewPostMetadata);
        UifServletRequestDataBinder binder = new UifServletRequestDataBinder((Object)form, "form");
        SessionCoordinator sc = new SessionCoordinator();
        sc.setName("admin");
        sc = (SessionCoordinator)this.getDataObjectService().save((Object)sc, new PersistenceOption[0]);
        Assert.assertNotNull((Object)sc.getId());
        MockHttpServletRequest request = this.setupMockRequest();
        this.addAccessibleRequestParameter("conferenceSessionList[0].altCoordinator1Id", sc.getId().toString(), request, viewPostMetadata);
        this.addAccessibleRequestParameter("conferenceSessionList[1].altCoordinator1Id", sc.getId().toString(), request, viewPostMetadata);
        binder.bind((ServletRequest)request);
        Assert.assertFalse((String)"TestAutoLinking_ListTarget: The conference session list should not be null or empty.", (boolean)form.getConferenceSessionList().isEmpty());
        this.assertAltSessionCoordinator(sc, (ConferenceSession)form.getConferenceSessionList().get(0));
        this.assertAltSessionCoordinator(sc, (ConferenceSession)form.getConferenceSessionList().get(1));
    }

    @Test
    public void testAutoLinking_MapTarget() {
        ConferenceSessionForm form = new ConferenceSessionForm();
        ViewPostMetadata viewPostMetadata = new ViewPostMetadata();
        form.setViewPostMetadata(viewPostMetadata);
        UifServletRequestDataBinder binder = new UifServletRequestDataBinder((Object)form, "form");
        SessionCoordinator sc = new SessionCoordinator();
        sc.setName("admin");
        sc = (SessionCoordinator)this.getDataObjectService().save((Object)sc, new PersistenceOption[0]);
        Assert.assertNotNull((Object)sc.getId());
        MockHttpServletRequest request = this.setupMockRequest();
        this.addAccessibleRequestParameter("conferenceSessionMap['foo1'].altCoordinator1Id", sc.getId().toString(), request, viewPostMetadata);
        this.addAccessibleRequestParameter("conferenceSessionMap['foo2'].altCoordinator1Id", sc.getId().toString(), request, viewPostMetadata);
        binder.bind((ServletRequest)request);
        Assert.assertFalse((String)"TestAutoLinking-MapTarget: The conference session list should not be null or empty.", (boolean)form.getConferenceSessionMap().isEmpty());
        this.assertAltSessionCoordinator(sc, (ConferenceSession)form.getConferenceSessionMap().get("foo1"));
        this.assertAltSessionCoordinator(sc, (ConferenceSession)form.getConferenceSessionMap().get("foo2"));
    }

    @Test
    public void testModifiedPropertyTracking() {
        MaintenanceDocumentForm form = this.buildMaintenanceDocumentForm();
        ViewPostMetadata viewPostMetadata = new ViewPostMetadata();
        form.setViewPostMetadata(viewPostMetadata);
        MaintenanceDocumentBase maintDoc = (MaintenanceDocumentBase)form.getDocument();
        UifServletRequestDataBinder binder = new UifServletRequestDataBinder((Object)form, "form");
        binder.setAutoLinking(false);
        MockHttpServletRequest request = new MockHttpServletRequest();
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletWebRequest((HttpServletRequest)request));
        UifFormManager formManager = new UifFormManager();
        request.getSession().setAttribute("formManager", (Object)formManager);
        String basePath = "document.newMaintainableObject.dataObject.";
        String idPath = basePath + "id";
        String titlePath = basePath + "sessionTitle";
        String altCoordinator1IdPath = basePath + "altCoordinator1Id";
        String altCoordinator1_idPath = basePath + "altCoordinator1.id";
        this.addAccessibleRequestParameter(idPath, "12345", request, viewPostMetadata);
        this.addAccessibleRequestParameter(titlePath, "My New ConferenceSession", request, viewPostMetadata);
        this.addAccessibleRequestParameter(altCoordinator1IdPath, null, request, viewPostMetadata);
        this.addAccessibleRequestParameter(altCoordinator1_idPath, "1", request, viewPostMetadata);
        binder.bind((ServletRequest)request);
        ConferenceSession session = (ConferenceSession)maintDoc.getNewMaintainableObject().getDataObject();
        Assert.assertEquals((Object)"12345", (Object)session.getId());
        Assert.assertEquals((Object)"My New ConferenceSession", (Object)session.getSessionTitle());
        Assert.assertNull((Object)session.getAltCoordinator1Id());
        Assert.assertNotNull((Object)session.getAltCoordinator1());
        Assert.assertEquals((Object)1L, (Object)session.getAltCoordinator1().getId());
        Assert.assertTrue((boolean)session.getAltCoordinator1().getAltCoordinatedSessions1().isEmpty());
        UifBeanPropertyBindingResult result = (UifBeanPropertyBindingResult)binder.getInternalBindingResult();
        Set modifiedPaths = result.getModifiedPaths();
        Assert.assertTrue((boolean)modifiedPaths.contains(idPath));
        Assert.assertTrue((boolean)modifiedPaths.contains(titlePath));
        Assert.assertTrue((boolean)modifiedPaths.contains(altCoordinator1_idPath));
        Assert.assertFalse((boolean)modifiedPaths.contains(altCoordinator1IdPath));
        Assert.assertEquals((long)3L, (long)modifiedPaths.size());
        binder = new UifServletRequestDataBinder((Object)form, "form");
        binder.bind((ServletRequest)request);
        result = (UifBeanPropertyBindingResult)binder.getInternalBindingResult();
        modifiedPaths = result.getModifiedPaths();
        Assert.assertEquals((long)0L, (long)modifiedPaths.size());
        binder = new UifServletRequestDataBinder((Object)form, "form");
        request.setParameter(altCoordinator1IdPath, "2");
        binder.bind((ServletRequest)request);
        Assert.assertEquals((Object)2L, (Object)session.getAltCoordinator1Id());
        result = (UifBeanPropertyBindingResult)binder.getInternalBindingResult();
        modifiedPaths = result.getModifiedPaths();
        Assert.assertEquals((long)1L, (long)modifiedPaths.size());
        Assert.assertTrue((boolean)modifiedPaths.contains(altCoordinator1IdPath));
    }

    private MaintenanceDocumentForm buildMaintenanceDocumentForm() {
        MaintenanceDocumentForm form = new MaintenanceDocumentForm();
        MaintenanceDocumentBase document = new MaintenanceDocumentBase();
        ConferenceSession session = new ConferenceSession();
        MaintainableImpl oldMaintainable = new MaintainableImpl();
        oldMaintainable.setDataObject((Object)session);
        MaintainableImpl newMaintainable = new MaintainableImpl();
        newMaintainable.setDataObject((Object)session);
        document.setOldMaintainableObject((Maintainable)oldMaintainable);
        document.setNewMaintainableObject((Maintainable)newMaintainable);
        document.setDocumentNumber(UUID.randomUUID().toString());
        form.setDocument((MaintenanceDocument)document);
        return form;
    }

    protected void addAccessibleRequestParameter(String parameterKey, String parameterValue, MockHttpServletRequest request, ViewPostMetadata viewPostMetadata) {
        request.addParameter(parameterKey, parameterValue);
        viewPostMetadata.addAccessibleBindingPath(parameterKey);
    }

    protected MockHttpServletRequest setupMockRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletWebRequest((HttpServletRequest)request));
        UifFormManager formManager = new UifFormManager();
        request.getSession().setAttribute("formManager", (Object)formManager);
        return request;
    }

    protected void assertAltSessionCoordinator(SessionCoordinator sc, ConferenceSession conferenceSession) {
        Assert.assertEquals((Object)sc.getId(), (Object)conferenceSession.getAltCoordinator1Id());
        Assert.assertNotNull((Object)conferenceSession.getAltCoordinator1());
        Assert.assertEquals((Object)sc.getId(), (Object)conferenceSession.getAltCoordinator1().getId());
        Assert.assertEquals((Object)"admin", (Object)conferenceSession.getAltCoordinator1().getName());
    }

    private DataObjectService getDataObjectService() {
        return KradDataServiceLocator.getDataObjectService();
    }
}

