/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.CriteriaLookupService;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.criteria.CriteriaLookupDao;
import org.kuali.rice.krad.criteria.CriteriaLookupDaoProxy;
import org.kuali.rice.krad.criteria.CriteriaLookupServiceImpl;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBinding;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBindingContract;
import org.kuali.rice.krms.impl.repository.ReferenceObjectBindingBo;
import org.kuali.rice.krms.impl.repository.ReferenceObjectBindingBoServiceImpl;
import org.kuali.rice.krms.impl.repository.ReferenceObjectBindingBoServiceImplGenTest;
import org.kuali.rice.krms.test.AbstractBoTest;

public final class ReferenceObjectBindingIntegrationGenTest
extends AbstractBoTest {
    ReferenceObjectBindingBoServiceImpl referenceObjectBindingBoServiceImpl;
    ReferenceObjectBinding referenceObjectBinding;

    ReferenceObjectBinding getReferenceObjectBinding() {
        return this.referenceObjectBinding;
    }

    @Before
    public void setup() {
        this.referenceObjectBindingBoServiceImpl = new ReferenceObjectBindingBoServiceImpl();
        this.referenceObjectBindingBoServiceImpl.setBusinessObjectService(this.getBoService());
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findReferenceObjectBindingsByCollectionName_null_fail() {
        ReferenceObjectBindingBoServiceImplGenTest.create((ReferenceObjectBindingBoServiceImpl)this.referenceObjectBindingBoServiceImpl).test_findReferenceObjectBindingsByCollectionName_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findReferenceObjectBindingsByKrmsDiscriminatorType_null_fail() {
        ReferenceObjectBindingBoServiceImplGenTest.create((ReferenceObjectBindingBoServiceImpl)this.referenceObjectBindingBoServiceImpl).test_findReferenceObjectBindingsByKrmsDiscriminatorType_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findReferenceObjectBindingsByKrmsObject_null_fail() {
        ReferenceObjectBindingBoServiceImplGenTest.create((ReferenceObjectBindingBoServiceImpl)this.referenceObjectBindingBoServiceImpl).test_findReferenceObjectBindingsByKrmsObject_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findReferenceObjectBindingsByNamespace_null_fail() {
        ReferenceObjectBindingBoServiceImplGenTest.create((ReferenceObjectBindingBoServiceImpl)this.referenceObjectBindingBoServiceImpl).test_findReferenceObjectBindingsByNamespace_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findReferenceObjectBindingsByReferenceDiscriminatorType_null_fail() {
        ReferenceObjectBindingBoServiceImplGenTest.create((ReferenceObjectBindingBoServiceImpl)this.referenceObjectBindingBoServiceImpl).test_findReferenceObjectBindingsByReferenceDiscriminatorType_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findReferenceObjectBindingsByReferenceObject_null_fail() {
        ReferenceObjectBindingBoServiceImplGenTest.create((ReferenceObjectBindingBoServiceImpl)this.referenceObjectBindingBoServiceImpl).test_findReferenceObjectBindingsByReferenceObject_null_fail();
    }

    @Test
    public void test_from_null_yields_null() {
        ReferenceObjectBindingBoServiceImplGenTest.create((ReferenceObjectBindingBoServiceImpl)this.referenceObjectBindingBoServiceImpl).test_from_null_yields_null();
    }

    @Test
    public void test_to() {
        ReferenceObjectBindingBoServiceImplGenTest.create((ReferenceObjectBindingBoServiceImpl)this.referenceObjectBindingBoServiceImpl).test_to();
    }

    @Test
    public void test_createReferenceObjectBinding() {
        ReferenceObjectBindingBoServiceImplGenTest test = ReferenceObjectBindingBoServiceImplGenTest.create((ReferenceObjectBindingBoServiceImpl)this.referenceObjectBindingBoServiceImpl);
        test.test_createReferenceObjectBinding();
        this.referenceObjectBinding = test.getReferenceObjectBinding();
        assert (this.referenceObjectBinding != null);
        assert (this.referenceObjectBinding.getId() != null);
    }

    @Test(expected=IllegalStateException.class)
    public void test_createReferenceObjectBinding_fail_existing() {
        this.test_createReferenceObjectBinding();
        this.test_createReferenceObjectBinding();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_createReferenceObjectBinding_null_fail() {
        ReferenceObjectBindingBoServiceImplGenTest.create((ReferenceObjectBindingBoServiceImpl)this.referenceObjectBindingBoServiceImpl).test_createReferenceObjectBinding_null_fail();
    }

    @Test
    public void test_getReferenceObjectBinding() {
        this.test_createReferenceObjectBinding();
        ReferenceObjectBinding def = this.getReferenceObjectBinding();
        ReferenceObjectBinding def2 = this.referenceObjectBindingBoServiceImpl.getReferenceObjectBinding(def.getId());
        assert (def2 != null);
        assert (def2.equals((Object)def));
    }

    @Test
    public void test_updateReferenceObjectBinding() {
        this.test_createReferenceObjectBinding();
        ReferenceObjectBinding def = this.getReferenceObjectBinding();
        String id = def.getId();
        assert (!"UpdateTest".equals(def.getCollectionName()));
        ReferenceObjectBindingBo bo = this.referenceObjectBindingBoServiceImpl.from(def);
        bo.setCollectionName("UpdateTest");
        this.referenceObjectBindingBoServiceImpl.updateReferenceObjectBinding(ReferenceObjectBinding.Builder.create((ReferenceObjectBindingContract)bo).build());
        ReferenceObjectBinding def2 = this.referenceObjectBindingBoServiceImpl.getReferenceObjectBinding(id);
        assert ("UpdateTest".equals(def2.getCollectionName()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_updateReferenceObjectBinding_null_fail() {
        ReferenceObjectBindingBoServiceImplGenTest.create((ReferenceObjectBindingBoServiceImpl)this.referenceObjectBindingBoServiceImpl).test_updateReferenceObjectBinding_null_fail();
    }

    @Test
    public void test_deleteReferenceObjectBinding() {
        this.test_createReferenceObjectBinding();
        ReferenceObjectBinding def = this.getReferenceObjectBinding();
        String id = def.getId();
        this.referenceObjectBindingBoServiceImpl.deleteReferenceObjectBinding(id);
        ReferenceObjectBinding def2 = this.referenceObjectBindingBoServiceImpl.getReferenceObjectBinding(id);
        assert (def2 == null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_deleteReferenceObjectBinding_null_fail() {
        ReferenceObjectBindingBoServiceImplGenTest.create((ReferenceObjectBindingBoServiceImpl)this.referenceObjectBindingBoServiceImpl).test_deleteReferenceObjectBinding_null_fail();
    }

    @Test
    public void test_Find() {
        QueryByCriteria.Builder query = QueryByCriteria.Builder.create();
        query.setPredicates(new Predicate[]{PredicateFactory.equal((String)"id", (Object)"ID")});
        CriteriaLookupServiceImpl criteria = new CriteriaLookupServiceImpl();
        criteria.setCriteriaLookupDao((CriteriaLookupDao)new CriteriaLookupDaoProxy());
        this.referenceObjectBindingBoServiceImpl.setCriteriaLookupService((CriteriaLookupService)criteria);
        assert (this.referenceObjectBindingBoServiceImpl.findReferenceObjectBindingIds(query.build()).isEmpty());
        this.test_createReferenceObjectBinding();
        assert (!this.referenceObjectBindingBoServiceImpl.findReferenceObjectBindingIds(query.build()).isEmpty());
        assert ("ID".equals(this.referenceObjectBindingBoServiceImpl.findReferenceObjectBindingIds(query.build()).get(0)));
    }
}

