/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.typerelation.RelationshipType;
import org.kuali.rice.krms.api.repository.typerelation.TypeTypeRelation;
import org.kuali.rice.krms.api.repository.typerelation.TypeTypeRelationContract;
import org.kuali.rice.krms.impl.repository.KrmsTypeBoServiceImpl;
import org.kuali.rice.krms.impl.repository.KrmsTypeIntegrationGenTest;
import org.kuali.rice.krms.impl.repository.TypeTypeRelationBo;
import org.kuali.rice.krms.impl.repository.TypeTypeRelationBoServiceImpl;
import org.kuali.rice.krms.impl.repository.TypeTypeRelationBoServiceImplGenTest;
import org.kuali.rice.krms.test.AbstractBoTest;

public final class TypeTypeRelationIntegrationGenTest
extends AbstractBoTest {
    TypeTypeRelationBoServiceImpl typeTypeRelationBoServiceImpl;
    TypeTypeRelation typeTypeRelation;
    KrmsTypeBoServiceImpl krmsTypeBoServiceImpl;

    TypeTypeRelation getTypeTypeRelation() {
        return this.typeTypeRelation;
    }

    @Before
    public void setup() {
        this.typeTypeRelationBoServiceImpl = new TypeTypeRelationBoServiceImpl();
        this.typeTypeRelationBoServiceImpl.setBusinessObjectService(this.getBoService());
        this.krmsTypeBoServiceImpl = new KrmsTypeBoServiceImpl();
        this.krmsTypeBoServiceImpl.setBusinessObjectService(this.getBoService());
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findTypeTypeRelationsByFromType_null_fail() {
        TypeTypeRelationBoServiceImplGenTest.create((TypeTypeRelationBoServiceImpl)this.typeTypeRelationBoServiceImpl).test_findTypeTypeRelationsByFromType_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findTypeTypeRelationsByToType_null_fail() {
        TypeTypeRelationBoServiceImplGenTest.create((TypeTypeRelationBoServiceImpl)this.typeTypeRelationBoServiceImpl).test_findTypeTypeRelationsByToType_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findTypeTypeRelationsByRelationshipType_null_fail() {
        TypeTypeRelationBoServiceImplGenTest.create((TypeTypeRelationBoServiceImpl)this.typeTypeRelationBoServiceImpl).test_findTypeTypeRelationsByRelationshipType_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findTypeTypeRelationsBySequenceNumber_null_fail() {
        TypeTypeRelationBoServiceImplGenTest.create((TypeTypeRelationBoServiceImpl)this.typeTypeRelationBoServiceImpl).test_findTypeTypeRelationsBySequenceNumber_null_fail();
    }

    @Test
    public void test_from_null_yields_null() {
        TypeTypeRelationBoServiceImplGenTest.create((TypeTypeRelationBoServiceImpl)this.typeTypeRelationBoServiceImpl).test_from_null_yields_null();
    }

    @Test
    public void test_to() {
        TypeTypeRelationBoServiceImplGenTest.create((TypeTypeRelationBoServiceImpl)this.typeTypeRelationBoServiceImpl).test_to();
    }

    @Test
    public void test_createTypeTypeRelation() {
        KrmsTypeIntegrationGenTest krmsTypeTest = new KrmsTypeIntegrationGenTest();
        krmsTypeTest.setup();
        krmsTypeTest.test_createKrmsType();
        KrmsTypeDefinition krmsType = krmsTypeTest.getKrmsType();
        TypeTypeRelationBoServiceImplGenTest test = TypeTypeRelationBoServiceImplGenTest.create((TypeTypeRelationBoServiceImpl)this.typeTypeRelationBoServiceImpl);
        test.createTypeTypeRelation(krmsType, krmsType);
        this.typeTypeRelation = test.getTypeTypeRelation();
        assert (this.typeTypeRelation != null);
        assert (this.typeTypeRelation.getId() != null);
    }

    @Test(expected=IllegalStateException.class)
    public void test_createTypeTypeRelation_fail_existing() {
        this.test_createTypeTypeRelation();
        this.test_createTypeTypeRelation();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_createTypeTypeRelation_null_fail() {
        TypeTypeRelationBoServiceImplGenTest.create((TypeTypeRelationBoServiceImpl)this.typeTypeRelationBoServiceImpl).test_createTypeTypeRelation_null_fail();
    }

    @Test
    public void test_getTypeTypeRelation() {
        this.test_createTypeTypeRelation();
        TypeTypeRelation def = this.getTypeTypeRelation();
        TypeTypeRelation def2 = this.typeTypeRelationBoServiceImpl.getTypeTypeRelation(def.getId());
        assert (def2 != null);
        assert (def2.equals((Object)def));
    }

    @Test
    public void test_updateTypeTypeRelation() {
        this.test_createTypeTypeRelation();
        TypeTypeRelation def = this.getTypeTypeRelation();
        String id = def.getId();
        assert (!RelationshipType.USAGE_ALLOWED.equals((Object)def.getRelationshipType()));
        TypeTypeRelationBo bo = this.typeTypeRelationBoServiceImpl.from(def);
        bo.setRelationshipType(RelationshipType.USAGE_ALLOWED);
        this.typeTypeRelationBoServiceImpl.updateTypeTypeRelation(TypeTypeRelation.Builder.create((TypeTypeRelationContract)bo).build());
        TypeTypeRelation def2 = this.typeTypeRelationBoServiceImpl.getTypeTypeRelation(id);
        assert (RelationshipType.USAGE_ALLOWED.equals((Object)def2.getRelationshipType()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_updateTypeTypeRelation_null_fail() {
        TypeTypeRelationBoServiceImplGenTest.create((TypeTypeRelationBoServiceImpl)this.typeTypeRelationBoServiceImpl).test_updateTypeTypeRelation_null_fail();
    }

    @Test
    public void test_deleteTypeTypeRelation() {
        this.test_createTypeTypeRelation();
        TypeTypeRelation def = this.getTypeTypeRelation();
        String id = def.getId();
        this.typeTypeRelationBoServiceImpl.deleteTypeTypeRelation(id);
        TypeTypeRelation def2 = this.typeTypeRelationBoServiceImpl.getTypeTypeRelation(id);
        assert (def2 == null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_deleteTypeTypeRelation_null_fail() {
        TypeTypeRelationBoServiceImplGenTest.create((TypeTypeRelationBoServiceImpl)this.typeTypeRelationBoServiceImpl).test_deleteTypeTypeRelation_null_fail();
    }
}

