/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.Collections;
import java.util.HashMap;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.impl.repository.ActionBoService;
import org.kuali.rice.krms.impl.repository.ActionBoServiceImpl;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaBoService;
import org.kuali.rice.krms.impl.repository.AgendaBoServiceImpl;
import org.kuali.rice.krms.impl.repository.ContextBoServiceImpl;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.PropositionBoService;
import org.kuali.rice.krms.impl.repository.PropositionBoServiceImpl;
import org.kuali.rice.krms.impl.repository.RuleBoService;
import org.kuali.rice.krms.impl.repository.RuleBoServiceImpl;
import org.kuali.rice.krms.impl.repository.TermBoService;
import org.kuali.rice.krms.impl.repository.TermBoServiceImpl;
import org.kuali.rice.krms.impl.ui.AgendaEditor;
import org.kuali.rice.krms.impl.ui.AgendaEditorMaintainable;
import org.kuali.rice.krms.test.AbstractBoTest;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class AgendaEditorMaintainableIntegrationTest
extends AbstractBoTest {
    static final String NAMESPACE1 = "AEMIT_KRMS_TEST_1";
    static final String CONTEXT1 = "AEMIT_Context1";
    static final String CONTEXT1_QUALIFIER = "Context1Qualifier";
    static final String CONTEXT1_QUALIFIER_VALUE = "BLAH1";
    static final String AGENDA1 = "TestAgenda1";
    private PropositionBoService propositionBoService;
    private TermBoService termBoService;
    private AgendaBoService agendaBoService;
    private RuleBoService ruleBoService;
    private ActionBoService actionBoService;

    @Before
    public void setup() {
        this.krmsAttributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        this.krmsTypeRepository = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
        this.propositionBoService = new PropositionBoServiceImpl();
        ((PropositionBoServiceImpl)this.propositionBoService).setBusinessObjectService(this.getBoService());
        this.termBoService = new TermBoServiceImpl();
        ((TermBoServiceImpl)this.termBoService).setBusinessObjectService(this.getBoService());
        this.contextRepository = new ContextBoServiceImpl();
        ((ContextBoServiceImpl)this.contextRepository).setBusinessObjectService(this.getBoService());
        this.agendaBoService = new AgendaBoServiceImpl();
        ((AgendaBoServiceImpl)this.agendaBoService).setBusinessObjectService(this.getBoService());
        ((AgendaBoServiceImpl)this.agendaBoService).setAttributeDefinitionService(this.krmsAttributeDefinitionService);
        this.ruleBoService = new RuleBoServiceImpl();
        ((RuleBoServiceImpl)this.ruleBoService).setBusinessObjectService(this.getBoService());
        this.actionBoService = new ActionBoServiceImpl();
        ((ActionBoServiceImpl)this.actionBoService).setBusinessObjectService(this.getBoService());
    }

    @Test
    public void testEmptyAgendaDelete() {
        ContextDefinition contextDefintion1 = this.createContextDefinition(NAMESPACE1, CONTEXT1, Collections.singletonMap(CONTEXT1_QUALIFIER, CONTEXT1_QUALIFIER_VALUE));
        this.createAgendaDefinition(AGENDA1, "AgendaLabel", contextDefintion1);
        AgendaDefinition agendaDefinition = this.agendaBoService.getAgendaByNameAndContextId(AGENDA1, contextDefintion1.getId());
        this.lookupAndSaveDataObject(agendaDefinition);
    }

    private void lookupAndSaveDataObject(AgendaDefinition agendaDefinition) {
        AgendaBo blah = this.findAgendaByPrimaryKey(agendaDefinition);
        AgendaEditorMaintainable aem = new AgendaEditorMaintainable();
        AgendaEditor ae = new AgendaEditor();
        ae.setAgenda(blah);
        aem.setDataObject((Object)ae);
        aem.saveDataObject();
    }

    private AgendaBo findAgendaByPrimaryKey(AgendaDefinition agendaDefinition) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("id", agendaDefinition.getId());
        return (AgendaBo)this.getBoService().findByPrimaryKey(AgendaBo.class, primaryKeys);
    }

    private void createAgendaDefinition(String agendaName, String agendaLabel, ContextDefinition contextDefinition) {
        KrmsTypeDefinition krmsGenericTypeDefinition = this.createKrmsGenericTypeDefinition(contextDefinition.getNamespace(), "testAgendaTypeService", agendaName, agendaLabel);
        AgendaDefinition agendaDefinition = AgendaDefinition.Builder.create(null, (String)agendaName, (String)krmsGenericTypeDefinition.getId(), (String)contextDefinition.getId()).build();
        agendaDefinition = this.agendaBoService.createAgenda(agendaDefinition);
        this.agendaBoService.updateAgenda(agendaDefinition);
        AgendaBo blah = this.findAgendaByPrimaryKey(agendaDefinition);
        AgendaDefinition.Builder agendaDefBuilder1 = AgendaDefinition.Builder.create((AgendaDefinitionContract)this.agendaBoService.to(blah));
        agendaDefinition = agendaDefBuilder1.build();
        this.agendaBoService.updateAgenda(agendaDefinition);
    }
}

