/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.test.AbstractAgendaBoTest;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.util.CollectionUtils;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class AgendaBoServiceTest
extends AbstractAgendaBoTest {
    private static final String NULL = new String("null");

    private static <A> A nullConvertingGet(List<A> list, int index) {
        A result = list.get(index);
        if (result == NULL) {
            result = null;
        }
        return result;
    }

    @Test
    public void testGetByContextId() {
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendasByContextId("#$^$ BogusContextId !@#$")));
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendaItemsByContext("#$^$ BogusContextId !@#$")));
        for (String contextName : Arrays.asList("Context1", "Context2", "Context3")) {
            String contextId = this.getContextRepository().getContextByNameAndNamespace(contextName, this.getNamespaceByContextName(contextName)).getId();
            List agendas = this.getAgendaBoService().getAgendasByContextId(contextId);
            List agendaItems = this.getAgendaBoService().getAgendaItemsByContext(contextId);
            Assert.assertEquals((String)("agenda count doesn't match our tally for context " + contextName), (long)agendas.size(), (long)this.getBoService().countMatching(AgendaBo.class, Collections.singletonMap("contextId", contextId)));
            int totalAgendaItems = 0;
            HashSet<String> agendaIds = new HashSet<String>();
            for (AgendaDefinition agenda : agendas) {
                Assert.assertEquals((String)("agenda w/ ID " + agenda.getId() + " has a context ID that doesn't match"), (Object)agenda.getContextId(), (Object)contextId);
                totalAgendaItems += this.getBoService().countMatching(AgendaItemBo.class, Collections.singletonMap("agendaId", agenda.getId()));
                agendaIds.add(agenda.getId());
            }
            for (AgendaItemDefinition agendaItem : agendaItems) {
                Assert.assertTrue((String)("agenda item is not part of any agendas in " + contextName), (boolean)agendaIds.contains(agendaItem.getAgendaId()));
            }
            Assert.assertEquals((String)"number of agenda items doesn't match our tally", (long)agendaItems.size(), (long)totalAgendaItems);
        }
    }

    @Test
    public void testGetAgendasByContextId_nullOrBlank() {
        for (String contextId : Arrays.asList(null, "", " ")) {
            try {
                this.getAgendaBoService().getAgendasByContextId(contextId);
                Assert.fail((String)("getAgendasByContextId should have thrown " + RiceIllegalArgumentException.class.getSimpleName() + " for invalid contextId=" + contextId + "."));
            }
            catch (RiceIllegalArgumentException riceIllegalArgumentException) {}
        }
    }

    @Test
    public void testGetAgendaItemsByContextId_nullOrBlank() {
        for (String contextId : Arrays.asList(null, "", " ")) {
            try {
                this.getAgendaBoService().getAgendaItemsByContext(contextId);
                Assert.fail((String)("getAgendaItemsByContext should have thrown " + RiceIllegalArgumentException.class.getSimpleName() + " for invalid contextId=" + contextId + "."));
            }
            catch (RiceIllegalArgumentException riceIllegalArgumentException) {}
        }
    }

    @Test
    public void testGetByType() {
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendasByType("#$^$ BogusTypeId !@#$")));
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendaItemsByType("#$^$ BogusTypeId !@#$")));
        List<KrmsTypeDefinition> agendaTypes = this.getAgendaTypesForContexts(Arrays.asList("Context1", "Context2", "Context3"));
        Assert.assertTrue((String)"We must have some types to test with or we prove nothing", (agendaTypes.size() > 0 ? 1 : 0) != 0);
        for (KrmsTypeDefinition agendaType : agendaTypes) {
            String typeName = agendaType.getName();
            String typeNamespace = agendaType.getNamespace();
            KrmsTypeDefinition type = this.getKrmsTypeRepository().getTypeByName(typeNamespace, typeName);
            List agendas = this.getAgendaBoService().getAgendasByType(type.getId());
            List agendaItems = this.getAgendaBoService().getAgendaItemsByType(type.getId());
            Assert.assertEquals((String)("agenda count doesn't match our tally for type " + typeNamespace + ":" + typeName), (long)agendas.size(), (long)this.getBoService().countMatching(AgendaBo.class, Collections.singletonMap("typeId", type.getId())));
            int totalAgendaItems = 0;
            HashSet<String> agendaIds = new HashSet<String>();
            for (AgendaDefinition agenda : agendas) {
                Assert.assertEquals((String)("agenda w/ ID " + agenda.getTypeId() + " has a type ID that doesn't match"), (Object)agenda.getTypeId(), (Object)type.getId());
                totalAgendaItems += this.getBoService().countMatching(AgendaItemBo.class, Collections.singletonMap("agendaId", agenda.getId()));
                agendaIds.add(agenda.getId());
            }
            for (AgendaItemDefinition agendaItem : agendaItems) {
                Assert.assertTrue((String)("agenda item is not part of any agendas in type " + typeNamespace + ":" + typeName), (boolean)agendaIds.contains(agendaItem.getAgendaId()));
            }
            Assert.assertEquals((String)"number of agenda items doesn't match our tally", (long)agendaItems.size(), (long)totalAgendaItems);
        }
    }

    private List<KrmsTypeDefinition> getAgendaTypesForContexts(List<String> contextNames) {
        ArrayList<KrmsTypeDefinition> results = new ArrayList<KrmsTypeDefinition>();
        for (String contextName : contextNames) {
            String namespace = this.getNamespaceByContextName(contextName);
            if (StringUtils.isBlank((String)namespace)) {
                throw new RiceRuntimeException("namespace is " + namespace + " for context with name " + contextName);
            }
            String contextId = this.getContextRepository().getContextByNameAndNamespace(contextName, namespace).getId();
            List agendas = this.getAgendaBoService().getAgendasByContextId(contextId);
            if (CollectionUtils.isEmpty((Collection)agendas)) continue;
            for (AgendaDefinition agenda : agendas) {
                KrmsTypeDefinition type;
                if (agenda.getTypeId() == null || results.contains(type = this.getKrmsTypeRepository().getTypeById(agenda.getTypeId()))) continue;
                results.add(type);
            }
        }
        return results;
    }

    @Test
    public void testGetAgendasByType_nullOrBlank() {
        for (String contextId : Arrays.asList(null, "", " ")) {
            try {
                this.getAgendaBoService().getAgendasByType(contextId);
                Assert.fail((String)("getAgendasByType should have thrown " + RiceIllegalArgumentException.class.getSimpleName() + " for invalid contextId=" + contextId + "."));
            }
            catch (RiceIllegalArgumentException riceIllegalArgumentException) {}
        }
    }

    @Test
    public void testGetAgendaItemsByType_nullOrBlank() {
        for (String contextId : Arrays.asList(null, "", " ")) {
            try {
                this.getAgendaBoService().getAgendaItemsByType(contextId);
                Assert.fail((String)("getAgendaItemsByType should have thrown " + RiceIllegalArgumentException.class.getSimpleName() + " for invalid contextId=" + contextId + "."));
            }
            catch (RiceIllegalArgumentException riceIllegalArgumentException) {}
        }
    }

    @Test
    public void testGetByTypeAndContext() {
        boolean testedSomeTypes = false;
        for (String contextName : Arrays.asList("Context1", "Context2", "Context3")) {
            List<KrmsTypeDefinition> agendaTypes = this.getAgendaTypesForContexts(Collections.singletonList(contextName));
            ContextDefinition context = this.getContextRepository().getContextByNameAndNamespace(contextName, this.getNamespaceByContextName(contextName));
            for (KrmsTypeDefinition agendaType : agendaTypes) {
                testedSomeTypes = true;
                Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendasByTypeAndContext("#$^$ BogusTypeId !@#$", context.getId())));
                Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendaItemsByTypeAndContext("#$^$ BogusTypeId !@#$", context.getId())));
                Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendasByTypeAndContext(agendaType.getId(), "#$^$ BogusContextId !@#$")));
                Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendaItemsByTypeAndContext(agendaType.getId(), "#$^$ BogusContextId !@#$")));
                List agendas = this.getAgendaBoService().getAgendasByTypeAndContext(agendaType.getId(), context.getId());
                List agendaItems = this.getAgendaBoService().getAgendaItemsByTypeAndContext(agendaType.getId(), context.getId());
                HashMap<String, String> agendaCountCrit = new HashMap<String, String>();
                agendaCountCrit.put("typeId", agendaType.getId());
                agendaCountCrit.put("contextId", context.getId());
                Assert.assertEquals((String)("agenda count doesn't match our tally for type " + agendaType.getNamespace() + ":" + agendaType.getName()), (long)agendas.size(), (long)this.getBoService().countMatching(AgendaBo.class, agendaCountCrit));
                int totalAgendaItems = 0;
                HashSet<String> agendaIds = new HashSet<String>();
                for (AgendaDefinition agenda : agendas) {
                    Assert.assertEquals((String)("agenda w/ ID " + agenda.getTypeId() + " has a type ID that doesn't match"), (Object)agenda.getTypeId(), (Object)agendaType.getId());
                    totalAgendaItems += this.getBoService().countMatching(AgendaItemBo.class, Collections.singletonMap("agendaId", agenda.getId()));
                    agendaIds.add(agenda.getId());
                }
                for (AgendaItemDefinition agendaItem : agendaItems) {
                    String assertionString = "agenda item is not part of any agendas in type " + agendaType.getNamespace() + ":" + agendaType.getName() + " and context " + context.getNamespace() + ":" + context.getName();
                    Assert.assertTrue((String)assertionString, (boolean)agendaIds.contains(agendaItem.getAgendaId()));
                }
                Assert.assertEquals((String)"number of agenda items doesn't match our tally", (long)agendaItems.size(), (long)totalAgendaItems);
            }
            Assert.assertTrue((String)"We have to test some types or we prove nothing", (boolean)testedSomeTypes);
        }
    }

    @Test
    public void testGetAgendaItemsByTypeAndContext_nullOrBlank() {
        HashSet<String> emptyValues = new HashSet<String>();
        emptyValues.addAll(Arrays.asList(NULL, "", " "));
        Sets.SetView oneNonBlank = Sets.union(emptyValues, Collections.singleton("fakeId"));
        Sets.SetView testIds = Sets.union((Set)Sets.cartesianProduct((Set[])new Set[]{emptyValues, oneNonBlank}), (Set)Sets.cartesianProduct((Set[])new Set[]{oneNonBlank, emptyValues}));
        for (List ids : testIds) {
            try {
                this.getAgendaBoService().getAgendaItemsByTypeAndContext((String)AgendaBoServiceTest.nullConvertingGet(ids, 0), (String)AgendaBoServiceTest.nullConvertingGet(ids, 1));
                Assert.fail((String)("getAgendaItemsByType should have thrown " + RiceIllegalArgumentException.class.getSimpleName() + " for invalid combo of contextId=" + ids + "."));
            }
            catch (RiceIllegalArgumentException riceIllegalArgumentException) {}
        }
    }

    @Test
    public void testAgendaCrud() {
        ContextDefinition context = this.getContextRepository().getContextByNameAndNamespace("Context1", this.getNamespaceByContextName("Context1"));
        List agendas = this.getAgendaBoService().getAgendasByContextId(context.getId());
        AgendaDefinition templateAgenda = (AgendaDefinition)agendas.get(0);
        AgendaDefinition.Builder agendaBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)templateAgenda);
        agendaBuilder.setFirstItemId(null);
        agendaBuilder.setId(null);
        agendaBuilder.setVersionNumber(null);
        agendaBuilder.setName("testAgendaCrud-agenda");
        AgendaDefinition newAgenda = this.getAgendaBoService().createAgenda(agendaBuilder.build());
        Assert.assertNotNull((Object)newAgenda);
        Assert.assertEquals((Object)newAgenda, (Object)this.getAgendaBoService().getAgendaByAgendaId(newAgenda.getId()));
    }
}

