/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.krms.api.KrmsApiServiceLocator;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.ExecutionFlag;
import org.kuali.rice.krms.api.engine.ExecutionOptions;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.engine.ResultEvent;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.impl.repository.ActionBoService;
import org.kuali.rice.krms.impl.repository.FunctionBoServiceImpl;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.test.AbstractAgendaBoTest;
import org.kuali.rice.krms.test.TestActionTypeService;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.transaction.annotation.Transactional;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class RepositoryCreateAndExecuteIntegrationTest
extends AbstractAgendaBoTest {
    static final String NAME = "name";
    static final String PREREQ_TERM_VALUE = "prereqValue";
    static final String NAMESPACE_CODE = "namespaceCode";
    static boolean localInitNeeded = true;

    @Override
    @Before
    public void setup() {
        TestActionTypeService.resetActionsFired();
        this.termBoService = KrmsRepositoryServiceLocator.getTermBoService();
        this.contextRepository = KrmsRepositoryServiceLocator.getContextBoService();
        this.krmsTypeRepository = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
        this.ruleBoService = KrmsRepositoryServiceLocator.getRuleBoService();
        this.agendaBoService = KrmsRepositoryServiceLocator.getAgendaBoService();
        this.actionBoService = (ActionBoService)KrmsRepositoryServiceLocator.getBean((String)"actionBoService");
        this.functionBoService = (FunctionBoServiceImpl)KrmsRepositoryServiceLocator.getBean((String)"functionRepositoryService");
        this.krmsAttributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        ContextDefinition contextDefintion1 = this.contextRepository.getContextByNameAndNamespace("Context1", "KRMS_TEST_1");
        if (contextDefintion1 == null || localInitNeeded) {
            localInitNeeded = false;
            PerformanceLogger perfLog = new PerformanceLogger();
            perfLog.log("starting agenda creation");
            contextDefintion1 = this.createContextDefinition("KRMS_TEST_1", "Context1", Collections.singletonMap("Context1Qualifier", "BLAH1"));
            this.createAgendaDefinition("TestAgenda1", contextDefintion1, "Tsunami", "KRMS_TEST_1");
            ContextDefinition contextDefinition2 = this.createContextDefinition("KRMS_TEST_2", "Context2", Collections.singletonMap("Context2Qualifier", "BLAH2"));
            ContextDefinition contextDefinition3 = this.createContextDefinition("KRMS_TEST_1", "Context3", Collections.emptyMap());
            this.createAgendaDefinition("Agenda2", contextDefinition2, "Earthquake", "KRMS_TEST_2");
            this.createAgendaDefinition("Agenda3", contextDefinition2, "Earthquake", "KRMS_TEST_2");
            this.createAgendaDefinition("Agenda4", contextDefinition2, "Tsunami", "KRMS_TEST_2");
            this.createAgendaDefinition2("Agenda5", contextDefinition3, "KRMS_TEST_1");
            perfLog.log("finished agenda creation", true);
        }
    }

    @Transactional
    @Test
    public void testNullFact() {
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        contextQualifiers.put(NAMESPACE_CODE, "KRMS_TEST_1");
        contextQualifiers.put(NAME, "Context3");
        HashMap<String, String> agendaQualifiers = new HashMap<String, String>();
        agendaQualifiers.put(NAME, "Agenda5");
        DateTime now = new DateTime();
        SelectionCriteria sc1 = SelectionCriteria.createCriteria((DateTime)now, contextQualifiers, agendaQualifiers);
        Facts.Builder factsBuilder1 = Facts.Builder.create();
        factsBuilder1.addFact("nullFact", null);
        ExecutionOptions xOptions1 = new ExecutionOptions();
        xOptions1.setFlag(ExecutionFlag.LOG_EXECUTION, true);
        PerformanceLogger perfLog = new PerformanceLogger();
        perfLog.log("starting rule execution");
        EngineResults eResults1 = KrmsApiServiceLocator.getEngine().execute(sc1, factsBuilder1.build(), xOptions1);
        perfLog.log("finished rule execution", true);
        List<ResultEvent> rEvents1 = this.executeEngileResults(eResults1);
        List ruleEvaluationResults1 = eResults1.getResultsOfType("Rule Evaluated".toString());
        Assert.assertEquals((String)"1 rules should have been evaluated", (long)1L, (long)ruleEvaluationResults1.size());
        Assert.assertTrue((String)"rule 0 should have evaluated to true", (boolean)((ResultEvent)ruleEvaluationResults1.get(0)).getResult());
        Assert.assertTrue((boolean)TestActionTypeService.actionFired("Agenda5::Rule5::TestAction"));
        this.assertAgendaDidNotExecute("TestAgenda1");
        this.assertAgendaDidNotExecute("Agenda2");
        this.assertAgendaDidNotExecute("Agenda3");
        this.assertAgendaDidNotExecute("Agenda4");
    }

    @Transactional
    @Test
    public void testSelectAgendaByAttributeAndName() {
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        contextQualifiers.put(NAMESPACE_CODE, "KRMS_TEST_1");
        contextQualifiers.put(NAME, "Context1");
        contextQualifiers.put("Context1Qualifier", "BLAH1");
        HashMap<String, String> agendaQualifiers = new HashMap<String, String>();
        agendaQualifiers.put("Event", "Tsunami");
        agendaQualifiers.put(NAME, "TestAgenda1");
        DateTime now = new DateTime();
        SelectionCriteria sc1 = SelectionCriteria.createCriteria((DateTime)now, contextQualifiers, Collections.singletonMap("Event", "Tsunami"));
        Facts.Builder factsBuilder1 = Facts.Builder.create();
        factsBuilder1.addFact("campusCodeTermSpec", (Object)"BL");
        factsBuilder1.addFact("bool1", (Object)"true");
        factsBuilder1.addFact("bool2", (Object)Boolean.TRUE);
        factsBuilder1.addFact("prereqTermSpec", (Object)PREREQ_TERM_VALUE);
        ExecutionOptions xOptions1 = new ExecutionOptions();
        xOptions1.setFlag(ExecutionFlag.LOG_EXECUTION, true);
        PerformanceLogger perfLog = new PerformanceLogger();
        perfLog.log("starting rule execution");
        EngineResults eResults1 = KrmsApiServiceLocator.getEngine().execute(sc1, factsBuilder1.build(), xOptions1);
        perfLog.log("finished rule execution", true);
        List<ResultEvent> rEvents1 = this.executeEngileResults(eResults1);
        List ruleEvaluationResults1 = eResults1.getResultsOfType("Rule Evaluated".toString());
        Assert.assertEquals((String)"4 rules should have been evaluated", (long)4L, (long)ruleEvaluationResults1.size());
        Assert.assertTrue((String)"rule 0 should have evaluated to true", (boolean)((ResultEvent)ruleEvaluationResults1.get(0)).getResult());
        Assert.assertFalse((String)"rule 1 should have evaluated to false", (boolean)((ResultEvent)ruleEvaluationResults1.get(1)).getResult());
        Assert.assertTrue((String)"rule 2 should have evaluated to true", (boolean)((ResultEvent)ruleEvaluationResults1.get(2)).getResult());
        Assert.assertTrue((boolean)TestActionTypeService.actionFired("TestAgenda1::Rule1::TestAction"));
        Assert.assertFalse((boolean)TestActionTypeService.actionFired("TestAgenda1::Rule2::TestAction"));
        Assert.assertTrue((boolean)TestActionTypeService.actionFired("TestAgenda1::Rule3::TestAction"));
        this.assertAgendaDidNotExecute("Agenda2");
        this.assertAgendaDidNotExecute("Agenda3");
        this.assertAgendaDidNotExecute("Agenda4");
        this.assertAgendaDidNotExecute("Agenda5");
    }

    @Transactional
    @Test
    public void testSelectAgendaByName() {
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        contextQualifiers.put(NAMESPACE_CODE, "KRMS_TEST_2");
        contextQualifiers.put(NAME, "Context2");
        contextQualifiers.put("Context2Qualifier", "BLAH2");
        HashMap<String, String> agendaQualifiers = new HashMap<String, String>();
        agendaQualifiers.put(NAME, "Agenda3");
        DateTime now = new DateTime();
        SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria((DateTime)now, contextQualifiers, agendaQualifiers);
        Facts.Builder factsBuilder2 = Facts.Builder.create();
        factsBuilder2.addFact("bool1", (Object)"true");
        factsBuilder2.addFact("bool2", (Object)Boolean.TRUE);
        factsBuilder2.addFact("campusCodeTermSpec", (Object)"BL");
        factsBuilder2.addFact("prereqTermSpec", (Object)PREREQ_TERM_VALUE);
        ExecutionOptions xOptions2 = new ExecutionOptions();
        xOptions2.setFlag(ExecutionFlag.LOG_EXECUTION, true);
        PerformanceLogger perfLog = new PerformanceLogger();
        perfLog.log("starting rule execution 1");
        EngineResults eResults1 = KrmsApiServiceLocator.getEngine().execute(selectionCriteria, factsBuilder2.build(), xOptions2);
        perfLog.log("finished rule execution 1");
        List<ResultEvent> rEvents1 = this.executeEngileResults(eResults1);
        List ruleEvaluationResults1 = eResults1.getResultsOfType("Rule Evaluated".toString());
        selectionCriteria = SelectionCriteria.createCriteria((DateTime)now, contextQualifiers, agendaQualifiers);
        Assert.assertEquals((String)"4 rules should have been evaluated", (long)4L, (long)ruleEvaluationResults1.size());
        this.assertAgendaDidNotExecute("TestAgenda1");
        this.assertAgendaDidNotExecute("Agenda2");
        Assert.assertTrue((boolean)TestActionTypeService.actionFired("Agenda3::Rule1::TestAction"));
        Assert.assertFalse((boolean)TestActionTypeService.actionFired("Agenda3::Rule2::TestAction"));
        Assert.assertTrue((boolean)TestActionTypeService.actionFired("Agenda3::Rule3::TestAction"));
        this.assertAgendaDidNotExecute("Agenda4");
        this.assertAgendaDidNotExecute("Agenda5");
    }

    @Transactional
    @Test
    public void testSelectMultipleAgendasByAttribute() {
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        contextQualifiers.put(NAMESPACE_CODE, "KRMS_TEST_2");
        contextQualifiers.put(NAME, "Context2");
        contextQualifiers.put("Context2Qualifier", "BLAH2");
        HashMap<String, String> agendaQualifiers = new HashMap<String, String>();
        agendaQualifiers.put("Event", "Earthquake");
        DateTime now = new DateTime();
        SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria((DateTime)now, contextQualifiers, agendaQualifiers);
        Facts.Builder factsBuilder2 = Facts.Builder.create();
        factsBuilder2.addFact("bool1", (Object)"true");
        factsBuilder2.addFact("bool2", (Object)Boolean.TRUE);
        factsBuilder2.addFact("campusCodeTermSpec", (Object)"BL");
        factsBuilder2.addFact("prereqTermSpec", (Object)PREREQ_TERM_VALUE);
        ExecutionOptions xOptions2 = new ExecutionOptions();
        xOptions2.setFlag(ExecutionFlag.LOG_EXECUTION, true);
        PerformanceLogger perfLog = new PerformanceLogger();
        perfLog.log("starting rule execution 1");
        EngineResults eResults1 = KrmsApiServiceLocator.getEngine().execute(selectionCriteria, factsBuilder2.build(), xOptions2);
        perfLog.log("finished rule execution 1");
        List<ResultEvent> rEvents1 = this.executeEngileResults(eResults1);
        List ruleEvaluationResults1 = eResults1.getResultsOfType("Rule Evaluated".toString());
        selectionCriteria = SelectionCriteria.createCriteria((DateTime)now, contextQualifiers, agendaQualifiers);
        Assert.assertEquals((String)"8 rules should have been evaluated", (long)8L, (long)ruleEvaluationResults1.size());
        this.assertAgendaDidNotExecute("TestAgenda1");
        Assert.assertTrue((boolean)TestActionTypeService.actionFired("Agenda2::Rule1::TestAction"));
        Assert.assertFalse((boolean)TestActionTypeService.actionFired("Agenda2::Rule2::TestAction"));
        Assert.assertTrue((boolean)TestActionTypeService.actionFired("Agenda2::Rule3::TestAction"));
        Assert.assertTrue((boolean)TestActionTypeService.actionFired("Agenda3::Rule1::TestAction"));
        Assert.assertFalse((boolean)TestActionTypeService.actionFired("Agenda3::Rule2::TestAction"));
        Assert.assertTrue((boolean)TestActionTypeService.actionFired("Agenda3::Rule3::TestAction"));
        this.assertAgendaDidNotExecute("Agenda4");
        this.assertAgendaDidNotExecute("Agenda5");
    }

    private List<ResultEvent> executeEngileResults(EngineResults eResults1) {
        try {
            return eResults1.getAllResults();
        }
        catch (NullPointerException npe) {
            Assert.fail((String)("https://jira.kuali.org/browse/KULRICE-8625 KRMS RepositoryCreateAndExecuteIntegrationTest fails with NPE in CI passes locally." + ExceptionUtils.getStackTrace((Throwable)npe)));
            return null;
        }
    }

    private void assertAgendaDidNotExecute(String agendaName) {
        Assert.assertFalse((boolean)TestActionTypeService.actionFired(agendaName + "::Rule1::TestAction"));
        Assert.assertFalse((boolean)TestActionTypeService.actionFired(agendaName + "::Rule2::TestAction"));
        Assert.assertFalse((boolean)TestActionTypeService.actionFired(agendaName + "::Rule3::TestAction"));
    }
}

