/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeEntryDefinitionContract;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.impl.repository.RuleManagementServiceImpl;
import org.kuali.rice.krms.test.RuleManagementBaseTest;
import org.kuali.rice.krms.test.RuleManagementBaseTestObjectNames;
import org.springmodules.orm.ojb.OjbOperationException;

public class RuleManagementAgendaTest
extends RuleManagementBaseTest {
    @Override
    @Before
    public void setClassDiscriminator() {
        this.CLASS_DISCRIMINATOR = "RMAT";
    }

    @Test
    public void testCreateAgenda() {
        RuleManagementBaseTestObjectNames t0 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t0");
        String ruleId = this.buildTestRuleDefinition(t0.namespaceName, t0.object0).getId();
        String agendaId = this.createTestAgenda(t0.object0, true).getId();
        this.buildTestAgendaItemDefinition(t0.agendaItem_Id, agendaId, ruleId);
        AgendaDefinition agendaDefinition = this.ruleManagementService.getAgenda(agendaId);
        Assert.assertTrue((String)"Created agenda is not active", (boolean)agendaDefinition.isActive());
        Assert.assertEquals((String)"Expected Context not found", (Object)t0.contextId, (Object)agendaDefinition.getContextId());
        Assert.assertEquals((String)"Expected AgendaId not found", (Object)t0.agenda_Id, (Object)agendaDefinition.getId());
        Assert.assertEquals((String)"Expected AgendaItemId not found", (Object)t0.agendaItem_0_Id, (Object)agendaDefinition.getFirstItemId());
        Assert.assertEquals((String)"Expected Rule of AgendaItem not found", (Object)t0.rule_0_Id, (Object)this.ruleManagementService.getAgendaItem(agendaDefinition.getFirstItemId()).getRule().getId());
    }

    @Test
    public void testGetAgendaByNameAndContextId() {
        RuleManagementBaseTestObjectNames t1 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t1");
        String ruleId = this.buildTestRuleDefinition(t1.namespaceName, t1.object0).getId();
        String agendaId = this.createTestAgenda(t1.object0).getId();
        this.buildTestAgendaItemDefinition(t1.agendaItem_Id, agendaId, ruleId);
        AgendaDefinition agendaDefinition = this.ruleManagementService.getAgendaByNameAndContextId(t1.agenda_Name, t1.contextId);
        Assert.assertEquals((String)"Invalid agendaId name found", (Object)t1.agenda_Id, (Object)agendaDefinition.getId());
        Assert.assertEquals((String)"Invalid contextId found", (Object)t1.contextId, (Object)agendaDefinition.getContextId());
        Assert.assertEquals((String)"Invalid typeId found", (Object)t1.typeId, (Object)agendaDefinition.getTypeId());
        Assert.assertEquals((String)"Incorrect agendaName found", (Object)t1.agenda_Name, (Object)agendaDefinition.getName());
        Assert.assertEquals((String)"Invalid agendaFirstItemId found", (Object)t1.agendaItem_0_Id, (Object)agendaDefinition.getFirstItemId());
        agendaDefinition = this.ruleManagementService.getAgendaByNameAndContextId(t1.agenda_Name, "badContext");
        Assert.assertNull((String)"Invalid Context, no agendas should have been found", (Object)agendaDefinition);
        agendaDefinition = this.ruleManagementService.getAgendaByNameAndContextId("badName", t1.contextId);
        Assert.assertNull((String)"Invalid Name, no agendas should have been found", (Object)agendaDefinition);
        try {
            agendaDefinition = this.ruleManagementService.getAgendaByNameAndContextId(null, t1.contextId);
            Assert.fail((String)"Null Name specified for search, should have thrown .RiceIllegalArgumentException: name is blank ");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        try {
            agendaDefinition = this.ruleManagementService.getAgendaByNameAndContextId(t1.agenda_Name, null);
            Assert.fail((String)"Null Context specified for search, should have thrown .RiceIllegalArgumentException: contextId is blank");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFindCreateAgenda() {
        RuleManagementBaseTestObjectNames t2 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t2");
        ContextDefinition.Builder contextDefinitionBuilder = ContextDefinition.Builder.create((String)t2.namespaceName, (String)t2.contextName);
        contextDefinitionBuilder.setId(t2.contextId);
        ContextDefinition contextDefinition = contextDefinitionBuilder.build();
        contextDefinition = this.ruleManagementService.findCreateContext(contextDefinition);
        Assert.assertNull((String)"Agenda should not have already existed", (Object)this.ruleManagementService.getAgenda(t2.agendaItem_0_Id));
        AgendaDefinition.Builder agendaBuilder = AgendaDefinition.Builder.create((String)t2.agenda_Id, (String)t2.agenda_Name, null, (String)t2.contextId);
        AgendaDefinition agenda = agendaBuilder.build();
        agenda = this.ruleManagementService.findCreateAgenda(agenda);
        Assert.assertNotNull((String)"Agenda should have been created", (Object)this.ruleManagementService.getAgenda(t2.agenda_Id));
        agendaBuilder = AgendaDefinition.Builder.create((String)t2.agenda_Id, (String)"ChangedName", null, (String)t2.contextId);
        agenda = agendaBuilder.build();
        try {
            agenda = this.ruleManagementService.findCreateAgenda(agenda);
            Assert.fail((String)"should have failed with OjbOperationException: OJB operation failed");
        }
        catch (OjbOperationException ojbOperationException) {
            // empty catch block
        }
        AgendaItemDefinition agendaItem = this.buildTestAgendaItemDefinition("AINew" + t2.action0, t2.agenda_Id, null);
        agendaBuilder = AgendaDefinition.Builder.create((String)t2.agenda_Id, (String)t2.agenda_Name, (String)t2.typeId, (String)t2.contextId);
        agendaBuilder.setFirstItemId(agendaItem.getId());
        agenda = this.ruleManagementService.findCreateAgenda(agendaBuilder.build());
        Assert.assertEquals((String)"Agenda should have been changed by findCreateAgenda", (Object)("AINew" + t2.action0), (Object)this.ruleManagementService.getAgenda(t2.agenda_Id).getFirstItemId());
    }

    @Test
    public void testGetAgenda() {
        RuleManagementBaseTestObjectNames t3 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t3");
        AgendaDefinition agendaDefinition = this.createTestAgenda(t3.object0);
        Assert.assertEquals((String)"Agenda not found", (Object)t3.agenda_Name, (Object)this.ruleManagementService.getAgenda(t3.agenda_Id).getName());
        try {
            this.ruleManagementService.getAgenda(null);
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: agenda id is null or blank");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.getAgenda("  ");
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: agenda id is null or blank");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((String)"Agenda should not have been found", (Object)this.ruleManagementService.getAgenda("badAgendaId"));
    }

    @Test
    public void testGetAgendasByContext() {
        RuleManagementBaseTestObjectNames t4 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t4");
        this.createTestAgenda(t4.object0);
        RuleManagementBaseTestObjectNames t5 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t5");
        this.createTestAgenda(t5.object0);
        AgendaDefinition.Builder agendaBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)this.ruleManagementService.getAgenda(t5.agenda_Id));
        agendaBuilder.setContextId(t4.contextId);
        this.ruleManagementService.updateAgenda(agendaBuilder.build());
        List agendas = this.ruleManagementService.getAgendasByContext(t4.contextId);
        Assert.assertEquals((String)"Incorrect number of Agendas returned", (long)2L, (long)agendas.size());
        List<String> agendaIds = Arrays.asList(t4.agenda_Id, t5.agenda_Id);
        int agendasFound = 0;
        for (AgendaDefinition agenda : agendas) {
            if (!agendaIds.contains(agenda.getId())) continue;
            ++agendasFound;
        }
        Assert.assertEquals((String)"Incorrect results of getAgendasByContext", (long)2L, (long)agendasFound);
        try {
            this.ruleManagementService.getAgendasByContext(null);
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: context ID is null or blank");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.getAgendasByContext("   ");
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: context ID is null or blank");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"No Agenda's should have been found", (long)0L, (long)this.ruleManagementService.getAgendasByContext("badContextId").size());
    }

    @Test
    public void testUpdateAgenda() {
        RuleManagementBaseTestObjectNames t6 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t6");
        this.createTestAgenda(t6.object0, true);
        KrmsTypeDefinition krmsType = this.createKrmsTypeDefinition(null, t6.namespaceName, "AGENDA", null);
        AgendaDefinition.Builder agendaBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)this.ruleManagementService.getAgenda(t6.agenda_Id));
        String attrKey = (String)agendaBuilder.getAttributes().entrySet().iterator().next().getKey();
        String newAttrValue = "newAttrVal" + t6.object0;
        agendaBuilder.setAttributes(Collections.singletonMap(attrKey, newAttrValue));
        agendaBuilder.setActive(false);
        this.ruleManagementService.updateAgenda(agendaBuilder.build());
        Assert.assertEquals((String)"Updated agenda attribute not found", (Object)newAttrValue, this.ruleManagementService.getAgenda(t6.agenda_Id).getAttributes().get(attrKey));
        Assert.assertEquals((String)"Agenda should have been changed to inActive", (Object)false, (Object)this.ruleManagementService.getAgenda(t6.agenda_Id).isActive());
    }

    @Test
    public void testDeleteAgenda() {
        RuleManagementBaseTestObjectNames t7 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t7");
        Assert.assertNull((String)"Agenda should not yet exist", (Object)this.ruleManagementService.getAgenda(t7.agenda_Id));
        AgendaDefinition agendaDefinition = this.createTestAgenda(t7.object0, true);
        Assert.assertNotNull((String)"Agenda should exist", (Object)this.ruleManagementService.getAgenda(t7.agenda_Id));
        this.ruleManagementService.deleteAgenda(t7.agenda_Id);
        Assert.assertNull((String)"Agenda should not exist after deletion", (Object)this.ruleManagementService.getAgenda(t7.agenda_Id));
        try {
            this.ruleManagementService.deleteAgenda("junkAgenda");
            Assert.fail((String)"Should have failed with IllegalStateException: the Agenda to delete does not exists");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.deleteAgenda(null);
            Assert.fail((String)"Should have failed with .RiceIllegalArgumentException: agendaId is null");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAgendasByType() {
        RuleManagementBaseTestObjectNames t8 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t8");
        this.createTestAgenda(t8.object0);
        RuleManagementBaseTestObjectNames t9 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t9");
        this.createTestAgenda(t9.object0);
        KrmsTypeDefinition krmsType = this.createKrmsTypeDefinition(null, t8.namespaceName, t8.namespaceType, null);
        AgendaDefinition.Builder agendaBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)this.ruleManagementService.getAgenda(t8.agenda_Id));
        agendaBuilder.setTypeId(krmsType.getId());
        this.ruleManagementService.updateAgenda(agendaBuilder.build());
        agendaBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)this.ruleManagementService.getAgenda(t9.agenda_Id));
        agendaBuilder.setTypeId(krmsType.getId());
        this.ruleManagementService.updateAgenda(agendaBuilder.build());
        List agendas = this.ruleManagementService.getAgendasByType(krmsType.getId());
        Assert.assertEquals((String)"Incorrect number of Agendas returned", (long)2L, (long)agendas.size());
        List<String> agendaIds = Arrays.asList(t8.agenda_Id, t9.agenda_Id);
        int agendasFound = 0;
        for (AgendaDefinition agenda : agendas) {
            if (!agendaIds.contains(agenda.getId())) continue;
            ++agendasFound;
        }
        Assert.assertEquals((String)"Incorrect results of getAgendasByContext", (long)2L, (long)agendasFound);
    }

    @Test
    public void testGetAgendasByTypeAndContext() {
        RuleManagementBaseTestObjectNames t10 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t10");
        this.createTestAgenda(t10.object0);
        RuleManagementBaseTestObjectNames t11 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t11");
        this.createTestAgenda(t11.object0);
        KrmsTypeDefinition krmsType = this.createKrmsTypeDefinition(null, t10.namespaceName, t10.namespaceType, null);
        AgendaDefinition.Builder agendaBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)this.ruleManagementService.getAgenda(t10.agenda_Id));
        agendaBuilder.setTypeId(krmsType.getId());
        this.ruleManagementService.updateAgenda(agendaBuilder.build());
        agendaBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)this.ruleManagementService.getAgenda(t11.agenda_Id));
        agendaBuilder.setTypeId(krmsType.getId());
        agendaBuilder.setContextId(this.ruleManagementService.getAgenda(t10.agenda_Id).getContextId());
        this.ruleManagementService.updateAgenda(agendaBuilder.build());
        List agendas = this.ruleManagementService.getAgendasByTypeAndContext(krmsType.getId(), t10.contextId);
        Assert.assertEquals((String)"Incorrect number of Agendas returned", (long)2L, (long)agendas.size());
        List<String> agendaIds = Arrays.asList(t10.agenda_Id, t11.agenda_Id);
        int agendasFound = 0;
        for (AgendaDefinition agenda : agendas) {
            if (!agendaIds.contains(agenda.getId())) continue;
            ++agendasFound;
        }
        Assert.assertEquals((String)"Incorrect results of getAgendasByTypeAndContext", (long)2L, (long)agendasFound);
    }

    @Test
    public void testFindAgendaIds() {
        RuleManagementBaseTestObjectNames t12 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t12");
        this.createTestAgenda(t12.object0);
        RuleManagementBaseTestObjectNames t13 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t13");
        this.createTestAgenda(t13.object0);
        RuleManagementBaseTestObjectNames t14 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t14");
        this.createTestAgenda(t14.object0);
        KrmsTypeDefinition krmsType = this.createKrmsTypeDefinition(null, t12.namespaceName, t12.namespaceType, null);
        AgendaDefinition.Builder agendaBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)this.ruleManagementService.getAgenda(t12.agenda_Id));
        agendaBuilder.setTypeId(krmsType.getId());
        this.ruleManagementService.updateAgenda(agendaBuilder.build());
        agendaBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)this.ruleManagementService.getAgenda(t13.agenda_Id));
        agendaBuilder.setTypeId(krmsType.getId());
        agendaBuilder.setContextId(this.ruleManagementService.getAgenda(t12.agenda_Id).getContextId());
        this.ruleManagementService.updateAgenda(agendaBuilder.build());
        agendaBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)this.ruleManagementService.getAgenda(t14.agenda_Id));
        agendaBuilder.setTypeId(krmsType.getId());
        this.ruleManagementService.updateAgenda(agendaBuilder.build());
        ArrayList<String> agendaNames = new ArrayList<String>();
        agendaNames.add(t12.agenda_Name);
        agendaNames.add(t13.agenda_Name);
        agendaNames.add(t14.agenda_Name);
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"active", (Object)"Y"), PredicateFactory.equal((String)"typeId", (Object)krmsType.getId())});
        List agendaIds = this.ruleManagementService.findAgendaIds(builder.build());
        Assert.assertEquals((String)"Wrong number of Agendas returned", (long)3L, (long)agendaIds.size());
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"contextId", (Object)t12.contextId)});
        agendaIds = this.ruleManagementService.findAgendaIds(builder.build());
        Assert.assertEquals((String)"Wrong number of Agendas returned", (long)2L, (long)agendaIds.size());
        builder.setPredicates(new Predicate[]{PredicateFactory.in((String)"name", (Object[])agendaNames.toArray(new String[0]))});
        agendaIds = this.ruleManagementService.findAgendaIds(builder.build());
        Assert.assertEquals((String)"Wrong number of Agendas returned", (long)3L, (long)agendaIds.size());
        int agendasFound = 0;
        for (String agendaId : agendaIds) {
            if (!agendaNames.contains(this.ruleManagementService.getAgenda(agendaId).getName())) continue;
            ++agendasFound;
        }
        Assert.assertEquals((String)"Incorrect results of findAgendaIds", (long)3L, (long)agendasFound);
    }

    @Test
    public void testAgendaCacheEvict() {
        RuleManagementBaseTestObjectNames t15 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t15");
        this.verifyEmptyAgenda(t15);
        RuleDefinition ruleDefinition = this.buildTestRuleDefinition(t15.namespaceName, t15.object0);
        AgendaDefinition agendaDefinition = this.createTestAgenda(t15.object0);
        this.buildTestAgendaItemDefinition(t15.agendaItem_Id, agendaDefinition.getId(), ruleDefinition.getId());
        this.verifyFullAgenda(t15);
    }

    private AgendaDefinition getPrototypeAgendaDefinition() {
        AgendaDefinition.Builder protoBuilder = AgendaDefinition.Builder.create((String)"123", (String)"name", (String)"typeId", (String)"contextId");
        protoBuilder.setActive(true);
        protoBuilder.setAttributes(Collections.singletonMap("attrKey", "attrValue"));
        protoBuilder.setFirstItemId("234");
        protoBuilder.setVersionNumber(Long.valueOf(1L));
        AgendaDefinition prototype = protoBuilder.build();
        return prototype;
    }

    private boolean callIsSame(AgendaDefinition ad1, AgendaDefinition ad2) throws Exception {
        RuleManagementServiceImpl ruleManagementServiceImpl = new RuleManagementServiceImpl();
        Method equalityMethod = ruleManagementServiceImpl.getClass().getDeclaredMethod("isSame", AgendaDefinition.class, AgendaDefinition.class);
        equalityMethod.setAccessible(true);
        return (Boolean)equalityMethod.invoke((Object)ruleManagementServiceImpl, ad1, ad2);
    }

    @Test
    public void testAgendaDefinitionComparisonLogic_nonNullEquality() throws Exception {
        RuleManagementServiceImpl ruleManagementServiceImpl = new RuleManagementServiceImpl();
        AgendaDefinition prototype = this.getPrototypeAgendaDefinition();
        AgendaDefinition identicalCopy = AgendaDefinition.Builder.create((AgendaDefinitionContract)prototype).build();
        Assert.assertTrue((String)"isSame should return true for identical copy", (boolean)this.callIsSame(prototype, identicalCopy));
        Assert.assertTrue((String)"isSame should return true for identical copy", (boolean)this.callIsSame(identicalCopy, prototype));
    }

    @Test
    public void testAgendaDefinitionComparisonLogic_booleanEquality() throws Exception {
        AgendaDefinition prototype = this.getPrototypeAgendaDefinition();
        AgendaDefinition.Builder protoBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)prototype);
        protoBuilder.setActive(false);
        AgendaDefinition agendaDefinitionInactive = protoBuilder.build();
        Assert.assertFalse((String)"isSame should return false for copy with mutated active flag", (boolean)this.callIsSame(prototype, agendaDefinitionInactive));
        Assert.assertFalse((String)"isSame should return false for copy with mutated active flag", (boolean)this.callIsSame(agendaDefinitionInactive, prototype));
    }

    @Test
    public void testAgendaDefinitionComparisonLogic_stringEquality() throws Exception {
        AgendaDefinition prototype = this.getPrototypeAgendaDefinition();
        AgendaDefinition.Builder protoBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)prototype);
        protoBuilder.setTypeId(null);
        AgendaDefinition agendaDefinitionNullType = protoBuilder.build();
        Assert.assertFalse((String)"isSame should return false for copy with nulled out typeId", (boolean)this.callIsSame(prototype, agendaDefinitionNullType));
        Assert.assertFalse((String)"isSame should return false for copy with nulled out typeId", (boolean)this.callIsSame(agendaDefinitionNullType, prototype));
        Assert.assertTrue((String)"isSame should return true for two copies with nulled out typeIds", (boolean)this.callIsSame(agendaDefinitionNullType, AgendaDefinition.Builder.create((AgendaDefinitionContract)agendaDefinitionNullType).build()));
        protoBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)prototype);
        protoBuilder.setTypeId("dIepyt");
        AgendaDefinition agendaDefinitionDiffType = protoBuilder.build();
        Assert.assertFalse((String)"isSame should return false for copy with mutated typeId", (boolean)this.callIsSame(prototype, agendaDefinitionDiffType));
        Assert.assertFalse((String)"isSame should return false for copy with mutated typeId", (boolean)this.callIsSame(agendaDefinitionDiffType, prototype));
    }

    @Test
    public void testAgendaDefinitionComparisonLogic_mapEquality() throws Exception {
        AgendaDefinition prototype = this.getPrototypeAgendaDefinition();
        AgendaDefinition.Builder protoBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)prototype);
        protoBuilder.setAttributes(null);
        AgendaDefinition agendaDefinitionNullAttrs = protoBuilder.build();
        Assert.assertFalse((String)"isSame should return false for copy with nulled attributes map", (boolean)this.callIsSame(prototype, agendaDefinitionNullAttrs));
        Assert.assertFalse((String)"isSame should return false for copy with nulled attributes map", (boolean)this.callIsSame(agendaDefinitionNullAttrs, prototype));
        Assert.assertTrue((String)"isSame should return true for two instances with nulled attributes map", (boolean)this.callIsSame(agendaDefinitionNullAttrs, AgendaDefinition.Builder.create((AgendaDefinitionContract)agendaDefinitionNullAttrs).build()));
        protoBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)prototype);
        protoBuilder.setAttributes(Collections.emptyMap());
        AgendaDefinition agendaDefinitionEmptyAttrs = protoBuilder.build();
        Assert.assertFalse((String)"isSame should return false for copy with empty attributes map", (boolean)this.callIsSame(prototype, agendaDefinitionEmptyAttrs));
        Assert.assertFalse((String)"isSame should return false for copy with empty attributes map", (boolean)this.callIsSame(agendaDefinitionEmptyAttrs, prototype));
        protoBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)prototype);
        protoBuilder.setAttributes(new TreeMap());
        AgendaDefinition agendaDefinitionEmptyTreeMapAttrs = protoBuilder.build();
        Assert.assertTrue((String)"isSame should return true for two empty attributes maps, even of different classes", (boolean)this.callIsSame(agendaDefinitionEmptyAttrs, agendaDefinitionEmptyTreeMapAttrs));
        Assert.assertTrue((String)"isSame should return true for two empty attributes maps, even of different classes", (boolean)this.callIsSame(agendaDefinitionEmptyTreeMapAttrs, agendaDefinitionEmptyAttrs));
    }

    private void verifyEmptyAgenda(RuleManagementBaseTestObjectNames t) {
        AgendaDefinition agenda = this.ruleManagementService.getAgenda(t.agenda_Id);
        Assert.assertNull((String)"Agenda is not null", (Object)agenda);
        AgendaItemDefinition agendaItem = this.ruleManagementService.getAgendaItem(t.agendaItem_Id);
        Assert.assertFalse((String)"Agenda in AgendaItem found", (agendaItem != null ? 1 : 0) != 0);
        boolean foundAgenda = false;
        ContextDefinition context = this.ruleManagementService.getContext(t.contextId);
        if (context != null) {
            for (AgendaDefinition contextAgenda : context.getAgendas()) {
                if (!StringUtils.equals((String)t.agenda_Id, (String)contextAgenda.getId())) continue;
                foundAgenda = true;
                break;
            }
        }
        Assert.assertFalse((String)"Agenda in Context found", (boolean)foundAgenda);
        AgendaTreeDefinition agendaTree = this.ruleManagementService.getAgendaTree(t.agenda_Id);
        Assert.assertFalse((String)"Agenda in AgendaTree found", (agendaTree != null ? 1 : 0) != 0);
    }

    private void verifyFullAgenda(RuleManagementBaseTestObjectNames t) {
        AgendaDefinition agenda = this.ruleManagementService.getAgenda(t.agenda_Id);
        Assert.assertNotNull((String)"Agenda is null", (Object)agenda);
        AgendaItemDefinition agendaItem = this.ruleManagementService.getAgendaItem(t.agendaItem_Id);
        Assert.assertTrue((String)"Agenda in AgendaItem not found", (agendaItem != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Agenda in AgendaItem not found", (boolean)StringUtils.equals((String)t.agenda_Id, (String)agendaItem.getAgendaId()));
        boolean foundAgenda = false;
        ContextDefinition context = this.ruleManagementService.getContext(t.contextId);
        if (context != null) {
            for (AgendaDefinition contextAgenda : context.getAgendas()) {
                if (!StringUtils.equals((String)t.agenda_Id, (String)contextAgenda.getId())) continue;
                foundAgenda = true;
                break;
            }
        }
        Assert.assertTrue((String)"Agenda in Context not found", (boolean)foundAgenda);
        foundAgenda = false;
        AgendaTreeDefinition agendaTree = this.ruleManagementService.getAgendaTree(t.agenda_Id);
        if (agendaTree != null) {
            for (AgendaTreeEntryDefinitionContract agendaTreeEntry : agendaTree.getEntries()) {
                if (!StringUtils.equals((String)t.agendaItem_Id, (String)agendaTreeEntry.getAgendaItemId())) continue;
                foundAgenda = true;
                break;
            }
        }
        Assert.assertTrue((String)"Agenda in AgendaTree not found", (boolean)foundAgenda);
    }
}

