/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeRuleEntry;
import org.kuali.rice.krms.test.RuleManagementBaseTest;
import org.kuali.rice.krms.test.RuleManagementBaseTestObjectNames;

public class RuleManagementAgendaTreeDefinitionTest
extends RuleManagementBaseTest {
    @Override
    @Before
    public void setClassDiscriminator() {
        this.CLASS_DISCRIMINATOR = "RMATDT";
    }

    @Test
    public void testGetAgendaTree() {
        RuleManagementBaseTestObjectNames t0 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t0");
        AgendaDefinition.Builder agendaBuilder = this.buildComplexAgenda(t0);
        AgendaTreeDefinition agendaTreeDefinition = this.ruleManagementService.getAgendaTree(agendaBuilder.getId());
        Assert.assertNotNull((String)"Should have returned a AgendaTreeDefinition", (Object)agendaTreeDefinition);
        List agendaTreeRuleEntrys = agendaTreeDefinition.getEntries();
        Assert.assertEquals((String)"First level of tree should of had 2 entries", (long)2L, (long)agendaTreeRuleEntrys.size());
        AgendaTreeRuleEntry firstLevelFirstEntry = (AgendaTreeRuleEntry)agendaTreeRuleEntrys.get(0);
        AgendaTreeRuleEntry firstLevelSecondEntry = (AgendaTreeRuleEntry)agendaTreeRuleEntrys.get(1);
        AgendaTreeDefinition ifTrueEntry = firstLevelFirstEntry.getIfTrue();
        agendaTreeRuleEntrys = ifTrueEntry.getEntries();
        Assert.assertEquals((String)"IfTrue level of first entry of tree should of had 2 entries", (long)2L, (long)agendaTreeRuleEntrys.size());
        AgendaTreeRuleEntry agendaTreeRuleEntry = (AgendaTreeRuleEntry)agendaTreeRuleEntrys.get(1);
        Assert.assertEquals((String)"Incorrect AgendaItemId found", (Object)t0.agendaItem_5_Id, (Object)agendaTreeRuleEntry.getAgendaItemId());
        AgendaTreeDefinition ifFalseEntry = firstLevelFirstEntry.getIfFalse();
        agendaTreeRuleEntrys = ifFalseEntry.getEntries();
        Assert.assertEquals((String)"IfFalse level of first entry of tree should of had 2 entries", (long)2L, (long)agendaTreeRuleEntrys.size());
        agendaTreeRuleEntry = (AgendaTreeRuleEntry)agendaTreeRuleEntrys.get(0);
        ifFalseEntry = agendaTreeRuleEntry.getIfFalse();
        agendaTreeRuleEntrys = ifFalseEntry.getEntries();
        agendaTreeRuleEntry = (AgendaTreeRuleEntry)agendaTreeRuleEntrys.get(0);
        Assert.assertEquals((String)"Incorrect AgendaItemId found", (Object)t0.agendaItem_4_Id, (Object)agendaTreeRuleEntry.getAgendaItemId());
        try {
            agendaTreeDefinition = this.ruleManagementService.getAgendaTree(" ");
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: agenda id is null or blank");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        try {
            agendaTreeDefinition = this.ruleManagementService.getAgendaTree(null);
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: agenda id is null or blank");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((String)"Should have return null", (Object)this.ruleManagementService.getAgendaTree("badValueId"));
    }

    @Test
    public void testGetAgendaTrees() {
        RuleManagementBaseTestObjectNames t1 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t1");
        AgendaDefinition.Builder agendaBuilder = this.buildComplexAgenda(t1);
        RuleManagementBaseTestObjectNames t2 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t2");
        this.buildComplexAgenda(t2);
        List<String> agendaIds = new ArrayList<String>();
        agendaIds.add(t1.agenda_Id);
        agendaIds.add(t2.agenda_Id);
        List agendaTreeDefinitions = this.ruleManagementService.getAgendaTrees(agendaIds);
        Assert.assertEquals((String)"Two agendaTree definitions should have been return", (long)2L, (long)agendaTreeDefinitions.size());
        for (AgendaTreeDefinition agendaTreeDefinition : agendaTreeDefinitions) {
            if (agendaIds.contains(agendaTreeDefinition.getAgendaId())) continue;
            Assert.fail((String)"Invalid AgendaTreeDefinition returned");
        }
        Assert.assertEquals((String)"No AgendaTreeDefinitions should have been returned", (long)0L, (long)this.ruleManagementService.getAgendaTrees(null).size());
        agendaIds = Arrays.asList("badValueId");
        Assert.assertEquals((String)"No AgendaTreeDefinitions should have been returned", (long)0L, (long)this.ruleManagementService.getAgendaTrees(agendaIds).size());
    }
}

