/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krms.api.repository.LogicalOperator;
import org.kuali.rice.krms.api.repository.RuleManagementService;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinitionContract;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsage;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinitionContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameter;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterType;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBinding;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBindingContract;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttribute;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.impl.repository.ActionBoService;
import org.kuali.rice.krms.impl.repository.AgendaBoService;
import org.kuali.rice.krms.impl.repository.ContextBoService;
import org.kuali.rice.krms.impl.repository.FunctionBoServiceImpl;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.RuleBoService;
import org.kuali.rice.krms.impl.repository.TermBoService;
import org.kuali.rice.krms.test.KRMSTestCase;
import org.kuali.rice.krms.test.RuleManagementBaseTestObjectNames;
import org.kuali.rice.krms.test.TestActionTypeService;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public abstract class RuleManagementBaseTest
extends KRMSTestCase {
    protected RuleManagementService ruleManagementService;
    protected TermBoService termBoService;
    protected ContextBoService contextRepository;
    protected KrmsTypeRepositoryService krmsTypeRepository;
    protected RuleBoService ruleBoService;
    protected AgendaBoService agendaBoService;
    protected ActionBoService actionBoService;
    protected FunctionBoServiceImpl functionBoService;
    protected KrmsAttributeDefinitionService krmsAttributeDefinitionService;
    protected BusinessObjectService businessObjectService;
    protected String CLASS_DISCRIMINATOR;
    private static String lastTestClass = null;

    @Before
    public void setup() {
        TestActionTypeService.resetActionsFired();
        this.ruleManagementService = (RuleManagementService)KrmsRepositoryServiceLocator.getService((String)"ruleManagementService");
        this.termBoService = KrmsRepositoryServiceLocator.getTermBoService();
        this.contextRepository = KrmsRepositoryServiceLocator.getContextBoService();
        this.krmsTypeRepository = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
        this.ruleBoService = KrmsRepositoryServiceLocator.getRuleBoService();
        this.agendaBoService = KrmsRepositoryServiceLocator.getAgendaBoService();
        this.actionBoService = (ActionBoService)KrmsRepositoryServiceLocator.getBean((String)"actionBoService");
        this.functionBoService = (FunctionBoServiceImpl)KrmsRepositoryServiceLocator.getBean((String)"functionRepositoryService");
        this.krmsAttributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
    }

    @Before
    public void setClassDiscriminator() {
        this.CLASS_DISCRIMINATOR = "BaseTest";
    }

    @Override
    protected List<String> getPerTestTablesNotToClear() {
        List<String> tablesNotToClear = super.getPerTestTablesNotToClear();
        if (((Object)((Object)this)).getClass().getName().equals(lastTestClass)) {
            tablesNotToClear.add("KRMS_.*");
        }
        lastTestClass = ((Object)((Object)this)).getClass().getName();
        return tablesNotToClear;
    }

    protected RuleDefinition buildTestRuleDefinition(String namespace, String objectDiscriminator) {
        PropositionDefinition propositionDefinition = this.createTestPropositionForRule(objectDiscriminator);
        String ruleId = "RuleId" + objectDiscriminator;
        String name = "RuleName" + objectDiscriminator;
        String propId = propositionDefinition.getId();
        RuleDefinition.Builder ruleDefinitionBuilder = RuleDefinition.Builder.create((String)ruleId, (String)name, (String)namespace, null, (String)propId);
        ruleDefinitionBuilder.setProposition(PropositionDefinition.Builder.create((PropositionDefinitionContract)propositionDefinition));
        String id = this.ruleManagementService.createRule(ruleDefinitionBuilder.build()).getId();
        RuleDefinition ruleDefinition = this.ruleManagementService.getRule(id);
        return ruleDefinition;
    }

    protected AgendaItemDefinition buildTestAgendaItemDefinition(String agendaItemId, String agendaId, String ruleId) {
        AgendaItemDefinition.Builder agendaItemDefinitionBuilder = AgendaItemDefinition.Builder.create((String)agendaItemId, (String)agendaId);
        agendaItemDefinitionBuilder.setRuleId(ruleId);
        String id = this.ruleManagementService.createAgendaItem(agendaItemDefinitionBuilder.build()).getId();
        AgendaItemDefinition agendaItemDefinition = this.ruleManagementService.getAgendaItem(id);
        AgendaDefinition agendaDefinition = this.ruleManagementService.getAgenda(agendaId);
        AgendaDefinition.Builder agendaDefinitionBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)agendaDefinition);
        agendaDefinitionBuilder.setFirstItemId(agendaItemDefinition.getId());
        this.ruleManagementService.updateAgenda(agendaDefinitionBuilder.build());
        return agendaItemDefinition;
    }

    protected ActionDefinition buildTestActionDefinition(String actionId, String actionName, String actionDescr, int actionSequence, String ruleId, String namespace) {
        return this.buildTestActionDefinition(actionId, actionName, actionDescr, actionSequence, ruleId, namespace, new HashMap<String, String>());
    }

    protected ActionDefinition buildTestActionDefinition(String actionId, String actionName, String actionDescr, int actionSequence, String ruleId, String namespace, Map<String, String> attributes) {
        KrmsTypeDefinition krmsTypeDefinition = this.createKrmsActionTypeDefinition(namespace);
        ActionDefinition.Builder actionDefinitionBuilder = ActionDefinition.Builder.create((String)actionId, (String)actionName, (String)namespace, (String)krmsTypeDefinition.getId(), (String)ruleId, (Integer)actionSequence);
        actionDefinitionBuilder.setDescription(actionDescr);
        actionDefinitionBuilder.setAttributes(attributes);
        String id = this.ruleManagementService.createAction(actionDefinitionBuilder.build()).getId();
        ActionDefinition actionDefinition = this.ruleManagementService.getAction(id);
        return actionDefinition;
    }

    protected PropositionDefinition createTestPropositionForRule(String objectDiscriminator) {
        this.createKrmsActionTypeDefinition("Namespace" + objectDiscriminator);
        String namespace = "Namespace" + objectDiscriminator;
        String propId = "P" + objectDiscriminator;
        String termSpecId = "TSI_" + propId;
        String ruleId = "RuleId" + objectDiscriminator;
        String termSpecDescr = "TSI_" + propId + "_Descr";
        return this.createTestSimpleProposition(namespace, propId, termSpecId, "ABC", "=", "java.lang.String", ruleId, termSpecDescr);
    }

    protected PropositionDefinition createTestPropositionForTranslation(String objectDiscriminator, String namespace, String typeName) {
        this.createKrmsTypeDefinition("TypeId" + objectDiscriminator, namespace, typeName, null);
        String ruleId = "RuleId" + objectDiscriminator;
        String propId = "P" + objectDiscriminator;
        return this.createTestSimpleProposition(namespace, propId, typeName, "ABC", "=", "java.lang.String", ruleId, "TSI_" + propId + "_Descr");
    }

    protected PropositionDefinition createTestSimpleProposition(String namespace, String propId, String termSpecId, String propConstant, String propOperator, String termSpecType, String ruleId, String termSpecDescr) {
        this.createTestTermSpecification(termSpecId, termSpecId, namespace, termSpecType, termSpecDescr);
        KrmsTypeDefinition krmsTypeDefinition = this.createKrmsTypeDefinition(null, namespace, termSpecId, "testTypeService");
        ArrayList<PropositionParameter.Builder> propParam = new ArrayList<PropositionParameter.Builder>();
        propParam.add(PropositionParameter.Builder.create((String)(propId + "_0"), (String)"unused_notnull", (String)termSpecId, (String)PropositionParameterType.TERM.getCode(), (Integer)0));
        propParam.add(PropositionParameter.Builder.create((String)(propId + "_1"), (String)"unused_notnull", (String)propConstant, (String)PropositionParameterType.CONSTANT.getCode(), (Integer)1));
        propParam.add(PropositionParameter.Builder.create((String)(propId + "_2"), (String)"unused_notnull", (String)propOperator, (String)PropositionParameterType.OPERATOR.getCode(), (Integer)2));
        PropositionDefinition.Builder propBuilder = PropositionDefinition.Builder.create(null, (String)PropositionType.SIMPLE.getCode(), (String)ruleId, (String)krmsTypeDefinition.getId(), propParam);
        propBuilder.setDescription(propId + "_simple_proposition");
        String id = this.ruleManagementService.createProposition(propBuilder.build()).getId();
        PropositionDefinition propositionDefinition = this.ruleManagementService.getProposition(id);
        return propositionDefinition;
    }

    protected TermSpecificationDefinition createTestTermSpecification(String termSpecId, String termSpecName, String namespace, String type, String termSpecDescr) {
        TermSpecificationDefinition termSpecificationDefinition = this.termBoService.getTermSpecificationByNameAndNamespace(termSpecName, namespace);
        if (termSpecificationDefinition == null) {
            TermSpecificationDefinition.Builder termSpecificationDefinitionBuilder = TermSpecificationDefinition.Builder.create(null, (String)termSpecName, (String)namespace, (String)type);
            termSpecificationDefinitionBuilder.setDescription(termSpecDescr);
            String id = this.termBoService.createTermSpecification(termSpecificationDefinitionBuilder.build()).getId();
            termSpecificationDefinition = this.termBoService.getTermSpecificationById(id);
        }
        return termSpecificationDefinition;
    }

    protected KrmsTypeDefinition createKrmsTypeDefinition(String typeId, String nameSpace, String typeName, String serviceName, List<KrmsTypeAttribute.Builder> typeAttributes) {
        KrmsTypeDefinition krmsTypeDefinition = this.krmsTypeRepository.getTypeByName(nameSpace, typeName);
        if (krmsTypeDefinition == null) {
            KrmsTypeDefinition.Builder krmsTypeDefnBuilder = KrmsTypeDefinition.Builder.create((String)typeName, (String)nameSpace);
            if (!CollectionUtils.isEmpty(typeAttributes)) {
                krmsTypeDefnBuilder.setAttributes(typeAttributes);
            }
            krmsTypeDefnBuilder.setId(typeId);
            krmsTypeDefnBuilder.setServiceName(serviceName);
            String id = this.krmsTypeRepository.createKrmsType(krmsTypeDefnBuilder.build()).getId();
            krmsTypeDefinition = this.krmsTypeRepository.getTypeById(id);
        }
        return krmsTypeDefinition;
    }

    protected KrmsTypeDefinition createKrmsTypeDefinition(String typeId, String nameSpace, String typeName, String serviceName) {
        return this.createKrmsTypeDefinition(typeId, nameSpace, typeName, serviceName, null);
    }

    protected AgendaDefinition createTestAgenda(String objectDiscriminator) {
        return this.createTestAgenda(objectDiscriminator, false);
    }

    protected AgendaDefinition createTestAgenda(String objectDiscriminator, boolean createAttributes) {
        String namespace = "Namespace" + objectDiscriminator;
        String typeId = "TypeId" + objectDiscriminator;
        String typeName = "TypeName" + objectDiscriminator;
        String agendaId = "AgendaId" + objectDiscriminator;
        String agendaName = "AgendaName" + objectDiscriminator;
        List<KrmsTypeAttribute.Builder> typeAttrs = Collections.emptyList();
        String attrDefName = "AttrName" + objectDiscriminator;
        String attrValue = "AttrVal" + objectDiscriminator;
        if (createAttributes) {
            String attrDefId = "KRTEST" + objectDiscriminator;
            String attrNamespace = "Namespace" + objectDiscriminator;
            KrmsAttributeDefinition attrDef = this.createTestKrmsAttribute(attrDefId, attrDefName, attrNamespace);
            typeAttrs = Collections.singletonList(KrmsTypeAttribute.Builder.create(null, (String)attrDef.getId(), (Integer)1));
        }
        KrmsTypeDefinition krmsTypeDefinition = this.createKrmsTypeDefinition(typeId, namespace, typeName, null, typeAttrs);
        ContextDefinition contextDefinition = this.buildTestContext(objectDiscriminator);
        AgendaDefinition.Builder agendaBuilder = AgendaDefinition.Builder.create((String)agendaId, (String)agendaName, (String)krmsTypeDefinition.getId(), (String)contextDefinition.getId());
        if (createAttributes) {
            agendaBuilder.setAttributes(Collections.singletonMap(attrDefName, attrValue));
        }
        String id = this.ruleManagementService.createAgenda(agendaBuilder.build()).getId();
        AgendaDefinition agendaDefinition = this.ruleManagementService.getAgenda(id);
        return agendaDefinition;
    }

    protected AgendaDefinition.Builder buildComplexAgenda(RuleManagementBaseTestObjectNames names) {
        String namespace = "Namespace" + names.discriminator;
        return this.createComplexAgenda(namespace, "AGENDA", names);
    }

    protected AgendaDefinition.Builder createComplexAgenda(String namespace, String namespaceType, RuleManagementBaseTestObjectNames names) {
        ContextDefinition.Builder contextBuilder = ContextDefinition.Builder.create((String)namespace, (String)names.contextName);
        contextBuilder.setId(names.contextId);
        ContextDefinition context = contextBuilder.build();
        this.ruleManagementService.createContext(context);
        this.createKrmsTypeDefinition(null, namespace, namespaceType, null);
        AgendaDefinition.Builder agendaBuilder = AgendaDefinition.Builder.create((String)names.agenda_Id, (String)names.agenda_Name, (String)namespaceType, (String)names.contextId);
        AgendaDefinition agenda = agendaBuilder.build();
        agenda = this.ruleManagementService.createAgenda(agenda);
        RuleDefinition rule0 = this.buildTestRuleDefinition(namespace, names.object0);
        RuleDefinition rule1 = this.buildTestRuleDefinition(namespace, names.object1);
        RuleDefinition rule2 = this.buildTestRuleDefinition(namespace, names.object2);
        RuleDefinition rule3 = this.buildTestRuleDefinition(namespace, names.object3);
        RuleDefinition rule4 = this.buildTestRuleDefinition(namespace, names.object4);
        RuleDefinition rule5 = this.buildTestRuleDefinition(namespace, names.object5);
        RuleDefinition rule6 = this.buildTestRuleDefinition(namespace, names.object6);
        RuleDefinition rule7 = this.buildTestRuleDefinition(namespace, names.object7);
        this.createTestKrmsAttribute(names.actionAttribute0, names.actionAttribute0_Key, names.namespaceName);
        this.createTestKrmsAttribute(names.actionAttribute1, names.actionAttribute1_Key, names.namespaceName);
        HashMap<String, String> actionAttributesOBJECT7 = new HashMap<String, String>();
        actionAttributesOBJECT7.put(names.actionAttribute_Key, names.actionAttribute_Value);
        this.buildTestActionDefinition(names.action_Id, names.action_Name, names.action_Descr, 1, rule7.getId(), names.namespaceName, actionAttributesOBJECT7);
        this.buildTestAgendaItemDefinition(names.agendaItem_7_Id, agenda.getId(), rule7.getId());
        AgendaItemDefinition agendaItemOBJECT6 = this.buildTestAgendaItemDefinition(names.agendaItem_6_Id, agenda.getId(), rule6.getId());
        AgendaItemDefinition agendaItemOBJECT5 = this.buildTestAgendaItemDefinition(names.agendaItem_5_Id, agenda.getId(), rule5.getId());
        AgendaItemDefinition agendaItemOBJECT4 = this.buildTestAgendaItemDefinition(names.agendaItem_4_Id, agenda.getId(), rule4.getId());
        AgendaItemDefinition agendaItemOBJECT3 = this.buildTestAgendaItemDefinition(names.agendaItem_3_Id, agenda.getId(), rule3.getId());
        AgendaItemDefinition agendaItemOBJECT2 = this.buildTestAgendaItemDefinition(names.agendaItem_2_Id, agenda.getId(), rule2.getId());
        AgendaItemDefinition.Builder itemBuilderOBJECT2 = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemOBJECT2);
        AgendaItemDefinition.Builder itemBuilderOBJECT4 = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemOBJECT4);
        itemBuilderOBJECT2.setWhenFalse(itemBuilderOBJECT4);
        itemBuilderOBJECT2.setWhenFalseId(itemBuilderOBJECT4.getId());
        AgendaItemDefinition.Builder itemBuilderOBJECT6 = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemOBJECT6);
        itemBuilderOBJECT2.setAlways(itemBuilderOBJECT6);
        itemBuilderOBJECT2.setAlwaysId(itemBuilderOBJECT6.getId());
        itemBuilderOBJECT2 = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)this.ruleManagementService.createAgendaItem(itemBuilderOBJECT2.build()));
        AgendaItemDefinition agendaItemOBJECT1 = this.buildTestAgendaItemDefinition(names.agendaItem_1_Id, agenda.getId(), rule1.getId());
        AgendaItemDefinition.Builder itemBuilderOBJECT1 = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemOBJECT1);
        AgendaItemDefinition.Builder itemBuilderOBJECT5 = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemOBJECT5);
        itemBuilderOBJECT1.setAlways(itemBuilderOBJECT5);
        itemBuilderOBJECT1.setAlwaysId(itemBuilderOBJECT5.getId());
        itemBuilderOBJECT1 = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)this.ruleManagementService.createAgendaItem(itemBuilderOBJECT1.build()));
        AgendaItemDefinition agendaItemOBJECT0 = this.buildTestAgendaItemDefinition(names.agendaItem_0_Id, agenda.getId(), rule0.getId());
        AgendaItemDefinition.Builder itemBuilderOBJECT0 = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemOBJECT0);
        itemBuilderOBJECT1 = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)this.ruleManagementService.getAgendaItem(itemBuilderOBJECT1.getId()));
        itemBuilderOBJECT0.setWhenTrue(itemBuilderOBJECT1);
        itemBuilderOBJECT0.setWhenTrueId(itemBuilderOBJECT1.getId());
        itemBuilderOBJECT2 = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)this.ruleManagementService.getAgendaItem(itemBuilderOBJECT2.getId()));
        itemBuilderOBJECT0.setWhenFalse(itemBuilderOBJECT2);
        itemBuilderOBJECT0.setWhenFalseId(itemBuilderOBJECT2.getId());
        AgendaItemDefinition.Builder itemBuilderOBJECT3 = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemOBJECT3);
        itemBuilderOBJECT0.setAlways(itemBuilderOBJECT3);
        itemBuilderOBJECT0.setAlwaysId(itemBuilderOBJECT3.getId());
        itemBuilderOBJECT0 = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)this.ruleManagementService.createAgendaItem(itemBuilderOBJECT0.build()));
        agendaBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)this.ruleManagementService.getAgenda(agenda.getId()));
        agendaBuilder.setFirstItemId(itemBuilderOBJECT0.getId());
        this.ruleManagementService.updateAgenda(agendaBuilder.build());
        List agendaItems = this.ruleManagementService.getAgendaItemsByContext(names.contextId);
        Assert.assertEquals((String)"Invalid number of agendaItems created", (long)8L, (long)agendaItems.size());
        return AgendaDefinition.Builder.create((AgendaDefinitionContract)this.ruleManagementService.getAgenda(agenda.getId()));
    }

    protected ReferenceObjectBinding.Builder createTestReferenceObjectBinding(String objectDiscriminator) {
        String namespace = "Namespace" + objectDiscriminator;
        AgendaDefinition agendaDefinition = this.createTestAgenda(objectDiscriminator);
        KrmsTypeDefinition krmsTypeDefinition = this.createKrmsTypeDefinition(null, namespace, "AgendaType" + objectDiscriminator, null);
        return this.createReferenceObjectBinding("ParkingPolicies", agendaDefinition.getId(), krmsTypeDefinition.getId(), namespace, "PA" + objectDiscriminator, "ParkingAffiliationType", true);
    }

    protected ReferenceObjectBinding.Builder createReferenceObjectBinding(String collectionName, String krmsObjectId, String krmsDiscriminatorType, String namespace, String referenceObjectId, String referenceDiscriminatorType, boolean active) {
        ReferenceObjectBinding.Builder refObjBindingBuilder = ReferenceObjectBinding.Builder.create((String)krmsDiscriminatorType, (String)krmsObjectId, (String)namespace, (String)referenceDiscriminatorType, (String)referenceObjectId);
        refObjBindingBuilder.setCollectionName(collectionName);
        refObjBindingBuilder.setActive(active);
        return ReferenceObjectBinding.Builder.create((ReferenceObjectBindingContract)this.ruleManagementService.createReferenceObjectBinding(refObjBindingBuilder.build()));
    }

    protected NaturalLanguageTemplate createTestNaturalLanguageTemplate(String namespace, String langCode, String nlObjectName, String template) {
        return this.createTestNaturalLanguageTemplate(namespace, langCode, nlObjectName, template, "krms.nl." + nlObjectName);
    }

    protected NaturalLanguageTemplate createTestNaturalLanguageTemplate(String namespace, String langCode, String nlObjectName, String template, String nlUsage) {
        KrmsTypeDefinition krmsType = this.createKrmsTypeDefinition(null, namespace, nlObjectName, null);
        if (ObjectUtils.isNull((Object)this.ruleManagementService.getNaturalLanguageUsage(nlUsage))) {
            NaturalLanguageUsage.Builder naturalLanguageUsageBuilder = NaturalLanguageUsage.Builder.create((String)nlObjectName, (String)namespace);
            naturalLanguageUsageBuilder.setId(nlUsage);
            naturalLanguageUsageBuilder.setDescription("Description-" + nlObjectName);
            naturalLanguageUsageBuilder.setActive(true);
            NaturalLanguageUsage naturalLanguageUsage = this.ruleManagementService.createNaturalLanguageUsage(naturalLanguageUsageBuilder.build());
        }
        this.createTestKrmsAttribute(langCode + "_" + nlObjectName + "Attribute1", nlObjectName + "TemplateAttributeName1", namespace);
        this.createTestKrmsAttribute(langCode + "_" + nlObjectName + "Attribute2", nlObjectName + "TemplateAttributeName2", namespace);
        HashMap<String, String> nlAttributes = new HashMap<String, String>();
        nlAttributes.put(nlObjectName + "TemplateAttributeName1", "value1");
        nlAttributes.put(nlObjectName + "TemplateAttributeName2", "value2");
        String naturalLanguageUsageId = nlUsage;
        String typeId = krmsType.getId();
        NaturalLanguageTemplate.Builder naturalLanguageTemplateBuilder = NaturalLanguageTemplate.Builder.create((String)langCode, (String)naturalLanguageUsageId, (String)template, (String)typeId);
        naturalLanguageTemplateBuilder.setActive(true);
        naturalLanguageTemplateBuilder.setId(langCode + "-" + nlObjectName);
        naturalLanguageTemplateBuilder.setAttributes(nlAttributes);
        return this.ruleManagementService.createNaturalLanguageTemplate(naturalLanguageTemplateBuilder.build());
    }

    protected KrmsAttributeDefinition createTestKrmsAttribute(String id, String name, String namespace) {
        if (ObjectUtils.isNull((Object)this.krmsAttributeDefinitionService.getAttributeDefinitionById(id))) {
            KrmsAttributeDefinition.Builder krmsAttributeDefinitionBuilder = KrmsAttributeDefinition.Builder.create((String)id, (String)name, (String)namespace);
            KrmsAttributeDefinition krmsAttributeDefinition = this.krmsAttributeDefinitionService.createAttributeDefinition(krmsAttributeDefinitionBuilder.build());
        }
        return this.krmsAttributeDefinitionService.getAttributeDefinitionById(id);
    }

    protected NaturalLanguageUsage buildTestNaturalLanguageUsage(String namespace, String nlUsageName) {
        KrmsTypeDefinition krmsType = this.createKrmsTypeDefinition(null, namespace, nlUsageName, null);
        NaturalLanguageUsage.Builder naturalLanguageUsageBuilder = NaturalLanguageUsage.Builder.create((String)nlUsageName, (String)namespace);
        naturalLanguageUsageBuilder.setId("krms.nl." + nlUsageName);
        naturalLanguageUsageBuilder.setDescription("Description-" + nlUsageName);
        naturalLanguageUsageBuilder.setActive(true);
        return this.ruleManagementService.createNaturalLanguageUsage(naturalLanguageUsageBuilder.build());
    }

    protected ContextDefinition buildTestContext(String objectDiscriminator) {
        String namespace = "Namespace" + objectDiscriminator;
        String contextId = "ContextId" + objectDiscriminator;
        String contextName = "ContextName" + objectDiscriminator;
        ContextDefinition.Builder contextDefinitionBuilder = ContextDefinition.Builder.create((String)namespace, (String)contextName);
        contextDefinitionBuilder.setId(contextId);
        String id = this.ruleManagementService.createContext(contextDefinitionBuilder.build()).getId();
        ContextDefinition contextDefinition = this.ruleManagementService.getContext(id);
        return contextDefinition;
    }

    protected PropositionDefinition createTestCompoundProposition(RuleManagementBaseTestObjectNames t0) {
        PropositionDefinition propS2 = this.createTestSimpleProposition(t0.namespaceName, "S2", "Occasion", "Conference", "=", "java.lang.String", t0.rule_0_Id, "Special Event");
        PropositionDefinition.Builder propBuilderS2 = PropositionDefinition.Builder.create((PropositionDefinitionContract)propS2);
        PropositionDefinition propS1 = this.createTestSimpleProposition(t0.namespaceName, "S1", "Account", "54321", "=", "java.lang.String", t0.rule_0_Id, "Charged To Account");
        PropositionDefinition.Builder propBuilderS1 = PropositionDefinition.Builder.create((PropositionDefinitionContract)propS1);
        KrmsTypeDefinition krmsTypeDefinition = this.createKrmsTypeDefinition(null, t0.namespaceName, "proposition", "testTypeService");
        PropositionDefinition.Builder propBuilderC1 = PropositionDefinition.Builder.create(null, (String)PropositionType.COMPOUND.getCode(), (String)t0.rule_0_Id, null, new ArrayList());
        propBuilderC1.compoundOpCode(LogicalOperator.AND.getCode());
        ArrayList<PropositionDefinition.Builder> compoundComponentsC1 = new ArrayList<PropositionDefinition.Builder>();
        compoundComponentsC1.add(propBuilderS1);
        compoundComponentsC1.add(propBuilderS2);
        propBuilderC1.setCompoundComponents(compoundComponentsC1);
        propBuilderC1.setDescription("C1_compound_proposition");
        propBuilderC1.setTypeId(krmsTypeDefinition.getId());
        return this.ruleManagementService.createProposition(propBuilderC1.build());
    }

    protected KrmsTypeDefinition createKrmsActionTypeDefinition(String nameSpace) {
        String ACTION_TYPE_NAME = "KrmsActionResolverType";
        KrmsTypeDefinition krmsActionTypeDefinition = this.krmsTypeRepository.getTypeByName(nameSpace, ACTION_TYPE_NAME);
        if (krmsActionTypeDefinition == null) {
            KrmsTypeDefinition.Builder krmsActionTypeDefnBuilder = KrmsTypeDefinition.Builder.create((String)ACTION_TYPE_NAME, (String)nameSpace);
            krmsActionTypeDefnBuilder.setServiceName("testActionTypeService");
            krmsActionTypeDefinition = this.krmsTypeRepository.createKrmsType(krmsActionTypeDefnBuilder.build());
        }
        return krmsActionTypeDefinition;
    }
}

