/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.NaturalLanguageTree;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsage;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsageContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.test.RuleManagementBaseTest;
import org.kuali.rice.krms.test.RuleManagementBaseTestObjectNames;

public class RuleManagementNaturalLanguageUsageTest
extends RuleManagementBaseTest {
    @Override
    @Before
    public void setClassDiscriminator() {
        this.CLASS_DISCRIMINATOR = "RMNLUT";
    }

    @Test
    public void testCreateNaturalLanguageUsage() {
        RuleManagementBaseTestObjectNames t0 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t0");
        NaturalLanguageUsage usage = this.buildTestNaturalLanguageUsage(t0.namespaceName, t0.object0);
        usage = this.ruleManagementService.getNaturalLanguageUsage(t0.nlUsage0_Id);
        Assert.assertEquals((String)"Unexpected Name returned", (Object)t0.nlUsage0_Name, (Object)usage.getName());
        Assert.assertEquals((String)"Unexpected Namespace returned ", (Object)t0.namespaceName, (Object)usage.getNamespace());
        Assert.assertEquals((String)"Unexpected Description returned", (Object)t0.nlUsage0_Descr, (Object)usage.getDescription());
        Assert.assertTrue((String)"Unexpected Active value returned", (boolean)usage.isActive());
        try {
            this.ruleManagementService.createNaturalLanguageUsage(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: naturalLanguageUsage was null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetNaturalLanguageUsage() {
        RuleManagementBaseTestObjectNames t1 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t1");
        NaturalLanguageUsage usage = this.buildTestNaturalLanguageUsage(t1.namespaceName, t1.object0);
        Assert.assertEquals((String)"Unexpected Description returned", (Object)t1.nlUsage0_Descr, (Object)this.ruleManagementService.getNaturalLanguageUsage(t1.nlUsage0_Id).getDescription());
        try {
            this.ruleManagementService.getNaturalLanguageUsage(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: naturalLanguageUsageId was null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.getNaturalLanguageUsage("   ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: naturalLanguageUsageId was blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((String)"Should not have return object", (Object)this.ruleManagementService.getNaturalLanguageUsage("badValue"));
    }

    @Test
    public void testUpdateNaturalLanguageUsage() {
        RuleManagementBaseTestObjectNames t2 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t2");
        NaturalLanguageUsage usage = this.buildTestNaturalLanguageUsage(t2.namespaceName, t2.object0);
        usage = this.ruleManagementService.getNaturalLanguageUsage(t2.nlUsage0_Id);
        Assert.assertEquals((String)"Unexpected Name returned", (Object)t2.nlUsage0_Name, (Object)usage.getName());
        Assert.assertEquals((String)"Unexpected Namespace returned ", (Object)t2.namespaceName, (Object)usage.getNamespace());
        Assert.assertEquals((String)"Unexpected Description returned", (Object)t2.nlUsage0_Descr, (Object)usage.getDescription());
        Assert.assertTrue((String)"Unexpected Active value returned", (boolean)usage.isActive());
        NaturalLanguageUsage.Builder usageBuilder = NaturalLanguageUsage.Builder.create((NaturalLanguageUsageContract)usage);
        usageBuilder.setNamespace(t2.namespaceName + "Changed");
        usageBuilder.setName(t2.nlUsage0_Name + "Changed");
        usageBuilder.setDescription(t2.nlUsage0_Descr + "Changed");
        usageBuilder.setActive(false);
        this.ruleManagementService.updateNaturalLanguageUsage(usageBuilder.build());
        usage = this.ruleManagementService.getNaturalLanguageUsage(t2.nlUsage0_Id);
        Assert.assertEquals((String)"Unexpected Name returned", (Object)(t2.nlUsage0_Name + "Changed"), (Object)usage.getName());
        Assert.assertEquals((String)"Unexpected Namespace returned ", (Object)(t2.namespaceName + "Changed"), (Object)usage.getNamespace());
        Assert.assertEquals((String)"Unexpected Description returned", (Object)(t2.nlUsage0_Descr + "Changed"), (Object)usage.getDescription());
        Assert.assertFalse((String)"Unexpected Active value returned", (boolean)usage.isActive());
        try {
            this.ruleManagementService.updateNaturalLanguageUsage(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: naturalLanguageUsage was null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteNaturalLanguageUsage() {
        RuleManagementBaseTestObjectNames t3 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t3");
        NaturalLanguageUsage usage = this.buildTestNaturalLanguageUsage(t3.namespaceName, t3.object0);
        Assert.assertEquals((String)"Unexpected Description returned", (Object)t3.nlUsage0_Descr, (Object)this.ruleManagementService.getNaturalLanguageUsage(t3.nlUsage0_Id).getDescription());
        this.ruleManagementService.deleteNaturalLanguageUsage(t3.nlUsage0_Id);
        Assert.assertNull((String)"Should not have returned deleted entry", (Object)this.ruleManagementService.getNaturalLanguageUsage(t3.nlUsage0_Id));
        try {
            this.ruleManagementService.deleteNaturalLanguageUsage(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: naturalLanguageUsageId was null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.deleteNaturalLanguageUsage("   ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: naturalLanguageUsageId was blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.deleteNaturalLanguageUsage("badValue");
            Assert.fail((String)"Should have thrown IllegalStateException: the NaturalLanguageUsage to delete does not exists: badValue");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testGetNaturalLanguageUsagesByNamespace() {
        RuleManagementBaseTestObjectNames t4 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t4");
        this.buildTestNaturalLanguageUsage(t4.namespaceName, t4.object0);
        this.buildTestNaturalLanguageUsage(t4.namespaceName, t4.object1);
        this.buildTestNaturalLanguageUsage(t4.namespaceName, t4.object2);
        List<String> usageIds = Arrays.asList(t4.nlUsage0_Id, t4.nlUsage1_Id, t4.nlUsage2_Id);
        List usages = this.ruleManagementService.getNaturalLanguageUsagesByNamespace(t4.namespaceName);
        Assert.assertEquals((String)"Should have returned 3 entries", (long)3L, (long)usages.size());
        for (NaturalLanguageUsage usage : usages) {
            Assert.assertTrue((String)"Unexpected entry id returned", (boolean)usageIds.contains(usage.getId()));
        }
        try {
            this.ruleManagementService.getNaturalLanguageUsagesByNamespace(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: namespace is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.getNaturalLanguageUsagesByNamespace("  ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: namespace is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Should have returned 0 entries", (long)0L, (long)this.ruleManagementService.getNaturalLanguageUsagesByNamespace("badValue").size());
    }

    @Test
    public void testGetNaturalLanguageUsageByNameAndNamespace() {
        RuleManagementBaseTestObjectNames t5 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t5");
        this.buildTestNaturalLanguageUsage(t5.namespaceName, t5.object0);
        this.buildTestNaturalLanguageUsage(t5.namespaceName, t5.object1);
        Assert.assertEquals((String)"Unexpected Description on entry returned", (Object)t5.nlUsage0_Descr, (Object)this.ruleManagementService.getNaturalLanguageUsageByNameAndNamespace(t5.nlUsage0_Name, t5.namespaceName).getDescription());
        try {
            this.ruleManagementService.getNaturalLanguageUsageByNameAndNamespace(null, t5.namespaceName);
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: name was a null or blank value");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.getNaturalLanguageUsageByNameAndNamespace("  ", t5.namespaceName);
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: name was a null or blank value");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((String)"Should not have return object", (Object)this.ruleManagementService.getNaturalLanguageUsageByNameAndNamespace("badValue", t5.namespaceName));
        try {
            this.ruleManagementService.getNaturalLanguageUsageByNameAndNamespace(t5.nlUsage0_Name, null);
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: namespace was a null or blank value");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.getNaturalLanguageUsageByNameAndNamespace(t5.nlUsage0_Name, "  ");
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: namespace was a null or blank value");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((String)"Should not have return object", (Object)this.ruleManagementService.getNaturalLanguageUsageByNameAndNamespace(t5.nlUsage0_Name, "badValue"));
    }

    @Test
    public void testTranslateNaturalLanguageForObject() {
        RuleManagementBaseTestObjectNames t6 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t6");
        PropositionDefinition propositionDefinition = this.createTestPropositionForTranslation(t6.object0, t6.namespaceName, "proposition");
        NaturalLanguageTemplate template = this.createTestNaturalLanguageTemplate(t6.namespaceName, "sw", "proposition", "Detta \u00e4ndam\u00e5l f\u00e5r inte vara inaktiv");
        String translation = this.ruleManagementService.translateNaturalLanguageForObject(template.getNaturalLanguageUsageId(), "proposition", propositionDefinition.getId(), "sw");
        Assert.assertEquals((String)"Unexpected translation returned", (Object)"Detta \u00e4ndam\u00e5l f\u00e5r inte vara inaktiv. ", (Object)translation);
        Assert.assertEquals((String)"Should have returned '. ' String", (Object)". ", (Object)this.ruleManagementService.translateNaturalLanguageForObject(null, "proposition", propositionDefinition.getId(), "sw"));
        try {
            this.ruleManagementService.translateNaturalLanguageForObject(template.getNaturalLanguageUsageId(), null, propositionDefinition.getId(), "sw");
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.translateNaturalLanguageForObject(template.getNaturalLanguageUsageId(), "proposition", null, "sw");
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: Proposition id must not be null or blank");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.translateNaturalLanguageForObject(template.getNaturalLanguageUsageId(), "proposition", propositionDefinition.getId(), null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: languageCode is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Should have returned '. ' String", (Object)". ", (Object)this.ruleManagementService.translateNaturalLanguageForObject("   ", "proposition", propositionDefinition.getId(), "sw"));
        Assert.assertEquals((String)"Should have returned empty String", (Object)"", (Object)this.ruleManagementService.translateNaturalLanguageForObject(template.getNaturalLanguageUsageId(), "    ", propositionDefinition.getId(), "sw"));
        try {
            this.ruleManagementService.translateNaturalLanguageForObject(template.getNaturalLanguageUsageId(), "proposition", "    ", "sw");
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: Proposition id must not be null or blank");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.translateNaturalLanguageForObject(template.getNaturalLanguageUsageId(), "proposition", propositionDefinition.getId(), "  ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: languageCode is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Should have returned '. ' String", (Object)". ", (Object)this.ruleManagementService.translateNaturalLanguageForObject("badValue", "proposition", propositionDefinition.getId(), "sw"));
        Assert.assertEquals((String)"Should have returned empty String", (Object)"", (Object)this.ruleManagementService.translateNaturalLanguageForObject(template.getNaturalLanguageUsageId(), "badValue", propositionDefinition.getId(), "sw"));
        try {
            this.ruleManagementService.translateNaturalLanguageForObject(template.getNaturalLanguageUsageId(), "proposition", "badValue", "sw");
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: badValue is not an Id for a proposition");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Should have returned '. ' String", (Object)". ", (Object)this.ruleManagementService.translateNaturalLanguageForObject(template.getNaturalLanguageUsageId(), "proposition", propositionDefinition.getId(), "xx"));
    }

    @Test
    public void testTranslateNaturalLanguageForProposition() {
        RuleManagementBaseTestObjectNames t7 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t7");
        PropositionDefinition propositionDefinition = this.createTestPropositionForTranslation(t7.object0, t7.namespaceName, "proposition");
        NaturalLanguageTemplate template = this.createTestNaturalLanguageTemplate(t7.namespaceName, "tr", "proposition", "Bu nesne inaktif olmamalidir");
        String translation = this.ruleManagementService.translateNaturalLanguageForProposition(template.getNaturalLanguageUsageId(), propositionDefinition, "tr");
        Assert.assertEquals((String)"Unexpected translation returned", (Object)"Bu nesne inaktif olmamalidir. ", (Object)translation);
        Assert.assertEquals((String)"Should have returned '. ' String", (Object)". ", (Object)this.ruleManagementService.translateNaturalLanguageForProposition(null, propositionDefinition, "tr"));
        try {
            this.ruleManagementService.translateNaturalLanguageForProposition(template.getNaturalLanguageUsageId(), null, "tr");
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.translateNaturalLanguageForProposition(template.getNaturalLanguageUsageId(), propositionDefinition, null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: languageCode is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Should have returned '. ' String", (Object)". ", (Object)this.ruleManagementService.translateNaturalLanguageForProposition("    ", propositionDefinition, "tr"));
        try {
            this.ruleManagementService.translateNaturalLanguageForProposition(template.getNaturalLanguageUsageId(), propositionDefinition, "    ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: languageCode is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Should have returned '. ' String", (Object)". ", (Object)this.ruleManagementService.translateNaturalLanguageForProposition("badValue", propositionDefinition, "tr"));
        Assert.assertEquals((String)"Should have returned '. ' String", (Object)". ", (Object)this.ruleManagementService.translateNaturalLanguageForProposition(template.getNaturalLanguageUsageId(), propositionDefinition, "badValue"));
    }

    @Test
    public void testTranslateNaturalLanguageTreeForProposition() {
        RuleManagementBaseTestObjectNames t8 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t8");
        PropositionDefinition propositionDefinition = this.createTestPropositionForTranslation(t8.object0, t8.namespaceName, "proposition");
        NaturalLanguageTemplate template = this.createTestNaturalLanguageTemplate(t8.namespaceName, "cy", "proposition", "Ni ddylai hyn fod yn segur, Gwrthrych");
        NaturalLanguageTree naturalLanguageTree = this.ruleManagementService.translateNaturalLanguageTreeForProposition(template.getNaturalLanguageUsageId(), propositionDefinition, "cy");
        String translation = naturalLanguageTree.getNaturalLanguage();
        Assert.assertEquals((String)"Unexpected translation returned", (Object)"Ni ddylai hyn fod yn segur, Gwrthrych", (Object)translation);
        Assert.assertNull((String)"Should have returned null", (Object)naturalLanguageTree.getChildren());
    }

    @Test
    public void testCompoundTranslateNaturalLanguageTreeForProposition() {
        RuleManagementBaseTestObjectNames t9 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t9");
        PropositionDefinition propositionDefinition = this.createTestCompoundProposition(t9);
        NaturalLanguageTemplate template = this.createTestNaturalLanguageTemplate(t9.namespaceName, "ms", this.krmsTypeRepository.getTypeById(propositionDefinition.getTypeId()).getName(), "Objek ini tidak boleh aktif");
        PropositionDefinition child1 = (PropositionDefinition)propositionDefinition.getCompoundComponents().get(0);
        this.createTestNaturalLanguageTemplate(t9.namespaceName, "ms", "Account", "Objek ini tidak boleh aktif", "krms.nl.proposition");
        PropositionDefinition child2 = (PropositionDefinition)propositionDefinition.getCompoundComponents().get(1);
        this.createTestNaturalLanguageTemplate(t9.namespaceName, "ms", "Occasion", "Objek ini tidak boleh aktif", "krms.nl.proposition");
        NaturalLanguageTree naturalLanguageTree = this.ruleManagementService.translateNaturalLanguageTreeForProposition(template.getNaturalLanguageUsageId(), propositionDefinition, "ms");
        List naturalLanguageTrees = naturalLanguageTree.getChildren();
        Assert.assertEquals((String)"Should have found 2 child entries", (long)2L, (long)naturalLanguageTrees.size());
        try {
            this.ruleManagementService.translateNaturalLanguageTreeForProposition(template.getNaturalLanguageUsageId(), null, "ms");
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.translateNaturalLanguageTreeForProposition(template.getNaturalLanguageUsageId(), propositionDefinition, null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: languageCode is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNullTranslateNaturalLanguageTreeForProposition() {
        RuleManagementBaseTestObjectNames t9 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t9");
        PropositionDefinition propositionDefinition = this.createTestPropositionForTranslation(t9.object0, t9.namespaceName, "proposition");
        NaturalLanguageTree naturalLanguageTree = this.ruleManagementService.translateNaturalLanguageTreeForProposition(null, propositionDefinition, "cy2");
        String translation = naturalLanguageTree.getNaturalLanguage();
        Assert.assertEquals((String)"Non-empty translation returned", (Object)"", (Object)translation);
        Assert.assertNull((String)"Should have returned null", (Object)naturalLanguageTree.getChildren());
    }

    @Test
    public void testEmptyTranslateNaturalLanguageTreeForProposition() {
        RuleManagementBaseTestObjectNames t10 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t10");
        PropositionDefinition propositionDefinition = this.createTestPropositionForTranslation(t10.object0, t10.namespaceName, "proposition2");
        NaturalLanguageTemplate template = this.createTestNaturalLanguageTemplate(t10.namespaceName, "cy", "proposition2", "Ddylai hyn fod yn segur, Gwrthrych");
        NaturalLanguageTree naturalLanguageTree = this.ruleManagementService.translateNaturalLanguageTreeForProposition(template.getNaturalLanguageUsageId(), propositionDefinition, "en");
        String translation = naturalLanguageTree.getNaturalLanguage();
        Assert.assertEquals((String)"Non-empty translation returned", (Object)"", (Object)translation);
        Assert.assertNull((String)"Should have returned null", (Object)naturalLanguageTree.getChildren());
    }
}

