/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsage;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsageContract;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateBoServiceImpl;
import org.kuali.rice.krms.impl.repository.NaturalLanguageUsageBo;
import org.kuali.rice.krms.impl.repository.NaturalLanguageUsageBoServiceImpl;
import org.kuali.rice.krms.impl.repository.NaturalLanguageUsageBoServiceImplGenTest;
import org.kuali.rice.krms.test.AbstractBoTest;

public final class NaturalLanguageUsageIntegrationGenTest
extends AbstractBoTest {
    NaturalLanguageUsageBoServiceImpl naturalLanguageUsageBoServiceImpl;
    NaturalLanguageTemplateBoServiceImpl naturalLanguageTemplateBoServiceImpl;
    NaturalLanguageUsage naturalLanguageUsage;

    NaturalLanguageUsage getNaturalLanguageUsage() {
        return this.naturalLanguageUsage;
    }

    @Before
    public void setup() {
        this.naturalLanguageUsageBoServiceImpl = new NaturalLanguageUsageBoServiceImpl();
        this.naturalLanguageUsageBoServiceImpl.setDataObjectService(this.getDataObjectService());
        this.naturalLanguageTemplateBoServiceImpl = new NaturalLanguageTemplateBoServiceImpl();
        this.naturalLanguageTemplateBoServiceImpl.setDataObjectService(this.getDataObjectService());
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findNaturalLanguageUsagesByName_null_fail() {
        NaturalLanguageUsageBoServiceImplGenTest.create((NaturalLanguageUsageBoServiceImpl)this.naturalLanguageUsageBoServiceImpl).test_findNaturalLanguageUsagesByName_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findNaturalLanguageUsagesByDescription_null_fail() {
        NaturalLanguageUsageBoServiceImplGenTest.create((NaturalLanguageUsageBoServiceImpl)this.naturalLanguageUsageBoServiceImpl).test_findNaturalLanguageUsagesByDescription_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findNaturalLanguageUsagesByNamespace_null_fail() {
        NaturalLanguageUsageBoServiceImplGenTest.create((NaturalLanguageUsageBoServiceImpl)this.naturalLanguageUsageBoServiceImpl).test_findNaturalLanguageUsagesByNamespace_null_fail();
    }

    @Test
    public void test_from_null_yields_null() {
        NaturalLanguageUsageBoServiceImplGenTest.create((NaturalLanguageUsageBoServiceImpl)this.naturalLanguageUsageBoServiceImpl).test_from_null_yields_null();
    }

    @Test
    public void test_to() {
        NaturalLanguageUsageBoServiceImplGenTest.create((NaturalLanguageUsageBoServiceImpl)this.naturalLanguageUsageBoServiceImpl).test_to();
    }

    @Test
    public void test_createNaturalLanguageUsage() {
        NaturalLanguageUsageBoServiceImplGenTest test = NaturalLanguageUsageBoServiceImplGenTest.create((NaturalLanguageUsageBoServiceImpl)this.naturalLanguageUsageBoServiceImpl);
        test.test_createNaturalLanguageUsage();
        this.naturalLanguageUsage = test.getNaturalLanguageUsage();
        assert (this.naturalLanguageUsage != null);
        assert (this.naturalLanguageUsage.getId() != null);
    }

    @Test
    public void test_createNaturalLanguageUsageGeneratedId() {
        NaturalLanguageUsageBoServiceImplGenTest test = NaturalLanguageUsageBoServiceImplGenTest.create((NaturalLanguageUsageBoServiceImpl)this.naturalLanguageUsageBoServiceImpl);
        test.test_createNaturalLanguageUsageGeneratedId();
        this.naturalLanguageUsage = test.getNaturalLanguageUsage();
        assert (this.naturalLanguageUsage != null);
        assert (this.naturalLanguageUsage.getId() != null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_createNaturalLanguageUsage_null_fail() {
        NaturalLanguageUsageBoServiceImplGenTest.create((NaturalLanguageUsageBoServiceImpl)this.naturalLanguageUsageBoServiceImpl).test_createNaturalLanguageUsage_null_fail();
    }

    @Test
    public void test_getNaturalLanguageUsage() {
        this.test_createNaturalLanguageUsage();
        NaturalLanguageUsage def = this.getNaturalLanguageUsage();
        NaturalLanguageUsage def2 = this.naturalLanguageUsageBoServiceImpl.getNaturalLanguageUsage(def.getId());
        assert (def2 != null);
        assert (def2.equals((Object)def));
    }

    @Test
    public void test_updateNaturalLanguageUsage() {
        this.test_createNaturalLanguageUsage();
        NaturalLanguageUsage def = this.getNaturalLanguageUsage();
        String id = def.getId();
        assert (!"UpdateTest".equals(def.getName()));
        NaturalLanguageUsageBo bo = this.naturalLanguageUsageBoServiceImpl.from(def);
        bo.setName("UpdateTest");
        this.naturalLanguageUsageBoServiceImpl.updateNaturalLanguageUsage(NaturalLanguageUsage.Builder.create((NaturalLanguageUsageContract)bo).build());
        NaturalLanguageUsage def2 = this.naturalLanguageUsageBoServiceImpl.getNaturalLanguageUsage(id);
        assert ("UpdateTest".equals(def2.getName()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_updateNaturalLanguageUsage_null_fail() {
        NaturalLanguageUsageBoServiceImplGenTest.create((NaturalLanguageUsageBoServiceImpl)this.naturalLanguageUsageBoServiceImpl).test_updateNaturalLanguageUsage_null_fail();
    }

    @Test
    public void test_deleteNaturalLanguageUsage() {
        this.test_createNaturalLanguageUsage();
        NaturalLanguageUsage def = this.getNaturalLanguageUsage();
        String id = def.getId();
        List templates = this.naturalLanguageTemplateBoServiceImpl.findNaturalLanguageTemplatesByNaturalLanguageUsage(id);
        if (!CollectionUtils.isEmpty((Collection)templates)) {
            for (NaturalLanguageTemplate template : templates) {
                this.naturalLanguageTemplateBoServiceImpl.deleteNaturalLanguageTemplate(template.getId());
            }
        }
        this.naturalLanguageUsageBoServiceImpl.deleteNaturalLanguageUsage(id);
        NaturalLanguageUsage def2 = this.naturalLanguageUsageBoServiceImpl.getNaturalLanguageUsage(id);
        assert (def2 == null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_deleteNaturalLanguageUsage_null_fail() {
        NaturalLanguageUsageBoServiceImplGenTest.create((NaturalLanguageUsageBoServiceImpl)this.naturalLanguageUsageBoServiceImpl).test_deleteNaturalLanguageUsage_null_fail();
    }

    @Test(expected=IllegalStateException.class)
    public void test_createNaturalLanguageUsageDuplicateNamespaceAndName() {
        NaturalLanguageUsageBoServiceImplGenTest test = NaturalLanguageUsageBoServiceImplGenTest.create((NaturalLanguageUsageBoServiceImpl)this.naturalLanguageUsageBoServiceImpl);
        test.test_createNaturalLanguageUsageGeneratedId();
        this.naturalLanguageUsage = test.getNaturalLanguageUsage();
        assert (this.naturalLanguageUsage != null);
        assert (this.naturalLanguageUsage.getId() != null);
        NaturalLanguageUsageBoServiceImplGenTest test2 = NaturalLanguageUsageBoServiceImplGenTest.create((NaturalLanguageUsageBoServiceImpl)this.naturalLanguageUsageBoServiceImpl);
        test2.test_createNaturalLanguageUsageGeneratedId();
        this.naturalLanguageUsage = test2.getNaturalLanguageUsage();
    }
}

