/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.impl.repository.ActionBoService;
import org.kuali.rice.krms.impl.repository.ActionBoServiceImpl;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaBoService;
import org.kuali.rice.krms.impl.repository.AgendaBoServiceImpl;
import org.kuali.rice.krms.impl.repository.ContextBoServiceImpl;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.PropositionBoService;
import org.kuali.rice.krms.impl.repository.PropositionBoServiceImpl;
import org.kuali.rice.krms.impl.repository.RuleBoService;
import org.kuali.rice.krms.impl.repository.RuleBoServiceImpl;
import org.kuali.rice.krms.impl.repository.TermBoService;
import org.kuali.rice.krms.impl.repository.TermBoServiceImpl;
import org.kuali.rice.krms.impl.ui.AgendaEditor;
import org.kuali.rice.krms.impl.ui.AgendaEditorMaintainable;
import org.kuali.rice.krms.test.AbstractAgendaBoTest;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class AgendaEditorMaintainableIntegrationTest
extends AbstractAgendaBoTest {
    static final String NAMESPACEX = "AEMIT_KRMS_TEST_1";
    static final String CONTEXTX = "AEMIT_Context1";
    static final String CONTEXTX_QUALIFIER = "Context1Qualifier";
    static final String CONTEXTX_QUALIFIER_VALUE = "BLAH1";
    static final String AGENDAX = "TestAgenda1";
    private PropositionBoService propositionBoService;
    private TermBoService termBoService;
    private AgendaBoService agendaBoService;
    private RuleBoService ruleBoService;
    private ActionBoService actionBoService;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.krmsAttributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        this.krmsTypeRepository = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
        this.propositionBoService = new PropositionBoServiceImpl();
        ((PropositionBoServiceImpl)this.propositionBoService).setDataObjectService(this.getDataObjectService());
        this.termBoService = new TermBoServiceImpl();
        ((TermBoServiceImpl)this.termBoService).setDataObjectService((DataObjectService)GlobalResourceLoader.getService((String)"dataObjectService"));
        this.contextRepository = new ContextBoServiceImpl();
        ((ContextBoServiceImpl)this.contextRepository).setDataObjectService(this.getDataObjectService());
        this.agendaBoService = new AgendaBoServiceImpl();
        ((AgendaBoServiceImpl)this.agendaBoService).setDataObjectService(this.getDataObjectService());
        ((AgendaBoServiceImpl)this.agendaBoService).setAttributeDefinitionService(this.krmsAttributeDefinitionService);
        this.ruleBoService = new RuleBoServiceImpl();
        ((RuleBoServiceImpl)this.ruleBoService).setDataObjectService(this.getDataObjectService());
        this.actionBoService = new ActionBoServiceImpl();
        ((ActionBoServiceImpl)this.actionBoService).setDataObjectService(this.getDataObjectService());
    }

    @Test
    public void testEmptyAgendaDelete() {
        ContextDefinition contextDefintion1 = this.createContextDefinition(NAMESPACEX, CONTEXTX, Collections.singletonMap(CONTEXTX_QUALIFIER, CONTEXTX_QUALIFIER_VALUE));
        this.createAgendaDefinition(AGENDAX, "AgendaLabel", contextDefintion1);
        AgendaDefinition agendaDefinition = this.agendaBoService.getAgendaByNameAndContextId(AGENDAX, contextDefintion1.getId());
        this.lookupAndSaveDataObject(agendaDefinition);
    }

    @Test
    public void testOrphanAgendaItems() {
        AgendaEditorMaintainable aem = new AgendaEditorMaintainable();
        AgendaEditor ae = new AgendaEditor();
        AgendaDefinitionDataWrapper agendaWrapper = new AgendaDefinitionDataWrapper();
        AgendaBo agendaBoToUpdate = this.findAgendaByPrimaryKey(agendaWrapper.agenda);
        AgendaItemDefinition toBeDeletedItem1 = this.agendaBoService.getAgendaItemById(agendaWrapper.firstItem.getId());
        AgendaItemDefinition toBeDeletedItem2 = this.agendaBoService.getAgendaItemById(agendaWrapper.secondItem.getId());
        AgendaItemDefinition toBeDeletedItem3 = this.agendaBoService.getAgendaItemById(agendaWrapper.thirdItem.getId());
        AgendaItemDefinition toBeDeletedItem4 = this.agendaBoService.getAgendaItemById(agendaWrapper.fourthItem.getId());
        RuleDefinition toBeDeletedRule1 = this.ruleBoService.getRuleByRuleId(agendaWrapper.firstItem.getRuleId());
        RuleDefinition toBeDeletedRule2 = this.ruleBoService.getRuleByRuleId(agendaWrapper.secondItem.getRuleId());
        RuleDefinition toBeDeletedRule3 = this.ruleBoService.getRuleByRuleId(agendaWrapper.thirdItem.getRuleId());
        RuleDefinition toBeDeletedRule4 = this.ruleBoService.getRuleByRuleId(agendaWrapper.fourthItem.getRuleId());
        PropositionDefinition toBeDeletedProp1 = this.propositionBoService.getPropositionById(agendaWrapper.firstItem.getRule().getPropId());
        PropositionDefinition toBeDeletedProp2 = this.propositionBoService.getPropositionById(agendaWrapper.secondItem.getRule().getPropId());
        PropositionDefinition toBeDeletedProp3 = this.propositionBoService.getPropositionById(agendaWrapper.thirdItem.getRule().getPropId());
        PropositionDefinition toBeDeletedProp4 = this.propositionBoService.getPropositionById(agendaWrapper.fourthItem.getRule().getPropId());
        Assert.assertEquals((long)agendaBoToUpdate.getItems().size(), (long)4L);
        Assert.assertEquals((Object)agendaBoToUpdate.getName(), (Object)AGENDAX);
        Assert.assertNotNull((String)"First item should be present", (Object)toBeDeletedItem1);
        Assert.assertNotNull((String)"Second item should be present", (Object)toBeDeletedItem2);
        Assert.assertNotNull((String)"Third item should be present", (Object)toBeDeletedItem3);
        Assert.assertNotNull((String)"Fourth item should be present", (Object)toBeDeletedItem4);
        Assert.assertNotNull((String)"First Item's rule should be present", (Object)toBeDeletedRule1);
        Assert.assertNotNull((String)"Second Item's rule should be present", (Object)toBeDeletedRule2);
        Assert.assertNotNull((String)"Third Item's rule should be present", (Object)toBeDeletedRule3);
        Assert.assertNotNull((String)"Fourth Item's rule should be present", (Object)toBeDeletedRule4);
        Assert.assertNotNull((String)"First Item's proposition should be present", (Object)toBeDeletedProp1);
        Assert.assertNotNull((String)"Second Item's proposition should be present", (Object)toBeDeletedProp2);
        Assert.assertNotNull((String)"Third Item's proposition should be present", (Object)toBeDeletedProp3);
        Assert.assertNotNull((String)"Fourth Item's proposition should be present", (Object)toBeDeletedProp4);
        agendaBoToUpdate.setName("Updated Agenda Name!");
        agendaBoToUpdate.setFirstItem(null);
        agendaBoToUpdate.setFirstItemId(null);
        agendaBoToUpdate.setItems(new ArrayList());
        ae.setAgenda(agendaBoToUpdate);
        aem.setDataObject((Object)ae);
        aem.saveDataObject();
        AgendaBo agendaBoUpdated = this.findAgendaByPrimaryKey(agendaWrapper.agenda);
        AgendaItemDefinition deletedItem1 = this.agendaBoService.getAgendaItemById(agendaWrapper.firstItem.getId());
        AgendaItemDefinition deletedItem2 = this.agendaBoService.getAgendaItemById(agendaWrapper.secondItem.getId());
        AgendaItemDefinition deletedItem3 = this.agendaBoService.getAgendaItemById(agendaWrapper.thirdItem.getId());
        AgendaItemDefinition deletedItem4 = this.agendaBoService.getAgendaItemById(agendaWrapper.fourthItem.getId());
        RuleDefinition deletedRule1 = this.ruleBoService.getRuleByRuleId(agendaWrapper.firstItem.getRuleId());
        RuleDefinition deletedRule2 = this.ruleBoService.getRuleByRuleId(agendaWrapper.secondItem.getRuleId());
        RuleDefinition deletedRule3 = this.ruleBoService.getRuleByRuleId(agendaWrapper.thirdItem.getRuleId());
        RuleDefinition deletedRule4 = this.ruleBoService.getRuleByRuleId(agendaWrapper.fourthItem.getRuleId());
        PropositionDefinition deletedProp1 = this.propositionBoService.getPropositionById(agendaWrapper.firstItem.getRule().getPropId());
        PropositionDefinition deletedProp2 = this.propositionBoService.getPropositionById(agendaWrapper.secondItem.getRule().getPropId());
        PropositionDefinition deletedProp3 = this.propositionBoService.getPropositionById(agendaWrapper.thirdItem.getRule().getPropId());
        PropositionDefinition deletedProp4 = this.propositionBoService.getPropositionById(agendaWrapper.fourthItem.getRule().getPropId());
        Assert.assertEquals((long)agendaBoUpdated.getItems().size(), (long)0L);
        Assert.assertEquals((Object)agendaBoUpdated.getName(), (Object)"Updated Agenda Name!");
        Assert.assertNull((String)"First item should be deleted", (Object)deletedItem1);
        Assert.assertNull((String)"Second item should be deleted", (Object)deletedItem2);
        Assert.assertNull((String)"Third item should be deleted", (Object)deletedItem3);
        Assert.assertNull((String)"Fourth item should be deleted", (Object)deletedItem4);
        Assert.assertNull((String)"First Item's rule should be deleted", (Object)deletedRule1);
        Assert.assertNull((String)"Second Item's rule should be deleted", (Object)deletedRule2);
        Assert.assertNull((String)"Third Item's rule should be deleted", (Object)deletedRule3);
        Assert.assertNull((String)"Fourth Item's rule should be deleted", (Object)deletedRule4);
        Assert.assertNull((String)"First Item's proposition should be deleted", (Object)deletedProp1);
        Assert.assertNull((String)"Second Item's proposition should be deleted", (Object)deletedProp2);
        Assert.assertNull((String)"Third Item's proposition should be deleted", (Object)deletedProp3);
        Assert.assertNull((String)"Fourth Item's proposition should be deleted", (Object)deletedProp4);
    }

    private void lookupAndSaveDataObject(AgendaDefinition agendaDefinition) {
        AgendaBo agendaBo = this.findAgendaByPrimaryKey(agendaDefinition);
        AgendaEditorMaintainable aem = new AgendaEditorMaintainable();
        AgendaEditor ae = new AgendaEditor();
        ae.setAgenda(agendaBo);
        aem.setDataObject((Object)ae);
        aem.saveDataObject();
    }

    private AgendaBo findAgendaByPrimaryKey(AgendaDefinition agendaDefinition) {
        return (AgendaBo)this.getDataObjectService().find(AgendaBo.class, (Object)agendaDefinition.getId());
    }

    private void createAgendaDefinition(String agendaName, String agendaLabel, ContextDefinition contextDefinition) {
        KrmsTypeDefinition krmsGenericTypeDefinition = this.createKrmsGenericTypeDefinition(contextDefinition.getNamespace(), "testAgendaTypeService", agendaName, agendaLabel);
        AgendaDefinition agendaDefinition = AgendaDefinition.Builder.create(null, (String)agendaName, (String)krmsGenericTypeDefinition.getId(), (String)contextDefinition.getId()).build();
        agendaDefinition = this.agendaBoService.createAgenda(agendaDefinition);
        this.agendaBoService.updateAgenda(agendaDefinition);
        AgendaBo agendaBo = this.findAgendaByPrimaryKey(agendaDefinition);
        AgendaDefinition.Builder agendaDefBuilder1 = AgendaDefinition.Builder.create((AgendaDefinitionContract)this.agendaBoService.to(agendaBo));
        agendaDefinition = agendaDefBuilder1.build();
        this.agendaBoService.updateAgenda(agendaDefinition);
    }

    private class AgendaDefinitionDataWrapper {
        private ContextDefinition context;
        private AgendaDefinition agenda;
        private AgendaItemDefinition firstItem;
        private AgendaItemDefinition secondItem;
        private AgendaItemDefinition thirdItem;
        private AgendaItemDefinition fourthItem;
        private RuleDefinition firstItemRule;

        AgendaDefinitionDataWrapper() {
            this.context = AgendaEditorMaintainableIntegrationTest.this.getContextRepository().getContextByNameAndNamespace("Context1", "KRMS_TEST_1");
            Assert.assertNotNull((String)"context Context1 not found", (Object)this.context);
            this.agenda = AgendaEditorMaintainableIntegrationTest.this.getAgendaBoService().getAgendaByNameAndContextId(AgendaEditorMaintainableIntegrationTest.AGENDAX, this.context.getId());
            Assert.assertNotNull((String)"agenda TestAgenda1 not found", (Object)this.agenda);
            this.firstItem = AgendaEditorMaintainableIntegrationTest.this.getAgendaBoService().getAgendaItemById(this.agenda.getFirstItemId());
            Assert.assertNotNull((String)("agenda item " + this.agenda.getFirstItemId() + " not found"), (Object)this.firstItem);
            this.secondItem = this.firstItem.getAlways();
            this.thirdItem = this.secondItem.getAlways();
            this.fourthItem = this.thirdItem.getAlways();
            this.firstItemRule = this.firstItem.getRule();
        }
    }
}

