/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krms.api.KrmsApiServiceLocator;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.ExecutionFlag;
import org.kuali.rice.krms.api.engine.ExecutionOptions;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.kuali.rice.krms.api.repository.RuleManagementService;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.action.ActionDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinitionContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameter;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterType;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinitionContract;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinitionContract;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinitionContract;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttribute;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttributeContract;
import org.kuali.rice.krms.api.repository.type.KrmsTypeBoService;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinitionContract;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperator;
import org.kuali.rice.krms.framework.type.ValidationActionType;
import org.kuali.rice.krms.framework.type.ValidationRuleType;
import org.kuali.rice.krms.impl.repository.ActionBoServiceImpl;
import org.kuali.rice.krms.impl.repository.AgendaBoServiceImpl;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.ContextBoServiceImpl;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.KrmsTypeBoServiceImpl;
import org.kuali.rice.krms.impl.repository.PropositionBoService;
import org.kuali.rice.krms.impl.repository.PropositionBoServiceImpl;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.kuali.rice.krms.impl.repository.RuleBoServiceImpl;
import org.kuali.rice.krms.impl.repository.TermBoServiceImpl;
import org.kuali.rice.krms.impl.util.KrmsServiceLocatorInternal;
import org.kuali.rice.krms.test.RuleManagementBaseTest;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.transaction.annotation.Transactional;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class ValidationIntegrationTest
extends RuleManagementBaseTest {
    private static final String EVENT_ATTRIBUTE = "Event";
    private static final String TERM_NAME = "campusCodeTermSpec";
    private static final String CONTEXT_NAME = "ValidationITContext";
    private static final String WARNING_MESSAGE = "Warning Message.";
    private static final String ERROR_MESSAGE = "Error Message.";
    private static final String VALIDATION_ACTION_TYPE_SERVICE = "validationActionTypeService";
    private static final String VALIDATION_RULE_TYPE_SERVICE = "validationRuleTypeService";
    private KrmsTypeBoService krmsTypeBoService;
    private PropositionBoService propositionBoService;
    private String propOperator = "=";
    private String discriminator = null;

    @Override
    @Before
    public void setup() {
        this.ruleManagementService = (RuleManagementService)KrmsRepositoryServiceLocator.getService((String)"ruleManagementService");
        this.dataObjectService = (DataObjectService)GlobalResourceLoader.getService((String)"dataObjectService");
        this.krmsAttributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        this.krmsTypeRepository = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
        this.krmsTypeBoService = new KrmsTypeBoServiceImpl();
        ((KrmsTypeBoServiceImpl)this.krmsTypeBoService).setDataObjectService(this.dataObjectService);
        this.propositionBoService = new PropositionBoServiceImpl();
        ((PropositionBoServiceImpl)this.propositionBoService).setDataObjectService(this.dataObjectService);
        this.termBoService = new TermBoServiceImpl();
        ((TermBoServiceImpl)this.termBoService).setDataObjectService(this.dataObjectService);
        this.contextRepository = new ContextBoServiceImpl();
        ((ContextBoServiceImpl)this.contextRepository).setDataObjectService(this.dataObjectService);
        this.agendaBoService = new AgendaBoServiceImpl();
        ((AgendaBoServiceImpl)this.agendaBoService).setDataObjectService(this.dataObjectService);
        ((AgendaBoServiceImpl)this.agendaBoService).setAttributeDefinitionService(this.krmsAttributeDefinitionService);
        this.ruleBoService = new RuleBoServiceImpl();
        ((RuleBoServiceImpl)this.ruleBoService).setDataObjectService(this.dataObjectService);
        this.actionBoService = new ActionBoServiceImpl();
        ((ActionBoServiceImpl)this.actionBoService).setDataObjectService(this.dataObjectService);
    }

    @Transactional
    @Test
    public void testValidWarning() {
        this.discriminator = "1";
        this.propOperator = "=";
        String ruleName = ValidationRuleType.VALID.toString();
        String nameSpace = "KR-RULE";
        String ruleTypeName = "ruleTypeCode";
        String ruleAttributeName = "ruleTypeCode";
        String ruleTypeLabel = ValidationRuleType.VALID.toString();
        String ruleServiceName = VALIDATION_RULE_TYPE_SERVICE;
        String actionTypeName = "KrmsActionResolverType";
        String actionTypeServicename = VALIDATION_ACTION_TYPE_SERVICE;
        String actionName = ValidationActionType.WARNING.toString();
        HashMap<String, String> actionAttributes = new HashMap<String, String>();
        actionAttributes.put("actionTypeCode", ValidationActionType.WARNING.getCode());
        actionAttributes.put("actionMessage", WARNING_MESSAGE);
        HashMap<String, String> actionAttributesDefs = new HashMap<String, String>();
        actionAttributesDefs.put("actionTypeCode", ValidationActionType.WARNING.toString());
        actionAttributesDefs.put("actionMessage", "Validation Action Message");
        HashMap<String, String> ruleAttributes = new HashMap<String, String>();
        ruleAttributes.put(ruleAttributeName, ValidationRuleType.VALID.getCode());
        KrmsTypeDefinition contextTypeDefinition = this.createContextTypeDef("ContextTypeName" + this.discriminator, nameSpace, "ContextAttributeName" + this.discriminator, "ContextLabel", "ContextServiceName");
        ContextDefinition contextDefinition = this.createContext(CONTEXT_NAME + this.discriminator, nameSpace, contextTypeDefinition.getId(), Collections.EMPTY_MAP);
        ContextBo contextBo = ContextBo.from((ContextDefinition)contextDefinition);
        KrmsTypeDefinition ruleTypeDefinition = this.createUpdateRuleTypeDef(ruleTypeName, nameSpace, ruleAttributeName, ruleTypeLabel, ruleServiceName);
        KrmsTypeDefinition actionTypeDefinition = this.createUpdateActionTypeDef(actionTypeName, nameSpace, actionTypeServicename);
        for (Map.Entry actionAttributeDef : actionAttributesDefs.entrySet()) {
            this.createUpdateAttribute((String)actionAttributeDef.getKey(), nameSpace, (String)actionAttributeDef.getValue());
        }
        RuleBo ruleBo = this.createUpdateRuleWithAction(ruleName, nameSpace, contextDefinition.getId(), ruleTypeDefinition.getId(), actionName, actionTypeDefinition.getId(), actionAttributes, ruleAttributes);
        this.createAgenda(ruleBo, contextBo, this.createEventAttributeDefinition());
        EngineResults results = this.engineExecute(CONTEXT_NAME + this.discriminator, nameSpace);
        Assert.assertTrue((results.getAttribute("validations") == null ? 1 : 0) != 0);
    }

    @Transactional
    @Test
    public void testInvalidWarning() {
        this.discriminator = "2";
        this.propOperator = "=";
        String ruleName = ValidationRuleType.INVALID.toString();
        String nameSpace = "KR-RULE";
        String ruleTypeName = "ruleTypeCode";
        String ruleAttributeName = "ruleTypeCode";
        String ruleTypeLabel = ValidationRuleType.INVALID.toString();
        String ruleServiceName = VALIDATION_RULE_TYPE_SERVICE;
        String actionTypeName = "KrmsActionResolverType";
        String actionTypeServicename = VALIDATION_ACTION_TYPE_SERVICE;
        String actionName = ValidationActionType.WARNING.toString();
        HashMap<String, String> actionAttributes = new HashMap<String, String>();
        actionAttributes.put("actionTypeCode", ValidationActionType.WARNING.getCode());
        actionAttributes.put("actionMessage", WARNING_MESSAGE);
        HashMap<String, String> actionAttributesDefs = new HashMap<String, String>();
        actionAttributesDefs.put("actionTypeCode", ValidationActionType.WARNING.toString());
        actionAttributesDefs.put("actionMessage", "Validation Action Message");
        HashMap<String, String> ruleAttributes = new HashMap<String, String>();
        ruleAttributes.put(ruleAttributeName, ValidationRuleType.INVALID.getCode());
        KrmsTypeDefinition contextTypeDefinition = this.createContextTypeDef("ContextTypeName" + this.discriminator, nameSpace, "ContextAttributeName" + this.discriminator, "ContextLabel", "ContextServiceName");
        ContextDefinition contextDefinition = this.createContext(CONTEXT_NAME + this.discriminator, nameSpace, contextTypeDefinition.getId(), Collections.EMPTY_MAP);
        ContextBo contextBo = ContextBo.from((ContextDefinition)contextDefinition);
        KrmsTypeDefinition ruleTypeDefinition = this.createUpdateRuleTypeDef(ruleTypeName, nameSpace, ruleAttributeName, ruleTypeLabel, ruleServiceName);
        KrmsTypeDefinition actionTypeDefinition = this.createUpdateActionTypeDef(actionTypeName, nameSpace, actionTypeServicename);
        for (Map.Entry actionAttributeDef : actionAttributesDefs.entrySet()) {
            this.createUpdateAttribute((String)actionAttributeDef.getKey(), nameSpace, (String)actionAttributeDef.getValue());
        }
        RuleBo ruleBo = this.createUpdateRuleWithAction(ruleName, nameSpace, contextDefinition.getId(), ruleTypeDefinition.getId(), actionName, actionTypeDefinition.getId(), actionAttributes, ruleAttributes);
        this.createAgenda(ruleBo, contextBo, this.createEventAttributeDefinition());
        EngineResults results = this.engineExecute(CONTEXT_NAME + this.discriminator, nameSpace);
        Assert.assertNotNull((Object)results.getAttribute("validations"));
        Assert.assertEquals((Object)(ValidationActionType.WARNING.getCode() + ":" + WARNING_MESSAGE), (Object)results.getAttribute("validations"));
    }

    @Transactional
    @Test
    public void testValidError() {
        this.discriminator = "3";
        this.propOperator = "=";
        String ruleName = ValidationRuleType.VALID.toString();
        String nameSpace = "KR-RULE";
        String ruleTypeName = "ruleTypeCode";
        String ruleAttributeName = "ruleTypeCode";
        String ruleTypeLabel = ValidationRuleType.VALID.toString();
        String ruleServiceName = VALIDATION_RULE_TYPE_SERVICE;
        String actionTypeName = "KrmsActionResolverType";
        String actionTypeServicename = VALIDATION_ACTION_TYPE_SERVICE;
        String actionName = ValidationActionType.ERROR.toString();
        HashMap<String, String> actionAttributes = new HashMap<String, String>();
        actionAttributes.put("actionTypeCode", ValidationActionType.ERROR.getCode());
        actionAttributes.put("actionMessage", ERROR_MESSAGE);
        HashMap<String, String> actionAttributesDefs = new HashMap<String, String>();
        actionAttributesDefs.put("actionTypeCode", ValidationActionType.ERROR.toString());
        actionAttributesDefs.put("actionMessage", "Validation Action Message");
        HashMap<String, String> ruleAttributes = new HashMap<String, String>();
        ruleAttributes.put(ruleAttributeName, ValidationRuleType.VALID.getCode());
        KrmsTypeDefinition contextTypeDefinition = this.createContextTypeDef("ContextTypeName" + this.discriminator, nameSpace, "ContextAttributeName" + this.discriminator, "ContextLabel", "ContextServiceName");
        ContextDefinition contextDefinition = this.createContext(CONTEXT_NAME + this.discriminator, nameSpace, contextTypeDefinition.getId(), Collections.EMPTY_MAP);
        ContextBo contextBo = ContextBo.from((ContextDefinition)contextDefinition);
        KrmsTypeDefinition ruleTypeDefinition = this.createUpdateRuleTypeDef(ruleTypeName, nameSpace, ruleAttributeName, ruleTypeLabel, ruleServiceName);
        KrmsTypeDefinition actionTypeDefinition = this.createUpdateActionTypeDef(actionTypeName, nameSpace, actionTypeServicename);
        for (Map.Entry actionAttributeDef : actionAttributesDefs.entrySet()) {
            this.createUpdateAttribute((String)actionAttributeDef.getKey(), nameSpace, (String)actionAttributeDef.getValue());
        }
        RuleBo ruleBo = this.createUpdateRuleWithAction(ruleName, nameSpace, contextDefinition.getId(), ruleTypeDefinition.getId(), actionName, actionTypeDefinition.getId(), actionAttributes, ruleAttributes);
        this.createAgenda(ruleBo, contextBo, this.createEventAttributeDefinition());
        EngineResults results = this.engineExecute(CONTEXT_NAME + this.discriminator, nameSpace);
        Assert.assertTrue((results.getAttribute("validations") == null ? 1 : 0) != 0);
    }

    @Transactional
    @Test
    public void testInvalidError() {
        this.discriminator = "4";
        this.propOperator = "=";
        String ruleName = ValidationRuleType.INVALID.toString();
        String nameSpace = "KR-RULE";
        String ruleTypeName = "ruleTypeCode";
        String ruleAttributeName = "ruleTypeCode";
        String ruleTypeLabel = ValidationRuleType.INVALID.toString();
        String ruleServiceName = VALIDATION_RULE_TYPE_SERVICE;
        String actionTypeName = "KrmsActionResolverType";
        String actionTypeServicename = VALIDATION_ACTION_TYPE_SERVICE;
        String actionName = ValidationActionType.ERROR.toString();
        HashMap<String, String> actionAttributes = new HashMap<String, String>();
        actionAttributes.put("actionTypeCode", ValidationActionType.ERROR.getCode());
        actionAttributes.put("actionMessage", ERROR_MESSAGE);
        HashMap<String, String> actionAttributesDefs = new HashMap<String, String>();
        actionAttributesDefs.put("actionTypeCode", ValidationActionType.ERROR.toString());
        actionAttributesDefs.put("actionMessage", "Validation Action Message");
        HashMap<String, String> ruleAttributes = new HashMap<String, String>();
        ruleAttributes.put(ruleAttributeName, ValidationRuleType.INVALID.getCode());
        KrmsTypeDefinition contextTypeDefinition = this.createContextTypeDef("ContextTypeName" + this.discriminator, "KR-RULE", "ContextAttributeName" + this.discriminator, "ContextLabel", "ContextServiceName");
        ContextDefinition contextDefinition = this.createContext(CONTEXT_NAME + this.discriminator, nameSpace, contextTypeDefinition.getId(), Collections.EMPTY_MAP);
        ContextBo contextBo = ContextBo.from((ContextDefinition)contextDefinition);
        KrmsTypeDefinition ruleTypeDefinition = this.createUpdateRuleTypeDef(ruleTypeName, nameSpace, ruleAttributeName, ruleTypeLabel, ruleServiceName);
        KrmsTypeDefinition actionTypeDefinition = this.createUpdateActionTypeDef(actionTypeName, nameSpace, actionTypeServicename);
        for (Map.Entry actionAttributeDef : actionAttributesDefs.entrySet()) {
            this.createUpdateAttribute((String)actionAttributeDef.getKey(), nameSpace, (String)actionAttributeDef.getValue());
        }
        RuleBo ruleBo = this.createUpdateRuleWithAction(ruleName, nameSpace, contextDefinition.getId(), ruleTypeDefinition.getId(), actionName, actionTypeDefinition.getId(), actionAttributes, ruleAttributes);
        this.createAgenda(ruleBo, contextBo, this.createEventAttributeDefinition());
        EngineResults results = this.engineExecute(CONTEXT_NAME + this.discriminator, "KR-RULE");
        Assert.assertNotNull((Object)results.getAttribute("validations"));
        Assert.assertEquals((Object)(ValidationActionType.ERROR.getCode() + ":" + ERROR_MESSAGE), (Object)results.getAttribute("validations"));
    }

    @Transactional
    @Test
    public void testValidWarningReversedOperator() {
        this.discriminator = "5";
        this.propOperator = "!=";
        String ruleName = ValidationRuleType.VALID.toString();
        String nameSpace = "KR-RULE";
        String ruleTypeName = "ruleTypeCode";
        String ruleAttributeName = "ruleTypeCode";
        String ruleTypeLabel = ValidationRuleType.VALID.toString();
        String ruleServiceName = VALIDATION_RULE_TYPE_SERVICE;
        String actionTypeName = "KrmsActionResolverType";
        String actionTypeServicename = VALIDATION_ACTION_TYPE_SERVICE;
        String actionName = ValidationActionType.WARNING.toString();
        HashMap<String, String> actionAttributes = new HashMap<String, String>();
        actionAttributes.put("actionTypeCode", ValidationActionType.WARNING.getCode());
        actionAttributes.put("actionMessage", WARNING_MESSAGE);
        HashMap<String, String> actionAttributesDefs = new HashMap<String, String>();
        actionAttributesDefs.put("actionTypeCode", ValidationActionType.WARNING.toString());
        actionAttributesDefs.put("actionMessage", "Validation Action Message");
        HashMap<String, String> ruleAttributes = new HashMap<String, String>();
        ruleAttributes.put(ruleAttributeName, ValidationRuleType.VALID.getCode());
        KrmsTypeDefinition contextTypeDefinition = this.createContextTypeDef("ContextTypeName" + this.discriminator, nameSpace, "ContextAttributeName" + this.discriminator, "ContextLabel", "ContextServiceName");
        ContextDefinition contextDefinition = this.createContext(CONTEXT_NAME + this.discriminator, nameSpace, contextTypeDefinition.getId(), Collections.EMPTY_MAP);
        ContextBo contextBo = ContextBo.from((ContextDefinition)contextDefinition);
        KrmsTypeDefinition ruleTypeDefinition = this.createUpdateRuleTypeDef(ruleTypeName, nameSpace, ruleAttributeName, ruleTypeLabel, ruleServiceName);
        KrmsTypeDefinition actionTypeDefinition = this.createUpdateActionTypeDef(actionTypeName, nameSpace, actionTypeServicename);
        for (Map.Entry actionAttributeDef : actionAttributesDefs.entrySet()) {
            this.createUpdateAttribute((String)actionAttributeDef.getKey(), nameSpace, (String)actionAttributeDef.getValue());
        }
        RuleBo ruleBo = this.createUpdateRuleWithAction(ruleName, nameSpace, contextDefinition.getId(), ruleTypeDefinition.getId(), actionName, actionTypeDefinition.getId(), actionAttributes, ruleAttributes);
        this.createAgenda(ruleBo, contextBo, this.createEventAttributeDefinition());
        EngineResults results = this.engineExecute(CONTEXT_NAME + this.discriminator, nameSpace);
        Assert.assertFalse((results.getAttribute("validations") == null ? 1 : 0) != 0);
    }

    @Transactional
    @Test
    public void testInvalidWarningReversedOperator() {
        this.discriminator = "6";
        this.propOperator = "!=";
        String ruleName = ValidationRuleType.INVALID.toString();
        String nameSpace = "KR-RULE";
        String ruleTypeName = "ruleTypeCode";
        String ruleAttributeName = "ruleTypeCode";
        String ruleTypeLabel = ValidationRuleType.INVALID.toString();
        String ruleServiceName = VALIDATION_RULE_TYPE_SERVICE;
        String actionTypeName = "KrmsActionResolverType";
        String actionTypeServicename = VALIDATION_ACTION_TYPE_SERVICE;
        String actionName = ValidationActionType.WARNING.toString();
        HashMap<String, String> actionAttributes = new HashMap<String, String>();
        actionAttributes.put("actionTypeCode", ValidationActionType.WARNING.getCode());
        actionAttributes.put("actionMessage", WARNING_MESSAGE);
        HashMap<String, String> actionAttributesDefs = new HashMap<String, String>();
        actionAttributesDefs.put("actionTypeCode", ValidationActionType.WARNING.toString());
        actionAttributesDefs.put("actionMessage", "Validation Action Message");
        HashMap<String, String> ruleAttributes = new HashMap<String, String>();
        ruleAttributes.put(ruleAttributeName, ValidationRuleType.INVALID.getCode());
        KrmsTypeDefinition contextTypeDefinition = this.createContextTypeDef("ContextTypeName" + this.discriminator, nameSpace, "ContextAttributeName" + this.discriminator, "ContextLabel", "ContextServiceName");
        ContextDefinition contextDefinition = this.createContext(CONTEXT_NAME + this.discriminator, nameSpace, contextTypeDefinition.getId(), Collections.EMPTY_MAP);
        ContextBo contextBo = ContextBo.from((ContextDefinition)contextDefinition);
        KrmsTypeDefinition ruleTypeDefinition = this.createUpdateRuleTypeDef(ruleTypeName, nameSpace, ruleAttributeName, ruleTypeLabel, ruleServiceName);
        KrmsTypeDefinition actionTypeDefinition = this.createUpdateActionTypeDef(actionTypeName, nameSpace, actionTypeServicename);
        for (Map.Entry actionAttributeDef : actionAttributesDefs.entrySet()) {
            this.createUpdateAttribute((String)actionAttributeDef.getKey(), nameSpace, (String)actionAttributeDef.getValue());
        }
        RuleBo ruleBo = this.createUpdateRuleWithAction(ruleName, nameSpace, contextDefinition.getId(), ruleTypeDefinition.getId(), actionName, actionTypeDefinition.getId(), actionAttributes, ruleAttributes);
        this.createAgenda(ruleBo, contextBo, this.createEventAttributeDefinition());
        EngineResults results = this.engineExecute(CONTEXT_NAME + this.discriminator, nameSpace);
        Assert.assertNull((Object)results.getAttribute("validations"));
    }

    @Transactional
    @Test
    public void testValidErrorReversedOperator() {
        this.discriminator = "7";
        this.propOperator = "!=";
        String ruleName = ValidationRuleType.VALID.toString();
        String nameSpace = "KR-RULE";
        String ruleTypeName = "ruleTypeCode";
        String ruleAttributeName = "ruleTypeCode";
        String ruleTypeLabel = ValidationRuleType.VALID.toString();
        String ruleServiceName = VALIDATION_RULE_TYPE_SERVICE;
        String actionTypeName = "KrmsActionResolverType";
        String actionTypeServicename = VALIDATION_ACTION_TYPE_SERVICE;
        String actionName = ValidationActionType.ERROR.toString();
        HashMap<String, String> actionAttributes = new HashMap<String, String>();
        actionAttributes.put("actionTypeCode", ValidationActionType.ERROR.getCode());
        actionAttributes.put("actionMessage", ERROR_MESSAGE);
        HashMap<String, String> actionAttributesDefs = new HashMap<String, String>();
        actionAttributesDefs.put("actionTypeCode", ValidationActionType.ERROR.toString());
        actionAttributesDefs.put("actionMessage", "Validation Action Message");
        HashMap<String, String> ruleAttributes = new HashMap<String, String>();
        ruleAttributes.put(ruleAttributeName, ValidationRuleType.VALID.getCode());
        KrmsTypeDefinition contextTypeDefinition = this.createContextTypeDef("ContextTypeName" + this.discriminator, nameSpace, "ContextAttributeName" + this.discriminator, "ContextLabel", "ContextServiceName");
        ContextDefinition contextDefinition = this.createContext(CONTEXT_NAME + this.discriminator, nameSpace, contextTypeDefinition.getId(), Collections.EMPTY_MAP);
        ContextBo contextBo = ContextBo.from((ContextDefinition)contextDefinition);
        KrmsTypeDefinition ruleTypeDefinition = this.createUpdateRuleTypeDef(ruleTypeName, nameSpace, ruleAttributeName, ruleTypeLabel, ruleServiceName);
        KrmsTypeDefinition actionTypeDefinition = this.createUpdateActionTypeDef(actionTypeName, nameSpace, actionTypeServicename);
        for (Map.Entry actionAttributeDef : actionAttributesDefs.entrySet()) {
            this.createUpdateAttribute((String)actionAttributeDef.getKey(), nameSpace, (String)actionAttributeDef.getValue());
        }
        RuleBo ruleBo = this.createUpdateRuleWithAction(ruleName, nameSpace, contextDefinition.getId(), ruleTypeDefinition.getId(), actionName, actionTypeDefinition.getId(), actionAttributes, ruleAttributes);
        this.createAgenda(ruleBo, contextBo, this.createEventAttributeDefinition());
        EngineResults results = this.engineExecute(CONTEXT_NAME + this.discriminator, nameSpace);
        Assert.assertFalse((results.getAttribute("validations") == null ? 1 : 0) != 0);
    }

    @Transactional
    @Test
    public void testInvalidErrorReversedOperator() {
        this.discriminator = "8";
        this.propOperator = "!=";
        String ruleName = ValidationRuleType.INVALID.toString();
        String nameSpace = "KR-RULE";
        String ruleTypeName = "ruleTypeCode";
        String ruleAttributeName = "ruleTypeCode";
        String ruleTypeLabel = ValidationRuleType.INVALID.toString();
        String ruleServiceName = VALIDATION_RULE_TYPE_SERVICE;
        String actionTypeName = "KrmsActionResolverType";
        String actionTypeServicename = VALIDATION_ACTION_TYPE_SERVICE;
        String actionName = ValidationActionType.ERROR.toString();
        HashMap<String, String> actionAttributes = new HashMap<String, String>();
        actionAttributes.put("actionTypeCode", ValidationActionType.ERROR.getCode());
        actionAttributes.put("actionMessage", ERROR_MESSAGE);
        HashMap<String, String> actionAttributesDefs = new HashMap<String, String>();
        actionAttributesDefs.put("actionTypeCode", ValidationActionType.ERROR.toString());
        actionAttributesDefs.put("actionMessage", "Validation Action Message");
        HashMap<String, String> ruleAttributes = new HashMap<String, String>();
        ruleAttributes.put(ruleAttributeName, ValidationRuleType.INVALID.getCode());
        KrmsTypeDefinition contextTypeDefinition = this.createContextTypeDef("ContextTypeName" + this.discriminator, "KR-RULE", "ContextAttributeName" + this.discriminator, "ContextLabel", "ContextServiceName");
        ContextDefinition contextDefinition = this.createContext(CONTEXT_NAME + this.discriminator, nameSpace, contextTypeDefinition.getId(), Collections.EMPTY_MAP);
        ContextBo contextBo = ContextBo.from((ContextDefinition)contextDefinition);
        KrmsTypeDefinition ruleTypeDefinition = this.createUpdateRuleTypeDef(ruleTypeName, nameSpace, ruleAttributeName, ruleTypeLabel, ruleServiceName);
        KrmsTypeDefinition actionTypeDefinition = this.createUpdateActionTypeDef(actionTypeName, nameSpace, actionTypeServicename);
        for (Map.Entry actionAttributeDef : actionAttributesDefs.entrySet()) {
            this.createUpdateAttribute((String)actionAttributeDef.getKey(), nameSpace, (String)actionAttributeDef.getValue());
        }
        RuleBo ruleBo = this.createUpdateRuleWithAction(ruleName, nameSpace, contextDefinition.getId(), ruleTypeDefinition.getId(), actionName, actionTypeDefinition.getId(), actionAttributes, ruleAttributes);
        this.createAgenda(ruleBo, contextBo, this.createEventAttributeDefinition());
        EngineResults results = this.engineExecute(CONTEXT_NAME + this.discriminator, "KR-RULE");
        Assert.assertNull((Object)results.getAttribute("validations"));
    }

    @Transactional
    @Test
    public void testDef() {
        this.discriminator = "9";
        KrmsTypeDefinition contextTypeDefinition = this.createContextTypeDef("KrmsTestContextType" + this.discriminator, "KR-RULE", "Context1Qualifier", "Context 1 Qualifier", null);
        ContextDefinition contextDefinition = this.createContext(CONTEXT_NAME + this.discriminator, "KR-RULE", contextTypeDefinition.getId(), Collections.singletonMap("Context1Qualifier", "BLAH"));
        this.createAgendaDefinition(contextDefinition.getId(), "ValidationIntegration", "KR-RULE");
        this.engineExecute(CONTEXT_NAME + this.discriminator, "KR-RULE");
    }

    private ContextDefinition createContext(String name, String nameSpace, String typeDefId, Map<String, String> attributes) {
        ContextDefinition contextDefinition = this.ruleManagementService.getContextByNameAndNamespace(name, nameSpace);
        Assert.assertNull((String)"Context with this name and namespace should not exist", (Object)contextDefinition);
        ContextDefinition.Builder contextDefinitionBuilder = ContextDefinition.Builder.create((String)nameSpace, (String)name);
        contextDefinitionBuilder.setTypeId(typeDefId);
        if (attributes != null) {
            contextDefinitionBuilder.setAttributes(attributes);
        }
        return this.ruleManagementService.findCreateContext(contextDefinitionBuilder.build());
    }

    private KrmsTypeDefinition createContextTypeDef(String contextTypeName, String nameSpace, String attributeName, String attributeLabel, String serviceName) {
        String attributeId = this.createUpdateAttribute(attributeName, nameSpace, attributeLabel);
        KrmsTypeDefinition.Builder typeDefinitionBuilder = KrmsTypeDefinition.Builder.create((String)contextTypeName, (String)nameSpace);
        typeDefinitionBuilder.setServiceName(serviceName);
        KrmsTypeAttribute.Builder attribDefinitionBuilder = KrmsTypeAttribute.Builder.create((String)"ContextTypeId", (String)attributeId, (Integer)1);
        typeDefinitionBuilder.setAttributes(Collections.singletonList(attribDefinitionBuilder));
        KrmsTypeDefinition typeDef = this.krmsTypeBoService.createKrmsType(typeDefinitionBuilder.build());
        Assert.assertNotNull((Object)typeDef);
        return typeDef;
    }

    private KrmsTypeDefinition createUpdateRuleTypeDef(String ruleTypeName, String nameSpace, String attributeName, String attributeLabel, String serviceName) {
        String attributeId = this.createUpdateAttribute(attributeName, nameSpace, attributeLabel);
        KrmsAttributeDefinition attributeDefinition = this.krmsTypeBoService.getAttributeDefinitionById(attributeId);
        KrmsAttributeDefinition.Builder attributeDefinitionBuilder = KrmsAttributeDefinition.Builder.create((KrmsAttributeDefinitionContract)attributeDefinition);
        KrmsTypeDefinition.Builder typeDefinitionBuilder = null;
        KrmsTypeDefinition typeDefinition = this.krmsTypeBoService.getTypeByName(nameSpace, ruleTypeName);
        if (typeDefinition == null) {
            typeDefinitionBuilder = KrmsTypeDefinition.Builder.create((String)ruleTypeName, (String)nameSpace);
            typeDefinitionBuilder.setServiceName(serviceName);
            KrmsTypeAttribute.Builder typeAttributeBuilder = KrmsTypeAttribute.Builder.create((String)ruleTypeName, (String)attributeId, (Integer)1);
            typeDefinitionBuilder.setAttributes(Collections.singletonList(typeAttributeBuilder));
            typeDefinition = this.krmsTypeBoService.createKrmsType(typeDefinitionBuilder.build());
        } else {
            typeDefinitionBuilder = KrmsTypeDefinition.Builder.create((KrmsTypeDefinitionContract)typeDefinition);
            typeDefinitionBuilder.setServiceName(serviceName);
            KrmsTypeAttribute.Builder typeAttributeBuilder = KrmsTypeAttribute.Builder.create((KrmsTypeAttributeContract)((KrmsTypeAttributeContract)typeDefinition.getAttributes().get(0)));
            typeAttributeBuilder.setAttributeDefinitionId(attributeId);
            typeDefinitionBuilder.setAttributes(Collections.singletonList(typeAttributeBuilder));
            typeDefinition = this.krmsTypeBoService.updateKrmsType(typeDefinitionBuilder.build());
        }
        Assert.assertNotNull((Object)typeDefinition);
        return typeDefinition;
    }

    private String createUpdateAttribute(String attributeName, String nameSpace, String attributeLabel) {
        KrmsAttributeDefinition attributeDefinition = this.krmsAttributeDefinitionService.getAttributeDefinitionByNameAndNamespace(attributeName, nameSpace);
        KrmsAttributeDefinition.Builder attributeDefinitionBuilder = null;
        if (attributeDefinition != null) {
            attributeDefinitionBuilder = KrmsAttributeDefinition.Builder.create((KrmsAttributeDefinitionContract)attributeDefinition);
            attributeDefinitionBuilder.setLabel(attributeLabel);
            attributeDefinitionBuilder.setActive(true);
            this.krmsAttributeDefinitionService.updateAttributeDefinition(attributeDefinitionBuilder.build());
        } else {
            attributeDefinitionBuilder = KrmsAttributeDefinition.Builder.create(null, (String)attributeName, (String)nameSpace);
            attributeDefinitionBuilder.setLabel(attributeLabel);
            attributeDefinitionBuilder.setActive(true);
            this.krmsAttributeDefinitionService.createAttributeDefinition(attributeDefinitionBuilder.build());
        }
        attributeDefinition = this.krmsAttributeDefinitionService.getAttributeDefinitionByNameAndNamespace(attributeName, nameSpace);
        Assert.assertNotNull((Object)attributeDefinition.getId());
        return attributeDefinition.getId();
    }

    private void createAgendaDefinition(String contextId, String eventName, String nameSpace) {
        AgendaDefinition agendaDef = AgendaDefinition.Builder.create(null, (String)"testAgenda", null, (String)contextId).build();
        agendaDef = this.agendaBoService.createAgenda(agendaDef);
        AgendaItemDefinition.Builder agendaItemBuilder1 = AgendaItemDefinition.Builder.create(null, (String)agendaDef.getId());
        RuleDefinition ruleDefinition = this.createRuleDefinition1(contextId, nameSpace);
        agendaItemBuilder1.setRuleId(ruleDefinition.getId());
        AgendaItemDefinition agendaItem1 = this.agendaBoService.createAgendaItem(agendaItemBuilder1.build());
        AgendaDefinition.Builder agendaDefBuilder1 = AgendaDefinition.Builder.create((AgendaDefinitionContract)agendaDef);
        agendaDefBuilder1.setFirstItemId(agendaItem1.getId());
        agendaDef = agendaDefBuilder1.build();
        this.agendaBoService.updateAgenda(agendaDef);
    }

    private RuleDefinition createRuleDefinition1(String contextId, String nameSpace) {
        RuleDefinition.Builder ruleDefBuilder1 = RuleDefinition.Builder.create(null, (String)"Rule1", (String)nameSpace, null, null);
        RuleDefinition ruleDef1 = this.ruleBoService.createRule(ruleDefBuilder1.build());
        ruleDefBuilder1 = RuleDefinition.Builder.create((RuleDefinitionContract)ruleDef1);
        ruleDefBuilder1.setProposition(this.createCompoundProposition(contextId, ruleDef1));
        ruleDef1 = ruleDefBuilder1.build();
        ruleDef1 = this.ruleBoService.updateRule(ruleDef1);
        ActionDefinition.Builder actionDefBuilder1 = ActionDefinition.Builder.create(null, (String)"testAction1", (String)nameSpace, (String)this.createUpdateActionTypeDef("KrmsActionResolverType", nameSpace, "testActionTypeService").getId(), (String)ruleDef1.getId(), (Integer)1);
        ActionDefinition actionDef1 = this.actionBoService.createAction(actionDefBuilder1.build());
        return ruleDef1;
    }

    private KrmsTypeDefinition createKrmsCampusTypeDefinition(String nameSpace) {
        KrmsTypeDefinition.Builder krmsCampusTypeDefnBuilder = KrmsTypeDefinition.Builder.create((String)"CAMPUS", (String)nameSpace);
        KrmsTypeDefinition krmsCampusTypeDefinition = this.krmsTypeBoService.createKrmsType(krmsCampusTypeDefnBuilder.build());
        return krmsCampusTypeDefinition;
    }

    private KrmsTypeDefinition createKrmsActionTypeDefx(String name, String nameSpace, String actionTypeServiceName) {
        KrmsTypeDefinition.Builder krmsActionTypeDefnBuilder = KrmsTypeDefinition.Builder.create((String)name, (String)nameSpace);
        krmsActionTypeDefnBuilder.setServiceName(actionTypeServiceName);
        KrmsTypeDefinition krmsActionTypeDefinition = this.krmsTypeBoService.createKrmsType(krmsActionTypeDefnBuilder.build());
        return krmsActionTypeDefinition;
    }

    private KrmsTypeDefinition createUpdateActionTypeDef(String actionTypeName, String nameSpace, String actionTypeServiceName) {
        KrmsTypeDefinition.Builder typeDefinitionBuilder = null;
        KrmsTypeDefinition typeDefinition = this.krmsTypeBoService.getTypeByName(nameSpace, actionTypeName);
        if (typeDefinition == null) {
            typeDefinitionBuilder = KrmsTypeDefinition.Builder.create((String)actionTypeName, (String)nameSpace);
            typeDefinitionBuilder.setServiceName(actionTypeServiceName);
            typeDefinition = this.krmsTypeBoService.createKrmsType(typeDefinitionBuilder.build());
        } else {
            typeDefinitionBuilder = KrmsTypeDefinition.Builder.create((KrmsTypeDefinitionContract)typeDefinition);
            typeDefinitionBuilder.setServiceName(actionTypeServiceName);
            typeDefinition = this.krmsTypeBoService.updateKrmsType(typeDefinitionBuilder.build());
        }
        Assert.assertNotNull((Object)typeDefinition);
        return typeDefinition;
    }

    private EngineResults engineExecute(String contextName, String nameSpace) {
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        contextQualifiers.put("name", contextName);
        contextQualifiers.put("namespaceCode", nameSpace);
        SelectionCriteria sc1 = SelectionCriteria.createCriteria((DateTime)new DateTime(), contextQualifiers, Collections.emptyMap());
        Facts.Builder factsBuilder1 = Facts.Builder.create();
        factsBuilder1.addFact(TERM_NAME, (Object)"BL");
        ExecutionOptions xOptions1 = new ExecutionOptions();
        xOptions1.setFlag(ExecutionFlag.LOG_EXECUTION, true);
        EngineResults engineResults = KrmsApiServiceLocator.getEngine().execute(sc1, factsBuilder1.build(), xOptions1);
        Assert.assertNotNull((Object)engineResults);
        Assert.assertTrue((engineResults.getAllResults().size() > 0 ? 1 : 0) != 0);
        this.print(engineResults);
        return engineResults;
    }

    private void print(EngineResults engineResults) {
        System.out.println(ToStringBuilder.reflectionToString((Object)engineResults, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
    }

    private RuleBo createUpdateRuleWithAction(String ruleName, String nameSpace, String contextId, String ruleTypeId, String actionName, String actionTypeId, Map<String, String> actionAttributes, Map<String, String> ruleAttributes) {
        RuleDefinition.Builder ruleDefinitionBuilder;
        RuleDefinition ruleDefinition = this.ruleManagementService.getRuleByNameAndNamespace(ruleName, nameSpace);
        if (ruleDefinition == null) {
            ruleDefinitionBuilder = RuleDefinition.Builder.create(null, (String)ruleName, (String)nameSpace, (String)ruleTypeId, null);
            ruleDefinition = this.ruleManagementService.createRule(ruleDefinitionBuilder.build());
        }
        ruleDefinitionBuilder = RuleDefinition.Builder.create((RuleDefinitionContract)ruleDefinition);
        ruleDefinitionBuilder.setActions(this.createUpdateAction(ruleDefinition.getId(), nameSpace, actionName, actionTypeId, actionAttributes));
        ruleDefinitionBuilder.setAttributes(ruleAttributes);
        PropositionDefinition propositionDefinition = this.createPropositionDefinition1(contextId, ruleDefinition.getId());
        ruleDefinitionBuilder.setProposition(PropositionDefinition.Builder.create((PropositionDefinitionContract)propositionDefinition));
        ruleDefinition = this.ruleManagementService.getRule(ruleDefinition.getId());
        ruleDefinitionBuilder.setVersionNumber(ruleDefinition.getVersionNumber());
        this.ruleManagementService.updateRule(ruleDefinitionBuilder.build());
        ruleDefinition = this.ruleManagementService.getRule(ruleDefinitionBuilder.getId());
        Assert.assertNotNull((Object)ruleDefinition.getId());
        Assert.assertNotNull((Object)ruleDefinition.getProposition().getId());
        Assert.assertEquals((Object)ruleDefinition.getProposition().getRuleId(), (Object)ruleDefinition.getId());
        Assert.assertEquals((long)1L, (long)ruleDefinition.getActions().size());
        Assert.assertNotNull((Object)((ActionDefinition)ruleDefinition.getActions().get(0)).getId());
        Assert.assertEquals((long)2L, (long)((ActionDefinition)ruleDefinition.getActions().get(0)).getAttributes().size());
        return RuleBo.from((RuleDefinition)ruleDefinition);
    }

    private List<ActionDefinition.Builder> createUpdateAction(String ruleId, String nameSpace, String actionName, String actionTypeId, Map<String, String> actionAttributes) {
        ActionDefinition actionDefinition = null;
        QueryByCriteria.Builder criteriaBuilder = QueryByCriteria.Builder.create();
        criteriaBuilder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"name", (Object)actionName)});
        List actionIds = this.ruleManagementService.findActionIds(criteriaBuilder.build());
        if (actionIds.size() > 0) {
            actionDefinition = this.ruleManagementService.getAction((String)actionIds.get(0));
            ActionDefinition.Builder actionDefinitionBuilder = ActionDefinition.Builder.create((ActionDefinitionContract)actionDefinition);
            actionDefinitionBuilder.setAttributes(actionAttributes);
            this.ruleManagementService.updateAction(actionDefinitionBuilder.build());
            actionDefinition = this.ruleManagementService.getAction(actionDefinitionBuilder.getId());
        } else {
            ActionDefinition.Builder actionDefinitionBuilder = ActionDefinition.Builder.create(null, (String)actionName, (String)nameSpace, (String)actionTypeId, (String)ruleId, (Integer)1);
            actionDefinitionBuilder.setAttributes(actionAttributes);
            actionDefinition = this.ruleManagementService.createAction(actionDefinitionBuilder.build());
        }
        return Collections.singletonList(ActionDefinition.Builder.create((ActionDefinitionContract)actionDefinition));
    }

    private PropositionDefinition createPropositionDefinition1(String contextId, String ruleId) {
        String namespace = "KR-RULE";
        String propId = null;
        String propConstant = "BL";
        TermDefinition termDefinition = this.createTermDefinition1(contextId);
        String termSpecId = termDefinition.getId();
        String termSpecType = termDefinition.getSpecification().getType();
        String termSpecDescr = termDefinition.getSpecification().getDescription();
        this.createTestTermSpecification(termSpecId, termSpecId, namespace, termSpecType, termSpecDescr);
        KrmsTypeDefinition krmsTypeDefinition = this.createKrmsTypeDefinition(null, namespace, termSpecId, "testTypeService");
        PropositionDefinition.Builder propBuilder = PropositionDefinition.Builder.create(propId, (String)PropositionType.SIMPLE.getCode(), (String)ruleId, null, Collections.emptyList());
        propBuilder.setDescription("is campus bloomington");
        PropositionDefinition propositionDefinition = this.ruleManagementService.createProposition(propBuilder.build());
        ArrayList<PropositionParameter.Builder> propParam = new ArrayList<PropositionParameter.Builder>();
        propParam.add(PropositionParameter.Builder.create((String)(propId + "_0"), (String)propositionDefinition.getId(), (String)termSpecId, (String)PropositionParameterType.TERM.getCode(), (Integer)0));
        propParam.add(PropositionParameter.Builder.create((String)(propId + "_1"), (String)propositionDefinition.getId(), (String)propConstant, (String)PropositionParameterType.CONSTANT.getCode(), (Integer)1));
        propParam.add(PropositionParameter.Builder.create((String)(propId + "_2"), (String)propositionDefinition.getId(), (String)this.propOperator, (String)PropositionParameterType.OPERATOR.getCode(), (Integer)2));
        propBuilder = PropositionDefinition.Builder.create((PropositionDefinitionContract)propositionDefinition);
        propBuilder.setParameters(propParam);
        this.ruleManagementService.updateProposition(propBuilder.build());
        propositionDefinition = this.ruleManagementService.getProposition(propositionDefinition.getId());
        return propositionDefinition;
    }

    private PropositionDefinition.Builder createCompoundProposition(String contextId, RuleDefinition ruleDef1) {
        ArrayList<PropositionParameter.Builder> propositionParameterBuilderList = new ArrayList<PropositionParameter.Builder>();
        propositionParameterBuilderList.add(PropositionParameter.Builder.create(null, null, (String)this.createTermDefinition1(contextId).getId(), (String)PropositionParameterType.TERM.getCode(), (Integer)1));
        propositionParameterBuilderList.add(PropositionParameter.Builder.create(null, null, (String)"BL", (String)PropositionParameterType.CONSTANT.getCode(), (Integer)2));
        propositionParameterBuilderList.add(PropositionParameter.Builder.create(null, null, (String)ComparisonOperator.EQUALS.getCode(), (String)PropositionParameterType.OPERATOR.getCode(), (Integer)3));
        PropositionDefinition.Builder propositionDefBuilder1 = PropositionDefinition.Builder.create(null, (String)PropositionType.SIMPLE.getCode(), (String)ruleDef1.getId(), null, propositionParameterBuilderList);
        propositionDefBuilder1.setDescription("propositionDefBuilder1 Description");
        for (PropositionParameter.Builder propositionParamBuilder : propositionParameterBuilderList) {
            propositionParamBuilder.setProposition(propositionDefBuilder1);
        }
        return propositionDefBuilder1;
    }

    private TermDefinition createTermDefinition1(String contextId) {
        TermSpecificationDefinition campusCodeTermSpec = TermSpecificationDefinition.Builder.create(null, (String)TERM_NAME, (String)contextId, (String)"java.lang.String").build();
        campusCodeTermSpec = this.termBoService.createTermSpecification(campusCodeTermSpec);
        TermDefinition termDefinition1 = TermDefinition.Builder.create(null, (TermSpecificationDefinition.Builder)TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)campusCodeTermSpec), null).build();
        termDefinition1 = this.termBoService.createTerm(termDefinition1);
        return termDefinition1;
    }

    private TermDefinition createTermDefinitionInteger(ContextDefinition contextDefinition) {
        TermSpecificationDefinition termSpec = TermSpecificationDefinition.Builder.create(null, (String)TERM_NAME, (String)contextDefinition.getId(), (String)"java.lang.Integer").build();
        termSpec = this.termBoService.createTermSpecification(termSpec);
        TermDefinition termDefinition1 = TermDefinition.Builder.create(null, (TermSpecificationDefinition.Builder)TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)termSpec), null).build();
        termDefinition1 = this.termBoService.createTerm(termDefinition1);
        return termDefinition1;
    }

    private KrmsAttributeDefinitionBo createEventAttributeDefinition() {
        KrmsAttributeDefinitionService service = (KrmsAttributeDefinitionService)KrmsServiceLocatorInternal.getService((String)"krmsAttributeDefinitionService");
        Assert.assertNotNull((Object)service);
        KrmsAttributeDefinition krmsAttributeDefinition = this.krmsAttributeDefinitionService.getAttributeDefinitionByNameAndNamespace(EVENT_ATTRIBUTE, "KR-RULE");
        if (krmsAttributeDefinition == null) {
            KrmsAttributeDefinition.Builder krmsAttributeDefinitionBuilder = KrmsAttributeDefinition.Builder.create(null, (String)EVENT_ATTRIBUTE, (String)"KR-RULE");
            krmsAttributeDefinitionBuilder.setLabel(EVENT_ATTRIBUTE);
            krmsAttributeDefinitionBuilder.setActive(true);
            krmsAttributeDefinition = this.krmsAttributeDefinitionService.createAttributeDefinition(krmsAttributeDefinitionBuilder.build());
        }
        Assert.assertNotNull((Object)krmsAttributeDefinition.getId());
        return KrmsAttributeDefinitionBo.from((KrmsAttributeDefinition)krmsAttributeDefinition);
    }

    private AgendaDefinition createAgenda(RuleBo ruleBo, ContextBo contextBo, KrmsAttributeDefinitionBo eventAttributeDefinition) {
        KrmsTypeDefinition agendaTypeDefinition = this.krmsTypeRepository.getTypeByName(contextBo.getNamespace(), "EventAgenda");
        String attributeId = this.createUpdateAttribute(EVENT_ATTRIBUTE, "KR-RULE", EVENT_ATTRIBUTE);
        if (agendaTypeDefinition == null) {
            KrmsTypeAttribute.Builder krmsTypeAttributeBuilder = KrmsTypeAttribute.Builder.create(null, (String)attributeId, (Integer)1);
            KrmsTypeDefinition.Builder krmsTypeDefnBuilder = KrmsTypeDefinition.Builder.create((String)"EventAgenda", (String)"KR-RULE");
            krmsTypeDefnBuilder.setAttributes(Collections.singletonList(krmsTypeAttributeBuilder));
            krmsTypeDefnBuilder.setServiceName("AgendaTypeService");
            agendaTypeDefinition = this.krmsTypeRepository.createKrmsType(krmsTypeDefnBuilder.build());
        }
        AgendaDefinition agendaDefinition = AgendaDefinition.Builder.create(null, (String)"testAgenda", null, (String)contextBo.getId()).build();
        agendaDefinition = this.ruleManagementService.findCreateAgenda(agendaDefinition);
        AgendaDefinition.Builder agendaDefinitionBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)agendaDefinition);
        RuleDefinition.Builder ruleDefinitionBuilder = RuleDefinition.Builder.create((RuleDefinitionContract)ruleBo);
        AgendaItemDefinition.Builder agendaItemDefininitionBuilder = AgendaItemDefinition.Builder.create(null, (String)agendaDefinition.getId());
        agendaItemDefininitionBuilder.setRule(ruleDefinitionBuilder);
        agendaItemDefininitionBuilder.setAgendaId(agendaDefinition.getId());
        AgendaItemDefinition agendaItemDefinition = this.ruleManagementService.createAgendaItem(agendaItemDefininitionBuilder.build());
        agendaDefinitionBuilder.setFirstItemId(agendaItemDefinition.getId());
        this.ruleManagementService.updateAgenda(agendaDefinitionBuilder.build());
        return this.ruleManagementService.getAgenda(agendaDefinitionBuilder.getId());
    }
}

