/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebParam;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.CodedAttributeContract;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.address.EntityAddress;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationType;
import org.kuali.rice.kim.api.identity.citizenship.EntityCitizenship;
import org.kuali.rice.kim.api.identity.email.EntityEmail;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.entity.EntityDefaultQueryResults;
import org.kuali.rice.kim.api.identity.entity.EntityQueryResults;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifier;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierType;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.name.EntityNameContract;
import org.kuali.rice.kim.api.identity.personal.EntityBioDemographics;
import org.kuali.rice.kim.api.identity.personal.EntityEthnicity;
import org.kuali.rice.kim.api.identity.phone.EntityPhone;
import org.kuali.rice.kim.api.identity.principal.EntityNamePrincipalName;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalQueryResults;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.identity.residency.EntityResidency;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.api.identity.visa.EntityVisa;
import org.kuali.rice.kim.impl.identity.IdentityArchiveService;
import org.kuali.rice.krad.util.ObjectUtils;

public class IdentityCurrentAndArchivedServiceImpl
implements IdentityService {
    private final IdentityArchiveService identityArchiveService;
    private final IdentityService innerIdentityService;

    public IdentityCurrentAndArchivedServiceImpl(IdentityService innerIdentityService, IdentityArchiveService identityArchiveService) {
        this.innerIdentityService = innerIdentityService;
        this.identityArchiveService = identityArchiveService;
    }

    public CodedAttribute getAddressType(String code) {
        return this.getInnerIdentityService().getAddressType(code);
    }

    public List<CodedAttribute> findAllAddressTypes() {
        return this.getInnerIdentityService().findAllAddressTypes();
    }

    public EntityAffiliationType getAffiliationType(String code) {
        return this.getInnerIdentityService().getAffiliationType(code);
    }

    public List<EntityAffiliationType> findAllAffiliationTypes() {
        return this.getInnerIdentityService().findAllAffiliationTypes();
    }

    public CodedAttribute getCitizenshipStatus(String code) {
        return CodedAttribute.Builder.create((CodedAttributeContract)this.getInnerIdentityService().getCitizenshipStatus(code)).build();
    }

    public List<CodedAttribute> findAllCitizenshipStatuses() {
        return this.getInnerIdentityService().findAllCitizenshipStatuses();
    }

    public EntityNamePrincipalName getDefaultNamesForPrincipalId(String principalId) {
        EntityDefault defaultEntity;
        EntityNamePrincipalName name = this.getInnerIdentityService().getDefaultNamesForPrincipalId(principalId);
        if ((name == null || ObjectUtils.isNull((Object)name.getDefaultName()) || StringUtils.isBlank((String)name.getPrincipalName()) || StringUtils.isBlank((String)name.getDefaultName().getCompositeName())) && (defaultEntity = this.getEntityDefaultByPrincipalId(principalId)) != null) {
            EntityNamePrincipalName.Builder nameBuilder = EntityNamePrincipalName.Builder.create();
            for (Principal principal : defaultEntity.getPrincipals()) {
                nameBuilder.setPrincipalName(principal.getPrincipalName());
            }
            nameBuilder.setDefaultName(EntityName.Builder.create((EntityNameContract)defaultEntity.getName()));
            if (StringUtils.isBlank((String)defaultEntity.getName().getCompositeName())) {
                String formattedName = (defaultEntity.getName().getLastName() + ", " + defaultEntity.getName().getFirstName() + (defaultEntity.getName().getMiddleName() == null ? "" : " " + defaultEntity.getName().getMiddleName())).trim();
                nameBuilder.getDefaultName().setCompositeName(formattedName);
            }
            return nameBuilder.build();
        }
        return name;
    }

    public EntityName addNameToEntity(EntityName name) {
        return this.getInnerIdentityService().addNameToEntity(name);
    }

    public EntityName updateName(EntityName name) {
        return this.getInnerIdentityService().updateName(name);
    }

    public EntityName inactivateName(String id) {
        return this.getInnerIdentityService().inactivateName(id);
    }

    public EntityEmployment addEmploymentToEntity(EntityEmployment employment) {
        return this.getInnerIdentityService().addEmploymentToEntity(employment);
    }

    public EntityEmployment updateEmployment(EntityEmployment employment) {
        return this.getInnerIdentityService().updateEmployment(employment);
    }

    public EntityEmployment inactivateEmployment(String id) {
        return this.getInnerIdentityService().inactivateEmployment(id);
    }

    public EntityBioDemographics addBioDemographicsToEntity(EntityBioDemographics bioDemographics) {
        return this.getInnerIdentityService().addBioDemographicsToEntity(bioDemographics);
    }

    public EntityBioDemographics updateBioDemographics(EntityBioDemographics bioDemographics) {
        return this.getInnerIdentityService().updateBioDemographics(bioDemographics);
    }

    public CodedAttribute getEmailType(String code) {
        return this.getInnerIdentityService().getEmailType(code);
    }

    public List<CodedAttribute> findAllEmailTypes() {
        return this.getInnerIdentityService().findAllEmailTypes();
    }

    public PrincipalQueryResults findPrincipals(QueryByCriteria query) throws RiceIllegalArgumentException {
        return this.getInnerIdentityService().findPrincipals(query);
    }

    public CodedAttribute getEmploymentStatus(String code) {
        return this.getInnerIdentityService().getEmploymentStatus(code);
    }

    public List<CodedAttribute> findAllEmploymentStatuses() {
        return this.getInnerIdentityService().findAllEmploymentStatuses();
    }

    public CodedAttribute getEmploymentType(String code) {
        return this.getInnerIdentityService().getEmploymentType(code);
    }

    public List<CodedAttribute> findAllEmploymentTypes() {
        return this.getInnerIdentityService().findAllEmploymentTypes();
    }

    public EntityDefault getEntityDefault(String entityId) {
        EntityDefault entity = this.getInnerIdentityService().getEntityDefault(entityId);
        if (entity == null) {
            entity = this.getIdentityArchiveService().getEntityDefaultFromArchive(entityId);
        } else {
            this.getIdentityArchiveService().saveEntityDefaultToArchive(entity);
        }
        return entity;
    }

    public EntityDefault getEntityDefaultByPrincipalId(String principalId) {
        EntityDefault entity = this.getInnerIdentityService().getEntityDefaultByPrincipalId(principalId);
        if (entity == null) {
            entity = this.getIdentityArchiveService().getEntityDefaultFromArchiveByPrincipalId(principalId);
        } else {
            this.getIdentityArchiveService().saveEntityDefaultToArchive(entity);
        }
        return entity;
    }

    public EntityDefault getEntityDefaultByPrincipalName(String principalName) {
        EntityDefault entity = this.getInnerIdentityService().getEntityDefaultByPrincipalName(principalName);
        if (entity == null) {
            entity = this.getIdentityArchiveService().getEntityDefaultFromArchiveByPrincipalName(principalName);
        } else {
            this.getIdentityArchiveService().saveEntityDefaultToArchive(entity);
        }
        return entity;
    }

    public EntityDefault getEntityDefaultByEmployeeId(String employeeId) {
        EntityDefault entity = this.getInnerIdentityService().getEntityDefaultByEmployeeId(employeeId);
        if (entity == null) {
            entity = this.getIdentityArchiveService().getEntityDefaultFromArchiveByEmployeeId(employeeId);
        } else {
            this.getIdentityArchiveService().saveEntityDefaultToArchive(entity);
        }
        return entity;
    }

    public EntityDefaultQueryResults findEntityDefaults(QueryByCriteria queryByCriteria) {
        return this.getInnerIdentityService().findEntityDefaults(queryByCriteria);
    }

    public EntityQueryResults findEntities(QueryByCriteria queryByCriteria) {
        return this.getInnerIdentityService().findEntities(queryByCriteria);
    }

    public Entity getEntity(String entityId) {
        return this.getInnerIdentityService().getEntity(entityId);
    }

    public Entity getEntityByPrincipalId(String principalId) {
        return this.getInnerIdentityService().getEntityByPrincipalId(principalId);
    }

    public Entity getEntityByPrincipalName(String principalName) {
        return this.getInnerIdentityService().getEntityByPrincipalName(principalName);
    }

    public Entity getEntityByEmployeeId(String employeeId) {
        return this.getInnerIdentityService().getEntityByEmployeeId(employeeId);
    }

    public Entity createEntity(Entity entity) {
        return this.getInnerIdentityService().createEntity(entity);
    }

    public Entity updateEntity(Entity entity) {
        return this.getInnerIdentityService().updateEntity(entity);
    }

    public Entity inactivateEntity(String entityId) {
        return this.getInnerIdentityService().inactivateEntity(entityId);
    }

    public CodedAttribute getNameType(String code) {
        return this.getInnerIdentityService().getNameType(code);
    }

    public List<CodedAttribute> findAllNameTypes() {
        return this.getInnerIdentityService().findAllNameTypes();
    }

    public EntityPrivacyPreferences getEntityPrivacyPreferences(String entityId) {
        return this.getInnerIdentityService().getEntityPrivacyPreferences(entityId);
    }

    public EntityPrivacyPreferences addPrivacyPreferencesToEntity(EntityPrivacyPreferences privacyPreferences) {
        return this.getInnerIdentityService().addPrivacyPreferencesToEntity(privacyPreferences);
    }

    public EntityPrivacyPreferences updatePrivacyPreferences(EntityPrivacyPreferences privacyPreferences) {
        return this.getInnerIdentityService().updatePrivacyPreferences(privacyPreferences);
    }

    public EntityCitizenship addCitizenshipToEntity(EntityCitizenship citizenship) {
        return this.getInnerIdentityService().addCitizenshipToEntity(citizenship);
    }

    public EntityCitizenship updateCitizenship(EntityCitizenship citizenship) {
        return this.getInnerIdentityService().updateCitizenship(citizenship);
    }

    public EntityCitizenship inactivateCitizenship(String id) {
        return this.getInnerIdentityService().inactivateCitizenship(id);
    }

    public EntityEthnicity addEthnicityToEntity(EntityEthnicity ethnicity) {
        return this.getInnerIdentityService().addEthnicityToEntity(ethnicity);
    }

    public EntityEthnicity updateEthnicity(EntityEthnicity ethnicity) {
        return this.getInnerIdentityService().updateEthnicity(ethnicity);
    }

    public EntityResidency addResidencyToEntity(EntityResidency residency) {
        return this.getInnerIdentityService().addResidencyToEntity(residency);
    }

    public EntityResidency updateResidency(EntityResidency residency) {
        return this.getInnerIdentityService().updateResidency(residency);
    }

    public EntityVisa addVisaToEntity(EntityVisa visa) {
        return this.getInnerIdentityService().addVisaToEntity(visa);
    }

    public EntityVisa updateVisa(EntityVisa visa) {
        return this.getInnerIdentityService().updateVisa(visa);
    }

    public CodedAttribute getEntityType(String code) {
        return this.getInnerIdentityService().getEntityType(code);
    }

    public List<CodedAttribute> findAllEntityTypes() {
        return this.getInnerIdentityService().findAllEntityTypes();
    }

    public EntityExternalIdentifierType getExternalIdentifierType(String code) {
        return this.getInnerIdentityService().getExternalIdentifierType(code);
    }

    public List<EntityExternalIdentifierType> findAllExternalIdendtifierTypes() {
        return this.getInnerIdentityService().findAllExternalIdendtifierTypes();
    }

    public CodedAttribute getPhoneType(String code) {
        return this.getInnerIdentityService().getPhoneType(code);
    }

    public List<CodedAttribute> findAllPhoneTypes() {
        return this.getInnerIdentityService().findAllPhoneTypes();
    }

    public Principal getPrincipal(String principalId) {
        List principals;
        EntityDefault entity;
        Principal principal = this.getInnerIdentityService().getPrincipal(principalId);
        if (principal == null && (entity = this.getEntityDefaultByPrincipalId(principalId)) != null && (principals = entity.getPrincipals()) != null && !principals.isEmpty()) {
            principal = (Principal)principals.get(0);
        }
        return principal;
    }

    public List<Principal> getPrincipals(@WebParam(name="principalIds") List<String> principalIds) {
        ArrayList<Principal> ret = new ArrayList<Principal>();
        for (String p : principalIds) {
            Principal principalInfo = this.getPrincipal(p);
            if (principalInfo == null) continue;
            ret.add(principalInfo);
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        return null;
    }

    public Principal getPrincipalByPrincipalName(String principalName) {
        List principals;
        EntityDefault entity;
        Principal principal = this.getInnerIdentityService().getPrincipalByPrincipalName(principalName);
        if (principal == null && (entity = this.getEntityDefaultByPrincipalName(principalName)) != null && (principals = entity.getPrincipals()) != null && !principals.isEmpty()) {
            principal = (Principal)principals.get(0);
        }
        return principal;
    }

    public List<Principal> getPrincipalsByEntityId(String entityId) {
        EntityDefault entity;
        List principals = this.getInnerIdentityService().getPrincipalsByEntityId(entityId);
        if (principals == null && (entity = this.getIdentityArchiveService().getEntityDefaultFromArchive(entityId)) != null && entity.getPrincipals() != null && !entity.getPrincipals().isEmpty()) {
            principals = entity.getPrincipals();
        }
        return principals;
    }

    public List<Principal> getPrincipalsByEmployeeId(String employeeId) {
        EntityDefault entity;
        List principals = this.getInnerIdentityService().getPrincipalsByEmployeeId(employeeId);
        if (principals == null && (entity = this.getIdentityArchiveService().getEntityDefaultFromArchive(employeeId)) != null && entity.getPrincipals() != null && !entity.getPrincipals().isEmpty()) {
            principals = entity.getPrincipals();
        }
        return principals;
    }

    public Principal getPrincipalByPrincipalNameAndPassword(String principalName, String password) {
        return this.getInnerIdentityService().getPrincipalByPrincipalNameAndPassword(principalName, password);
    }

    public Principal addPrincipalToEntity(Principal principal) {
        return this.getInnerIdentityService().addPrincipalToEntity(principal);
    }

    public Principal updatePrincipal(Principal principal) {
        return this.getInnerIdentityService().updatePrincipal(principal);
    }

    public Principal inactivatePrincipal(String principalId) {
        return this.getInnerIdentityService().inactivatePrincipal(principalId);
    }

    public Principal inactivatePrincipalByName(String principalName) {
        return this.getInnerIdentityService().inactivatePrincipalByName(principalName);
    }

    public EntityTypeContactInfo addEntityTypeContactInfoToEntity(EntityTypeContactInfo entityTypeContactInfo) {
        return this.getInnerIdentityService().addEntityTypeContactInfoToEntity(entityTypeContactInfo);
    }

    public EntityTypeContactInfo updateEntityTypeContactInfo(EntityTypeContactInfo entityTypeContactInfo) {
        return this.getInnerIdentityService().updateEntityTypeContactInfo(entityTypeContactInfo);
    }

    public EntityTypeContactInfo inactivateEntityTypeContactInfo(String entityId, String entityTypeCode) {
        return this.getInnerIdentityService().inactivateEntityTypeContactInfo(entityId, entityTypeCode);
    }

    public EntityAddress addAddressToEntity(EntityAddress address) {
        return this.getInnerIdentityService().addAddressToEntity(address);
    }

    public EntityAddress updateAddress(EntityAddress address) {
        return this.getInnerIdentityService().updateAddress(address);
    }

    public EntityAddress inactivateAddress(String addressId) {
        return this.getInnerIdentityService().inactivateAddress(addressId);
    }

    public EntityEmail addEmailToEntity(EntityEmail email) {
        return this.getInnerIdentityService().addEmailToEntity(email);
    }

    public EntityEmail updateEmail(EntityEmail email) {
        return this.getInnerIdentityService().updateEmail(email);
    }

    public EntityEmail inactivateEmail(String emailId) {
        return this.getInnerIdentityService().inactivateEmail(emailId);
    }

    public EntityPhone addPhoneToEntity(EntityPhone phone) {
        return this.getInnerIdentityService().addPhoneToEntity(phone);
    }

    public EntityPhone updatePhone(EntityPhone phone) {
        return this.getInnerIdentityService().updatePhone(phone);
    }

    public EntityPhone inactivatePhone(String phoneId) {
        return this.getInnerIdentityService().inactivatePhone(phoneId);
    }

    public EntityExternalIdentifier addExternalIdentifierToEntity(EntityExternalIdentifier externalId) {
        return this.getInnerIdentityService().addExternalIdentifierToEntity(externalId);
    }

    public EntityExternalIdentifier updateExternalIdentifier(EntityExternalIdentifier externalId) {
        return this.getInnerIdentityService().updateExternalIdentifier(externalId);
    }

    public EntityAffiliation addAffiliationToEntity(EntityAffiliation affiliation) {
        return this.getInnerIdentityService().addAffiliationToEntity(affiliation);
    }

    public EntityAffiliation updateAffiliation(EntityAffiliation affiliation) {
        return this.getInnerIdentityService().updateAffiliation(affiliation);
    }

    public EntityAffiliation inactivateAffiliation(String id) {
        return this.getInnerIdentityService().inactivateAffiliation(id);
    }

    private IdentityService getInnerIdentityService() {
        return this.innerIdentityService;
    }

    private IdentityArchiveService getIdentityArchiveService() {
        return this.identityArchiveService;
    }
}

