/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.address.EntityAddress;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationContract;
import org.kuali.rice.kim.api.identity.email.EntityEmail;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifier;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.phone.EntityPhone;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfoDefault;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.identity.EntityDefaultInfoCacheBo;
import org.kuali.rice.kim.impl.identity.KimInternalSuppressUtils;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentStatusBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentTypeBo;
import org.kuali.rice.krad.bo.TransientBusinessObjectBase;

public class PersonImpl
extends TransientBusinessObjectBase
implements Person {
    private static final long serialVersionUID = 1L;
    protected static PersonService personService;
    protected static IdentityService identityService;
    private String lookupRoleNamespaceCode;
    private String lookupRoleName;
    protected String principalId;
    protected String principalName;
    protected String entityId;
    protected String entityTypeCode;
    protected String firstName = "";
    protected String middleName = "";
    protected String lastName = "";
    protected String name = "";
    protected EntityAddress address;
    protected String emailAddress = "";
    protected String phoneNumber = "";
    protected boolean suppressName = false;
    protected boolean suppressAddress = false;
    protected boolean suppressPhone = false;
    protected boolean suppressPersonal = false;
    protected boolean suppressEmail = false;
    protected List<? extends EntityAffiliationContract> affiliations;
    protected String campusCode = "";
    protected Map<String, String> externalIdentifiers = null;
    protected String employeeStatusCode = "";
    protected EntityEmploymentStatusBo employeeStatus;
    protected String employeeTypeCode = "";
    protected EntityEmploymentTypeBo employeeType;
    protected String primaryDepartmentCode = "";
    protected String employeeId = "";
    protected KualiDecimal baseSalaryAmount = KualiDecimal.ZERO;
    protected boolean active = true;

    public PersonImpl() {
    }

    public PersonImpl(Principal principal, String personEntityTypeCode) {
        this(principal, null, personEntityTypeCode);
    }

    public PersonImpl(Principal principal, EntityDefault entity, String personEntityTypeCode) {
        this.setPrincipal(principal, entity, personEntityTypeCode);
    }

    public PersonImpl(String principalId, String personEntityTypeCode) {
        this(PersonImpl.getIdentityService().getPrincipal(principalId), personEntityTypeCode);
    }

    public PersonImpl(EntityDefaultInfoCacheBo p) {
        this.entityId = p.getEntityId();
        this.principalId = p.getPrincipalId();
        this.principalName = p.getPrincipalName();
        this.entityTypeCode = p.getEntityTypeCode();
        this.firstName = p.getFirstName();
        this.middleName = p.getMiddleName();
        this.lastName = p.getLastName();
        this.name = p.getName();
        this.campusCode = p.getCampusCode();
        this.primaryDepartmentCode = p.getPrimaryDepartmentCode();
        this.employeeId = p.getEmployeeId();
        this.affiliations = new ArrayList<EntityAffiliationContract>(0);
        this.externalIdentifiers = new HashMap<String, String>(0);
    }

    public void setPrincipal(Principal principal, EntityDefault entity, String personEntityTypeCode) {
        this.populatePrincipalInfo(principal);
        if (entity == null) {
            entity = PersonImpl.getIdentityService().getEntityDefault(principal.getEntityId());
        }
        this.populateEntityInfo(entity, principal, personEntityTypeCode);
    }

    protected void populatePrincipalInfo(Principal principal) {
        this.entityId = principal.getEntityId();
        this.principalId = principal.getPrincipalId();
        this.principalName = principal.getPrincipalName();
        this.active = principal.isActive();
    }

    protected void populateEntityInfo(EntityDefault entity, Principal principal, String personEntityTypeCode) {
        if (entity != null) {
            this.populatePrivacyInfo(entity);
            EntityTypeContactInfoDefault entityTypeContactInfoDefault = entity.getEntityType(personEntityTypeCode);
            this.entityTypeCode = personEntityTypeCode;
            this.populateNameInfo(personEntityTypeCode, entity, principal);
            this.populateAddressInfo(entityTypeContactInfoDefault);
            this.populateEmailInfo(entityTypeContactInfoDefault);
            this.populatePhoneInfo(entityTypeContactInfoDefault);
            this.populateAffiliationInfo(entity);
            this.populateEmploymentInfo(entity);
            this.populateExternalIdentifiers(entity);
        }
    }

    protected void populateNameInfo(String entityTypeCode, EntityDefault entity, Principal principal) {
        if (entity != null) {
            EntityName entityName = entity.getName();
            if (entityName != null) {
                this.firstName = this.unNullify(entityName.getFirstName());
                this.middleName = this.unNullify(entityName.getMiddleName());
                this.lastName = this.unNullify(entityName.getLastName());
                if (entityTypeCode.equals("SYSTEM")) {
                    this.name = principal.getPrincipalName().toUpperCase();
                } else {
                    this.name = this.unNullify(entityName.getCompositeName());
                    if (this.name.equals("") || this.name == null) {
                        this.name = this.lastName + ", " + this.firstName;
                    }
                }
            } else {
                this.firstName = "";
                this.middleName = "";
                if (entityTypeCode.equals("SYSTEM")) {
                    this.name = principal.getPrincipalName().toUpperCase();
                    this.lastName = principal.getPrincipalName().toUpperCase();
                } else {
                    this.name = "";
                    this.lastName = "";
                }
            }
        }
    }

    protected void populatePrivacyInfo(EntityDefault entity) {
        if (entity != null && entity.getPrivacyPreferences() != null) {
            this.suppressName = entity.getPrivacyPreferences().isSuppressName();
            this.suppressAddress = entity.getPrivacyPreferences().isSuppressAddress();
            this.suppressPhone = entity.getPrivacyPreferences().isSuppressPhone();
            this.suppressPersonal = entity.getPrivacyPreferences().isSuppressPersonal();
            this.suppressEmail = entity.getPrivacyPreferences().isSuppressEmail();
        }
    }

    protected void populateAddressInfo(EntityTypeContactInfoDefault contactInfoDefault) {
        if (contactInfoDefault != null) {
            EntityAddress defaultAddress = contactInfoDefault.getDefaultAddress();
            if (defaultAddress != null) {
                this.address = defaultAddress;
            } else {
                EntityAddress.Builder builder = EntityAddress.Builder.create();
                builder.setCity("");
                builder.setCountryCode("");
                builder.setLine1("");
                builder.setLine2("");
                builder.setLine3("");
                builder.setCity("");
                builder.setPostalCode("");
                builder.setStateProvinceCode("");
                builder.setActive(true);
                this.address = builder.build();
            }
        }
    }

    protected void populateEmailInfo(EntityTypeContactInfoDefault contactInfoDefault) {
        if (contactInfoDefault != null) {
            EntityEmail entityEmail = contactInfoDefault.getDefaultEmailAddress();
            this.emailAddress = entityEmail != null ? this.unNullify(entityEmail.getEmailAddressUnmasked()) : "";
        }
    }

    protected void populatePhoneInfo(EntityTypeContactInfoDefault contactInfoDefault) {
        if (contactInfoDefault != null) {
            EntityPhone entityPhone = contactInfoDefault.getDefaultPhoneNumber();
            this.phoneNumber = entityPhone != null ? this.unNullify(entityPhone.getFormattedPhoneNumberUnmasked()) : "";
        }
    }

    protected void populateAffiliationInfo(EntityDefault entity) {
        if (entity != null) {
            this.affiliations = entity.getAffiliations();
            EntityAffiliation defaultAffiliation = entity.getDefaultAffiliation();
            this.campusCode = defaultAffiliation != null ? this.unNullify(defaultAffiliation.getCampusCode()) : "";
        }
    }

    protected void populateEmploymentInfo(EntityDefault entity) {
        if (entity != null) {
            EntityEmployment employmentInformation = entity.getEmployment();
            if (employmentInformation != null) {
                this.employeeStatusCode = this.unNullify(employmentInformation.getEmployeeStatus() != null ? employmentInformation.getEmployeeStatus().getCode() : null);
                this.employeeTypeCode = this.unNullify(employmentInformation.getEmployeeType() != null ? employmentInformation.getEmployeeType().getCode() : null);
                this.primaryDepartmentCode = this.unNullify(employmentInformation.getPrimaryDepartmentCode());
                this.employeeId = this.unNullify(employmentInformation.getEmployeeId());
                this.baseSalaryAmount = employmentInformation.getBaseSalaryAmount() != null ? employmentInformation.getBaseSalaryAmount() : KualiDecimal.ZERO;
            } else {
                this.employeeStatusCode = "";
                this.employeeTypeCode = "";
                this.primaryDepartmentCode = "";
                this.employeeId = "";
                this.baseSalaryAmount = KualiDecimal.ZERO;
            }
        }
    }

    protected void populateExternalIdentifiers(EntityDefault entity) {
        if (entity != null) {
            List externalIds = entity.getExternalIdentifiers();
            this.externalIdentifiers = new HashMap<String, String>(externalIds.size());
            for (EntityExternalIdentifier eei : externalIds) {
                this.externalIdentifiers.put(eei.getExternalIdentifierTypeCode(), eei.getExternalId());
            }
        }
    }

    private String unNullify(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public String getFirstName() {
        if (KimInternalSuppressUtils.isSuppressName(this.getEntityId())) {
            return "Xxxxxx";
        }
        return this.firstName;
    }

    public String getFirstNameUnmasked() {
        return this.firstName;
    }

    public String getMiddleName() {
        if (KimInternalSuppressUtils.isSuppressName(this.getEntityId())) {
            return "Xxxxxx";
        }
        return this.middleName;
    }

    public String getMiddleNameUnmasked() {
        return this.middleName;
    }

    public String getLastName() {
        if (KimInternalSuppressUtils.isSuppressName(this.getEntityId())) {
            return "Xxxxxx";
        }
        return this.lastName;
    }

    public String getLastNameUnmasked() {
        return this.lastName;
    }

    public String getName() {
        if (StringUtils.isNotBlank((String)this.getEntityId()) && KimInternalSuppressUtils.isSuppressName(this.getEntityId())) {
            return "Xxxxxx";
        }
        return this.name;
    }

    public String getNameUnmasked() {
        return this.name;
    }

    public String getPhoneNumber() {
        if (KimInternalSuppressUtils.isSuppressPhone(this.getEntityId())) {
            return "Xxxxxx";
        }
        return this.phoneNumber;
    }

    public String getPhoneNumberUnmasked() {
        return this.phoneNumber;
    }

    public String getEmailAddress() {
        if (KimInternalSuppressUtils.isSuppressEmail(this.getEntityId())) {
            return "Xxxxxx";
        }
        return this.emailAddress;
    }

    public String getEmailAddressUnmasked() {
        return this.emailAddress;
    }

    public List<? extends EntityAffiliationContract> getAffiliations() {
        return this.affiliations;
    }

    public boolean hasAffiliationOfType(String affiliationTypeCode) {
        return this.getCampusCodesForAffiliationOfType(affiliationTypeCode).size() > 0;
    }

    public List<String> getCampusCodesForAffiliationOfType(String affiliationTypeCode) {
        ArrayList<String> campusCodes = new ArrayList<String>(3);
        if (affiliationTypeCode == null) {
            return campusCodes;
        }
        for (EntityAffiliationContract entityAffiliationContract : this.getAffiliations()) {
            if (!entityAffiliationContract.getAffiliationType().getCode().equals(affiliationTypeCode)) continue;
            campusCodes.add(entityAffiliationContract.getCampusCode());
        }
        return campusCodes;
    }

    public String getExternalId(String externalIdentifierTypeCode) {
        return this.externalIdentifiers.get(externalIdentifierTypeCode);
    }

    public String getCampusCode() {
        return this.campusCode;
    }

    public static PersonService getPersonService() {
        if (personService == null) {
            personService = KimApiServiceLocator.getPersonService();
        }
        return personService;
    }

    public static IdentityService getIdentityService() {
        if (identityService == null) {
            identityService = KimApiServiceLocator.getIdentityService();
        }
        return identityService;
    }

    public Map<String, String> getExternalIdentifiers() {
        return this.externalIdentifiers;
    }

    public String getAddressLine1() {
        return this.address.getLine1();
    }

    public String getAddressLine1Unmasked() {
        return this.address.getLine1Unmasked();
    }

    public String getAddressLine2() {
        return this.address.getLine2();
    }

    public String getAddressLine2Unmasked() {
        return this.address.getLine2Unmasked();
    }

    public String getAddressLine3() {
        return this.address.getLine3();
    }

    public String getAddressLine3Unmasked() {
        return this.address.getLine3Unmasked();
    }

    public String getAddressCity() {
        return this.address.getCity();
    }

    public String getAddressCityUnmasked() {
        return this.address.getCityUnmasked();
    }

    public String getAddressStateProvinceCode() {
        return this.address.getStateProvinceCode();
    }

    public String getAddressStateProvinceCodeUnmasked() {
        return this.address.getStateProvinceCodeUnmasked();
    }

    public String getAddressPostalCode() {
        return this.address.getPostalCode();
    }

    public String getAddressPostalCodeUnmasked() {
        return this.address.getPostalCodeUnmasked();
    }

    public String getAddressCountryCode() {
        return this.address.getCountryCode();
    }

    public String getAddressCountryCodeUnmasked() {
        return this.address.getCountryCodeUnmasked();
    }

    public String getEmployeeStatusCode() {
        return this.employeeStatusCode;
    }

    public String getEmployeeTypeCode() {
        return this.employeeTypeCode;
    }

    public KualiDecimal getBaseSalaryAmount() {
        return this.baseSalaryAmount;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public String getPrimaryDepartmentCode() {
        return this.primaryDepartmentCode;
    }

    public String getEntityTypeCode() {
        return this.entityTypeCode;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getLookupRoleNamespaceCode() {
        return this.lookupRoleNamespaceCode;
    }

    public void setLookupRoleNamespaceCode(String lookupRoleNamespaceCode) {
        this.lookupRoleNamespaceCode = lookupRoleNamespaceCode;
    }

    public String getLookupRoleName() {
        return this.lookupRoleName;
    }

    public void setLookupRoleName(String lookupRoleName) {
        this.lookupRoleName = lookupRoleName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EntityEmploymentStatusBo getEmployeeStatus() {
        return this.employeeStatus;
    }

    public EntityEmploymentTypeBo getEmployeeType() {
        return this.employeeType;
    }
}

