/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.permission;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.impl.permission.PermissionAttributeBo;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kim.impl.permission.PermissionTemplateBo;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KRIM_PERM_T")
public class GenericPermissionBo
extends PersistableBusinessObjectBase {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="PERM_ID")
    protected String id;
    protected String namespaceCode;
    protected String name;
    protected String description;
    protected boolean active;
    protected String templateId;
    protected String detailValues;
    protected Map<String, String> details;
    protected PermissionTemplateBo template = new PermissionTemplateBo();
    protected List<PermissionAttributeBo> attributeDetails;

    public GenericPermissionBo() {
    }

    public GenericPermissionBo(PermissionBo perm) {
        this.loadFromPermission(perm);
    }

    public void loadFromPermission(PermissionBo perm) {
        this.setId(perm.getId());
        this.setNamespaceCode(perm.getNamespaceCode());
        this.setTemplate(perm.getTemplate());
        this.setAttributeDetails(perm.getAttributeDetails());
        this.setDetailValues(perm.getDetailObjectsValues());
        this.setName(perm.getName());
        this.setTemplateId(perm.getTemplateId());
        this.setDescription(perm.getDescription());
        this.setActive(perm.isActive());
        this.setDetails(perm.getAttributes());
        this.setVersionNumber(perm.getVersionNumber());
        this.setObjectId(perm.getObjectId());
        this.setExtension(perm.getExtension());
    }

    public String getDetailValues() {
        return this.detailValues;
    }

    public void setDetailValues(String detailValues) {
        this.detailValues = detailValues;
    }

    public void setDetailValues(Map<String, String> detailsAttribs) {
        StringBuffer sb = new StringBuffer();
        if (detailsAttribs != null) {
            Iterator<String> keyIter = detailsAttribs.keySet().iterator();
            while (keyIter.hasNext()) {
                String key = keyIter.next();
                sb.append(key).append('=').append(detailsAttribs.get(key));
                if (!keyIter.hasNext()) continue;
                sb.append('\n');
            }
        }
        this.detailValues = sb.toString();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public PermissionTemplateBo getTemplate() {
        return this.template;
    }

    public void setDescription(String permissionDescription) {
        this.description = permissionDescription;
    }

    public void setName(String permissionName) {
        this.name = permissionName;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
        this.setDetailValues(details);
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setTemplate(PermissionTemplateBo template) {
        this.template = template;
    }

    public Map<String, String> getDetails() {
        String detailValuesTemp = this.detailValues;
        HashMap<String, String> detailsTemp = new HashMap<String, String>();
        if (detailValuesTemp != null) {
            detailValuesTemp = detailValuesTemp.replace("\r\n", "\n");
            if (StringUtils.isNotBlank((String)(detailValuesTemp = detailValuesTemp.replace('\r', '\n')))) {
                String[] values;
                for (String attrib : values = detailValuesTemp.split("\n")) {
                    if (attrib.indexOf(61) == -1) continue;
                    String[] keyValueArray = attrib.split("=", 2);
                    detailsTemp.put(keyValueArray[0].trim(), keyValueArray[1].trim());
                }
            }
        }
        this.details = detailsTemp;
        return this.details;
    }

    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    public void setNamespaceCode(String namespaceCode) {
        this.namespaceCode = namespaceCode;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<PermissionAttributeBo> getAttributeDetails() {
        return this.attributeDetails;
    }

    public void setAttributeDetails(List<PermissionAttributeBo> attributeDetails) {
        this.attributeDetails = attributeDetails;
    }

    public void refreshNonUpdateableReferences() {
    }

    public void refreshReferenceObject(String referenceObjectName) {
    }

    protected void prePersist() {
        throw new UnsupportedOperationException("This object should never be persisted.");
    }

    protected void preUpdate() {
        throw new UnsupportedOperationException("This object should never be persisted.");
    }

    protected void preRemove() {
        throw new UnsupportedOperationException("This object should never be persisted.");
    }

    public static PermissionBo toPermissionBo(GenericPermissionBo bo) {
        PermissionBo permission = new PermissionBo();
        permission.setTemplateId(bo.getTemplateId());
        permission.setId(bo.getId());
        permission.setTemplate(bo.getTemplate());
        permission.setActive(bo.isActive());
        permission.setDescription(bo.getDescription());
        permission.setName(bo.getName());
        permission.setNamespaceCode(bo.namespaceCode);
        permission.setAttributeDetails(bo.getAttributeDetails());
        permission.setAttributes(bo.getDetails());
        permission.setVersionNumber(bo.versionNumber);
        permission.setObjectId(bo.getObjectId());
        permission.setExtension(bo.getExtension());
        return permission;
    }
}

