/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.permission;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.permission.PermissionContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.permission.PermissionAttributeBo;
import org.kuali.rice.kim.impl.permission.PermissionTemplateBo;
import org.kuali.rice.kim.impl.role.RolePermissionBo;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.springframework.util.AutoPopulatingList;

@Entity
@Table(name="KRIM_PERM_T")
public class PermissionBo
extends PersistableBusinessObjectBase
implements PermissionContract {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="PERM_ID")
    private String id;
    @Column(name="NMSPC_CD")
    private String namespaceCode;
    @Column(name="NM")
    private String name;
    @Column(name="DESC_TXT", length=400)
    private String description;
    @Column(name="PERM_TMPL_ID")
    private String templateId;
    @Column(name="ACTV_IND")
    @Type(type="yes_no")
    private boolean active;
    @OneToOne(targetEntity=PermissionTemplateBo.class, cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="PERM_TMPL_ID", insertable=false, updatable=false)
    private PermissionTemplateBo template = new PermissionTemplateBo();
    @OneToMany(targetEntity=PermissionAttributeBo.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="id")
    @Fetch(value=FetchMode.SELECT)
    private List<PermissionAttributeBo> attributeDetails;
    @Transient
    private Map<String, String> attributes;
    @OneToMany(targetEntity=RolePermissionBo.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="id")
    @Fetch(value=FetchMode.SELECT)
    private List<RolePermissionBo> rolePermissions = new AutoPopulatingList(RolePermissionBo.class);

    public Map<String, String> getAttributes() {
        return this.attributeDetails != null ? KimAttributeDataBo.toAttributes(this.attributeDetails) : this.attributes;
    }

    public Map<String, String> getDetails() {
        return this.attributeDetails != null ? KimAttributeDataBo.toAttributes(this.attributeDetails) : this.attributes;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    public void setNamespaceCode(String namespaceCode) {
        this.namespaceCode = namespaceCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public List<PermissionAttributeBo> getAttributeDetails() {
        return this.attributeDetails;
    }

    public void setAttributeDetails(List<PermissionAttributeBo> attributeDetails) {
        this.attributeDetails = attributeDetails;
    }

    public List<RolePermissionBo> getRolePermissions() {
        return this.rolePermissions;
    }

    public void setRolePermissions(List<RolePermissionBo> rolePermissions) {
        this.rolePermissions = rolePermissions;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public static Permission to(PermissionBo bo) {
        if (bo == null) {
            return null;
        }
        return Permission.Builder.create((PermissionContract)bo).build();
    }

    public static PermissionBo from(Permission im) {
        if (im == null) {
            return null;
        }
        PermissionBo bo = new PermissionBo();
        bo.setId(im.getId());
        bo.setNamespaceCode(im.getNamespaceCode());
        bo.setName(im.getName());
        bo.setDescription(im.getDescription());
        bo.setActive(im.isActive());
        bo.setTemplateId(im.getTemplate() != null ? im.getTemplate().getId() : null);
        bo.setTemplate(PermissionTemplateBo.from(im.getTemplate()));
        bo.setAttributes(im.getAttributes());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());
        return bo;
    }

    public PermissionTemplateBo getTemplate() {
        return this.template;
    }

    public void setTemplate(PermissionTemplateBo template) {
        this.template = template;
    }

    public String getDetailObjectsValues() {
        StringBuffer detailObjectsToDisplayBuffer = new StringBuffer();
        Iterator<PermissionAttributeBo> permIter = this.attributeDetails.iterator();
        while (permIter.hasNext()) {
            PermissionAttributeBo permissionAttributeData = permIter.next();
            detailObjectsToDisplayBuffer.append(permissionAttributeData.getAttributeValue());
            if (!permIter.hasNext()) continue;
            detailObjectsToDisplayBuffer.append(", ");
        }
        return detailObjectsToDisplayBuffer.toString();
    }

    public String getDetailObjectsToDisplay() {
        KimType kimType = this.getTypeInfoService().getKimType(this.getTemplate().getKimTypeId());
        StringBuffer detailObjects = new StringBuffer();
        Iterator<PermissionAttributeBo> permIter = this.attributeDetails.iterator();
        while (permIter.hasNext()) {
            PermissionAttributeBo bo = permIter.next();
            detailObjects.append(this.getKimAttributeLabelFromDD(kimType.getAttributeDefinitionById(bo.getKimAttributeId()))).append(":").append(bo.getAttributeValue());
            if (!permIter.hasNext()) continue;
            detailObjects.append(", ");
        }
        return detailObjects.toString();
    }

    private String getKimAttributeLabelFromDD(KimTypeAttribute attribute) {
        return this.getDataDictionaryService().getAttributeLabel(attribute.getKimAttribute().getComponentName(), attribute.getKimAttribute().getAttributeName());
    }

    private DataDictionaryService getDataDictionaryService() {
        return KRADServiceLocatorWeb.getDataDictionaryService();
    }

    private KimTypeInfoService getTypeInfoService() {
        return KimApiServiceLocator.getKimTypeInfoService();
    }
}

