/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.criteria.CriteriaLookupService;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.namespace.Namespace;
import org.kuali.rice.coreservice.api.namespace.NamespaceService;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.framework.role.RoleEbo;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateTypeBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityInternalService;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleBoLite;
import org.kuali.rice.kim.impl.role.RoleDao;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityActionBo;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LookupService;
import org.kuali.rice.krad.util.ObjectUtils;

abstract class RoleServiceBase {
    private static final Logger LOG = Logger.getLogger(RoleServiceBase.class);
    private BusinessObjectService businessObjectService;
    private LookupService lookupService;
    private IdentityService identityService;
    private NamespaceService namespaceService;
    private KimTypeInfoService kimTypeInfoService;
    private GroupService groupService;
    private ResponsibilityInternalService responsibilityInternalService;
    private RoleDao roleDao;
    protected CriteriaLookupService criteriaLookupService;

    RoleServiceBase() {
    }

    void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }

    private Map<String, String> convertQualifierKeys(Map<String, String> qualification, Map<String, String> validAttributeIds) {
        HashMap<String, String> convertedQualification = new HashMap<String, String>();
        if (qualification != null && CollectionUtils.isNotEmpty(qualification.entrySet())) {
            for (Map.Entry<String, String> entry : qualification.entrySet()) {
                String attributeId = validAttributeIds.get(entry.getKey());
                if (!StringUtils.isNotEmpty((String)attributeId)) continue;
                convertedQualification.put(attributeId, entry.getValue());
            }
        }
        return convertedQualification;
    }

    protected void getNestedRoleTypeMemberIds(String roleId, Set<String> members) {
        ArrayList<String> roleList = new ArrayList<String>(1);
        roleList.add(roleId);
        List<RoleMemberBo> firstLevelMembers = this.getStoredRoleMembersForRoleIds(roleList, MemberType.ROLE.getCode(), Collections.emptyMap());
        for (RoleMemberBo member : firstLevelMembers) {
            if (!MemberType.ROLE.equals((Object)member.getType()) || members.contains(member.getMemberId())) continue;
            members.add(member.getMemberId());
            this.getNestedRoleTypeMemberIds(member.getMemberId(), members);
        }
    }

    protected List<RoleMemberBo> getRoleMembersForPrincipalId(String roleId, String principalId) {
        return this.roleDao.getRolePrincipalsForPrincipalIdAndRoleIds(Collections.singletonList(roleId), principalId, null);
    }

    protected List<RoleMemberBo> getRoleMembersForGroupIds(String roleId, List<String> groupIds) {
        if (CollectionUtils.isEmpty(groupIds)) {
            return new ArrayList<RoleMemberBo>();
        }
        return this.roleDao.getRoleMembersForGroupIds(roleId, groupIds);
    }

    protected List<RoleMemberBo> getRoleMemberBoList(RoleDaoAction daoActionToTake, Collection<String> roleIds, String principalId, Collection<String> groupIds, String memberTypeCode, Map<String, String> qualification) {
        if (roleIds == null || roleIds.isEmpty()) {
            roleIds = Collections.emptyList();
        }
        if (groupIds == null || groupIds.isEmpty()) {
            groupIds = Collections.emptyList();
        }
        HashMap<String, String> validAttributeIds = new HashMap<String, String>();
        HashSet<String> kimTypeIds = new HashSet<String>();
        for (String roleId : roleIds) {
            RoleBoLite role = this.getRoleBoLite(roleId);
            kimTypeIds.add(role.getKimTypeId());
        }
        if (qualification != null && CollectionUtils.isNotEmpty(qualification.entrySet())) {
            for (String kimTypeId : kimTypeIds) {
                for (Map.Entry<String, String> entry : qualification.entrySet()) {
                    validAttributeIds.put(entry.getKey(), this.getKimAttributeId(kimTypeId, entry.getKey()));
                }
            }
        }
        Map<String, String> convertedQualification = this.convertQualifierKeys(qualification, validAttributeIds);
        switch (daoActionToTake) {
            case ROLE_PRINCIPALS_FOR_PRINCIPAL_ID_AND_ROLE_IDS: {
                return this.roleDao.getRolePrincipalsForPrincipalIdAndRoleIds(roleIds, principalId, convertedQualification);
            }
            case ROLE_GROUPS_FOR_GROUP_IDS_AND_ROLE_IDS: {
                return this.roleDao.getRoleGroupsForGroupIdsAndRoleIds(roleIds, groupIds, convertedQualification);
            }
            case ROLE_MEMBERS_FOR_ROLE_IDS: {
                return this.roleDao.getRoleMembersForRoleIds(roleIds, memberTypeCode, convertedQualification);
            }
            case ROLE_MEMBERSHIPS_FOR_ROLE_IDS_AS_MEMBERS: {
                return this.roleDao.getRoleMembershipsForRoleIdsAsMembers(roleIds, convertedQualification);
            }
            case ROLE_MEMBERS_FOR_ROLE_IDS_WITH_FILTERS: {
                return this.roleDao.getRoleMembersForRoleIdsWithFilters(roleIds, principalId, groupIds, convertedQualification);
            }
        }
        throw new IllegalArgumentException("The 'daoActionToTake' parameter cannot refer to a non-role-member-related value!");
    }

    protected List<RoleMemberBo> getStoredRolePrincipalsForPrincipalIdAndRoleIds(Collection<String> roleIds, String principalId, Map<String, String> qualification) {
        return this.getRoleMemberBoList(RoleDaoAction.ROLE_PRINCIPALS_FOR_PRINCIPAL_ID_AND_ROLE_IDS, roleIds, principalId, Collections.emptyList(), null, qualification);
    }

    protected List<RoleMemberBo> getStoredRoleGroupsForGroupIdsAndRoleIds(Collection<String> roleIds, Collection<String> groupIds, Map<String, String> qualification) {
        return this.getRoleMemberBoList(RoleDaoAction.ROLE_GROUPS_FOR_GROUP_IDS_AND_ROLE_IDS, roleIds, null, groupIds, null, qualification);
    }

    protected List<RoleMemberBo> getStoredRoleMembersForRoleIds(Collection<String> roleIds, String memberTypeCode, Map<String, String> qualification) {
        return this.getRoleMemberBoList(RoleDaoAction.ROLE_MEMBERS_FOR_ROLE_IDS, roleIds, null, Collections.emptyList(), memberTypeCode, qualification);
    }

    protected List<RoleMemberBo> getStoredRoleMembershipsForRoleIdsAsMembers(Collection<String> roleIds, Map<String, String> qualification) {
        return this.getRoleMemberBoList(RoleDaoAction.ROLE_MEMBERSHIPS_FOR_ROLE_IDS_AS_MEMBERS, roleIds, null, Collections.emptyList(), null, qualification);
    }

    protected List<RoleMemberBo> getStoredRoleMembersForRoleIdsWithFilters(Collection<String> roleIds, String principalId, List<String> groupIds, Map<String, String> qualification) {
        return this.getRoleMemberBoList(RoleDaoAction.ROLE_MEMBERS_FOR_ROLE_IDS_WITH_FILTERS, roleIds, principalId, groupIds, null, qualification);
    }

    protected RoleMemberBo getRoleMemberBo(String roleMemberId) {
        if (StringUtils.isBlank((String)roleMemberId)) {
            return null;
        }
        return (RoleMemberBo)this.getBusinessObjectService().findByPrimaryKey(RoleMemberBo.class, Collections.singletonMap("id", roleMemberId));
    }

    protected RoleResponsibilityActionBo getRoleResponsibilityActionBo(String roleResponsibilityActionId) {
        if (StringUtils.isBlank((String)roleResponsibilityActionId)) {
            return null;
        }
        return (RoleResponsibilityActionBo)this.getBusinessObjectService().findByPrimaryKey(RoleResponsibilityActionBo.class, Collections.singletonMap("id", roleResponsibilityActionId));
    }

    protected Map<String, DelegateTypeBo> getStoredDelegationImplMapFromRoleIds(Collection<String> roleIds) {
        if (roleIds != null && !roleIds.isEmpty()) {
            return this.roleDao.getDelegationImplMapFromRoleIds(roleIds);
        }
        return Collections.emptyMap();
    }

    protected List<DelegateTypeBo> getStoredDelegationImplsForRoleIds(Collection<String> roleIds) {
        if (roleIds != null && !roleIds.isEmpty()) {
            return this.roleDao.getDelegationBosForRoleIds(roleIds);
        }
        return Collections.emptyList();
    }

    protected List<DelegateMemberBo> getDelegationMemberBoList(RoleDaoAction daoActionToTake, Collection<String> delegationIds, String principalId, List<String> groupIds) {
        if (delegationIds == null || delegationIds.isEmpty()) {
            delegationIds = Collections.emptyList();
        }
        if (groupIds == null || groupIds.isEmpty()) {
            groupIds = Collections.emptyList();
        }
        switch (daoActionToTake) {
            case DELEGATION_PRINCIPALS_FOR_PRINCIPAL_ID_AND_DELEGATION_IDS: {
                return this.roleDao.getDelegationPrincipalsForPrincipalIdAndDelegationIds(delegationIds, principalId);
            }
            case DELEGATION_GROUPS_FOR_GROUP_IDS_AND_DELEGATION_IDS: {
                return this.roleDao.getDelegationGroupsForGroupIdsAndDelegationIds(delegationIds, groupIds);
            }
        }
        throw new IllegalArgumentException("The 'daoActionToTake' parameter cannot refer to a non-delegation-member-list-related value!");
    }

    protected List<DelegateMemberBo> getStoredDelegationPrincipalsForPrincipalIdAndDelegationIds(Collection<String> delegationIds, String principalId) {
        return this.getDelegationMemberBoList(RoleDaoAction.DELEGATION_PRINCIPALS_FOR_PRINCIPAL_ID_AND_DELEGATION_IDS, delegationIds, principalId, null);
    }

    protected DelegateMemberBo getDelegateMemberBo(String delegationMemberId) {
        if (StringUtils.isBlank((String)delegationMemberId)) {
            return null;
        }
        return (DelegateMemberBo)this.getBusinessObjectService().findByPrimaryKey(DelegateMemberBo.class, Collections.singletonMap("delegationMemberId", delegationMemberId));
    }

    protected List<DelegateMemberBo> getDelegationMemberBoListByMemberAndDelegationId(String memberId, String delegationId) {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("memberId", memberId);
        searchCriteria.put("delegationId", delegationId);
        return new ArrayList<DelegateMemberBo>(this.getBusinessObjectService().findMatching(DelegateMemberBo.class, searchCriteria));
    }

    protected Object getMember(String memberTypeCode, String memberId) {
        if (StringUtils.isBlank((String)memberId)) {
            return null;
        }
        if (MemberType.PRINCIPAL.getCode().equals(memberTypeCode)) {
            return this.getIdentityService().getPrincipal(memberId);
        }
        if (MemberType.GROUP.getCode().equals(memberTypeCode)) {
            return this.getGroupService().getGroup(memberId);
        }
        if (MemberType.ROLE.getCode().equals(memberTypeCode)) {
            return this.getRoleBo(memberId);
        }
        return null;
    }

    protected String getMemberName(Object member) {
        if (member == null) {
            return "";
        }
        if (member instanceof Principal) {
            return ((Principal)member).getPrincipalName();
        }
        if (member instanceof Group) {
            return ((Group)member).getName();
        }
        if (member instanceof Role) {
            return ((Role)member).getName();
        }
        return member.toString();
    }

    protected RoleBo getRoleBo(String roleId) {
        if (StringUtils.isBlank((String)roleId)) {
            return null;
        }
        return (RoleBo)this.getBusinessObjectService().findBySinglePrimaryKey(RoleBo.class, (Object)roleId);
    }

    protected RoleBoLite getRoleBoLite(String roleId) {
        if (StringUtils.isBlank((String)roleId)) {
            return null;
        }
        return (RoleBoLite)this.getBusinessObjectService().findBySinglePrimaryKey(RoleBoLite.class, (Object)roleId);
    }

    protected DelegateTypeBo getDelegationOfType(String roleId, DelegationType delegationType) {
        List<DelegateTypeBo> roleDelegates = this.getRoleDelegations(roleId);
        if (this.isDelegationPrimary(delegationType)) {
            return this.getPrimaryDelegation(roleId, roleDelegates);
        }
        return this.getSecondaryDelegation(roleId, roleDelegates);
    }

    private DelegateTypeBo getSecondaryDelegation(String roleId, List<DelegateTypeBo> roleDelegates) {
        DelegateTypeBo secondaryDelegate = null;
        RoleBoLite roleBo = this.getRoleBoLite(roleId);
        for (DelegateTypeBo delegate : roleDelegates) {
            if (!this.isDelegationSecondary(delegate.getDelegationType())) continue;
            secondaryDelegate = delegate;
        }
        if (secondaryDelegate == null) {
            secondaryDelegate = new DelegateTypeBo();
            secondaryDelegate.setRoleId(roleId);
            secondaryDelegate.setDelegationType(DelegationType.SECONDARY);
            secondaryDelegate.setKimTypeId(roleBo.getKimTypeId());
        }
        return secondaryDelegate;
    }

    protected DelegateTypeBo getPrimaryDelegation(String roleId, List<DelegateTypeBo> roleDelegates) {
        DelegateTypeBo primaryDelegate = null;
        RoleBoLite roleBo = this.getRoleBoLite(roleId);
        for (DelegateTypeBo delegate : roleDelegates) {
            if (!this.isDelegationPrimary(delegate.getDelegationType())) continue;
            primaryDelegate = delegate;
        }
        if (primaryDelegate == null) {
            primaryDelegate = new DelegateTypeBo();
            primaryDelegate.setRoleId(roleId);
            primaryDelegate.setDelegationType(DelegationType.PRIMARY);
            primaryDelegate.setKimTypeId(roleBo.getKimTypeId());
        }
        return primaryDelegate;
    }

    protected RoleMemberBo matchingMemberRecord(List<RoleMemberBo> roleMembers, String memberId, String memberTypeCode, Map<String, String> qualifier) {
        for (RoleMemberBo rm : roleMembers) {
            if (!this.doesMemberMatch(rm, memberId, memberTypeCode, qualifier)) continue;
            return rm;
        }
        return null;
    }

    protected boolean isDelegationPrimary(DelegationType delegationType) {
        return DelegationType.PRIMARY.equals((Object)delegationType);
    }

    protected boolean isDelegationSecondary(DelegationType delegationType) {
        return DelegationType.SECONDARY.equals((Object)delegationType);
    }

    private List<DelegateTypeBo> getRoleDelegations(String roleId) {
        if (roleId == null) {
            return new ArrayList<DelegateTypeBo>();
        }
        return this.getStoredDelegationImplsForRoleIds(Collections.singletonList(roleId));
    }

    protected RoleBo getRoleBoByName(String namespaceCode, String roleName) {
        if (StringUtils.isBlank((String)namespaceCode) || StringUtils.isBlank((String)roleName)) {
            return null;
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("namespaceCode", namespaceCode);
        criteria.put("name", roleName);
        criteria.put("active", "Y");
        return (RoleBo)this.getBusinessObjectService().findByPrimaryKey(RoleBo.class, criteria);
    }

    protected RoleBoLite getRoleBoLiteByName(String namespaceCode, String roleName) {
        if (StringUtils.isBlank((String)namespaceCode) || StringUtils.isBlank((String)roleName)) {
            return null;
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("namespaceCode", namespaceCode);
        criteria.put("name", roleName);
        criteria.put("active", "Y");
        return (RoleBoLite)this.getBusinessObjectService().findByPrimaryKey(RoleBoLite.class, criteria);
    }

    protected List<RoleMember> doAnyMemberRecordsMatchByExactQualifier(RoleEbo role, String memberId, RoleDaoAction daoActionToTake, Map<String, String> qualifier) {
        List<RoleMemberBo> roleMemberBos = this.getRoleMembersByExactQualifierMatch(role, memberId, daoActionToTake, qualifier);
        ArrayList<RoleMember> roleMembers = new ArrayList<RoleMember>();
        if (CollectionUtils.isNotEmpty(roleMemberBos)) {
            for (RoleMemberBo bo : roleMemberBos) {
                roleMembers.add(RoleMemberBo.to(bo));
            }
            return roleMembers;
        }
        return Collections.emptyList();
    }

    protected List<RoleMemberBo> getRoleMembersByExactQualifierMatch(RoleEbo role, String memberId, RoleDaoAction daoActionToTake, Map<String, String> qualifier) {
        List attributesForExactMatch;
        List<RoleMemberBo> rms = new ArrayList<RoleMemberBo>();
        RoleTypeService roleTypeService = this.getRoleTypeService(role.getId());
        if (roleTypeService != null && CollectionUtils.isNotEmpty((Collection)(attributesForExactMatch = roleTypeService.getQualifiersForExactMatch()))) {
            switch (daoActionToTake) {
                case ROLE_GROUPS_FOR_GROUP_IDS_AND_ROLE_IDS: {
                    rms = this.getStoredRoleGroupsForGroupIdsAndRoleIds(Collections.singletonList(role.getId()), Collections.singletonList(memberId), this.populateQualifiersForExactMatch(qualifier, attributesForExactMatch));
                    break;
                }
                case ROLE_PRINCIPALS_FOR_PRINCIPAL_ID_AND_ROLE_IDS: {
                    rms = this.getStoredRolePrincipalsForPrincipalIdAndRoleIds(Collections.singletonList(role.getId()), memberId, this.populateQualifiersForExactMatch(qualifier, attributesForExactMatch));
                    break;
                }
                case ROLE_MEMBERSHIPS_FOR_ROLE_IDS_AS_MEMBERS: {
                    List<RoleMemberBo> allRoleMembers = this.getStoredRoleMembershipsForRoleIdsAsMembers(Collections.singletonList(role.getId()), this.populateQualifiersForExactMatch(qualifier, attributesForExactMatch));
                    for (RoleMemberBo rm : allRoleMembers) {
                        if (!rm.getMemberId().equals(memberId)) continue;
                        rms.add(rm);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The 'daoActionToTake' parameter cannot refer to a non-role-member-related value!");
                }
            }
        }
        return rms;
    }

    protected RoleMember doAnyMemberRecordsMatch(List<RoleMemberBo> roleMembers, String memberId, String memberTypeCode, Map<String, String> qualifier) {
        for (RoleMemberBo rm : roleMembers) {
            if (!rm.isActive() || !this.doesMemberMatch(rm, memberId, memberTypeCode, qualifier)) continue;
            return RoleMemberBo.to(rm);
        }
        return null;
    }

    protected boolean doesMemberMatch(RoleMemberBo roleMember, String memberId, String memberTypeCode, Map<String, String> qualifier) {
        if (roleMember.getMemberId().equals(memberId) && roleMember.getType().getCode().equals(memberTypeCode)) {
            Map<String, String> roleQualifier = roleMember.getAttributes();
            if ((qualifier == null || qualifier.isEmpty()) && (roleQualifier == null || roleQualifier.isEmpty())) {
                return true;
            }
            if (qualifier != null && roleQualifier != null && qualifier.equals(roleQualifier)) {
                return true;
            }
        }
        return false;
    }

    protected RoleTypeService getRoleTypeService(String roleId) {
        KimType roleType;
        RoleBoLite roleBo = this.getRoleBoLite(roleId);
        if (roleBo != null && (roleType = KimTypeBo.to(roleBo.getKimRoleType())) != null) {
            return this.getRoleTypeService(roleType);
        }
        return KimImplServiceLocator.getDefaultRoleTypeService();
    }

    protected RoleTypeService getRoleTypeServiceByName(String serviceName) {
        try {
            KimTypeService service = (KimTypeService)GlobalResourceLoader.getService((QName)QName.valueOf(serviceName));
            if (service != null && service instanceof RoleTypeService) {
                return (RoleTypeService)service;
            }
            LOG.warn((Object)("Unable to find role type service by name: " + serviceName + ". Defaulting to: kimNoMembersRoleTypeService "));
            return (RoleTypeService)KimImplServiceLocator.getService("kimNoMembersRoleTypeService");
        }
        catch (Exception ex) {
            LOG.warn((Object)("Unable to find role type service by name: " + serviceName), (Throwable)ex);
            return (RoleTypeService)KimImplServiceLocator.getService("kimNoMembersRoleTypeService");
        }
    }

    protected RoleTypeService getRoleTypeService(KimType typeInfo) {
        String serviceName = typeInfo.getServiceName();
        if (serviceName != null) {
            try {
                KimTypeService service = (KimTypeService)GlobalResourceLoader.getService((QName)QName.valueOf(serviceName));
                if (service != null && service instanceof RoleTypeService) {
                    return (RoleTypeService)service;
                }
                LOG.warn((Object)("Unable to find role type service with name: " + serviceName + ". Defaulting to: kimNoMembersRoleTypeService "));
                return (RoleTypeService)KimImplServiceLocator.getService("kimNoMembersRoleTypeService");
            }
            catch (Exception ex) {
                LOG.error((Object)("Unable to find role type service with name: " + serviceName), (Throwable)ex);
                return (RoleTypeService)KimImplServiceLocator.getService("kimNoMembersRoleTypeService");
            }
        }
        return KimImplServiceLocator.getDefaultRoleTypeService();
    }

    protected Map<String, String> populateQualifiersForExactMatch(Map<String, String> defaultQualification, List<String> attributes) {
        HashMap<String, String> qualifiersForExactMatch = new HashMap<String, String>();
        if (defaultQualification != null && CollectionUtils.isNotEmpty(defaultQualification.keySet())) {
            for (String attributeName : attributes) {
                if (!StringUtils.isNotEmpty((String)defaultQualification.get(attributeName))) continue;
                qualifiersForExactMatch.put(attributeName, defaultQualification.get(attributeName));
            }
        }
        return qualifiersForExactMatch;
    }

    protected String getKimAttributeId(String kimTypeId, String attributeName) {
        Collection<KimAttributeBo> attributeData = this.getAttributeByName(attributeName);
        String kimAttributeId = null;
        if (CollectionUtils.isNotEmpty(attributeData)) {
            kimAttributeId = CollectionUtils.size(attributeData) == 1 ? attributeData.iterator().next().getId() : this.getCorrectAttributeId(kimTypeId, attributeName, attributeData);
        }
        return kimAttributeId;
    }

    protected Collection<KimAttributeBo> getAttributeByName(String attributeName) {
        HashMap<String, String> critieria = new HashMap<String, String>(1);
        critieria.put("attributeName", attributeName);
        Collection attributeData = this.getBusinessObjectService().findMatching(KimAttributeBo.class, critieria);
        return attributeData;
    }

    protected String getCorrectAttributeId(String kimTypeId, String attributeName, Collection<KimAttributeBo> attributeData) {
        KimType kimType = this.getKimTypeInfoService().getKimType(kimTypeId);
        String attribute = this.getAttributeFromKimType(kimType, attributeName);
        return ObjectUtils.isNotNull((Object)attribute) ? attribute : this.getAttributeFromNamespace(kimType, attributeName, attributeData);
    }

    protected String getAttributeFromKimType(KimType kimType, String attributeName) {
        if (kimType != null) {
            for (KimTypeAttribute attribute : kimType.getAttributeDefinitions()) {
                if (attribute.getKimAttribute() == null || !StringUtils.equals((String)attributeName, (String)attribute.getKimAttribute().getAttributeName())) continue;
                return attribute.getKimAttribute().getId();
            }
        }
        return null;
    }

    protected String getAttributeFromNamespace(KimType kimType, String attributeName, Collection<KimAttributeBo> attributes) {
        String appId = this.getAppIdFromNamespace(kimType.getNamespaceCode());
        String attributeId = this.getAttributeFromAppId(attributes, appId);
        if (ObjectUtils.isNull((Object)attributeId) && ObjectUtils.isNull((Object)(attributeId = this.getAttributeFromAppId(attributes, "RICE")))) {
            attributeId = this.getAttributeFromAppId(attributes, "KUALI");
        }
        return attributeId;
    }

    protected String getAppIdFromNamespace(String namespaceCode) {
        Namespace appNamespace = this.getNamespaceService().getNamespace(namespaceCode);
        if (appNamespace == null) {
            throw new RuntimeException("Namespace " + namespaceCode + " not mapped in namespace table.");
        }
        return appNamespace.getApplicationId();
    }

    protected String getAttributeFromAppId(Collection<KimAttributeBo> attributes, String appId) {
        for (KimAttributeBo attribute : attributes) {
            if (!StringUtils.equalsIgnoreCase((String)this.getAppIdFromNamespace(attribute.getNamespaceCode()), (String)appId)) continue;
            return attribute.getId();
        }
        return null;
    }

    protected KimTypeInfoService getKimTypeInfoService() {
        if (this.kimTypeInfoService == null) {
            this.kimTypeInfoService = KimApiServiceLocator.getKimTypeInfoService();
        }
        return this.kimTypeInfoService;
    }

    protected NamespaceService getNamespaceService() {
        if (this.namespaceService == null) {
            this.namespaceService = CoreServiceApiServiceLocator.getNamespaceService();
        }
        return this.namespaceService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    protected LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = KRADServiceLocatorWeb.getLookupService();
        }
        return this.lookupService;
    }

    protected IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    protected GroupService getGroupService() {
        if (this.groupService == null) {
            this.groupService = KimApiServiceLocator.getGroupService();
        }
        return this.groupService;
    }

    protected ResponsibilityInternalService getResponsibilityInternalService() {
        if (this.responsibilityInternalService == null) {
            this.responsibilityInternalService = KimImplServiceLocator.getResponsibilityInternalService();
        }
        return this.responsibilityInternalService;
    }

    protected RoleDao getRoleDao() {
        return this.roleDao;
    }

    public void setRoleDao(RoleDao roleDao) {
        this.roleDao = roleDao;
    }

    public void setCriteriaLookupService(CriteriaLookupService criteriaLookupService) {
        this.criteriaLookupService = criteriaLookupService;
    }

    public CriteriaLookupService getCriteriaLookupService() {
        return this.criteriaLookupService;
    }

    protected static enum RoleDaoAction {
        ROLE_PRINCIPALS_FOR_PRINCIPAL_ID_AND_ROLE_IDS,
        ROLE_GROUPS_FOR_GROUP_IDS_AND_ROLE_IDS,
        ROLE_MEMBERS_FOR_ROLE_IDS,
        ROLE_MEMBERSHIPS_FOR_ROLE_IDS_AS_MEMBERS,
        ROLE_MEMBERS_FOR_ROLE_IDS_WITH_FILTERS,
        DELEGATION_PRINCIPALS_FOR_PRINCIPAL_ID_AND_DELEGATION_IDS,
        DELEGATION_GROUPS_FOR_GROUP_IDS_AND_DELEGATION_IDS,
        DELEGATION_MEMBERS_FOR_DELEGATION_IDS;

    }
}

