/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.common.attribute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Transient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kim.api.common.attribute.KimAttributeDataContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class KimAttributeDataBo
extends PersistableBusinessObjectBase
implements KimAttributeDataContract {
    private static final Logger LOG = Logger.getLogger(KimAttributeDataBo.class);
    private static final long serialVersionUID = 1L;
    private static KimTypeInfoService kimTypeInfoService;
    private String id;
    private String attributeValue;
    private String kimAttributeId;
    private KimAttributeBo kimAttribute;
    private String kimTypeId;
    @Transient
    private KimTypeBo kimType;

    public abstract void setAssignedToId(String var1);

    public KimAttributeBo getKimAttribute() {
        if (ObjectUtils.isNull((Object)((Object)this.kimAttribute)) && StringUtils.isNotBlank((String)this.kimAttributeId)) {
            this.refreshReferenceObject("kimAttribute");
        }
        return this.kimAttribute;
    }

    public KimTypeBo getKimType() {
        if (this.kimType == null && StringUtils.isNotEmpty((String)this.id)) {
            this.kimType = KimTypeBo.from(KimApiServiceLocator.getKimTypeInfoService().getKimType(this.kimTypeId));
        }
        return this.kimType;
    }

    public static <T extends KimAttributeDataBo> Map<String, String> toAttributes(Collection<T> bos) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(bos)) {
            for (KimAttributeDataBo it : bos) {
                if (it == null) continue;
                KimTypeAttribute attribute = null;
                if (it.getKimType() != null) {
                    attribute = KimTypeBo.to(it.getKimType()).getAttributeDefinitionById(it.getKimAttributeId());
                }
                if (attribute != null) {
                    m.put(attribute.getKimAttribute().getAttributeName(), it.getAttributeValue());
                    continue;
                }
                m.put(it.getKimAttribute().getAttributeName(), it.getAttributeValue());
            }
        }
        return m;
    }

    public static <T extends KimAttributeDataBo> List<T> createFrom(Class<T> type, Map<String, String> attributes, String kimTypeId) {
        if (attributes == null) {
            return new ArrayList();
        }
        ArrayList<KimAttributeDataBo> attrs = new ArrayList<KimAttributeDataBo>();
        for (Map.Entry<String, String> it : attributes.entrySet()) {
            KimTypeAttribute attr = KimAttributeDataBo.getKimTypeInfoService().getKimType(kimTypeId).getAttributeDefinitionByName(it.getKey());
            KimType theType = KimAttributeDataBo.getKimTypeInfoService().getKimType(kimTypeId);
            if (attr == null || !StringUtils.isNotBlank((String)it.getValue())) continue;
            try {
                KimAttributeDataBo newDetail = (KimAttributeDataBo)((Object)type.newInstance());
                newDetail.setKimAttributeId(attr.getKimAttribute().getId());
                newDetail.setKimAttribute(KimAttributeBo.from(attr.getKimAttribute()));
                newDetail.setKimTypeId(kimTypeId);
                newDetail.setKimType(KimTypeBo.from(theType));
                newDetail.setAttributeValue(it.getValue());
                attrs.add(newDetail);
            }
            catch (InstantiationException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return attrs;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public void setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public String getKimAttributeId() {
        return this.kimAttributeId;
    }

    public void setKimAttributeId(String kimAttributeId) {
        this.kimAttributeId = kimAttributeId;
    }

    public String getKimTypeId() {
        return this.kimTypeId;
    }

    public void setKimTypeId(String kimTypeId) {
        this.kimTypeId = kimTypeId;
    }

    public void setKimType(KimTypeBo kimType) {
        this.kimType = kimType;
    }

    public void setKimAttribute(KimAttributeBo kimAttribute) {
        this.kimAttribute = kimAttribute;
    }

    public static KimTypeInfoService getKimTypeInfoService() {
        if (kimTypeInfoService == null) {
            kimTypeInfoService = KimApiServiceLocator.getKimTypeInfoService();
        }
        return kimTypeInfoService;
    }

    public static void setKimTypeInfoService(KimTypeInfoService kimTypeInfoService) {
        KimAttributeDataBo.kimTypeInfoService = kimTypeInfoService;
    }
}

