/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.permission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.cache.CacheKeyUtils;
import org.kuali.rice.core.api.criteria.CriteriaLookupService;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.LookupCustomizer;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.common.assignee.Assignee;
import org.kuali.rice.kim.api.common.delegate.DelegateType;
import org.kuali.rice.kim.api.common.delegate.DelegateTypeContract;
import org.kuali.rice.kim.api.common.template.Template;
import org.kuali.rice.kim.api.common.template.TemplateContract;
import org.kuali.rice.kim.api.common.template.TemplateQueryResults;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.permission.PermissionContract;
import org.kuali.rice.kim.api.permission.PermissionQueryResults;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.framework.permission.PermissionTypeService;
import org.kuali.rice.kim.impl.common.attribute.AttributeTransform;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.permission.PermissionAttributeBo;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kim.impl.permission.PermissionTemplateBo;
import org.kuali.rice.kim.impl.role.RolePermissionBo;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.NoOpCacheManager;

public class PermissionServiceImpl
implements PermissionService {
    private static final Logger LOG = Logger.getLogger(PermissionServiceImpl.class);
    private RoleService roleService;
    private PermissionTypeService defaultPermissionTypeService;
    private KimTypeInfoService kimTypeInfoService;
    private BusinessObjectService businessObjectService;
    private CriteriaLookupService criteriaLookupService;
    private CacheManager cacheManager;
    private final CopyOnWriteArrayList<Template> allTemplates = new CopyOnWriteArrayList();

    public PermissionServiceImpl() {
        this.cacheManager = new NoOpCacheManager();
    }

    protected PermissionTypeService getPermissionTypeService(Template permissionTemplate) {
        if (permissionTemplate == null) {
            throw new IllegalArgumentException("permissionTemplate may not be null");
        }
        KimType kimType = this.kimTypeInfoService.getKimType(permissionTemplate.getKimTypeId());
        String serviceName = kimType.getServiceName();
        if (StringUtils.isBlank((String)serviceName)) {
            return this.defaultPermissionTypeService;
        }
        try {
            Object service = GlobalResourceLoader.getService((QName)QName.valueOf(serviceName));
            if (service == null) {
                throw new RuntimeException("null returned for permission type service for service name: " + serviceName);
            }
            if (!(service instanceof PermissionTypeService)) {
                throw new RuntimeException("Service " + serviceName + " was not a PermissionTypeService.  Was: " + service.getClass().getName());
            }
            return (PermissionTypeService)service;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error retrieving service: " + serviceName + " from the KimImplServiceLocator.", ex);
        }
    }

    public boolean hasPermission(String principalId, String namespaceCode, String permissionName) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(permissionName, "permissionName");
        return this.isAuthorized(principalId, namespaceCode, permissionName, Collections.emptyMap());
    }

    public boolean isAuthorized(String principalId, String namespaceCode, String permissionName, Map<String, String> qualification) throws RiceIllegalArgumentException {
        List<String> roleIds;
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(permissionName, "permissionName");
        this.incomingParamCheck(qualification, "qualification");
        if (LOG.isDebugEnabled()) {
            this.logAuthorizationCheck("Permission", principalId, namespaceCode, permissionName, qualification);
        }
        if ((roleIds = this.getRoleIdsForPermission(namespaceCode, permissionName)).isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Result: false");
            }
            return false;
        }
        boolean isAuthorized = this.roleService.principalHasRole(principalId, roleIds, qualification);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Result: " + isAuthorized));
        }
        return isAuthorized;
    }

    public boolean hasPermissionByTemplate(String principalId, String namespaceCode, String permissionTemplateName, Map<String, String> permissionDetails) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(permissionTemplateName, "permissionTemplateName");
        return this.isAuthorizedByTemplate(principalId, namespaceCode, permissionTemplateName, permissionDetails, Collections.emptyMap());
    }

    public boolean isAuthorizedByTemplate(String principalId, String namespaceCode, String permissionTemplateName, Map<String, String> permissionDetails, Map<String, String> qualification) throws RiceIllegalArgumentException {
        List<String> roleIds;
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(permissionTemplateName, "permissionTemplateName");
        this.incomingParamCheck(qualification, "qualification");
        if (LOG.isDebugEnabled()) {
            this.logAuthorizationCheckByTemplate("Perm Templ", principalId, namespaceCode, permissionTemplateName, permissionDetails, qualification);
        }
        if ((roleIds = this.getRoleIdsForPermissionTemplate(namespaceCode, permissionTemplateName, permissionDetails)).isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Result: false");
            }
            return false;
        }
        boolean isAuthorized = this.roleService.principalHasRole(principalId, roleIds, qualification);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Result: " + isAuthorized));
        }
        return isAuthorized;
    }

    public List<Permission> getAuthorizedPermissions(String principalId, String namespaceCode, String permissionName, Map<String, String> qualification) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(permissionName, "permissionName");
        this.incomingParamCheck(qualification, "qualification");
        List<Permission> permissions = this.getPermissionsByName(namespaceCode, permissionName);
        List<Permission> applicablePermissions = this.getMatchingPermissions(permissions, null);
        List<Permission> permissionsForUser = this.getPermissionsForUser(principalId, applicablePermissions, qualification);
        return permissionsForUser;
    }

    public List<Permission> getAuthorizedPermissionsByTemplate(String principalId, String namespaceCode, String permissionTemplateName, Map<String, String> permissionDetails, Map<String, String> qualification) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(permissionTemplateName, "permissionTemplateName");
        this.incomingParamCheck(qualification, "qualification");
        List<Permission> permissions = this.getPermissionsByTemplateName(namespaceCode, permissionTemplateName);
        List<Permission> applicablePermissions = this.getMatchingPermissions(permissions, permissionDetails);
        return this.getPermissionsForUser(principalId, applicablePermissions, qualification);
    }

    protected List<Permission> getPermissionsForUser(String principalId, List<Permission> permissions, Map<String, String> qualification) {
        ArrayList<Permission> results = new ArrayList<Permission>();
        for (Permission perm : permissions) {
            List<String> roleIds = this.getRoleIdsForPermissions(Collections.singletonList(perm));
            if (roleIds == null || roleIds.isEmpty() || !this.roleService.principalHasRole(principalId, roleIds, qualification)) continue;
            results.add(perm);
        }
        return Collections.unmodifiableList(results);
    }

    protected Map<String, PermissionTypeService> getPermissionTypeServicesByTemplateId(Collection<Permission> permissions) {
        HashMap<String, PermissionTypeService> permissionTypeServices = new HashMap<String, PermissionTypeService>(permissions.size());
        for (Permission perm : permissions) {
            if (permissionTypeServices.containsKey(perm.getTemplate().getId())) continue;
            permissionTypeServices.put(perm.getTemplate().getId(), this.getPermissionTypeService(perm.getTemplate()));
        }
        return permissionTypeServices;
    }

    protected Map<String, List<Permission>> groupPermissionsByTemplate(Collection<Permission> permissions) {
        HashMap<String, List<Permission>> results = new HashMap<String, List<Permission>>();
        for (Permission perm : permissions) {
            ArrayList<Permission> perms = (ArrayList<Permission>)results.get(perm.getTemplate().getId());
            if (perms == null) {
                perms = new ArrayList<Permission>();
                results.put(perm.getTemplate().getId(), perms);
            }
            perms.add(perm);
        }
        return results;
    }

    protected List<Permission> getMatchingPermissions(List<Permission> permissions, Map<String, String> permissionDetails) {
        ArrayList<String> permissionIds = new ArrayList<String>(permissions.size());
        for (Permission permission : permissions) {
            permissionIds.add(permission.getId());
        }
        String cacheKey = "{getMatchingPermissions}" + "permissionIds=" + CacheKeyUtils.key(permissionIds) + "|" + "permissionDetails=" + CacheKeyUtils.mapKey(permissionDetails);
        Cache.ValueWrapper cachedValue = this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/PermissionType").get((Object)cacheKey);
        if (cachedValue != null && cachedValue.get() instanceof List) {
            return (List)cachedValue.get();
        }
        List<Permission> applicablePermissions = new ArrayList();
        if (permissionDetails == null || permissionDetails.isEmpty()) {
            for (Permission perm : permissions) {
                applicablePermissions.add(perm);
            }
        } else {
            Map<String, PermissionTypeService> permissionTypeServices = this.getPermissionTypeServicesByTemplateId(permissions);
            Map<String, List<Permission>> permissionMap = this.groupPermissionsByTemplate(permissions);
            for (Map.Entry<String, List<Permission>> entry : permissionMap.entrySet()) {
                PermissionTypeService permissionTypeService = permissionTypeServices.get(entry.getKey());
                List<Permission> permissionList = entry.getValue();
                applicablePermissions.addAll(permissionTypeService.getMatchingPermissions(permissionDetails, permissionList));
            }
        }
        applicablePermissions = Collections.unmodifiableList(applicablePermissions);
        this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/PermissionType").put((Object)cacheKey, applicablePermissions);
        return applicablePermissions;
    }

    public List<Assignee> getPermissionAssignees(String namespaceCode, String permissionName, Map<String, String> qualification) throws RiceIllegalArgumentException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(permissionName, "permissionName");
        this.incomingParamCheck(qualification, "qualification");
        List<String> roleIds = this.getRoleIdsForPermission(namespaceCode, permissionName);
        if (roleIds.isEmpty()) {
            return Collections.emptyList();
        }
        List roleMembers = this.roleService.getRoleMembers(roleIds, qualification);
        ArrayList<Assignee> results = new ArrayList<Assignee>();
        for (RoleMembership rm : roleMembers) {
            ArrayList<DelegateType.Builder> delegateBuilderList = new ArrayList<DelegateType.Builder>();
            if (!rm.getDelegates().isEmpty()) {
                for (DelegateType delegate : rm.getDelegates()) {
                    delegateBuilderList.add(DelegateType.Builder.create((DelegateTypeContract)delegate));
                }
            }
            if (MemberType.PRINCIPAL.equals((Object)rm.getType())) {
                results.add(Assignee.Builder.create((String)rm.getMemberId(), null, delegateBuilderList).build());
                continue;
            }
            if (!MemberType.GROUP.equals((Object)rm.getType())) continue;
            results.add(Assignee.Builder.create(null, (String)rm.getMemberId(), delegateBuilderList).build());
        }
        return Collections.unmodifiableList(results);
    }

    public List<Assignee> getPermissionAssigneesByTemplate(String namespaceCode, String permissionTemplateName, Map<String, String> permissionDetails, Map<String, String> qualification) throws RiceIllegalArgumentException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(permissionTemplateName, "permissionTemplateName");
        this.incomingParamCheck(qualification, "qualification");
        List<String> roleIds = this.getRoleIdsForPermissionTemplate(namespaceCode, permissionTemplateName, permissionDetails);
        if (roleIds.isEmpty()) {
            return Collections.emptyList();
        }
        List roleMembers = this.roleService.getRoleMembers(roleIds, qualification);
        ArrayList<Assignee> results = new ArrayList<Assignee>();
        for (RoleMembership rm : roleMembers) {
            ArrayList<DelegateType.Builder> delegateBuilderList = new ArrayList<DelegateType.Builder>();
            if (!rm.getDelegates().isEmpty()) {
                for (DelegateType delegate : rm.getDelegates()) {
                    delegateBuilderList.add(DelegateType.Builder.create((DelegateTypeContract)delegate));
                }
            }
            if (MemberType.PRINCIPAL.equals((Object)rm.getType())) {
                results.add(Assignee.Builder.create((String)rm.getMemberId(), null, delegateBuilderList).build());
                continue;
            }
            results.add(Assignee.Builder.create(null, (String)rm.getMemberId(), delegateBuilderList).build());
        }
        return Collections.unmodifiableList(results);
    }

    public boolean isPermissionDefined(String namespaceCode, String permissionName) throws RiceIllegalArgumentException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(permissionName, "permissionName");
        List<Permission> permissions = this.getPermissionsByName(namespaceCode, permissionName);
        return !this.getMatchingPermissions(permissions, null).isEmpty();
    }

    public boolean isPermissionDefinedByTemplate(String namespaceCode, String permissionTemplateName, Map<String, String> permissionDetails) throws RiceIllegalArgumentException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(permissionTemplateName, "permissionTemplateName");
        List<Permission> permissions = this.getPermissionsByTemplateName(namespaceCode, permissionTemplateName);
        return !this.getMatchingPermissions(permissions, permissionDetails).isEmpty();
    }

    public List<String> getRoleIdsForPermission(String namespaceCode, String permissionName) throws RiceIllegalArgumentException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(permissionName, "permissionName");
        String cacheKey = "{RoleIds}" + "namespaceCode=" + namespaceCode + "|" + "name=" + permissionName;
        Cache.ValueWrapper cachedValue = this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/PermissionType").get((Object)cacheKey);
        if (cachedValue != null && cachedValue.get() instanceof List) {
            return (List)cachedValue.get();
        }
        List<Permission> permissions = this.getPermissionsByName(namespaceCode, permissionName);
        List<Permission> applicablePermissions = this.getMatchingPermissions(permissions, null);
        List<String> roleIds = this.getRoleIdsForPermissions(applicablePermissions);
        this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/PermissionType").put((Object)cacheKey, roleIds);
        return roleIds;
    }

    protected List<String> getRoleIdsForPermissionTemplate(String namespaceCode, String permissionTemplateName, Map<String, String> permissionDetails) {
        String cacheKey = "{getRoleIdsForPermissionTemplate}" + "namespaceCode=" + namespaceCode + "|" + "permissionTemplateName=" + permissionTemplateName + "|" + "permissionDetails=" + CacheKeyUtils.mapKey(permissionDetails);
        Cache.ValueWrapper cachedValue = this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/PermissionType").get((Object)cacheKey);
        if (cachedValue != null && cachedValue.get() instanceof List) {
            return (List)cachedValue.get();
        }
        List<Permission> permissions = this.getPermissionsByTemplateName(namespaceCode, permissionTemplateName);
        List<Permission> applicablePermissions = this.getMatchingPermissions(permissions, permissionDetails);
        List<String> roleIds = this.getRoleIdsForPermissions(applicablePermissions);
        this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/PermissionType").put((Object)cacheKey, roleIds);
        return roleIds;
    }

    public Permission getPermission(String permissionId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(permissionId, "permissionId");
        PermissionBo impl = this.getPermissionImpl(permissionId);
        if (impl != null) {
            return PermissionBo.to(impl);
        }
        return null;
    }

    public List<Permission> findPermissionsByTemplate(String namespaceCode, String permissionTemplateName) throws RiceIllegalArgumentException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(permissionTemplateName, "permissionTemplateName");
        List<Permission> perms = this.getPermissionsByTemplateName(namespaceCode, permissionTemplateName);
        ArrayList<Permission> results = new ArrayList<Permission>(perms.size());
        for (Permission perm : perms) {
            results.add(perm);
        }
        return Collections.unmodifiableList(results);
    }

    protected PermissionBo getPermissionImpl(String permissionId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(permissionId, "permissionId");
        HashMap<String, String> pk = new HashMap<String, String>(1);
        pk.put("id", permissionId);
        return (PermissionBo)this.businessObjectService.findByPrimaryKey(PermissionBo.class, pk);
    }

    protected List<Permission> getPermissionsByTemplateName(String namespaceCode, String permissionTemplateName) {
        String cacheKey = "{getPermissionsByTemplateName}" + "namespaceCode=" + namespaceCode + "|" + "permissionTemplateName=" + permissionTemplateName;
        Cache.ValueWrapper cachedValue = this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/PermissionType").get((Object)cacheKey);
        if (cachedValue != null && cachedValue.get() instanceof List) {
            return (List)cachedValue.get();
        }
        HashMap<String, String> criteria = new HashMap<String, String>(3);
        criteria.put("template.namespaceCode", namespaceCode);
        criteria.put("template.name", permissionTemplateName);
        criteria.put("template.active", "Y");
        criteria.put("active", "Y");
        List<Permission> permissions = this.toPermissions(this.businessObjectService.findMatching(PermissionBo.class, criteria));
        this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/PermissionType").put((Object)cacheKey, permissions);
        return permissions;
    }

    protected List<Permission> getPermissionsByName(String namespaceCode, String permissionName) {
        String cacheKey = "{getPermissionsByName}" + "namespaceCode=" + namespaceCode + "|" + "permissionName=" + permissionName;
        Cache.ValueWrapper cachedValue = this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/PermissionType").get((Object)cacheKey);
        if (cachedValue != null && cachedValue.get() instanceof List) {
            return (List)cachedValue.get();
        }
        HashMap<String, String> criteria = new HashMap<String, String>(3);
        criteria.put("namespaceCode", namespaceCode);
        criteria.put("name", permissionName);
        criteria.put("active", "Y");
        List<Permission> permissions = this.toPermissions(this.businessObjectService.findMatching(PermissionBo.class, criteria));
        this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/PermissionType").put((Object)cacheKey, permissions);
        return permissions;
    }

    public Template getPermissionTemplate(String permissionTemplateId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(permissionTemplateId, "permissionTemplateId");
        PermissionTemplateBo impl = (PermissionTemplateBo)this.businessObjectService.findBySinglePrimaryKey(PermissionTemplateBo.class, (Object)permissionTemplateId);
        if (impl != null) {
            return PermissionTemplateBo.to(impl);
        }
        return null;
    }

    public Template findPermTemplateByNamespaceCodeAndName(String namespaceCode, String permissionTemplateName) throws RiceIllegalArgumentException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(permissionTemplateName, "permissionTemplateName");
        HashMap<String, String> criteria = new HashMap<String, String>(2);
        criteria.put("namespaceCode", namespaceCode);
        criteria.put("name", permissionTemplateName);
        PermissionTemplateBo impl = (PermissionTemplateBo)this.businessObjectService.findByPrimaryKey(PermissionTemplateBo.class, criteria);
        if (impl != null) {
            return PermissionTemplateBo.to(impl);
        }
        return null;
    }

    public List<Template> getAllTemplates() {
        if (this.allTemplates.isEmpty()) {
            HashMap<String, String> criteria = new HashMap<String, String>(1);
            criteria.put("active", "Y");
            List impls = (List)this.businessObjectService.findMatching(PermissionTemplateBo.class, criteria);
            ArrayList<Template> infos = new ArrayList<Template>(impls.size());
            for (PermissionTemplateBo impl : impls) {
                infos.add(PermissionTemplateBo.to(impl));
            }
            Collections.sort(infos, new Comparator<Template>(){

                @Override
                public int compare(Template tmpl1, Template tmpl2) {
                    int result = tmpl1.getNamespaceCode().compareTo(tmpl2.getNamespaceCode());
                    if (result != 0) {
                        return result;
                    }
                    result = tmpl1.getName().compareTo(tmpl2.getName());
                    return result;
                }
            });
            this.allTemplates.addAll(infos);
        }
        return Collections.unmodifiableList(this.allTemplates);
    }

    public Permission createPermission(Permission permission) throws RiceIllegalArgumentException, RiceIllegalStateException {
        PermissionBo bo;
        this.incomingParamCheck(permission, "permission");
        if (StringUtils.isNotBlank((String)permission.getId()) && this.getPermission(permission.getId()) != null) {
            throw new RiceIllegalStateException("the permission to create already exists: " + permission);
        }
        List<PermissionAttributeBo> attrBos = Collections.emptyList();
        if (permission.getTemplate() != null) {
            attrBos = KimAttributeDataBo.createFrom(PermissionAttributeBo.class, permission.getAttributes(), permission.getTemplate().getKimTypeId());
        }
        if ((bo = PermissionBo.from(permission)).getTemplate() == null && bo.getTemplateId() != null) {
            bo.setTemplate(PermissionTemplateBo.from(this.getPermissionTemplate(bo.getTemplateId())));
        }
        bo.setAttributeDetails(attrBos);
        return PermissionBo.to((PermissionBo)this.businessObjectService.save((PersistableBusinessObject)bo));
    }

    public Permission updatePermission(Permission permission) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(permission, "permission");
        PermissionBo oldPermission = this.getPermissionImpl(permission.getId());
        if (StringUtils.isBlank((String)permission.getId()) || oldPermission == null) {
            throw new RiceIllegalStateException("the permission does not exist: " + permission);
        }
        List<PermissionAttributeBo> oldAttrBos = oldPermission.getAttributeDetails();
        HashMap<String, PermissionAttributeBo> oldAttrMap = new HashMap<String, PermissionAttributeBo>();
        for (PermissionAttributeBo permissionAttributeBo : oldAttrBos) {
            oldAttrMap.put(permissionAttributeBo.getKimAttribute().getAttributeName(), permissionAttributeBo);
        }
        ArrayList<PermissionAttributeBo> newAttrBos = new ArrayList<PermissionAttributeBo>();
        for (String key : permission.getAttributes().keySet()) {
            if (oldAttrMap.containsKey(key)) {
                PermissionAttributeBo updatedAttr = (PermissionAttributeBo)((Object)oldAttrMap.get(key));
                updatedAttr.setAttributeValue((String)permission.getAttributes().get(key));
                newAttrBos.add(updatedAttr);
                continue;
            }
            newAttrBos.addAll(KimAttributeDataBo.createFrom(PermissionAttributeBo.class, Collections.singletonMap(key, permission.getAttributes().get(key)), permission.getTemplate().getKimTypeId()));
        }
        PermissionBo permissionBo = PermissionBo.from(permission);
        if (CollectionUtils.isNotEmpty(newAttrBos)) {
            if (null != permissionBo.getAttributeDetails()) {
                permissionBo.getAttributeDetails().clear();
            }
            permissionBo.setAttributeDetails(newAttrBos);
        }
        if (permissionBo.getTemplate() == null && permissionBo.getTemplateId() != null) {
            permissionBo.setTemplate(PermissionTemplateBo.from(this.getPermissionTemplate(permissionBo.getTemplateId())));
        }
        return PermissionBo.to((PermissionBo)this.businessObjectService.save((PersistableBusinessObject)permissionBo));
    }

    public Permission findPermByNamespaceCodeAndName(String namespaceCode, String permissionName) throws RiceIllegalArgumentException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(permissionName, "permissionName");
        PermissionBo permissionBo = this.getPermissionBoByName(namespaceCode, permissionName);
        if (permissionBo != null) {
            return PermissionBo.to(permissionBo);
        }
        return null;
    }

    protected PermissionBo getPermissionBoByName(String namespaceCode, String permissionName) {
        if (StringUtils.isBlank((String)namespaceCode) || StringUtils.isBlank((String)permissionName)) {
            return null;
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("namespaceCode", namespaceCode);
        criteria.put("name", permissionName);
        criteria.put("active", "Y");
        return (PermissionBo)this.businessObjectService.findByPrimaryKey(PermissionBo.class, criteria);
    }

    public PermissionQueryResults findPermissions(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        LookupCustomizer.Builder lc = LookupCustomizer.Builder.create();
        lc.setPredicateTransform(AttributeTransform.getInstance());
        GenericQueryResults results = this.criteriaLookupService.lookup(PermissionBo.class, queryByCriteria, lc.build());
        PermissionQueryResults.Builder builder = PermissionQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Permission.Builder> ims = new ArrayList<Permission.Builder>();
        for (PermissionBo bo : results.getResults()) {
            ims.add(Permission.Builder.create((PermissionContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public TemplateQueryResults findPermissionTemplates(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        GenericQueryResults results = this.criteriaLookupService.lookup(PermissionTemplateBo.class, queryByCriteria);
        TemplateQueryResults.Builder builder = TemplateQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Template.Builder> ims = new ArrayList<Template.Builder>();
        for (PermissionTemplateBo bo : results.getResults()) {
            ims.add(Template.Builder.create((TemplateContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    private List<String> getRoleIdsForPermissions(Collection<Permission> permissions) {
        if (CollectionUtils.isEmpty(permissions)) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (Permission p : permissions) {
            ids.add(p.getId());
        }
        return this.getRoleIdsForPermissionIds(ids);
    }

    private List<String> getRoleIdsForPermissionIds(Collection<String> permissionIds) {
        if (CollectionUtils.isEmpty(permissionIds)) {
            return Collections.emptyList();
        }
        String cacheKey = "{getRoleIdsForPermissionIds}" + "permissionIds=" + CacheKeyUtils.key(permissionIds);
        Cache.ValueWrapper cachedValue = this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/PermissionType").get((Object)cacheKey);
        if (cachedValue != null && cachedValue.get() instanceof List) {
            return (List)cachedValue.get();
        }
        QueryByCriteria query = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"active", (Object)"true"), PredicateFactory.in((String)"permissionId", (Object[])permissionIds.toArray(new String[0]))});
        GenericQueryResults results = this.criteriaLookupService.lookup(RolePermissionBo.class, query);
        List<String> roleIds = new ArrayList();
        for (RolePermissionBo bo : results.getResults()) {
            roleIds.add(bo.getRoleId());
        }
        roleIds = Collections.unmodifiableList(roleIds);
        this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/PermissionType").put((Object)cacheKey, roleIds);
        return roleIds;
    }

    public void setKimTypeInfoService(KimTypeInfoService kimTypeInfoService) {
        this.kimTypeInfoService = kimTypeInfoService;
    }

    public void setDefaultPermissionTypeService(PermissionTypeService defaultPermissionTypeService) {
        this.defaultPermissionTypeService = defaultPermissionTypeService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setCriteriaLookupService(CriteriaLookupService criteriaLookupService) {
        this.criteriaLookupService = criteriaLookupService;
    }

    public void setCacheManager(CacheManager cacheManager) {
        if (cacheManager == null) {
            throw new IllegalArgumentException("cacheManager must not be null");
        }
        this.cacheManager = cacheManager;
    }

    private List<Permission> toPermissions(Collection<PermissionBo> permissionBos) {
        if (CollectionUtils.isEmpty(permissionBos)) {
            return new ArrayList<Permission>();
        }
        ArrayList<Permission> permissions = new ArrayList<Permission>(permissionBos.size());
        for (PermissionBo permissionBo : permissionBos) {
            permissions.add(PermissionBo.to(permissionBo));
        }
        return permissions;
    }

    protected void logAuthorizationCheck(String checkType, String principalId, String namespaceCode, String permissionName, Map<String, String> qualification) {
        Principal principal;
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append("Is AuthZ for ").append(checkType).append(": ").append(namespaceCode).append("/").append(permissionName).append('\n');
        sb.append("             Principal:  ").append(principalId);
        if (principalId != null && (principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId)) != null) {
            sb.append(" (").append(principal.getPrincipalName()).append(')');
        }
        sb.append('\n');
        sb.append("             Qualifiers:\n");
        if (qualification != null && !qualification.isEmpty()) {
            sb.append(qualification);
        } else {
            sb.append("                         [null]\n");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)sb.append(ExceptionUtils.getStackTrace((Throwable)new Throwable())));
        } else {
            LOG.debug((Object)sb.toString());
        }
    }

    protected void logAuthorizationCheckByTemplate(String checkType, String principalId, String namespaceCode, String permissionName, Map<String, String> permissionDetails, Map<String, String> qualification) {
        Principal principal;
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append("Is AuthZ for ").append(checkType).append(": ").append(namespaceCode).append("/").append(permissionName).append('\n');
        sb.append("             Principal:  ").append(principalId);
        if (principalId != null && (principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId)) != null) {
            sb.append(" (").append(principal.getPrincipalName()).append(')');
        }
        sb.append('\n');
        sb.append("             Details:\n");
        if (permissionDetails != null) {
            sb.append(permissionDetails);
        } else {
            sb.append("                         [null]\n");
        }
        sb.append("             Qualifiers:\n");
        if (qualification != null && !qualification.isEmpty()) {
            sb.append(qualification);
        } else {
            sb.append("                         [null]\n");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)sb.append(ExceptionUtils.getStackTrace((Throwable)new Throwable())));
        } else {
            LOG.debug((Object)sb.toString());
        }
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }
}

