/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.responsibility;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.api.responsibility.ResponsibilityService;
import org.kuali.rice.kim.api.role.RoleResponsibility;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityInternalService;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityBo;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class ResponsibilityInternalServiceImpl
implements ResponsibilityInternalService {
    private BusinessObjectService businessObjectService;
    private ResponsibilityService responsibilityService;

    @Override
    public RoleMemberBo saveRoleMember(RoleMemberBo roleMember) {
        List<RoleResponsibility> oldRoleResp = this.getRoleResponsibilities(roleMember.getRoleId());
        RoleMemberBo member = (RoleMemberBo)this.getBusinessObjectService().save((PersistableBusinessObject)roleMember);
        List<RoleResponsibility> newRoleResp = this.getRoleResponsibilities(roleMember.getRoleId());
        this.updateActionRequestsForResponsibilityChange(this.getChangedRoleResponsibilityIds(oldRoleResp, newRoleResp));
        return member;
    }

    @Override
    public DelegateMemberBo saveDelegateMember(DelegateMemberBo delegateMember) {
        DelegateMemberBo member = (DelegateMemberBo)this.getBusinessObjectService().save((PersistableBusinessObject)delegateMember);
        return member;
    }

    @Override
    public void removeRoleMember(RoleMemberBo roleMember) {
        List<RoleResponsibility> oldRoleResp = this.getRoleResponsibilities(roleMember.getRoleId());
        roleMember.setActiveToDateValue(new Timestamp(System.currentTimeMillis()));
        this.getBusinessObjectService().save((PersistableBusinessObject)roleMember);
        List<RoleResponsibility> newRoleResp = this.getRoleResponsibilities(roleMember.getRoleId());
        this.updateActionRequestsForResponsibilityChange(this.getChangedRoleResponsibilityIds(oldRoleResp, newRoleResp));
    }

    @Override
    public void updateActionRequestsForRoleChange(String roleId) {
        List<RoleResponsibility> newRoleResp = this.getRoleResponsibilities(roleId);
        this.updateActionRequestsForResponsibilityChange(this.getChangedRoleResponsibilityIds(Collections.EMPTY_LIST, newRoleResp));
    }

    @Override
    public void updateActionRequestsForResponsibilityChange(Set<String> responsibilityIds) {
        KewApiServiceLocator.getResponsibilityChangeQueue().responsibilitiesChanged(responsibilityIds);
    }

    public List<RoleResponsibility> getRoleResponsibilities(String roleId) {
        List rrBoList = (List)this.getBusinessObjectService().findMatching(RoleResponsibilityBo.class, Collections.singletonMap("roleId", roleId));
        ArrayList<RoleResponsibility> result = new ArrayList<RoleResponsibility>(rrBoList.size());
        for (RoleResponsibilityBo bo : rrBoList) {
            result.add(RoleResponsibilityBo.to(bo));
        }
        return result;
    }

    protected Set<String> getChangedRoleResponsibilityIds(List<RoleResponsibility> oldRespList, List<RoleResponsibility> newRespList) {
        HashSet<String> lRet = new HashSet<String>();
        for (RoleResponsibility resp : oldRespList) {
            lRet.add(resp.getResponsibilityId());
        }
        for (RoleResponsibility resp : newRespList) {
            lRet.add(resp.getResponsibilityId());
        }
        return lRet;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    protected ResponsibilityService getResponsibilityService() {
        if (this.responsibilityService == null) {
            this.responsibilityService = KimApiServiceLocator.getResponsibilityService();
        }
        return this.responsibilityService;
    }

    @Override
    public boolean areActionsAtAssignmentLevel(Responsibility responsibility) {
        Map details = responsibility.getAttributes();
        if (details == null) {
            return false;
        }
        String actionDetailsAtRoleMemberLevel = (String)details.get("actionDetailsAtRoleMemberLevel");
        return Boolean.valueOf(actionDetailsAtRoleMemberLevel);
    }

    @Override
    public boolean areActionsAtAssignmentLevelById(String responsibilityId) {
        Responsibility responsibility = this.getResponsibilityService().getResponsibility(responsibilityId);
        if (responsibility == null) {
            return false;
        }
        return this.areActionsAtAssignmentLevel(responsibility);
    }
}

