/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.role;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.PredicateUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.util.Truth;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.rice.kim.api.common.attribute.KimAttribute;
import org.kuali.rice.kim.api.group.GroupMember;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.api.responsibility.ResponsibilityQueryResults;
import org.kuali.rice.kim.api.responsibility.ResponsibilityService;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateTypeBo;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleBoLite;
import org.kuali.rice.kim.impl.role.RoleDao;
import org.kuali.rice.kim.impl.role.RoleMemberAttributeDataBo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.impl.role.RolePermissionBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

public class RoleDaoOjb
extends PlatformAwareDaoBaseOjb
implements RoleDao {
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = new TransactionAwareDataSourceProxy(dataSource);
    }

    private void addSubCriteriaBasedOnRoleQualification(Criteria c, Map<String, String> qualification) {
        if (qualification != null && CollectionUtils.isNotEmpty(qualification.keySet())) {
            for (Map.Entry<String, String> qualifier : qualification.entrySet()) {
                Criteria subCrit = new Criteria();
                if (!StringUtils.isNotEmpty((String)qualifier.getValue())) continue;
                String value = qualifier.getValue().replace('*', '%');
                subCrit.addLike((Object)"attributeValue", (Object)value);
                subCrit.addEqualTo("kimAttributeId", (Object)qualifier.getKey());
                subCrit.addEqualToField("assignedToId", "parentQuery.id");
                ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(RoleMemberAttributeDataBo.class, (Criteria)subCrit);
                c.addExists((Query)subQuery);
            }
        }
    }

    @Override
    public List<RoleMemberBo> getRoleMembersForGroupIds(String roleId, List<String> groupIds) {
        Criteria crit = new Criteria();
        crit.addEqualTo("roleId", (Object)roleId);
        crit.addEqualTo("typeCode", (Object)MemberType.GROUP.getCode());
        crit.addIn("memberId", groupIds);
        QueryByCriteria query = QueryFactory.newQuery(RoleMemberBo.class, (Criteria)crit);
        Collection coll = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        ArrayList<RoleMemberBo> results = new ArrayList<RoleMemberBo>(coll.size());
        for (RoleMemberBo rm : coll) {
            if (!rm.isActive(new Timestamp(System.currentTimeMillis()))) continue;
            results.add(rm);
        }
        return results;
    }

    @Override
    public List<RoleMemberBo> getRolePrincipalsForPrincipalIdAndRoleIds(Collection<String> roleIds, String principalId, Map<String, String> qualification) {
        Criteria c = new Criteria();
        if (CollectionUtils.isNotEmpty(roleIds)) {
            if (roleIds.size() == 1) {
                c.addEqualTo("roleId", (Object)roleIds.iterator().next());
            } else {
                c.addIn("roleId", roleIds);
            }
        }
        if (principalId != null) {
            c.addEqualTo("memberId", (Object)principalId);
        }
        c.addEqualTo("typeCode", (Object)MemberType.PRINCIPAL.getCode());
        this.addSubCriteriaBasedOnRoleQualification(c, qualification);
        QueryByCriteria query = QueryFactory.newQuery(RoleMemberBo.class, (Criteria)c);
        Collection coll = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        ArrayList<RoleMemberBo> results = new ArrayList<RoleMemberBo>(coll.size());
        for (RoleMemberBo rm : coll) {
            if (!rm.isActive(new Timestamp(System.currentTimeMillis()))) continue;
            results.add(rm);
        }
        return results;
    }

    @Override
    public List<GroupMember> getGroupPrincipalsForPrincipalIdAndGroupIds(Collection<String> groupIds, String principalId) {
        List<Object> groupIdValues = new ArrayList();
        ArrayList<GroupMember> groupPrincipals = new ArrayList<GroupMember>();
        if (groupIds != null && principalId == null) {
            groupIdValues = new ArrayList<String>(groupIds);
        } else if (principalId != null) {
            groupIdValues = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
        }
        if (groupIdValues != null && groupIdValues.size() > 0) {
            List groupMembers = KimApiServiceLocator.getGroupService().getMembers(groupIdValues);
            for (GroupMember groupMembershipInfo : groupMembers) {
                if (principalId != null) {
                    if (!MemberType.PRINCIPAL.equals((Object)groupMembershipInfo.getType()) || !StringUtils.equals((String)principalId, (String)groupMembershipInfo.getMemberId()) || !groupMembershipInfo.isActive(new DateTime())) continue;
                    groupPrincipals.add(groupMembershipInfo);
                    continue;
                }
                groupPrincipals.add(groupMembershipInfo);
            }
        }
        return groupPrincipals;
    }

    @Override
    public List<GroupMember> getGroupMembers(Collection<String> groupIds) {
        List groupMemberships;
        ArrayList<String> groupIdValues;
        ArrayList<GroupMember> groupMembers = new ArrayList<GroupMember>();
        if (groupIds != null && (groupIdValues = new ArrayList<String>(groupIds)).size() > 0 && !CollectionUtils.isEmpty((Collection)(groupMemberships = KimApiServiceLocator.getGroupService().getMembers(groupIdValues)))) {
            for (GroupMember groupMembershipInfo : groupMemberships) {
                if (!MemberType.GROUP.equals((Object)groupMembershipInfo.getType()) || !groupMembershipInfo.isActive(new DateTime())) continue;
                groupMembers.add(groupMembershipInfo);
            }
        }
        return groupMembers;
    }

    @Override
    public List<RoleMemberBo> getRoleGroupsForGroupIdsAndRoleIds(Collection<String> roleIds, Collection<String> groupIds, Map<String, String> qualification) {
        Criteria c = new Criteria();
        if (roleIds != null && !roleIds.isEmpty()) {
            c.addIn("roleId", roleIds);
        }
        if (groupIds != null && !groupIds.isEmpty()) {
            c.addIn("memberId", groupIds);
        }
        c.addEqualTo("typeCode", (Object)MemberType.GROUP.getCode());
        this.addSubCriteriaBasedOnRoleQualification(c, qualification);
        QueryByCriteria query = QueryFactory.newQuery(RoleMemberBo.class, (Criteria)c);
        Collection coll = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        ArrayList<RoleMemberBo> results = new ArrayList<RoleMemberBo>(coll.size());
        for (RoleMemberBo rm : coll) {
            if (!rm.isActive(new Timestamp(System.currentTimeMillis()))) continue;
            results.add(rm);
        }
        return results;
    }

    @Override
    public Map<String, DelegateTypeBo> getDelegationImplMapFromRoleIds(Collection<String> roleIds) {
        HashMap<String, DelegateTypeBo> results = new HashMap<String, DelegateTypeBo>();
        if (CollectionUtils.isNotEmpty(roleIds)) {
            Criteria c = new Criteria();
            c.addIn("roleId", roleIds);
            c.addEqualTo("active", (Object)Boolean.TRUE);
            QueryByCriteria query = QueryFactory.newQuery(DelegateTypeBo.class, (Criteria)c);
            Collection coll = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            for (DelegateTypeBo delegateBo : coll) {
                results.put(delegateBo.getDelegationId(), delegateBo);
            }
        }
        return results;
    }

    @Override
    public List<DelegateTypeBo> getDelegationBosForRoleIds(Collection<String> roleIds) {
        ArrayList<DelegateTypeBo> results = new ArrayList<DelegateTypeBo>();
        if (roleIds != null && !roleIds.isEmpty()) {
            Criteria c = new Criteria();
            c.addIn("roleId", roleIds);
            c.addEqualTo("active", (Object)Boolean.TRUE);
            QueryByCriteria query = QueryFactory.newQuery(DelegateTypeBo.class, (Criteria)c);
            Collection coll = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
            for (DelegateTypeBo delegateBo : coll) {
                results.add(delegateBo);
            }
        }
        return results;
    }

    @Override
    public List<DelegateMemberBo> getDelegationPrincipalsForPrincipalIdAndDelegationIds(Collection<String> delegationIds, String principalId) {
        Criteria c = new Criteria();
        if (principalId != null) {
            c.addEqualTo("memberId", (Object)principalId);
        }
        c.addEqualTo("typeCode", (Object)MemberType.PRINCIPAL.getCode());
        if (delegationIds != null && !delegationIds.isEmpty()) {
            c.addIn("delegationId", delegationIds);
        }
        QueryByCriteria query = QueryFactory.newQuery(DelegateMemberBo.class, (Criteria)c);
        Collection coll = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        ArrayList<DelegateMemberBo> results = new ArrayList<DelegateMemberBo>(coll.size());
        for (DelegateMemberBo rm : coll) {
            if (!rm.isActive(new Timestamp(System.currentTimeMillis()))) continue;
            results.add(rm);
        }
        return results;
    }

    @Override
    public List<DelegateMemberBo> getDelegationGroupsForGroupIdsAndDelegationIds(Collection<String> delegationIds, List<String> groupIds) {
        Criteria c = new Criteria();
        if (delegationIds != null && !delegationIds.isEmpty()) {
            c.addIn("delegationId", delegationIds);
        }
        if (groupIds != null && !groupIds.isEmpty()) {
            c.addIn("memberId", groupIds);
        }
        c.addEqualTo("typeCode", (Object)MemberType.GROUP.getCode());
        QueryByCriteria query = QueryFactory.newQuery(DelegateMemberBo.class, (Criteria)c);
        Collection coll = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        ArrayList<DelegateMemberBo> results = new ArrayList<DelegateMemberBo>(coll.size());
        for (DelegateMemberBo rm : coll) {
            if (!rm.isActive(new Timestamp(System.currentTimeMillis()))) continue;
            results.add(rm);
        }
        return results;
    }

    @Override
    public List<RoleMemberBo> getRoleMembersForRoleIds(Collection<String> roleIds, String memberTypeCode, Map<String, String> qualification) {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        final ArrayList<String> roleIDs = new ArrayList<String>(roleIds);
        final String memberTypeCd = memberTypeCode;
        final Map<String, String> qual = qualification;
        final ArrayList<RoleMemberBo> roleMemberBos = new ArrayList<RoleMemberBo>();
        List results = (List)template.execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                StringBuffer sql1 = new StringBuffer("SELECT  A0.ROLE_MBR_ID AS ROLE_MBR_ID,A0.ROLE_ID AS ROLE_ID,A0.MBR_ID AS MBR_ID,A0.MBR_TYP_CD AS MBR_TYP_CD,A0.VER_NBR AS ROLE_MBR_VER_NBR,A0.OBJ_ID AS ROLE_MBR_OBJ_ID,A0.ACTV_FRM_DT AS ROLE_MBR_ACTV_FRM_DT ,A0.ACTV_TO_DT AS ROLE_MBR_ACTV_TO_DT,  BO.KIM_TYP_ID AS KIM_TYP_ID, BO.KIM_ATTR_DEFN_ID AS KIM_ATTR_DEFN_ID, BO.ATTR_VAL AS ATTR_VAL, BO.ATTR_DATA_ID AS ATTR_DATA_ID, BO.OBJ_ID AS ATTR_DATA_OBJ_ID, BO.VER_NBR AS ATTR_DATA_VER_NBR,   C0.KIM_ATTR_DEFN_ID AS KIM_ATTR_DEFN_ID, C0.OBJ_ID AS ATTR_DEFN_OBJ_ID, C0.VER_NBR as ATTR_DEFN_VER_NBR, C0.NM AS ATTR_NAME, C0.LBL as ATTR_DEFN_LBL, C0.ACTV_IND as ATTR_DEFN_ACTV_IND, C0.NMSPC_CD AS ATTR_DEFN_NMSPC_CD, C0.CMPNT_NM AS ATTR_DEFN_CMPNT_NM  FROM KRIM_ROLE_MBR_T A0 JOIN KRIM_ROLE_MBR_ATTR_DATA_T BO ON A0.ROLE_MBR_ID = BO.ROLE_MBR_ID  JOIN KRIM_ATTR_DEFN_T C0 ON BO.KIM_ATTR_DEFN_ID = C0.KIM_ATTR_DEFN_ID  ");
                StringBuffer sql2 = new StringBuffer("SELECT D0.ROLE_MBR_ID AS ROLE_MBR_ID,D0.ROLE_ID AS ROLE_ID,D0.MBR_ID AS MBR_ID,D0.MBR_TYP_CD AS MBR_TYP_CD,D0.VER_NBR AS ROLE_MBR_VER_NBR,D0.OBJ_ID AS ROLE_MBR_OBJ_ID,D0.ACTV_FRM_DT AS ROLE_MBR_ACTV_FRM_DT ,D0.ACTV_TO_DT AS ROLE_MBR_ACTV_TO_DT,  '' AS KIM_TYP_ID, '' AS KIM_ATTR_DEFN_ID, '' AS ATTR_VAL, '' AS ATTR_DATA_ID, '' AS ATTR_DATA_OBJ_ID, NULL AS ATTR_DATA_VER_NBR, '' AS KIM_ATTR_DEFN_ID,'' AS ATTR_DEFN_OBJ_ID, NULL as ATTR_DEFN_VER_NBR, '' AS ATTR_NAME, '' as ATTR_DEFN_LBL, '' as ATTR_DEFN_ACTV_IND, '' AS ATTR_DEFN_NMSPC_CD, '' AS ATTR_DEFN_CMPNT_NM  FROM KRIM_ROLE_MBR_T D0  WHERE D0.ROLE_MBR_ID NOT IN (SELECT DISTINCT (E0.ROLE_MBR_ID) FROM KRIM_ROLE_MBR_ATTR_DATA_T E0)");
                StringBuffer criteria = new StringBuffer();
                ArrayList<String> params1 = new ArrayList<String>();
                ArrayList<String> params2 = new ArrayList<String>();
                if (roleIDs != null && !roleIDs.isEmpty()) {
                    criteria.append("A0.ROLE_ID IN (");
                    for (String string : roleIDs) {
                        criteria.append("?,");
                        params1.add(string);
                        params2.add(string);
                    }
                    criteria.deleteCharAt(criteria.length() - 1);
                    criteria.append(")");
                }
                if (memberTypeCd != null) {
                    if (criteria.length() > 0) {
                        criteria.append(" AND ");
                    }
                    criteria.append("A0.MBR_TYP_CD = ?");
                    params1.add(memberTypeCd);
                    params2.add(memberTypeCd);
                }
                if (criteria.length() > 0) {
                    sql1.append(" WHERE ");
                    sql2.append(" AND ");
                    sql1.append(criteria);
                    sql2.append(criteria.toString().replaceAll("A0", "D0"));
                }
                if (qual != null && CollectionUtils.isNotEmpty(qual.keySet())) {
                    sql2 = new StringBuffer();
                    if (criteria.length() > 0) {
                        sql1.append(" AND ");
                    } else {
                        sql1.append(" WHERE ");
                    }
                    sql1.append(" EXISTS (SELECT B1.ROLE_MBR_ID FROM KRIM_ROLE_MBR_ATTR_DATA_T B1 WHERE (");
                    for (Map.Entry entry : qual.entrySet()) {
                        if (StringUtils.isNotEmpty((String)((String)entry.getValue()))) {
                            String value = ((String)entry.getValue()).replace('*', '%');
                            sql1.append(" (B1.ATTR_VAL LIKE ? AND B1.KIM_ATTR_DEFN_ID = ? ) ");
                            params1.add(value);
                            params1.add((String)entry.getKey());
                        }
                        sql1.append("OR");
                    }
                    sql1.delete(sql1.length() - 2, sql1.length());
                    sql1.append(") AND B1.ROLE_MBR_ID = A0.ROLE_MBR_ID )");
                }
                StringBuffer sql = new StringBuffer(sql1.toString());
                if (sql2.length() > 0) {
                    sql.append(" UNION ALL ");
                    sql.append(sql2.toString());
                }
                sql.append(" ORDER BY ROLE_MBR_ID ");
                PreparedStatement preparedStatement = connection.prepareStatement(sql.toString());
                int i = 1;
                for (String param : params1) {
                    preparedStatement.setString(i, param);
                    ++i;
                }
                if (sql2.length() > 0) {
                    for (String param : params2) {
                        preparedStatement.setString(i, param);
                        ++i;
                    }
                }
                return preparedStatement;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<List<RoleMemberBo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<RoleMemberBo> doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                try (ResultSet rs = statement.executeQuery();){
                    RoleMemberBo lastRoleMember = null;
                    while (rs.next()) {
                        DateTime activeToDate;
                        boolean processRolemember = true;
                        String roleId = rs.getString("ROLE_ID");
                        String id = rs.getString("ROLE_MBR_ID");
                        String memberId = rs.getString("MBR_ID");
                        MemberType memberType = MemberType.fromCode((String)rs.getString("MBR_TYP_CD"));
                        DateTime activeFromDate = rs.getDate("ROLE_MBR_ACTV_FRM_DT") == null ? null : new DateTime((Object)rs.getDate("ROLE_MBR_ACTV_FRM_DT"));
                        DateTime dateTime = activeToDate = rs.getDate("ROLE_MBR_ACTV_TO_DT") == null ? null : new DateTime((Object)rs.getDate("ROLE_MBR_ACTV_TO_DT"));
                        if (lastRoleMember == null || !id.equals(lastRoleMember.getId())) {
                            RoleMember roleMember = RoleMember.Builder.create((String)roleId, (String)id, (String)memberId, (MemberType)memberType, (DateTime)activeFromDate, (DateTime)activeToDate, new HashMap(), (String)"", (String)"").build();
                            Long roleVersionNbr = rs.getLong("ROLE_MBR_VER_NBR");
                            String roleObjId = rs.getString("ROLE_MBR_OBJ_ID");
                            RoleMemberBo roleMemberBo = RoleMemberBo.from(roleMember);
                            roleMemberBo.setVersionNumber(roleVersionNbr);
                            roleMemberBo.setObjectId(roleObjId);
                            ArrayList<RoleMemberAttributeDataBo> roleMemAttrBos = new ArrayList<RoleMemberAttributeDataBo>();
                            roleMemberBo.setAttributeDetails(roleMemAttrBos);
                            if (roleMemberBo.isActive(new Timestamp(System.currentTimeMillis()))) {
                                roleMemberBos.add(roleMemberBo);
                            } else {
                                processRolemember = false;
                            }
                            lastRoleMember = roleMemberBo;
                        }
                        String kimTypeId = rs.getString("KIM_TYP_ID");
                        String attrKey = rs.getString("KIM_ATTR_DEFN_ID");
                        String attrVal = rs.getString("ATTR_VAL");
                        if (!processRolemember || !StringUtils.isNotEmpty((String)kimTypeId)) continue;
                        KimType theType = KimApiServiceLocator.getKimTypeInfoService().getKimType(kimTypeId);
                        RoleMemberAttributeDataBo roleMemAttrDataBo = new RoleMemberAttributeDataBo();
                        KimAttribute.Builder attrBuilder = KimAttribute.Builder.create((String)rs.getString("ATTR_DEFN_CMPNT_NM"), (String)rs.getString("ATTR_NAME"), (String)rs.getString("ATTR_DEFN_NMSPC_CD"));
                        attrBuilder.setActive(Truth.strToBooleanIgnoreCase((String)rs.getString("ATTR_DEFN_ACTV_IND")).booleanValue());
                        attrBuilder.setAttributeLabel(rs.getString("ATTR_DEFN_LBL"));
                        attrBuilder.setId(rs.getString("KIM_ATTR_DEFN_ID"));
                        attrBuilder.setObjectId(rs.getString("ATTR_DEFN_OBJ_ID"));
                        attrBuilder.setVersionNumber(Long.valueOf(rs.getLong("ATTR_DEFN_VER_NBR")));
                        roleMemAttrDataBo.setId(rs.getString("ATTR_DATA_ID"));
                        roleMemAttrDataBo.setAssignedToId(id);
                        roleMemAttrDataBo.setKimTypeId(kimTypeId);
                        roleMemAttrDataBo.setKimType(KimTypeBo.from(theType));
                        roleMemAttrDataBo.setKimAttributeId(attrBuilder.getId());
                        roleMemAttrDataBo.setAttributeValue(attrVal);
                        roleMemAttrDataBo.setVersionNumber(rs.getLong("ATTR_DATA_VER_NBR"));
                        roleMemAttrDataBo.setObjectId(rs.getString("ATTR_DATA_OBJ_ID"));
                        roleMemAttrDataBo.setKimAttribute(KimAttributeBo.from(attrBuilder.build()));
                        lastRoleMember.getAttributeDetails().add(roleMemAttrDataBo);
                    }
                }
                return roleMemberBos;
            }
        });
        return roleMemberBos;
    }

    @Override
    public List<RoleMemberBo> getRoleMembershipsForRoleIdsAsMembers(Collection<String> roleIds, Map<String, String> qualification) {
        Criteria c = new Criteria();
        if (roleIds != null && !roleIds.isEmpty()) {
            c.addIn("memberId", roleIds);
        }
        c.addEqualTo("typeCode", (Object)MemberType.ROLE.getCode());
        this.addSubCriteriaBasedOnRoleQualification(c, qualification);
        QueryByCriteria query = QueryFactory.newQuery(RoleMemberBo.class, (Criteria)c);
        Collection coll = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        ArrayList<RoleMemberBo> results = new ArrayList<RoleMemberBo>(coll.size());
        for (RoleMemberBo rm : coll) {
            if (!rm.isActive(new Timestamp(System.currentTimeMillis()))) continue;
            results.add(rm);
        }
        return results;
    }

    @Override
    public List<RoleMemberBo> getRoleMembershipsForMemberId(String memberType, String memberId, Map<String, String> qualification) {
        Criteria c = new Criteria();
        ArrayList<RoleMemberBo> parentRoleMembers = new ArrayList<RoleMemberBo>();
        if (StringUtils.isEmpty((String)memberId) || StringUtils.isEmpty((String)memberType)) {
            return parentRoleMembers;
        }
        c.addEqualTo("memberId", (Object)memberId);
        c.addEqualTo("typeCode", (Object)memberType);
        this.addSubCriteriaBasedOnRoleQualification(c, qualification);
        QueryByCriteria query = QueryFactory.newQuery(RoleMemberBo.class, (Criteria)c);
        Collection coll = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        ArrayList<RoleMemberBo> results = new ArrayList<RoleMemberBo>(coll.size());
        for (RoleMemberBo rm : coll) {
            if (!rm.isActive(new Timestamp(System.currentTimeMillis()))) continue;
            results.add(rm);
        }
        return results;
    }

    @Override
    public List<RoleMemberBo> getRoleMembersForRoleIdsWithFilters(Collection<String> roleIds, String principalId, Collection<String> groupIds, Map<String, String> qualification) {
        Criteria c = new Criteria();
        if (roleIds != null && !roleIds.isEmpty()) {
            c.addIn("roleId", roleIds);
        }
        Criteria orSet = new Criteria();
        orSet.addEqualTo("typeCode", (Object)MemberType.ROLE.getCode());
        Criteria principalCheck = new Criteria();
        if (principalId != null) {
            principalCheck.addEqualTo("memberId", (Object)principalId);
        }
        principalCheck.addEqualTo("typeCode", (Object)MemberType.PRINCIPAL.getCode());
        orSet.addOrCriteria(principalCheck);
        Criteria groupCheck = new Criteria();
        if (groupIds != null && !groupIds.isEmpty()) {
            groupCheck.addIn("memberId", groupIds);
        }
        groupCheck.addEqualTo("typeCode", (Object)MemberType.GROUP.getCode());
        orSet.addOrCriteria(groupCheck);
        c.addAndCriteria(orSet);
        this.addSubCriteriaBasedOnRoleQualification(c, qualification);
        QueryByCriteria query = QueryFactory.newQuery(RoleMemberBo.class, (Criteria)c);
        Collection coll = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        ArrayList<RoleMemberBo> results = new ArrayList<RoleMemberBo>(coll.size());
        for (RoleMemberBo rm : coll) {
            if (!rm.isActive(new Timestamp(System.currentTimeMillis()))) continue;
            results.add(rm);
        }
        return results;
    }

    @Override
    public List<RoleBo> getRoles(Map<String, String> fieldValues) {
        Criteria criteria = new Criteria();
        Map<String, Map<String, String>> criteriaMap = this.setupCritMaps(fieldValues);
        Map<String, String> lookupNames = criteriaMap.get("lookupNames");
        for (Map.Entry<String, String> entry : lookupNames.entrySet()) {
            if (!StringUtils.isNotBlank((String)entry.getValue())) continue;
            if (!entry.getKey().equals("principalName")) {
                if (((String)entry.getKey()).equals("active")) {
                    criteria.addEqualTo("active", entry.getValue());
                    continue;
                }
                this.addLikeToCriteria(criteria, (String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            List<String> list = this.getRoleIdsForPrincipalName((String)entry.getValue());
            if (list != null && !list.isEmpty()) {
                criteria.addIn("id", list);
                continue;
            }
            list.add("NOTFOUND");
            criteria.addIn("id", list);
        }
        if (!criteriaMap.get("attr").isEmpty()) {
            String kimTypeId = null;
            for (Map.Entry entry : fieldValues.entrySet()) {
                if (!((String)entry.getKey()).equals("kimTypeId")) continue;
                kimTypeId = (String)entry.getValue();
                break;
            }
            this.setupAttrCriteria(criteria, criteriaMap.get("attr"), kimTypeId);
        }
        if (!criteriaMap.get("perm").isEmpty()) {
            criteria.addExists((Query)this.setupPermCriteria(criteriaMap.get("perm")));
        }
        if (!criteriaMap.get("resp").isEmpty()) {
            criteria.addExists((Query)this.setupRespCriteria(criteriaMap.get("resp")));
        }
        if (!criteriaMap.get("group").isEmpty()) {
            criteria.addExists((Query)this.setupGroupCriteria(criteriaMap.get("group")));
        }
        QueryByCriteria q = QueryFactory.newQuery(RoleBoLite.class, (Criteria)criteria);
        List roleBoLiteList = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)q);
        ArrayList<RoleBo> arrayList = new ArrayList<RoleBo>();
        for (RoleBoLite roleLite : roleBoLiteList) {
            RoleBo role = RoleBo.from(RoleBoLite.to(roleLite));
            arrayList.add(role);
        }
        return arrayList;
    }

    private List<String> getPrincipalIdsForPrincipalName(String principalName) {
        QueryByCriteria.Builder qb = QueryByCriteria.Builder.create();
        qb.setPredicates(new Predicate[]{PredicateFactory.equal((String)"principals.principalName", (Object)principalName)});
        List entities = KimApiServiceLocator.getIdentityService().findEntityDefaults(qb.build()).getResults();
        ArrayList<String> principalIds = new ArrayList<String>();
        for (EntityDefault entity : entities) {
            for (Principal principal : entity.getPrincipals()) {
                principalIds.add(principal.getPrincipalId());
            }
        }
        return principalIds;
    }

    private List<String> getRoleIdsForPrincipalName(String value) {
        String principalName = value.replace('*', '%');
        ArrayList<String> roleIds = new ArrayList<String>();
        Criteria memberSubCrit = new Criteria();
        QueryByCriteria.Builder qb = QueryByCriteria.Builder.create();
        qb.setPredicates(new Predicate[]{PredicateFactory.like((String)"principals.principalName", (CharSequence)principalName)});
        List entities = KimApiServiceLocator.getIdentityService().findEntityDefaults(qb.build()).getResults();
        if (entities == null || entities.size() == 0) {
            return roleIds;
        }
        ArrayList<String> principalIds = new ArrayList<String>();
        for (Object entity : entities) {
            for (Principal principal : entity.getPrincipals()) {
                principalIds.add(principal.getPrincipalId());
            }
        }
        if (principalIds != null && !principalIds.isEmpty()) {
            memberSubCrit.addEqualTo("typeCode", (Object)MemberType.PRINCIPAL.getCode());
            memberSubCrit.addIn("memberId", principalIds);
            ReportQueryByCriteria memberSubQuery = QueryFactory.newReportQuery(RoleMemberBo.class, (Criteria)memberSubCrit);
            for (RoleMemberBo roleMbr : (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)memberSubQuery)) {
                if (!roleMbr.isActive(new Timestamp(System.currentTimeMillis())) || roleIds.contains(roleMbr.getRoleId())) continue;
                roleIds.add(roleMbr.getRoleId());
            }
        }
        ArrayList<String> groupIds = new ArrayList<String>();
        for (String principalId : principalIds) {
            List principalGroupIds = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
            for (String groupId : principalGroupIds) {
                if (groupIds.contains(groupId)) continue;
                groupIds.add(groupId);
            }
        }
        if (groupIds != null && !groupIds.isEmpty()) {
            Criteria grpRoleCrit = new Criteria();
            grpRoleCrit.addEqualTo("typeCode", (Object)MemberType.GROUP.getCode());
            grpRoleCrit.addIn("memberId", groupIds);
            ReportQueryByCriteria memberSubQuery = QueryFactory.newReportQuery(RoleMemberBo.class, (Criteria)grpRoleCrit);
            for (RoleMemberBo roleMbr : (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)memberSubQuery)) {
                if (!roleMbr.isActive(new Timestamp(System.currentTimeMillis())) || roleIds.contains(roleMbr.getRoleId())) continue;
                roleIds.add(roleMbr.getRoleId());
            }
        }
        return roleIds;
    }

    private Map<String, Map<String, String>> setupCritMaps(Map<String, String> fieldValues) {
        HashMap<String, Map<String, String>> critMap = new HashMap<String, Map<String, String>>();
        ArrayList<String> permFieldName = new ArrayList<String>();
        permFieldName.add("permName");
        permFieldName.add("permNamespaceCode");
        permFieldName.add("permTmplName");
        permFieldName.add("permTmplNamespaceCode");
        ArrayList<String> respFieldName = new ArrayList<String>();
        respFieldName.add("respName");
        respFieldName.add("respNamespaceCode");
        respFieldName.add("respTmplName");
        respFieldName.add("respTmplNamespaceCode");
        HashMap<String, String> permFieldMap = new HashMap<String, String>();
        HashMap<String, String> respFieldMap = new HashMap<String, String>();
        HashMap<String, String> attrFieldMap = new HashMap<String, String>();
        HashMap<String, String> groupFieldMap = new HashMap<String, String>();
        HashMap<String, String> lookupNamesMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : fieldValues.entrySet()) {
            if (!StringUtils.isNotBlank((String)entry.getValue())) continue;
            String nameValue = entry.getValue();
            if (permFieldName.contains(entry.getKey())) {
                permFieldMap.put(entry.getKey(), nameValue);
                continue;
            }
            if (respFieldName.contains(entry.getKey())) {
                respFieldMap.put(entry.getKey(), nameValue);
                continue;
            }
            if (entry.getKey().startsWith("groupName")) {
                groupFieldMap.put(entry.getKey(), nameValue);
                continue;
            }
            if (entry.getKey().contains(".")) {
                attrFieldMap.put(entry.getKey(), nameValue).replace('*', '%');
                continue;
            }
            lookupNamesMap.put(entry.getKey(), nameValue);
        }
        critMap.put("perm", permFieldMap);
        critMap.put("resp", respFieldMap);
        critMap.put("group", groupFieldMap);
        critMap.put("attr", attrFieldMap);
        critMap.put("lookupNames", lookupNamesMap);
        return critMap;
    }

    private void setupAttrCriteria(Criteria crit, Map<String, String> attrCrit, String kimTypeId) {
        for (Map.Entry<String, String> entry : attrCrit.entrySet()) {
            Criteria subCrit = new Criteria();
            this.addLikeToCriteria(subCrit, "attributes.attributeValue", entry.getValue());
            this.addEqualToCriteria(subCrit, "attributes.kimAttributeId", entry.getKey().substring(entry.getKey().indexOf(".") + 1, entry.getKey().length()));
            this.addEqualToCriteria(subCrit, "attributes.kimTypeId", kimTypeId);
            subCrit.addEqualToField("roleId", "parentQuery.id");
            crit.addExists((Query)QueryFactory.newReportQuery(RoleMemberBo.class, (Criteria)subCrit));
        }
    }

    private ReportQueryByCriteria setupPermCriteria(Map<String, String> permCrit) {
        HashMap<String, String> actualCriteriaMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : permCrit.entrySet()) {
            if (entry.getKey().equals("permTmplName") || entry.getKey().equals("permTmplNamespaceCode")) {
                if (entry.getKey().equals("permTmplName")) {
                    actualCriteriaMap.put("template.name", entry.getValue());
                } else {
                    actualCriteriaMap.put("template.namespaceCode", entry.getValue());
                }
            }
            if (!entry.getKey().equals("permName") && !entry.getKey().equals("permNamespaceCode")) continue;
            if (entry.getKey().equals("permName")) {
                actualCriteriaMap.put("name", entry.getValue());
                continue;
            }
            actualCriteriaMap.put("namespaceCode", entry.getValue());
        }
        Predicate predicate = PredicateUtils.convertMapToPredicate(actualCriteriaMap);
        List permList = KimApiServiceLocator.getPermissionService().findPermissions(QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{predicate})).getResults();
        List<Object> roleIds = null;
        if (permList != null && !permList.isEmpty()) {
            roleIds = this.getRoleIdsForPermissions(permList);
        }
        if (roleIds == null || roleIds.isEmpty()) {
            roleIds = new ArrayList();
            roleIds.add("-1");
        }
        Criteria memberSubCrit = new Criteria();
        memberSubCrit.addIn("id", roleIds);
        memberSubCrit.addEqualToField("id", "parentQuery.id");
        return QueryFactory.newReportQuery(RoleBo.class, (Criteria)memberSubCrit);
    }

    private List<String> getRoleIdsForPermissions(Collection<Permission> permissions) {
        if (permissions.isEmpty()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> permissionIds = new ArrayList<String>(permissions.size());
        for (Permission permission : permissions) {
            permissionIds.add(permission.getId());
        }
        Criteria c = new Criteria();
        c.addIn("permissionId", permissionIds);
        c.addEqualTo("active", (Object)true);
        QueryByCriteria query = QueryFactory.newQuery(RolePermissionBo.class, (Criteria)c, (boolean)true);
        Collection coll = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        ArrayList<String> roleIds = new ArrayList<String>(coll.size());
        for (RolePermissionBo rp : coll) {
            roleIds.add(rp.getRoleId());
        }
        return roleIds;
    }

    private ReportQueryByCriteria setupRespCriteria(Map<String, String> respCrit) {
        QueryByCriteria.Builder queryByCriteriaBuilder = QueryByCriteria.Builder.create();
        HashMap<String, String> actualCriteriaMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : respCrit.entrySet()) {
            if (entry.getKey().equals("respTmplName") || entry.getKey().equals("respTmplNamespaceCode")) {
                if (entry.getKey().equals("respTmplName")) {
                    actualCriteriaMap.put("template.name", entry.getValue());
                } else {
                    actualCriteriaMap.put("template.namespaceCode", entry.getValue());
                }
            }
            if (!entry.getKey().equals("respName") && !entry.getKey().equals("respNamespaceCode")) continue;
            if (entry.getKey().equals("respName")) {
                actualCriteriaMap.put("name", entry.getValue());
                continue;
            }
            actualCriteriaMap.put("namespaceCode", entry.getValue());
        }
        Predicate predicate = PredicateUtils.convertMapToPredicate(actualCriteriaMap);
        queryByCriteriaBuilder.setPredicates(new Predicate[]{predicate});
        ResponsibilityService responsibilityService = KimApiServiceLocator.getResponsibilityService();
        ResponsibilityQueryResults results = responsibilityService.findResponsibilities(queryByCriteriaBuilder.build());
        List responsibilities = results.getResults();
        ArrayList<String> roleIds = new ArrayList<String>();
        for (Responsibility responsibility : responsibilities) {
            roleIds.addAll(responsibilityService.getRoleIdsForResponsibility(responsibility.getId()));
        }
        if (roleIds.isEmpty()) {
            roleIds.add("-1");
        }
        Criteria memberSubCrit = new Criteria();
        memberSubCrit.addIn("id", roleIds);
        memberSubCrit.addEqualToField("id", "parentQuery.id");
        return QueryFactory.newReportQuery(RoleBo.class, (Criteria)memberSubCrit);
    }

    private ReportQueryByCriteria setupGroupCriteria(Map<String, String> groupCrit) {
        QueryByCriteria.Builder searchCrit = QueryByCriteria.Builder.create();
        HashMap<String, String> actualCrit = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : groupCrit.entrySet()) {
            if (entry.getKey().equals("groupName")) {
                actualCrit.put("name", entry.getValue());
                continue;
            }
            actualCrit.put("namespaceCode", entry.getValue());
        }
        Criteria crit = new Criteria();
        Predicate predicate = PredicateUtils.convertMapToPredicate(actualCrit);
        searchCrit.setPredicates(new Predicate[]{predicate});
        ArrayList<String> groupIds = KimApiServiceLocator.getGroupService().findGroupIds(searchCrit.build());
        if (groupIds == null || groupIds.isEmpty()) {
            groupIds = new ArrayList<String>();
            groupIds.add("-1");
        }
        crit.addIn("memberId", groupIds);
        crit.addEqualToField("roleId", "parentQuery.id");
        return QueryFactory.newReportQuery(RoleMemberBo.class, (Criteria)crit);
    }

    private void addLikeToCriteria(Criteria criteria, String propertyName, String propertyValue) {
        String[] keyValues = this.getCaseInsensitiveValues(propertyName, propertyValue);
        criteria.addLike((Object)keyValues[0], (Object)keyValues[1]);
    }

    private void addEqualToCriteria(Criteria criteria, String propertyName, String propertyValue) {
        String[] keyValues = this.getCaseInsensitiveValues(propertyName, propertyValue);
        criteria.addEqualTo(keyValues[0], (Object)keyValues[1]);
    }

    private String[] getCaseInsensitiveValues(String propertyName, String propertyValue) {
        String[] keyValues = new String[]{propertyName == null ? "" : this.getDbPlatform().getUpperCaseFunction() + "(" + propertyName + ")", propertyValue == null ? "" : propertyValue.toUpperCase()};
        return keyValues;
    }

    private boolean hasCoreRoleMemberCriteria(Map<String, String> fieldValues) {
        return StringUtils.isNotEmpty((String)fieldValues.get("id")) || StringUtils.isNotEmpty((String)fieldValues.get("roleId")) || StringUtils.isNotEmpty((String)fieldValues.get("memberId")) || StringUtils.isNotEmpty((String)fieldValues.get("typeCode")) || StringUtils.isNotEmpty((String)fieldValues.get("activeFromDate")) || StringUtils.isNotEmpty((String)fieldValues.get("activeToDate"));
    }

    private boolean hasExtraRoleMemberCriteria(Map<String, String> fieldValues) {
        return StringUtils.isNotEmpty((String)fieldValues.get("memberName")) || StringUtils.isNotEmpty((String)fieldValues.get("memberNamespaceCode"));
    }

    private List<RoleBo> getRoleMembersRoles(String memberNamespaceCode, String memberName) {
        Criteria queryCriteria = new Criteria();
        this.addEqualToCriteria(queryCriteria, "namespaceCode", memberNamespaceCode);
        this.addEqualToCriteria(queryCriteria, "name", memberName);
        QueryByCriteria q = QueryFactory.newQuery(RoleBo.class, (Criteria)queryCriteria);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)q);
    }
}

