/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.role;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.kim.api.group.GroupMember;
import org.kuali.rice.kim.api.group.GroupMemberContract;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateTypeBo;
import org.kuali.rice.kim.impl.group.GroupMemberBo;
import org.kuali.rice.kim.impl.role.RoleInternalService;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.impl.role.RoleServiceBase;

public class RoleInternalServiceImpl
extends RoleServiceBase
implements RoleInternalService {
    @Override
    public void principalInactivated(String principalId) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new IllegalArgumentException("principalId is null or blank");
        }
        long oneDayInMillis = TimeUnit.DAYS.toMillis(1L);
        Timestamp yesterday = new Timestamp(System.currentTimeMillis() - oneDayInMillis);
        this.inactivatePrincipalRoleMemberships(principalId, yesterday);
        this.inactivatePrincipalGroupMemberships(principalId, yesterday);
        this.inactivatePrincipalDelegations(principalId, yesterday);
        this.inactivateApplicationRoleMemberships(principalId, yesterday);
    }

    @Override
    public void roleInactivated(String roleId) {
        if (StringUtils.isBlank((String)roleId)) {
            throw new IllegalArgumentException("roleId is null or blank");
        }
        long oneDayInMillis = TimeUnit.DAYS.toMillis(1L);
        Timestamp yesterday = new Timestamp(System.currentTimeMillis() - oneDayInMillis);
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleId);
        this.inactivateRoleMemberships(roleIds, yesterday);
        this.inactivateRoleDelegations(roleIds, yesterday);
        this.inactivateMembershipsForRoleAsMember(roleIds, yesterday);
    }

    private void inactivateRoleMemberships(List<String> roleIds, Timestamp yesterday) {
        List<RoleMemberBo> roleMemberBoList = this.getStoredRoleMembersForRoleIds(roleIds, null, null);
        for (RoleMemberBo roleMemberBo : roleMemberBoList) {
            roleMemberBo.setActiveToDateValue(yesterday);
        }
        this.getBusinessObjectService().save(roleMemberBoList);
    }

    private void inactivateRoleDelegations(List<String> roleIds, Timestamp yesterday) {
        List<DelegateTypeBo> delegations = this.getStoredDelegationImplsForRoleIds(roleIds);
        for (DelegateTypeBo delegation : delegations) {
            delegation.setActive(false);
            for (DelegateMemberBo delegationMember : delegation.getMembers()) {
                delegationMember.setActiveToDateValue(yesterday);
            }
        }
        this.getBusinessObjectService().save(delegations);
    }

    private void inactivateMembershipsForRoleAsMember(List<String> roleIds, Timestamp yesterday) {
        List<RoleMemberBo> roleMemberBoList = this.getStoredRoleMembershipsForRoleIdsAsMembers(roleIds, null);
        for (RoleMemberBo roleMemberBo : roleMemberBoList) {
            roleMemberBo.setActiveToDateValue(yesterday);
        }
        this.getBusinessObjectService().save(roleMemberBoList);
    }

    @Override
    public void groupInactivated(String groupId) {
        if (StringUtils.isBlank((String)groupId)) {
            throw new IllegalArgumentException("groupId is null or blank");
        }
        long oneDayInMillis = TimeUnit.DAYS.toMillis(1L);
        Timestamp yesterday = new Timestamp(System.currentTimeMillis() - oneDayInMillis);
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add(groupId);
        this.inactivatePrincipalGroupMemberships(groupIds, yesterday);
        this.inactivateGroupRoleMemberships(groupIds, yesterday);
    }

    protected void inactivateApplicationRoleMemberships(String principalId, Timestamp yesterday) {
    }

    protected void inactivatePrincipalRoleMemberships(String principalId, Timestamp yesterday) {
        List<RoleMemberBo> roleMembers = this.getStoredRolePrincipalsForPrincipalIdAndRoleIds(null, principalId, null);
        HashSet<String> roleIds = new HashSet<String>(roleMembers.size());
        for (RoleMemberBo roleMemberBo : roleMembers) {
            roleMemberBo.setActiveToDateValue(yesterday);
            roleIds.add(roleMemberBo.getRoleId());
        }
        this.getBusinessObjectService().save(roleMembers);
    }

    protected void inactivateGroupRoleMemberships(List<String> groupIds, Timestamp yesterday) {
        List<RoleMemberBo> roleMemberBosOfGroupType = this.getStoredRoleGroupsForGroupIdsAndRoleIds(null, groupIds, null);
        for (RoleMemberBo roleMemberbo : roleMemberBosOfGroupType) {
            roleMemberbo.setActiveToDateValue(yesterday);
        }
        this.getBusinessObjectService().save(roleMemberBosOfGroupType);
    }

    protected void inactivatePrincipalGroupMemberships(String principalId, Timestamp yesterday) {
        List<GroupMember> groupMembers = this.getRoleDao().getGroupPrincipalsForPrincipalIdAndGroupIds(null, principalId);
        ArrayList<GroupMemberBo> groupMemberBoList = new ArrayList<GroupMemberBo>(groupMembers.size());
        for (GroupMember gm : groupMembers) {
            GroupMember.Builder builder = GroupMember.Builder.create((GroupMemberContract)gm);
            builder.setActiveToDate(new DateTime(yesterday.getTime()));
            groupMemberBoList.add(GroupMemberBo.from(builder.build()));
        }
        this.getBusinessObjectService().save(groupMemberBoList);
    }

    protected void inactivatePrincipalGroupMemberships(List<String> groupIds, Timestamp yesterday) {
        List<GroupMember> groupMembers = this.getRoleDao().getGroupMembers(groupIds);
        ArrayList<GroupMemberBo> groupMemberBoList = new ArrayList<GroupMemberBo>(groupMembers.size());
        for (GroupMember groupMember : groupMembers) {
            GroupMember.Builder builder = GroupMember.Builder.create((GroupMemberContract)groupMember);
            builder.setActiveToDate(new DateTime(yesterday.getTime()));
            groupMemberBoList.add(GroupMemberBo.from(builder.build()));
        }
        this.getBusinessObjectService().save(groupMemberBoList);
    }

    protected void inactivatePrincipalDelegations(String principalId, Timestamp yesterday) {
        List<DelegateMemberBo> delegationMembers = this.getStoredDelegationPrincipalsForPrincipalIdAndDelegationIds(null, principalId);
        for (DelegateMemberBo delegateMemberBo : delegationMembers) {
            delegateMemberBo.setActiveToDateValue(yesterday);
        }
        this.getBusinessObjectService().save(delegationMembers);
    }
}

