/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.common.attribute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.api.common.attribute.KimAttributeDataContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@MappedSuperclass
@PortableSequenceGenerator(name="KRIM_ATTR_DATA_ID_S")
public abstract class KimAttributeDataBo
extends DataObjectBase
implements KimAttributeDataContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final Logger LOG = Logger.getLogger(KimAttributeDataBo.class);
    private static final long serialVersionUID = 1L;
    private static KimTypeInfoService kimTypeInfoService;
    @Column(name="ATTR_VAL")
    private String attributeValue;
    @Column(name="KIM_ATTR_DEFN_ID")
    private String kimAttributeId;
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="KIM_ATTR_DEFN_ID", insertable=false, updatable=false)
    private KimAttributeBo kimAttribute;
    @Column(name="KIM_TYP_ID")
    private String kimTypeId;
    @Transient
    private KimTypeBo kimType;

    public KimAttributeDataBo() {
    }

    public abstract void setId(String var1);

    public abstract void setAssignedToId(String var1);

    public KimAttributeBo getKimAttribute() {
        if (this._persistence_get_kimAttribute() == null && StringUtils.isNotBlank((String)this._persistence_get_kimAttributeId())) {
            KradDataServiceLocator.getDataObjectService().wrap((Object)this).fetchRelationship("kimAttribute");
        }
        return this._persistence_get_kimAttribute();
    }

    public KimTypeBo getKimType() {
        if (this.kimType == null && StringUtils.isNotEmpty((String)this.getId())) {
            this.kimType = KimTypeBo.from(KimApiServiceLocator.getKimTypeInfoService().getKimType(this._persistence_get_kimTypeId()));
        }
        return this.kimType;
    }

    public static <T extends KimAttributeDataBo> Map<String, String> toAttributes(Collection<T> bos) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(bos)) {
            for (KimAttributeDataBo it : bos) {
                if (it == null) continue;
                KimTypeAttribute attribute = null;
                if (it.getKimType() != null) {
                    attribute = KimTypeBo.to(it.getKimType()).getAttributeDefinitionById(it.getKimAttributeId());
                }
                if (attribute != null) {
                    m.put(attribute.getKimAttribute().getAttributeName(), it.getAttributeValue());
                    continue;
                }
                m.put(it.getKimAttribute().getAttributeName(), it.getAttributeValue());
            }
        }
        return m;
    }

    public static <T extends KimAttributeDataBo> List<T> createFrom(Class<T> type, Map<String, String> attributes, String kimTypeId) {
        if (attributes == null) {
            return new ArrayList();
        }
        ArrayList<KimAttributeDataBo> attrs = new ArrayList<KimAttributeDataBo>();
        for (Map.Entry<String, String> it : attributes.entrySet()) {
            KimTypeAttribute attr = KimAttributeDataBo.getKimTypeInfoService().getKimType(kimTypeId).getAttributeDefinitionByName(it.getKey());
            if (attr == null) {
                LOG.error((Object)("Attribute " + it.getKey() + " was not found for kimType " + KimAttributeDataBo.getKimTypeInfoService().getKimType(kimTypeId).getName()));
            }
            KimType theType = KimAttributeDataBo.getKimTypeInfoService().getKimType(kimTypeId);
            if (attr == null || !StringUtils.isNotBlank((String)it.getValue())) continue;
            try {
                KimAttributeDataBo newDetail = (KimAttributeDataBo)((Object)type.newInstance());
                newDetail.setKimAttributeId(attr.getKimAttribute().getId());
                newDetail.setKimAttribute(KimAttributeBo.from(attr.getKimAttribute()));
                newDetail.setKimTypeId(kimTypeId);
                newDetail.setKimType(KimTypeBo.from(theType));
                newDetail.setAttributeValue(it.getValue());
                attrs.add(newDetail);
            }
            catch (InstantiationException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return attrs;
    }

    public String getAttributeValue() {
        return this._persistence_get_attributeValue();
    }

    public void setAttributeValue(String attributeValue) {
        this._persistence_set_attributeValue(attributeValue);
    }

    public String getKimAttributeId() {
        return this._persistence_get_kimAttributeId();
    }

    public void setKimAttributeId(String kimAttributeId) {
        this._persistence_set_kimAttributeId(kimAttributeId);
    }

    public String getKimTypeId() {
        return this._persistence_get_kimTypeId();
    }

    public void setKimTypeId(String kimTypeId) {
        this._persistence_set_kimTypeId(kimTypeId);
    }

    public void setKimType(KimTypeBo kimType) {
        this.kimType = kimType;
    }

    public void setKimAttribute(KimAttributeBo kimAttribute) {
        this._persistence_set_kimAttribute(kimAttribute);
    }

    public static KimTypeInfoService getKimTypeInfoService() {
        if (kimTypeInfoService == null) {
            kimTypeInfoService = KimApiServiceLocator.getKimTypeInfoService();
        }
        return kimTypeInfoService;
    }

    public static void setKimTypeInfoService(KimTypeInfoService kimTypeInfoService) {
        KimAttributeDataBo.kimTypeInfoService = kimTypeInfoService;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new KimAttributeDataBo(persistenceObject);
    }

    public KimAttributeDataBo(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "kimAttribute") {
            return this.kimAttribute;
        }
        if (string == "attributeValue") {
            return this.attributeValue;
        }
        if (string == "kimAttributeId") {
            return this.kimAttributeId;
        }
        if (string == "kimTypeId") {
            return this.kimTypeId;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "kimAttribute") {
            this.kimAttribute = (KimAttributeBo)((Object)object);
            return;
        }
        if (string == "attributeValue") {
            this.attributeValue = (String)object;
            return;
        }
        if (string == "kimAttributeId") {
            this.kimAttributeId = (String)object;
            return;
        }
        if (string == "kimTypeId") {
            this.kimTypeId = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public KimAttributeBo _persistence_get_kimAttribute() {
        this._persistence_checkFetched("kimAttribute");
        return this.kimAttribute;
    }

    public void _persistence_set_kimAttribute(KimAttributeBo kimAttributeBo) {
        this._persistence_checkFetchedForSet("kimAttribute");
        this._persistence_propertyChange("kimAttribute", (Object)this.kimAttribute, (Object)kimAttributeBo);
        this.kimAttribute = kimAttributeBo;
    }

    public String _persistence_get_attributeValue() {
        this._persistence_checkFetched("attributeValue");
        return this.attributeValue;
    }

    public void _persistence_set_attributeValue(String string) {
        this._persistence_checkFetchedForSet("attributeValue");
        this._persistence_propertyChange("attributeValue", this.attributeValue, string);
        this.attributeValue = string;
    }

    public String _persistence_get_kimAttributeId() {
        this._persistence_checkFetched("kimAttributeId");
        return this.kimAttributeId;
    }

    public void _persistence_set_kimAttributeId(String string) {
        this._persistence_checkFetchedForSet("kimAttributeId");
        this._persistence_propertyChange("kimAttributeId", this.kimAttributeId, string);
        this.kimAttributeId = string;
    }

    public String _persistence_get_kimTypeId() {
        this._persistence_checkFetched("kimTypeId");
        return this.kimTypeId;
    }

    public void _persistence_set_kimTypeId(String string) {
        this._persistence_checkFetchedForSet("kimTypeId");
        this._persistence_propertyChange("kimTypeId", this.kimTypeId, string);
        this.kimTypeId = string;
    }
}

