/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.common.delegate;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.api.common.delegate.DelegateMember;
import org.kuali.rice.kim.api.common.delegate.DelegateMemberContract;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberAttributeDataBo;
import org.kuali.rice.kim.impl.membership.AbstractMemberBo;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.springframework.util.AutoPopulatingList;

@Entity
@Table(name="KRIM_DLGN_MBR_T")
public class DelegateMemberBo
extends AbstractMemberBo
implements DelegateMemberContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @PortableSequenceGenerator(name="KRIM_DLGN_MBR_ID_S")
    @GeneratedValue(generator="KRIM_DLGN_MBR_ID_S")
    @Id
    @Column(name="DLGN_MBR_ID")
    private String delegationMemberId;
    @Column(name="DLGN_ID")
    private String delegationId;
    @Column(name="ROLE_MBR_ID")
    private String roleMemberId;
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=DelegateMemberAttributeDataBo.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="DLGN_MBR_ID", referencedColumnName="DLGN_MBR_ID", insertable=false, updatable=false)
    private List<DelegateMemberAttributeDataBo> attributeDetails = new AutoPopulatingList(DelegateMemberAttributeDataBo.class);
    @Transient
    private Map<String, String> attributes;

    public Map<String, String> getQualifier() {
        HashMap<String, String> attribs = new HashMap<String, String>();
        if (this._persistence_get_attributeDetails() == null) {
            return attribs;
        }
        for (DelegateMemberAttributeDataBo attr : this._persistence_get_attributeDetails()) {
            attribs.put(attr.getKimAttribute().getAttributeName(), attr.getAttributeValue());
        }
        return attribs;
    }

    public List<DelegateMemberAttributeDataBo> getAttributeDetails() {
        if (this._persistence_get_attributeDetails() == null) {
            return new AutoPopulatingList(DelegateMemberAttributeDataBo.class);
        }
        return this._persistence_get_attributeDetails();
    }

    public void setAttributeDetails(List<DelegateMemberAttributeDataBo> attributeDetails) {
        this._persistence_set_attributeDetails(attributeDetails);
    }

    public Map<String, String> getAttributes() {
        return CollectionUtils.isNotEmpty((Collection)this._persistence_get_attributeDetails()) ? KimAttributeDataBo.toAttributes(this._persistence_get_attributeDetails()) : this.attributes;
    }

    public static DelegateMember to(DelegateMemberBo bo) {
        if (bo == null) {
            return null;
        }
        return DelegateMember.Builder.create((DelegateMemberContract)bo).build();
    }

    public static DelegateMemberBo from(DelegateMember immutable) {
        if (immutable == null) {
            return null;
        }
        DelegateMemberBo bo = new DelegateMemberBo();
        bo.setDelegationMemberId(immutable.getDelegationMemberId());
        bo.setActiveFromDateValue(immutable.getActiveFromDate() == null ? null : new Timestamp(immutable.getActiveFromDate().getMillis()));
        bo.setActiveToDateValue(immutable.getActiveToDate() == null ? null : new Timestamp(immutable.getActiveToDate().getMillis()));
        bo.setDelegationId(immutable.getDelegationId());
        bo.setMemberId(immutable.getMemberId());
        bo.setRoleMemberId(immutable.getRoleMemberId());
        bo.setTypeCode(immutable.getType().getCode());
        bo.setVersionNumber(immutable.getVersionNumber());
        bo.setAttributes(immutable.getAttributes());
        return bo;
    }

    public String getDelegationMemberId() {
        return this._persistence_get_delegationMemberId();
    }

    public void setDelegationMemberId(String delegationMemberId) {
        this._persistence_set_delegationMemberId(delegationMemberId);
    }

    public String getDelegationId() {
        return this._persistence_get_delegationId();
    }

    public void setDelegationId(String delegationId) {
        this._persistence_set_delegationId(delegationId);
    }

    public String getRoleMemberId() {
        return this._persistence_get_roleMemberId();
    }

    public void setRoleMemberId(String roleMemberId) {
        this._persistence_set_roleMemberId(roleMemberId);
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new DelegateMemberBo();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "roleMemberId") {
            return this.roleMemberId;
        }
        if (string == "delegationId") {
            return this.delegationId;
        }
        if (string == "delegationMemberId") {
            return this.delegationMemberId;
        }
        if (string == "attributeDetails") {
            return this.attributeDetails;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "roleMemberId") {
            this.roleMemberId = (String)object;
            return;
        }
        if (string == "delegationId") {
            this.delegationId = (String)object;
            return;
        }
        if (string == "delegationMemberId") {
            this.delegationMemberId = (String)object;
            return;
        }
        if (string == "attributeDetails") {
            this.attributeDetails = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_roleMemberId() {
        this._persistence_checkFetched("roleMemberId");
        return this.roleMemberId;
    }

    public void _persistence_set_roleMemberId(String string) {
        this._persistence_checkFetchedForSet("roleMemberId");
        this._persistence_propertyChange("roleMemberId", this.roleMemberId, string);
        this.roleMemberId = string;
    }

    public String _persistence_get_delegationId() {
        this._persistence_checkFetched("delegationId");
        return this.delegationId;
    }

    public void _persistence_set_delegationId(String string) {
        this._persistence_checkFetchedForSet("delegationId");
        this._persistence_propertyChange("delegationId", this.delegationId, string);
        this.delegationId = string;
    }

    public String _persistence_get_delegationMemberId() {
        this._persistence_checkFetched("delegationMemberId");
        return this.delegationMemberId;
    }

    public void _persistence_set_delegationMemberId(String string) {
        this._persistence_checkFetchedForSet("delegationMemberId");
        this._persistence_propertyChange("delegationMemberId", this.delegationMemberId, string);
        this.delegationMemberId = string;
    }

    public List _persistence_get_attributeDetails() {
        this._persistence_checkFetched("attributeDetails");
        return this.attributeDetails;
    }

    public void _persistence_set_attributeDetails(List list) {
        this._persistence_checkFetchedForSet("attributeDetails");
        this._persistence_propertyChange("attributeDetails", this.attributeDetails, list);
        this.attributeDetails = list;
    }
}

