/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.group.GroupInternalService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class GroupInternalServiceImpl
implements GroupInternalService {
    protected DataObjectService getDataObjectService() {
        return KRADServiceLocator.getDataObjectService();
    }

    protected GroupService getGroupService() {
        return KimApiServiceLocator.getGroupService();
    }

    @Override
    public GroupBo saveWorkgroup(GroupBo group) {
        GroupService ims = this.getGroupService();
        List oldIds = Collections.emptyList();
        if (StringUtils.isNotEmpty((String)group.getId())) {
            oldIds = ims.getMemberPrincipalIds(group.getId());
        }
        group = (GroupBo)((Object)this.getDataObjectService().save((Object)group, new PersistenceOption[]{PersistenceOption.FLUSH}));
        List newIds = ims.getMemberPrincipalIds(group.getId());
        this.updateForWorkgroupChange(group.getId(), oldIds, newIds);
        return group;
    }

    @Override
    public void updateForWorkgroupChange(String groupId, List<String> oldPrincipalIds, List<String> newPrincipalIds) {
        MembersDiff membersDiff = this.getMembersDiff(oldPrincipalIds, newPrincipalIds);
        for (String removedPrincipalId : membersDiff.getRemovedPrincipalIds()) {
            this.updateForUserRemovedFromGroup(removedPrincipalId, groupId);
        }
        for (String addedPrincipalId : membersDiff.getAddedPrincipalIds()) {
            this.updateForUserAddedToGroup(addedPrincipalId, groupId);
        }
    }

    @Override
    public void updateForUserAddedToGroup(String principalId, String groupId) {
        if (this.getGroupService().isMemberOfGroup(principalId, groupId)) {
            KewApiServiceLocator.getGroupMembershipChangeQueue().notifyMembershipChange("ADDED", groupId, principalId);
        }
    }

    @Override
    public void updateForUserRemovedFromGroup(String principalId, String groupId) {
        if (!this.getGroupService().isMemberOfGroup(principalId, groupId)) {
            KewApiServiceLocator.getGroupMembershipChangeQueue().notifyMembershipChange("REMOVED", groupId, principalId);
        }
    }

    private MembersDiff getMembersDiff(List<String> oldMemberPrincipalIds, List<String> newMemberPrincipalIds) {
        if (oldMemberPrincipalIds == null) {
            oldMemberPrincipalIds = new ArrayList<String>();
        }
        if (newMemberPrincipalIds == null) {
            newMemberPrincipalIds = new ArrayList<String>();
        }
        HashSet<String> addedPrincipalIds = new HashSet<String>(ListUtils.subtract(newMemberPrincipalIds, oldMemberPrincipalIds));
        HashSet<String> removedPrincipalIds = new HashSet<String>(ListUtils.subtract(oldMemberPrincipalIds, newMemberPrincipalIds));
        return new MembersDiff(addedPrincipalIds, removedPrincipalIds);
    }

    private class MembersDiff {
        private final Set<String> addedPrincipalIds;
        private final Set<String> removedPrincipalIds;

        public MembersDiff(Set<String> addedPrincipalIds, Set<String> removedPrincipalIds) {
            this.addedPrincipalIds = addedPrincipalIds;
            this.removedPrincipalIds = removedPrincipalIds;
        }

        public Set<String> getAddedPrincipalIds() {
            return this.addedPrincipalIds;
        }

        public Set<String> getRemovedPrincipalIds() {
            return this.removedPrincipalIds;
        }
    }
}

