/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.api.identity.EntityUtils;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.citizenship.EntityCitizenship;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityContract;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifier;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.name.EntityNameContract;
import org.kuali.rice.kim.api.identity.personal.EntityEthnicity;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.residency.EntityResidency;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.api.identity.visa.EntityVisa;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationBo;
import org.kuali.rice.kim.impl.identity.citizenship.EntityCitizenshipBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentBo;
import org.kuali.rice.kim.impl.identity.external.EntityExternalIdentifierBo;
import org.kuali.rice.kim.impl.identity.name.EntityNameBo;
import org.kuali.rice.kim.impl.identity.personal.EntityBioDemographicsBo;
import org.kuali.rice.kim.impl.identity.personal.EntityEthnicityBo;
import org.kuali.rice.kim.impl.identity.principal.PrincipalBo;
import org.kuali.rice.kim.impl.identity.privacy.EntityPrivacyPreferencesBo;
import org.kuali.rice.kim.impl.identity.residency.EntityResidencyBo;
import org.kuali.rice.kim.impl.identity.type.EntityTypeContactInfoBo;
import org.kuali.rice.kim.impl.identity.visa.EntityVisaBo;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

@Entity
@Cacheable(value=false)
@Table(name="KRIM_ENTITY_T")
public class EntityBo
extends DataObjectBase
implements EntityContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = -2448541334029932773L;
    @PortableSequenceGenerator(name="KRIM_ENTITY_ID_S")
    @GeneratedValue(generator="KRIM_ENTITY_ID_S")
    @Id
    @Column(name="ENTITY_ID")
    private String id;
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=EntityNameBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="ENTITY_ID", referencedColumnName="ENTITY_ID", insertable=false, updatable=false)
    private List<EntityNameBo> names = new ArrayList<EntityNameBo>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=PrincipalBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="ENTITY_ID", referencedColumnName="ENTITY_ID", insertable=false, updatable=false)
    private List<PrincipalBo> principals = new ArrayList<PrincipalBo>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=EntityExternalIdentifierBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="ENTITY_ID", referencedColumnName="ENTITY_ID", insertable=false, updatable=false)
    private List<EntityExternalIdentifierBo> externalIdentifiers = new ArrayList<EntityExternalIdentifierBo>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=EntityAffiliationBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="ENTITY_ID", referencedColumnName="ENTITY_ID", insertable=false, updatable=false)
    private List<EntityAffiliationBo> affiliations = new ArrayList<EntityAffiliationBo>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=EntityEmploymentBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="ENTITY_ID", referencedColumnName="ENTITY_ID", insertable=false, updatable=false)
    private List<EntityEmploymentBo> employmentInformation = new ArrayList<EntityEmploymentBo>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=EntityTypeContactInfoBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="ENTITY_ID", referencedColumnName="ENTITY_ID", insertable=false, updatable=false)
    private List<EntityTypeContactInfoBo> entityTypeContactInfos = new ArrayList<EntityTypeContactInfoBo>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToOne(targetEntity=EntityPrivacyPreferencesBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @PrimaryKeyJoinColumn(name="ENTITY_ID", referencedColumnName="ENTITY_ID")
    private EntityPrivacyPreferencesBo privacyPreferences;
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToOne(targetEntity=EntityBioDemographicsBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @PrimaryKeyJoinColumn(name="ENTITY_ID", referencedColumnName="ENTITY_ID")
    private EntityBioDemographicsBo bioDemographics;
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=EntityCitizenshipBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="ENTITY_ID", referencedColumnName="ENTITY_ID", insertable=false, updatable=false)
    private List<EntityCitizenshipBo> citizenships = new ArrayList<EntityCitizenshipBo>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=EntityEthnicityBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="ENTITY_ID", referencedColumnName="ENTITY_ID", insertable=false, updatable=false)
    private List<EntityEthnicityBo> ethnicities = new ArrayList<EntityEthnicityBo>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=EntityResidencyBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="ENTITY_ID", referencedColumnName="ENTITY_ID", insertable=false, updatable=false)
    private List<EntityResidencyBo> residencies = new ArrayList<EntityResidencyBo>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=EntityVisaBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="ENTITY_ID", referencedColumnName="ENTITY_ID", insertable=false, updatable=false)
    private List<EntityVisaBo> visas = new ArrayList<EntityVisaBo>();
    @Column(name="ACTV_IND")
    @Convert(converter=BooleanYNConverter.class)
    private boolean active;

    public static org.kuali.rice.kim.api.identity.entity.Entity to(EntityBo bo) {
        if (bo == null) {
            return null;
        }
        return Entity.Builder.create((EntityContract)bo).build();
    }

    public static EntityDefault toDefault(EntityBo bo) {
        if (bo == null) {
            return null;
        }
        return EntityDefault.Builder.create((EntityContract)bo).build();
    }

    public static EntityBo from(org.kuali.rice.kim.api.identity.entity.Entity immutable) {
        return EntityBo.fromAndUpdate(immutable, null);
    }

    public static EntityBo fromAndUpdate(org.kuali.rice.kim.api.identity.entity.Entity immutable, EntityBo toUpdate) {
        String entityId;
        if (immutable == null) {
            return null;
        }
        EntityBo bo = toUpdate;
        if (toUpdate == null) {
            bo = new EntityBo();
        }
        bo._persistence_set_active(immutable.isActive());
        bo._persistence_set_id(immutable.getId());
        if (StringUtils.isBlank((String)bo._persistence_get_id())) {
            DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ENTITY_ID_S");
            entityId = incrementer.nextStringValue();
            bo._persistence_set_id(entityId);
        } else {
            entityId = bo._persistence_get_id();
        }
        bo._persistence_set_names(new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)immutable.getNames())) {
            for (EntityName name : immutable.getNames()) {
                bo._persistence_get_names().add(EntityNameBo.from(name));
            }
            for (EntityNameBo nameBo : bo.getNames()) {
                if (!StringUtils.isBlank((String)nameBo.getEntityId())) continue;
                nameBo.setEntityId(entityId);
            }
        }
        bo._persistence_set_principals(new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)immutable.getPrincipals())) {
            for (Principal principal : immutable.getPrincipals()) {
                bo._persistence_get_principals().add(PrincipalBo.from(principal));
            }
            for (PrincipalBo principalBo : bo.getPrincipals()) {
                if (!StringUtils.isBlank((String)principalBo.getEntityId())) continue;
                principalBo.setEntityId(entityId);
            }
        }
        bo._persistence_set_externalIdentifiers(new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)immutable.getExternalIdentifiers())) {
            for (EntityExternalIdentifier externalId : immutable.getExternalIdentifiers()) {
                bo._persistence_get_externalIdentifiers().add(EntityExternalIdentifierBo.from(externalId));
            }
            for (EntityExternalIdentifierBo EntityExternalIdentifierBo2 : bo.getExternalIdentifiers()) {
                if (!StringUtils.isBlank((String)EntityExternalIdentifierBo2.getEntityId())) continue;
                EntityExternalIdentifierBo2.setEntityId(entityId);
            }
        }
        bo._persistence_set_affiliations(new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)immutable.getAffiliations())) {
            for (EntityAffiliation affiliation : immutable.getAffiliations()) {
                bo._persistence_get_affiliations().add(EntityAffiliationBo.from(affiliation));
            }
            for (EntityAffiliationBo entityAffiliationBo : bo.getAffiliations()) {
                if (!StringUtils.isBlank((String)entityAffiliationBo.getEntityId())) continue;
                entityAffiliationBo.setEntityId(entityId);
            }
        }
        bo._persistence_set_employmentInformation(new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)immutable.getEmploymentInformation())) {
            for (EntityEmployment employment : immutable.getEmploymentInformation()) {
                bo._persistence_get_employmentInformation().add(EntityEmploymentBo.from(employment));
            }
            for (EntityEmploymentBo employmentBo : bo.getEmploymentInformation()) {
                EntityAffiliationBo entityAffiliationBo;
                if (StringUtils.isBlank((String)employmentBo.getEntityId())) {
                    employmentBo.setEntityId(entityId);
                }
                if ((entityAffiliationBo = employmentBo.getEntityAffiliation()) == null || !StringUtils.isBlank((String)employmentBo.getEntityAffiliationId())) continue;
                DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ENTITY_AFLTN_ID_S");
                String affiliationId = incrementer.nextStringValue();
                employmentBo.setEntityAffiliationId(affiliationId);
                entityAffiliationBo.setId(affiliationId);
                if (!StringUtils.isBlank((String)entityAffiliationBo.getEntityId())) continue;
                entityAffiliationBo.setEntityId(entityId);
            }
        }
        bo._persistence_set_entityTypeContactInfos(new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)immutable.getEntityTypeContactInfos())) {
            for (EntityTypeContactInfo entityType : immutable.getEntityTypeContactInfos()) {
                bo._persistence_get_entityTypeContactInfos().add(EntityTypeContactInfoBo.from(entityType));
            }
        }
        if (immutable.getPrivacyPreferences() != null) {
            bo._persistence_set_privacyPreferences(EntityPrivacyPreferencesBo.from(immutable.getPrivacyPreferences()));
        }
        if (immutable.getBioDemographics() != null) {
            bo._persistence_set_bioDemographics(EntityBioDemographicsBo.from(immutable.getBioDemographics()));
        }
        bo._persistence_set_citizenships(new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)immutable.getCitizenships())) {
            for (EntityCitizenship citizenship : immutable.getCitizenships()) {
                bo._persistence_get_citizenships().add(EntityCitizenshipBo.from(citizenship));
            }
            for (EntityCitizenshipBo citizenshipBo : bo.getCitizenships()) {
                if (!StringUtils.isBlank((String)citizenshipBo.getEntityId())) continue;
                citizenshipBo.setEntityId(entityId);
            }
        }
        bo._persistence_set_ethnicities(new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)immutable.getEthnicities())) {
            for (EntityEthnicity ethnicity : immutable.getEthnicities()) {
                bo._persistence_get_ethnicities().add(EntityEthnicityBo.from(ethnicity));
            }
        }
        bo._persistence_set_residencies(new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)immutable.getResidencies())) {
            for (EntityResidency residency : immutable.getResidencies()) {
                bo._persistence_get_residencies().add(EntityResidencyBo.from(residency));
            }
            for (EntityResidencyBo entityResidencyBo : bo.getResidencies()) {
                if (!StringUtils.isBlank((String)entityResidencyBo.getEntityId())) continue;
                entityResidencyBo.setEntityId(entityId);
            }
        }
        bo._persistence_set_visas(new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)immutable.getVisas())) {
            for (EntityVisa visa : immutable.getVisas()) {
                bo._persistence_get_visas().add(EntityVisaBo.from(visa));
            }
            for (EntityVisaBo entityVisaBo : bo.getVisas()) {
                if (!StringUtils.isBlank((String)entityVisaBo.getEntityId())) continue;
                entityVisaBo.setEntityId(entityId);
            }
        }
        bo.setVersionNumber(immutable.getVersionNumber());
        bo.setObjectId(immutable.getObjectId());
        return bo;
    }

    public EntityTypeContactInfoBo getEntityTypeContactInfoByTypeCode(String entityTypeCode) {
        if (CollectionUtils.isEmpty((Collection)this._persistence_get_entityTypeContactInfos())) {
            return null;
        }
        for (EntityTypeContactInfoBo entType : this._persistence_get_entityTypeContactInfos()) {
            if (!entType.getEntityTypeCode().equals(entityTypeCode)) continue;
            return entType;
        }
        return null;
    }

    public EntityEmploymentBo getPrimaryEmployment() {
        if (CollectionUtils.isEmpty((Collection)this._persistence_get_employmentInformation())) {
            return null;
        }
        for (EntityEmploymentBo employment : this._persistence_get_employmentInformation()) {
            if (!employment.isPrimary() || !employment.isActive()) continue;
            return employment;
        }
        return null;
    }

    public EntityAffiliationBo getDefaultAffiliation() {
        return (EntityAffiliationBo)EntityUtils.getDefaultItem((Collection)this._persistence_get_affiliations());
    }

    public EntityExternalIdentifierBo getEntityExternalIdentifier(String externalIdentifierTypeCode) {
        if (CollectionUtils.isEmpty((Collection)this._persistence_get_externalIdentifiers())) {
            return null;
        }
        for (EntityExternalIdentifierBo externalId : this._persistence_get_externalIdentifiers()) {
            if (!externalId.getExternalIdentifierTypeCode().equals(externalIdentifierTypeCode)) continue;
            return externalId;
        }
        return null;
    }

    public EntityNameContract getDefaultName() {
        return (EntityNameContract)EntityUtils.getDefaultItem((Collection)this._persistence_get_names());
    }

    public EntityPrivacyPreferencesBo getPrivacyPreferences() {
        return this._persistence_get_privacyPreferences();
    }

    public EntityBioDemographicsBo getBioDemographics() {
        return this._persistence_get_bioDemographics();
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public List<EntityNameBo> getNames() {
        return this._persistence_get_names();
    }

    public void setNames(List<EntityNameBo> names) {
        this._persistence_set_names(names);
    }

    public List<PrincipalBo> getPrincipals() {
        return this._persistence_get_principals();
    }

    public void setPrincipals(List<PrincipalBo> principals) {
        this._persistence_set_principals(principals);
    }

    public List<EntityExternalIdentifierBo> getExternalIdentifiers() {
        return this._persistence_get_externalIdentifiers();
    }

    public void setExternalIdentifiers(List<EntityExternalIdentifierBo> externalIdentifiers) {
        this._persistence_set_externalIdentifiers(externalIdentifiers);
    }

    public List<EntityAffiliationBo> getAffiliations() {
        return this._persistence_get_affiliations();
    }

    public void setAffiliations(List<EntityAffiliationBo> affiliations) {
        this._persistence_set_affiliations(affiliations);
    }

    public List<EntityEmploymentBo> getEmploymentInformation() {
        return this._persistence_get_employmentInformation();
    }

    public void setEmploymentInformation(List<EntityEmploymentBo> employmentInformation) {
        this._persistence_set_employmentInformation(employmentInformation);
    }

    public List<EntityTypeContactInfoBo> getEntityTypeContactInfos() {
        return this._persistence_get_entityTypeContactInfos();
    }

    public void setEntityTypeContactInfos(List<EntityTypeContactInfoBo> entityTypeContactInfos) {
        this._persistence_set_entityTypeContactInfos(entityTypeContactInfos);
    }

    public void setPrivacyPreferences(EntityPrivacyPreferencesBo privacyPreferences) {
        this._persistence_set_privacyPreferences(privacyPreferences);
    }

    public void setBioDemographics(EntityBioDemographicsBo bioDemographics) {
        this._persistence_set_bioDemographics(bioDemographics);
    }

    public List<EntityCitizenshipBo> getCitizenships() {
        return this._persistence_get_citizenships();
    }

    public void setCitizenships(List<EntityCitizenshipBo> citizenships) {
        this._persistence_set_citizenships(citizenships);
    }

    public List<EntityEthnicityBo> getEthnicities() {
        return this._persistence_get_ethnicities();
    }

    public void setEthnicities(List<EntityEthnicityBo> ethnicities) {
        this._persistence_set_ethnicities(ethnicities);
    }

    public List<EntityResidencyBo> getResidencies() {
        return this._persistence_get_residencies();
    }

    public void setResidencies(List<EntityResidencyBo> residencies) {
        this._persistence_set_residencies(residencies);
    }

    public List<EntityVisaBo> getVisas() {
        return this._persistence_get_visas();
    }

    public void setVisas(List<EntityVisaBo> visas) {
        this._persistence_set_visas(visas);
    }

    public boolean getActive() {
        return this._persistence_get_active();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EntityBo();
    }

    public Object _persistence_get(String string) {
        if (string == "visas") {
            return this.visas;
        }
        if (string == "affiliations") {
            return this.affiliations;
        }
        if (string == "entityTypeContactInfos") {
            return this.entityTypeContactInfos;
        }
        if (string == "ethnicities") {
            return this.ethnicities;
        }
        if (string == "externalIdentifiers") {
            return this.externalIdentifiers;
        }
        if (string == "principals") {
            return this.principals;
        }
        if (string == "privacyPreferences") {
            return this.privacyPreferences;
        }
        if (string == "citizenships") {
            return this.citizenships;
        }
        if (string == "residencies") {
            return this.residencies;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "employmentInformation") {
            return this.employmentInformation;
        }
        if (string == "bioDemographics") {
            return this.bioDemographics;
        }
        if (string == "names") {
            return this.names;
        }
        if (string == "active") {
            return this.active;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "visas") {
            this.visas = (List)object;
            return;
        }
        if (string == "affiliations") {
            this.affiliations = (List)object;
            return;
        }
        if (string == "entityTypeContactInfos") {
            this.entityTypeContactInfos = (List)object;
            return;
        }
        if (string == "ethnicities") {
            this.ethnicities = (List)object;
            return;
        }
        if (string == "externalIdentifiers") {
            this.externalIdentifiers = (List)object;
            return;
        }
        if (string == "principals") {
            this.principals = (List)object;
            return;
        }
        if (string == "privacyPreferences") {
            this.privacyPreferences = (EntityPrivacyPreferencesBo)((Object)object);
            return;
        }
        if (string == "citizenships") {
            this.citizenships = (List)object;
            return;
        }
        if (string == "residencies") {
            this.residencies = (List)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "employmentInformation") {
            this.employmentInformation = (List)object;
            return;
        }
        if (string == "bioDemographics") {
            this.bioDemographics = (EntityBioDemographicsBo)((Object)object);
            return;
        }
        if (string == "names") {
            this.names = (List)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_visas() {
        this._persistence_checkFetched("visas");
        return this.visas;
    }

    public void _persistence_set_visas(List list) {
        this._persistence_checkFetchedForSet("visas");
        this._persistence_propertyChange("visas", this.visas, list);
        this.visas = list;
    }

    public List _persistence_get_affiliations() {
        this._persistence_checkFetched("affiliations");
        return this.affiliations;
    }

    public void _persistence_set_affiliations(List list) {
        this._persistence_checkFetchedForSet("affiliations");
        this._persistence_propertyChange("affiliations", this.affiliations, list);
        this.affiliations = list;
    }

    public List _persistence_get_entityTypeContactInfos() {
        this._persistence_checkFetched("entityTypeContactInfos");
        return this.entityTypeContactInfos;
    }

    public void _persistence_set_entityTypeContactInfos(List list) {
        this._persistence_checkFetchedForSet("entityTypeContactInfos");
        this._persistence_propertyChange("entityTypeContactInfos", this.entityTypeContactInfos, list);
        this.entityTypeContactInfos = list;
    }

    public List _persistence_get_ethnicities() {
        this._persistence_checkFetched("ethnicities");
        return this.ethnicities;
    }

    public void _persistence_set_ethnicities(List list) {
        this._persistence_checkFetchedForSet("ethnicities");
        this._persistence_propertyChange("ethnicities", this.ethnicities, list);
        this.ethnicities = list;
    }

    public List _persistence_get_externalIdentifiers() {
        this._persistence_checkFetched("externalIdentifiers");
        return this.externalIdentifiers;
    }

    public void _persistence_set_externalIdentifiers(List list) {
        this._persistence_checkFetchedForSet("externalIdentifiers");
        this._persistence_propertyChange("externalIdentifiers", this.externalIdentifiers, list);
        this.externalIdentifiers = list;
    }

    public List _persistence_get_principals() {
        this._persistence_checkFetched("principals");
        return this.principals;
    }

    public void _persistence_set_principals(List list) {
        this._persistence_checkFetchedForSet("principals");
        this._persistence_propertyChange("principals", this.principals, list);
        this.principals = list;
    }

    public EntityPrivacyPreferencesBo _persistence_get_privacyPreferences() {
        this._persistence_checkFetched("privacyPreferences");
        return this.privacyPreferences;
    }

    public void _persistence_set_privacyPreferences(EntityPrivacyPreferencesBo entityPrivacyPreferencesBo) {
        this._persistence_checkFetchedForSet("privacyPreferences");
        this._persistence_propertyChange("privacyPreferences", (Object)this.privacyPreferences, (Object)entityPrivacyPreferencesBo);
        this.privacyPreferences = entityPrivacyPreferencesBo;
    }

    public List _persistence_get_citizenships() {
        this._persistence_checkFetched("citizenships");
        return this.citizenships;
    }

    public void _persistence_set_citizenships(List list) {
        this._persistence_checkFetchedForSet("citizenships");
        this._persistence_propertyChange("citizenships", this.citizenships, list);
        this.citizenships = list;
    }

    public List _persistence_get_residencies() {
        this._persistence_checkFetched("residencies");
        return this.residencies;
    }

    public void _persistence_set_residencies(List list) {
        this._persistence_checkFetchedForSet("residencies");
        this._persistence_propertyChange("residencies", this.residencies, list);
        this.residencies = list;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public List _persistence_get_employmentInformation() {
        this._persistence_checkFetched("employmentInformation");
        return this.employmentInformation;
    }

    public void _persistence_set_employmentInformation(List list) {
        this._persistence_checkFetchedForSet("employmentInformation");
        this._persistence_propertyChange("employmentInformation", this.employmentInformation, list);
        this.employmentInformation = list;
    }

    public EntityBioDemographicsBo _persistence_get_bioDemographics() {
        this._persistence_checkFetched("bioDemographics");
        return this.bioDemographics;
    }

    public void _persistence_set_bioDemographics(EntityBioDemographicsBo entityBioDemographicsBo) {
        this._persistence_checkFetchedForSet("bioDemographics");
        this._persistence_propertyChange("bioDemographics", (Object)this.bioDemographics, (Object)entityBioDemographicsBo);
        this.bioDemographics = entityBioDemographicsBo;
    }

    public List _persistence_get_names() {
        this._persistence_checkFetched("names");
        return this.names;
    }

    public void _persistence_set_names(List list) {
        this._persistence_checkFetchedForSet("names");
        this._persistence_propertyChange("names", this.names, list);
        this.names = list;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }
}

