/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity.external;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifier;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierContract;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierType;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.identity.external.EntityExternalIdentifierTypeBo;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="KRIM_ENTITY_EXT_ID_T")
public class EntityExternalIdentifierBo
extends DataObjectBase
implements EntityExternalIdentifierContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final Logger LOG = Logger.getLogger(EntityExternalIdentifierBo.class);
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="ENTITY_EXT_ID_ID")
    @PortableSequenceGenerator(name="KRIM_ENTITY_EXT_ID_ID_S")
    @GeneratedValue(generator="KRIM_ENTITY_EXT_ID_ID_S")
    private String id;
    @Column(name="ENTITY_ID")
    private String entityId;
    @Column(name="EXT_ID_TYP_CD")
    private String externalIdentifierTypeCode;
    @Column(name="EXT_ID")
    private String externalId;
    @JoinFetch(value=JoinFetchType.OUTER)
    @ManyToOne(targetEntity=EntityExternalIdentifierTypeBo.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="EXT_ID_TYP_CD", referencedColumnName="EXT_ID_TYP_CD", insertable=false, updatable=false)
    private EntityExternalIdentifierTypeBo externalIdentifierType;
    @Transient
    private EntityExternalIdentifierType cachedExtIdType = null;
    @Transient
    private boolean encryptionRequired = false;
    @Transient
    private boolean decryptionNeeded = false;

    public static EntityExternalIdentifier to(EntityExternalIdentifierBo bo) {
        if (bo == null) {
            return null;
        }
        return EntityExternalIdentifier.Builder.create((EntityExternalIdentifierContract)bo).build();
    }

    public static EntityExternalIdentifierBo from(EntityExternalIdentifier immutable) {
        if (immutable == null) {
            return null;
        }
        EntityExternalIdentifierBo bo = new EntityExternalIdentifierBo();
        bo._persistence_set_id(immutable.getId());
        bo._persistence_set_externalId(immutable.getExternalId());
        bo._persistence_set_entityId(immutable.getEntityId());
        bo._persistence_set_externalIdentifierTypeCode(immutable.getExternalIdentifierTypeCode());
        bo._persistence_set_externalIdentifierType(immutable.getExternalIdentifierType() != null ? EntityExternalIdentifierTypeBo.from(immutable.getExternalIdentifierType()) : null);
        bo.setVersionNumber(immutable.getVersionNumber());
        bo.setObjectId(immutable.getObjectId());
        return bo;
    }

    @PrePersist
    protected void prePersist() {
        super.prePersist();
        this.encryptExternalId();
    }

    @PreUpdate
    protected void preUpdate() {
        super.preUpdate();
        if (!this.decryptionNeeded) {
            this.encryptExternalId();
        }
    }

    protected void encryptExternalId() {
        this.evaluateExternalIdentifierType();
        if (this.encryptionRequired && StringUtils.isNotEmpty((String)this._persistence_get_externalId())) {
            try {
                if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                    this._persistence_set_externalId(CoreApiServiceLocator.getEncryptionService().encrypt((Object)this._persistence_get_externalId()));
                    this.decryptionNeeded = true;
                }
            }
            catch (Exception e) {
                LOG.info((Object)("Unable to encrypt value : " + e.getMessage() + " or it is already encrypted"));
            }
        }
    }

    protected void decryptExternalId() {
        this.evaluateExternalIdentifierType();
        if (this.encryptionRequired && StringUtils.isNotEmpty((String)this._persistence_get_externalId())) {
            try {
                if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                    this._persistence_set_externalId(CoreApiServiceLocator.getEncryptionService().decrypt(this._persistence_get_externalId()));
                }
            }
            catch (Exception e) {
                LOG.info((Object)("Unable to decrypt value : " + e.getMessage() + " or it is already decrypted"));
            }
        }
    }

    protected void evaluateExternalIdentifierType() {
        if (this.cachedExtIdType == null) {
            this.cachedExtIdType = KimApiServiceLocator.getIdentityService().getExternalIdentifierType(this._persistence_get_externalIdentifierTypeCode());
            this.encryptionRequired = this.cachedExtIdType != null && this.cachedExtIdType.isEncryptionRequired();
        }
    }

    protected String decryptedExternalId() {
        this.evaluateExternalIdentifierType();
        if (this.encryptionRequired && StringUtils.isNotEmpty((String)this._persistence_get_externalId())) {
            try {
                if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                    return CoreApiServiceLocator.getEncryptionService().decrypt(this._persistence_get_externalId());
                }
            }
            catch (Exception e) {
                LOG.info((Object)("Unable to decrypt value : " + e.getMessage() + " or it is already decrypted"));
            }
        }
        return "";
    }

    public void setExternalId(String externalId) {
        this._persistence_set_externalId(externalId);
        this.decryptionNeeded = false;
    }

    public void setExternalIdentifierTypeCode(String externalIdentifierTypeCode) {
        this._persistence_set_externalIdentifierTypeCode(externalIdentifierTypeCode);
        this.cachedExtIdType = null;
    }

    public void setExternalIdentifierType(EntityExternalIdentifierTypeBo externalIdentifierType) {
        this._persistence_set_externalIdentifierType(externalIdentifierType);
        this.cachedExtIdType = null;
    }

    public EntityExternalIdentifierTypeBo getExternalIdentifierType() {
        return this._persistence_get_externalIdentifierType();
    }

    public String getExternalId() {
        if (this.decryptionNeeded) {
            return this.decryptedExternalId();
        }
        return this._persistence_get_externalId();
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public String getEntityId() {
        return this._persistence_get_entityId();
    }

    public void setEntityId(String entityId) {
        this._persistence_set_entityId(entityId);
    }

    public String getExternalIdentifierTypeCode() {
        return this._persistence_get_externalIdentifierTypeCode();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EntityExternalIdentifierBo();
    }

    public Object _persistence_get(String string) {
        if (string == "id") {
            return this.id;
        }
        if (string == "externalIdentifierTypeCode") {
            return this.externalIdentifierTypeCode;
        }
        if (string == "entityId") {
            return this.entityId;
        }
        if (string == "externalId") {
            return this.externalId;
        }
        if (string == "externalIdentifierType") {
            return this.externalIdentifierType;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "externalIdentifierTypeCode") {
            this.externalIdentifierTypeCode = (String)object;
            return;
        }
        if (string == "entityId") {
            this.entityId = (String)object;
            return;
        }
        if (string == "externalId") {
            this.externalId = (String)object;
            return;
        }
        if (string == "externalIdentifierType") {
            this.externalIdentifierType = (EntityExternalIdentifierTypeBo)((Object)object);
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public String _persistence_get_externalIdentifierTypeCode() {
        this._persistence_checkFetched("externalIdentifierTypeCode");
        return this.externalIdentifierTypeCode;
    }

    public void _persistence_set_externalIdentifierTypeCode(String string) {
        this._persistence_checkFetchedForSet("externalIdentifierTypeCode");
        this._persistence_propertyChange("externalIdentifierTypeCode", this.externalIdentifierTypeCode, string);
        this.externalIdentifierTypeCode = string;
    }

    public String _persistence_get_entityId() {
        this._persistence_checkFetched("entityId");
        return this.entityId;
    }

    public void _persistence_set_entityId(String string) {
        this._persistence_checkFetchedForSet("entityId");
        this._persistence_propertyChange("entityId", this.entityId, string);
        this.entityId = string;
    }

    public String _persistence_get_externalId() {
        this._persistence_checkFetched("externalId");
        return this.externalId;
    }

    public void _persistence_set_externalId(String string) {
        this._persistence_checkFetchedForSet("externalId");
        this._persistence_propertyChange("externalId", this.externalId, string);
        this.externalId = string;
    }

    public EntityExternalIdentifierTypeBo _persistence_get_externalIdentifierType() {
        this._persistence_checkFetched("externalIdentifierType");
        return this.externalIdentifierType;
    }

    public void _persistence_set_externalIdentifierType(EntityExternalIdentifierTypeBo entityExternalIdentifierTypeBo) {
        this._persistence_checkFetchedForSet("externalIdentifierType");
        this._persistence_propertyChange("externalIdentifierType", (Object)this.externalIdentifierType, (Object)entityExternalIdentifierTypeBo);
        this.externalIdentifierType = entityExternalIdentifierTypeBo;
    }
}

