/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity.personal;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.api.identity.personal.EntityEthnicity;
import org.kuali.rice.kim.api.identity.personal.EntityEthnicityContract;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="KRIM_ENTITY_ETHNIC_T")
public class EntityEthnicityBo
extends DataObjectBase
implements EntityEthnicityContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @PortableSequenceGenerator(name="KRIM_ENTITY_ETHNIC_ID_S")
    @GeneratedValue(generator="KRIM_ENTITY_ETHNIC_ID_S")
    @Id
    @Column(name="ID")
    private String id;
    @Column(name="ENTITY_ID")
    private String entityId;
    @Column(name="ETHNCTY_CD")
    private String ethnicityCode;
    @Column(name="SUB_ETHNCTY_CD")
    private String subEthnicityCode;
    @Transient
    private boolean suppressPersonal;

    public static EntityEthnicity to(EntityEthnicityBo bo) {
        if (bo == null) {
            return null;
        }
        return EntityEthnicity.Builder.create((EntityEthnicityContract)bo).build();
    }

    public static EntityEthnicityBo from(EntityEthnicity immutable) {
        if (immutable == null) {
            return null;
        }
        EntityEthnicityBo bo = new EntityEthnicityBo();
        bo._persistence_set_entityId(immutable.getEntityId());
        bo._persistence_set_id(immutable.getId());
        bo._persistence_set_ethnicityCode(immutable.getEthnicityCodeUnmasked());
        bo._persistence_set_subEthnicityCode(immutable.getSubEthnicityCodeUnmasked());
        bo.setVersionNumber(immutable.getVersionNumber());
        bo.setObjectId(immutable.getObjectId());
        return bo;
    }

    public boolean isSuppressPersonal() {
        try {
            EntityPrivacyPreferences privacy = KimApiServiceLocator.getIdentityService().getEntityPrivacyPreferences(this.getEntityId());
            this.suppressPersonal = privacy != null ? privacy.isSuppressPersonal() : false;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException c) {
            return false;
        }
        return this.suppressPersonal;
    }

    public String getEthnicityCode() {
        if (this.isSuppressPersonal()) {
            return "Xxxxxx";
        }
        return this._persistence_get_ethnicityCode();
    }

    public String getSubEthnicityCode() {
        if (this.isSuppressPersonal()) {
            return "Xxxxxx";
        }
        return this._persistence_get_subEthnicityCode();
    }

    public String getEthnicityCodeUnmasked() {
        return this._persistence_get_ethnicityCode();
    }

    public String getSubEthnicityCodeUnmasked() {
        return this._persistence_get_subEthnicityCode();
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public String getEntityId() {
        return this._persistence_get_entityId();
    }

    public void setEntityId(String entityId) {
        this._persistence_set_entityId(entityId);
    }

    public void setEthnicityCode(String ethnicityCode) {
        this._persistence_set_ethnicityCode(ethnicityCode);
    }

    public void setSubEthnicityCode(String subEthnicityCode) {
        this._persistence_set_subEthnicityCode(subEthnicityCode);
    }

    public boolean getSuppressPersonal() {
        return this.suppressPersonal;
    }

    public void setSuppressPersonal(boolean suppressPersonal) {
        this.suppressPersonal = suppressPersonal;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EntityEthnicityBo();
    }

    public Object _persistence_get(String string) {
        if (string == "id") {
            return this.id;
        }
        if (string == "ethnicityCode") {
            return this.ethnicityCode;
        }
        if (string == "entityId") {
            return this.entityId;
        }
        if (string == "subEthnicityCode") {
            return this.subEthnicityCode;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "ethnicityCode") {
            this.ethnicityCode = (String)object;
            return;
        }
        if (string == "entityId") {
            this.entityId = (String)object;
            return;
        }
        if (string == "subEthnicityCode") {
            this.subEthnicityCode = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public String _persistence_get_ethnicityCode() {
        this._persistence_checkFetched("ethnicityCode");
        return this.ethnicityCode;
    }

    public void _persistence_set_ethnicityCode(String string) {
        this._persistence_checkFetchedForSet("ethnicityCode");
        this._persistence_propertyChange("ethnicityCode", this.ethnicityCode, string);
        this.ethnicityCode = string;
    }

    public String _persistence_get_entityId() {
        this._persistence_checkFetched("entityId");
        return this.entityId;
    }

    public void _persistence_set_entityId(String string) {
        this._persistence_checkFetchedForSet("entityId");
        this._persistence_propertyChange("entityId", this.entityId, string);
        this.entityId = string;
    }

    public String _persistence_get_subEthnicityCode() {
        this._persistence_checkFetched("subEthnicityCode");
        return this.subEthnicityCode;
    }

    public void _persistence_set_subEthnicityCode(String string) {
        this._persistence_checkFetchedForSet("subEthnicityCode");
        this._persistence_propertyChange("subEthnicityCode", this.subEthnicityCode, string);
        this.subEthnicityCode = string;
    }
}

