/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity.phone;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.api.identity.phone.EntityPhone;
import org.kuali.rice.kim.api.identity.phone.EntityPhoneContract;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@MappedSuperclass
public abstract class EntityPhoneBase
extends DataObjectBase
implements EntityPhoneContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="ENTITY_ID")
    private String entityId;
    @Column(name="ENT_TYP_CD")
    private String entityTypeCode;
    @Column(name="PHONE_TYP_CD")
    private String phoneTypeCode;
    @Column(name="PHONE_NBR")
    private String phoneNumber;
    @Column(name="PHONE_EXTN_NBR")
    private String extensionNumber;
    @Column(name="POSTAL_CNTRY_CD")
    private String countryCode;
    @Transient
    private boolean suppressPhone;
    @Convert(converter=BooleanYNConverter.class)
    @Column(name="ACTV_IND")
    private boolean active;
    @Convert(converter=BooleanYNConverter.class)
    @Column(name="DFLT_IND")
    private boolean defaultValue;
    private static final long serialVersionUID = 1L;

    public EntityPhoneBase() {
    }

    public String getPhoneTypeCode() {
        return this._persistence_get_phoneTypeCode();
    }

    public static EntityPhone to(EntityPhoneBase bo) {
        if (bo == null) {
            return null;
        }
        return EntityPhone.Builder.create((EntityPhoneContract)bo).build();
    }

    public boolean isSuppressPhone() {
        try {
            EntityPrivacyPreferences privacy = KimApiServiceLocator.getIdentityService().getEntityPrivacyPreferences(this.getEntityId());
            this.suppressPhone = privacy != null ? privacy.isSuppressPhone() : false;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException c) {
            return false;
        }
        return this.suppressPhone;
    }

    public String getFormattedPhoneNumber() {
        if (this.isSuppressPhone()) {
            return "Xxxxxx";
        }
        return this.getFormattedPhoneNumberUnmasked();
    }

    public String getPhoneNumberUnmasked() {
        return this._persistence_get_phoneNumber();
    }

    public String getExtensionNumberUnmasked() {
        return this._persistence_get_extensionNumber();
    }

    public String getCountryCodeUnmasked() {
        return this._persistence_get_countryCode();
    }

    public String getFormattedPhoneNumberUnmasked() {
        StringBuffer sb = new StringBuffer(30);
        sb.append(this._persistence_get_phoneNumber());
        if (StringUtils.isNotBlank((String)this._persistence_get_extensionNumber())) {
            sb.append(" x");
            sb.append(this._persistence_get_extensionNumber());
        }
        return sb.toString();
    }

    public String getPhoneNumber() {
        if (this.isSuppressPhone()) {
            return "000-000-0000";
        }
        return this._persistence_get_phoneNumber();
    }

    public String getCountryCode() {
        if (this.isSuppressPhone()) {
            return "XX";
        }
        return this._persistence_get_countryCode();
    }

    public String getExtensionNumber() {
        if (this.isSuppressPhone()) {
            return "Xxxxxx";
        }
        return this._persistence_get_extensionNumber();
    }

    public String getEntityId() {
        return this._persistence_get_entityId();
    }

    public void setEntityId(String entityId) {
        this._persistence_set_entityId(entityId);
    }

    public String getEntityTypeCode() {
        return this._persistence_get_entityTypeCode();
    }

    public void setEntityTypeCode(String entityTypeCode) {
        this._persistence_set_entityTypeCode(entityTypeCode);
    }

    public void setPhoneTypeCode(String phoneTypeCode) {
        this._persistence_set_phoneTypeCode(phoneTypeCode);
    }

    public void setPhoneNumber(String phoneNumber) {
        this._persistence_set_phoneNumber(phoneNumber);
    }

    public void setExtensionNumber(String extensionNumber) {
        this._persistence_set_extensionNumber(extensionNumber);
    }

    public void setCountryCode(String countryCode) {
        this._persistence_set_countryCode(countryCode);
    }

    public boolean getSuppressPhone() {
        return this.suppressPhone;
    }

    public void setSuppressPhone(boolean suppressPhone) {
        this.suppressPhone = suppressPhone;
    }

    public boolean getActive() {
        return this._persistence_get_active();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public boolean getDefaultValue() {
        return this._persistence_get_defaultValue();
    }

    public boolean isDefaultValue() {
        return this._persistence_get_defaultValue();
    }

    public void setDefaultValue(boolean defaultValue) {
        this._persistence_set_defaultValue(defaultValue);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EntityPhoneBase(persistenceObject);
    }

    public EntityPhoneBase(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "phoneNumber") {
            return this.phoneNumber;
        }
        if (string == "entityTypeCode") {
            return this.entityTypeCode;
        }
        if (string == "countryCode") {
            return this.countryCode;
        }
        if (string == "entityId") {
            return this.entityId;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "defaultValue") {
            return this.defaultValue;
        }
        if (string == "extensionNumber") {
            return this.extensionNumber;
        }
        if (string == "phoneTypeCode") {
            return this.phoneTypeCode;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "phoneNumber") {
            this.phoneNumber = (String)object;
            return;
        }
        if (string == "entityTypeCode") {
            this.entityTypeCode = (String)object;
            return;
        }
        if (string == "countryCode") {
            this.countryCode = (String)object;
            return;
        }
        if (string == "entityId") {
            this.entityId = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "defaultValue") {
            this.defaultValue = (Boolean)object;
            return;
        }
        if (string == "extensionNumber") {
            this.extensionNumber = (String)object;
            return;
        }
        if (string == "phoneTypeCode") {
            this.phoneTypeCode = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_phoneNumber() {
        this._persistence_checkFetched("phoneNumber");
        return this.phoneNumber;
    }

    public void _persistence_set_phoneNumber(String string) {
        this._persistence_checkFetchedForSet("phoneNumber");
        this._persistence_propertyChange("phoneNumber", this.phoneNumber, string);
        this.phoneNumber = string;
    }

    public String _persistence_get_entityTypeCode() {
        this._persistence_checkFetched("entityTypeCode");
        return this.entityTypeCode;
    }

    public void _persistence_set_entityTypeCode(String string) {
        this._persistence_checkFetchedForSet("entityTypeCode");
        this._persistence_propertyChange("entityTypeCode", this.entityTypeCode, string);
        this.entityTypeCode = string;
    }

    public String _persistence_get_countryCode() {
        this._persistence_checkFetched("countryCode");
        return this.countryCode;
    }

    public void _persistence_set_countryCode(String string) {
        this._persistence_checkFetchedForSet("countryCode");
        this._persistence_propertyChange("countryCode", this.countryCode, string);
        this.countryCode = string;
    }

    public String _persistence_get_entityId() {
        this._persistence_checkFetched("entityId");
        return this.entityId;
    }

    public void _persistence_set_entityId(String string) {
        this._persistence_checkFetchedForSet("entityId");
        this._persistence_propertyChange("entityId", this.entityId, string);
        this.entityId = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public boolean _persistence_get_defaultValue() {
        this._persistence_checkFetched("defaultValue");
        return this.defaultValue;
    }

    public void _persistence_set_defaultValue(boolean bl) {
        this._persistence_checkFetchedForSet("defaultValue");
        this._persistence_propertyChange("defaultValue", new Boolean(this.defaultValue), new Boolean(bl));
        this.defaultValue = bl;
    }

    public String _persistence_get_extensionNumber() {
        this._persistence_checkFetched("extensionNumber");
        return this.extensionNumber;
    }

    public void _persistence_set_extensionNumber(String string) {
        this._persistence_checkFetchedForSet("extensionNumber");
        this._persistence_propertyChange("extensionNumber", this.extensionNumber, string);
        this.extensionNumber = string;
    }

    public String _persistence_get_phoneTypeCode() {
        this._persistence_checkFetched("phoneTypeCode");
        return this.phoneTypeCode;
    }

    public void _persistence_set_phoneTypeCode(String string) {
        this._persistence_checkFetchedForSet("phoneTypeCode");
        this._persistence_propertyChange("phoneTypeCode", this.phoneTypeCode, string);
        this.phoneTypeCode = string;
    }
}

