/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.api.identity.EntityUtils;
import org.kuali.rice.kim.api.identity.address.EntityAddress;
import org.kuali.rice.kim.api.identity.email.EntityEmail;
import org.kuali.rice.kim.api.identity.phone.EntityPhone;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfoContract;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfoDefault;
import org.kuali.rice.kim.impl.identity.EntityTypeBo;
import org.kuali.rice.kim.impl.identity.address.EntityAddressBo;
import org.kuali.rice.kim.impl.identity.email.EntityEmailBo;
import org.kuali.rice.kim.impl.identity.phone.EntityPhoneBo;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.IdClassBase;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="KRIM_ENTITY_ENT_TYP_T")
@IdClass(value=EntityTypeContactInfoBoId.class)
public class EntityTypeContactInfoBo
extends DataObjectBase
implements EntityTypeContactInfoContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="ENTITY_ID")
    private String entityId;
    @Id
    @Column(name="ENT_TYP_CD")
    private String entityTypeCode;
    @JoinFetch(value=JoinFetchType.INNER)
    @ManyToOne(targetEntity=EntityTypeBo.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="ENT_TYP_CD", referencedColumnName="ENT_TYP_CD", insertable=false, updatable=false)
    private EntityTypeBo entityType;
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=EntityEmailBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="ENTITY_ID", referencedColumnName="ENTITY_ID", insertable=false, updatable=false), @JoinColumn(name="ENT_TYP_CD", referencedColumnName="ENT_TYP_CD", insertable=false, updatable=false)})
    private List<EntityEmailBo> emailAddresses;
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=EntityPhoneBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="ENTITY_ID", referencedColumnName="ENTITY_ID", insertable=false, updatable=false), @JoinColumn(name="ENT_TYP_CD", referencedColumnName="ENT_TYP_CD", insertable=false, updatable=false)})
    private List<EntityPhoneBo> phoneNumbers;
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=EntityAddressBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="ENTITY_ID", referencedColumnName="ENTITY_ID", insertable=false, updatable=false), @JoinColumn(name="ENT_TYP_CD", referencedColumnName="ENT_TYP_CD", insertable=false, updatable=false)})
    private List<EntityAddressBo> addresses;
    @Column(name="ACTV_IND")
    @Convert(converter=BooleanYNConverter.class)
    private boolean active;

    public static EntityTypeContactInfo to(EntityTypeContactInfoBo bo) {
        if (bo == null) {
            return null;
        }
        return EntityTypeContactInfo.Builder.create((EntityTypeContactInfoContract)bo).build();
    }

    public static EntityTypeContactInfoDefault toDefault(EntityTypeContactInfoBo bo) {
        if (bo == null) {
            return null;
        }
        return new EntityTypeContactInfoDefault(bo.getEntityTypeCode(), EntityAddressBo.to(bo.getDefaultAddress()), EntityEmailBo.to(bo.getDefaultEmailAddress()), EntityPhoneBo.to(bo.getDefaultPhoneNumber()));
    }

    public static EntityTypeContactInfoBo from(EntityTypeContactInfo immutable) {
        if (immutable == null) {
            return null;
        }
        EntityTypeContactInfoBo bo = new EntityTypeContactInfoBo();
        bo._persistence_set_active(immutable.isActive());
        bo._persistence_set_entityId(immutable.getEntityId());
        bo._persistence_set_entityTypeCode(immutable.getEntityTypeCode());
        bo._persistence_set_addresses(new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)immutable.getAddresses())) {
            for (EntityAddress address : immutable.getAddresses()) {
                bo._persistence_get_addresses().add(EntityAddressBo.from(address));
            }
        }
        bo._persistence_set_phoneNumbers(new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)immutable.getPhoneNumbers())) {
            for (EntityPhone phone : immutable.getPhoneNumbers()) {
                bo._persistence_get_phoneNumbers().add(EntityPhoneBo.from(phone));
            }
        }
        bo._persistence_set_emailAddresses(new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)immutable.getEmailAddresses())) {
            for (EntityEmail email : immutable.getEmailAddresses()) {
                bo._persistence_get_emailAddresses().add(EntityEmailBo.from(email));
            }
        }
        bo.setVersionNumber(immutable.getVersionNumber());
        bo.setObjectId(immutable.getObjectId());
        return bo;
    }

    public EntityAddressBo getDefaultAddress() {
        return (EntityAddressBo)EntityUtils.getDefaultItem((Collection)this._persistence_get_addresses());
    }

    public EntityEmailBo getDefaultEmailAddress() {
        return (EntityEmailBo)EntityUtils.getDefaultItem((Collection)this._persistence_get_emailAddresses());
    }

    public EntityPhoneBo getDefaultPhoneNumber() {
        return (EntityPhoneBo)EntityUtils.getDefaultItem((Collection)this._persistence_get_phoneNumbers());
    }

    public EntityTypeBo getEntityType() {
        return this._persistence_get_entityType();
    }

    public String getEntityId() {
        return this._persistence_get_entityId();
    }

    public void setEntityId(String entityId) {
        this._persistence_set_entityId(entityId);
    }

    public String getEntityTypeCode() {
        return this._persistence_get_entityTypeCode();
    }

    public void setEntityTypeCode(String entityTypeCode) {
        this._persistence_set_entityTypeCode(entityTypeCode);
    }

    public void setEntityType(EntityTypeBo entityType) {
        this._persistence_set_entityType(entityType);
    }

    public List<EntityEmailBo> getEmailAddresses() {
        return this._persistence_get_emailAddresses();
    }

    public void setEmailAddresses(List<EntityEmailBo> emailAddresses) {
        this._persistence_set_emailAddresses(emailAddresses);
    }

    public List<EntityPhoneBo> getPhoneNumbers() {
        return this._persistence_get_phoneNumbers();
    }

    public void setPhoneNumbers(List<EntityPhoneBo> phoneNumbers) {
        this._persistence_set_phoneNumbers(phoneNumbers);
    }

    public List<EntityAddressBo> getAddresses() {
        return this._persistence_get_addresses();
    }

    public void setAddresses(List<EntityAddressBo> addresses) {
        this._persistence_set_addresses(addresses);
    }

    public boolean getActive() {
        return this._persistence_get_active();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EntityTypeContactInfoBo();
    }

    public Object _persistence_get(String string) {
        if (string == "entityTypeCode") {
            return this.entityTypeCode;
        }
        if (string == "entityId") {
            return this.entityId;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "phoneNumbers") {
            return this.phoneNumbers;
        }
        if (string == "addresses") {
            return this.addresses;
        }
        if (string == "entityType") {
            return this.entityType;
        }
        if (string == "emailAddresses") {
            return this.emailAddresses;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "entityTypeCode") {
            this.entityTypeCode = (String)object;
            return;
        }
        if (string == "entityId") {
            this.entityId = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "phoneNumbers") {
            this.phoneNumbers = (List)object;
            return;
        }
        if (string == "addresses") {
            this.addresses = (List)object;
            return;
        }
        if (string == "entityType") {
            this.entityType = (EntityTypeBo)((Object)object);
            return;
        }
        if (string == "emailAddresses") {
            this.emailAddresses = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_entityTypeCode() {
        this._persistence_checkFetched("entityTypeCode");
        return this.entityTypeCode;
    }

    public void _persistence_set_entityTypeCode(String string) {
        this._persistence_checkFetchedForSet("entityTypeCode");
        this._persistence_propertyChange("entityTypeCode", this.entityTypeCode, string);
        this.entityTypeCode = string;
    }

    public String _persistence_get_entityId() {
        this._persistence_checkFetched("entityId");
        return this.entityId;
    }

    public void _persistence_set_entityId(String string) {
        this._persistence_checkFetchedForSet("entityId");
        this._persistence_propertyChange("entityId", this.entityId, string);
        this.entityId = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public List _persistence_get_phoneNumbers() {
        this._persistence_checkFetched("phoneNumbers");
        return this.phoneNumbers;
    }

    public void _persistence_set_phoneNumbers(List list) {
        this._persistence_checkFetchedForSet("phoneNumbers");
        this._persistence_propertyChange("phoneNumbers", this.phoneNumbers, list);
        this.phoneNumbers = list;
    }

    public List _persistence_get_addresses() {
        this._persistence_checkFetched("addresses");
        return this.addresses;
    }

    public void _persistence_set_addresses(List list) {
        this._persistence_checkFetchedForSet("addresses");
        this._persistence_propertyChange("addresses", this.addresses, list);
        this.addresses = list;
    }

    public EntityTypeBo _persistence_get_entityType() {
        this._persistence_checkFetched("entityType");
        return this.entityType;
    }

    public void _persistence_set_entityType(EntityTypeBo entityTypeBo) {
        this._persistence_checkFetchedForSet("entityType");
        this._persistence_propertyChange("entityType", (Object)this.entityType, (Object)entityTypeBo);
        this.entityType = entityTypeBo;
    }

    public List _persistence_get_emailAddresses() {
        this._persistence_checkFetched("emailAddresses");
        return this.emailAddresses;
    }

    public void _persistence_set_emailAddresses(List list) {
        this._persistence_checkFetchedForSet("emailAddresses");
        this._persistence_propertyChange("emailAddresses", this.emailAddresses, list);
        this.emailAddresses = list;
    }

    public static class EntityTypeContactInfoBoId
    extends IdClassBase
    implements Comparable<EntityTypeContactInfoBoId> {
        private static final long serialVersionUID = -6087504648008003050L;
        private String entityId;
        private String entityTypeCode;

        public EntityTypeContactInfoBoId() {
        }

        public EntityTypeContactInfoBoId(String entityId, String entityTypeCode) {
            this.entityId = entityId;
            this.entityTypeCode = entityTypeCode;
        }

        public String getEntityId() {
            return this.entityId;
        }

        public String getEntityTypeCode() {
            return this.entityTypeCode;
        }

        @Override
        public int compareTo(EntityTypeContactInfoBoId other) {
            return new CompareToBuilder().append((Object)this.entityId, (Object)other.entityId).append((Object)this.entityTypeCode, (Object)other.entityTypeCode).toComparison();
        }
    }
}

