/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.permission;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.impl.permission.PermissionAttributeBo;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kim.impl.permission.PermissionTemplateBo;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="KRIM_PERM_T")
public class GenericPermissionBo
extends PersistableBusinessObjectBase
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="PERM_ID")
    protected String id;
    @Column(name="NMSPC_CD")
    protected String namespaceCode;
    @Column(name="NM")
    protected String name;
    @Column(name="DESC_TXT")
    protected String description;
    @Column(name="ACTV_IND")
    @Convert(converter=BooleanYNConverter.class)
    protected boolean active;
    @Column(name="PERM_TMPL_ID")
    protected String templateId;
    protected String detailValues;
    protected Map<String, String> details;
    protected PermissionTemplateBo template = new PermissionTemplateBo();
    protected List<PermissionAttributeBo> attributeDetails;

    public GenericPermissionBo() {
    }

    public GenericPermissionBo(PermissionBo perm) {
        this.loadFromPermission(perm);
    }

    public void loadFromPermission(PermissionBo perm) {
        this.setId(perm.getId());
        this.setNamespaceCode(perm.getNamespaceCode());
        this.setTemplate(perm.getTemplate());
        this.setAttributeDetails(perm.getAttributeDetails());
        this.setDetailValues(perm.getDetailObjectsValues());
        this.setName(perm.getName());
        this.setTemplateId(perm.getTemplateId());
        this.setDescription(perm.getDescription());
        this.setActive(perm.isActive());
        this.setDetails(perm.getAttributes());
        this.setVersionNumber(perm.getVersionNumber());
        this.setObjectId(perm.getObjectId());
    }

    public String getDetailValues() {
        return this._persistence_get_detailValues();
    }

    public void setDetailValues(String detailValues) {
        this._persistence_set_detailValues(detailValues);
    }

    public void setDetailValues(Map<String, String> detailsAttribs) {
        StringBuffer sb = new StringBuffer();
        if (detailsAttribs != null) {
            Iterator<String> keyIter = detailsAttribs.keySet().iterator();
            while (keyIter.hasNext()) {
                String key = keyIter.next();
                sb.append(key).append('=').append(detailsAttribs.get(key));
                if (!keyIter.hasNext()) continue;
                sb.append('\n');
            }
        }
        this._persistence_set_detailValues(sb.toString());
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public PermissionTemplateBo getTemplate() {
        return this._persistence_get_template();
    }

    public void setDescription(String permissionDescription) {
        this._persistence_set_description(permissionDescription);
    }

    public void setName(String permissionName) {
        this._persistence_set_name(permissionName);
    }

    public void setDetails(Map<String, String> details) {
        this._persistence_set_details(details);
        this.setDetailValues(details);
    }

    public String getTemplateId() {
        return this._persistence_get_templateId();
    }

    public void setTemplateId(String templateId) {
        this._persistence_set_templateId(templateId);
    }

    public void setTemplate(PermissionTemplateBo template) {
        this._persistence_set_template(template);
    }

    public Map<String, String> getDetails() {
        String detailValuesTemp = this._persistence_get_detailValues();
        HashMap<String, String> detailsTemp = new HashMap<String, String>();
        if (detailValuesTemp != null) {
            detailValuesTemp = detailValuesTemp.replace("\r\n", "\n");
            if (StringUtils.isNotBlank((String)(detailValuesTemp = detailValuesTemp.replace('\r', '\n')))) {
                String[] values;
                for (String attrib : values = detailValuesTemp.split("\n")) {
                    if (attrib.indexOf(61) == -1) continue;
                    String[] keyValueArray = attrib.split("=", 2);
                    detailsTemp.put(keyValueArray[0].trim(), keyValueArray[1].trim());
                }
            }
        }
        this._persistence_set_details(detailsTemp);
        return this._persistence_get_details();
    }

    public String getNamespaceCode() {
        return this._persistence_get_namespaceCode();
    }

    public void setNamespaceCode(String namespaceCode) {
        this._persistence_set_namespaceCode(namespaceCode);
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public List<PermissionAttributeBo> getAttributeDetails() {
        return this._persistence_get_attributeDetails();
    }

    public void setAttributeDetails(List<PermissionAttributeBo> attributeDetails) {
        this._persistence_set_attributeDetails(attributeDetails);
    }

    public void refreshNonUpdateableReferences() {
    }

    public void refreshReferenceObject(String referenceObjectName) {
    }

    protected void prePersist() {
        throw new UnsupportedOperationException("This object should never be persisted.");
    }

    protected void preUpdate() {
        throw new UnsupportedOperationException("This object should never be persisted.");
    }

    protected void preRemove() {
        throw new UnsupportedOperationException("This object should never be persisted.");
    }

    public static PermissionBo toPermissionBo(GenericPermissionBo bo) {
        PermissionBo permission = new PermissionBo();
        permission.setTemplateId(bo.getTemplateId());
        permission.setId(bo.getId());
        permission.setTemplate(bo.getTemplate());
        permission.setActive(bo.isActive());
        permission.setDescription(bo.getDescription());
        permission.setName(bo.getName());
        permission.setNamespaceCode(bo._persistence_get_namespaceCode());
        permission.setAttributeDetails(bo.getAttributeDetails());
        permission.setAttributes(bo.getDetails());
        permission.setVersionNumber(bo._persistence_get_versionNumber());
        permission.setObjectId(bo.getObjectId());
        return permission;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new GenericPermissionBo();
    }

    public Object _persistence_get(String string) {
        if (string == "template") {
            return this.template;
        }
        if (string == "templateId") {
            return this.templateId;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "details") {
            return this.details;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "attributeDetails") {
            return this.attributeDetails;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "namespaceCode") {
            return this.namespaceCode;
        }
        if (string == "detailValues") {
            return this.detailValues;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "template") {
            this.template = (PermissionTemplateBo)((Object)object);
            return;
        }
        if (string == "templateId") {
            this.templateId = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "details") {
            this.details = (Map)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "attributeDetails") {
            this.attributeDetails = (List)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "namespaceCode") {
            this.namespaceCode = (String)object;
            return;
        }
        if (string == "detailValues") {
            this.detailValues = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public PermissionTemplateBo _persistence_get_template() {
        this._persistence_checkFetched("template");
        return this.template;
    }

    public void _persistence_set_template(PermissionTemplateBo permissionTemplateBo) {
        this._persistence_checkFetchedForSet("template");
        this._persistence_propertyChange("template", (Object)this.template, (Object)permissionTemplateBo);
        this.template = permissionTemplateBo;
    }

    public String _persistence_get_templateId() {
        this._persistence_checkFetched("templateId");
        return this.templateId;
    }

    public void _persistence_set_templateId(String string) {
        this._persistence_checkFetchedForSet("templateId");
        this._persistence_propertyChange("templateId", this.templateId, string);
        this.templateId = string;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public Map _persistence_get_details() {
        this._persistence_checkFetched("details");
        return this.details;
    }

    public void _persistence_set_details(Map map) {
        this._persistence_checkFetchedForSet("details");
        this._persistence_propertyChange("details", this.details, map);
        this.details = map;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    public List _persistence_get_attributeDetails() {
        this._persistence_checkFetched("attributeDetails");
        return this.attributeDetails;
    }

    public void _persistence_set_attributeDetails(List list) {
        this._persistence_checkFetchedForSet("attributeDetails");
        this._persistence_propertyChange("attributeDetails", this.attributeDetails, list);
        this.attributeDetails = list;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_namespaceCode() {
        this._persistence_checkFetched("namespaceCode");
        return this.namespaceCode;
    }

    public void _persistence_set_namespaceCode(String string) {
        this._persistence_checkFetchedForSet("namespaceCode");
        this._persistence_propertyChange("namespaceCode", this.namespaceCode, string);
        this.namespaceCode = string;
    }

    public String _persistence_get_detailValues() {
        this._persistence_checkFetched("detailValues");
        return this.detailValues;
    }

    public void _persistence_set_detailValues(String string) {
        this._persistence_checkFetchedForSet("detailValues");
        this._persistence_propertyChange("detailValues", this.detailValues, string);
        this.detailValues = string;
    }
}

