/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.responsibility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.common.delegate.DelegateType;
import org.kuali.rice.kim.api.common.delegate.DelegateTypeContract;
import org.kuali.rice.kim.api.common.template.Template;
import org.kuali.rice.kim.api.common.template.TemplateContract;
import org.kuali.rice.kim.api.common.template.TemplateQueryResults;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.api.responsibility.ResponsibilityAction;
import org.kuali.rice.kim.api.responsibility.ResponsibilityContract;
import org.kuali.rice.kim.api.responsibility.ResponsibilityQueryResults;
import org.kuali.rice.kim.api.responsibility.ResponsibilityService;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleResponsibilityAction;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.framework.responsibility.ResponsibilityTypeService;
import org.kuali.rice.kim.impl.common.attribute.AttributeTransform;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityAttributeBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityTemplateBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityActionBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityBo;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.util.CollectionUtils;

public class ResponsibilityServiceImpl
implements ResponsibilityService {
    private static final Integer DEFAULT_PRIORITY_NUMBER = 1;
    private static final Log LOG = LogFactory.getLog(ResponsibilityServiceImpl.class);
    private ResponsibilityTypeService defaultResponsibilityTypeService;
    private KimTypeInfoService kimTypeInfoService;
    private RoleService roleService;
    private DataObjectService dataObjectService;

    public Responsibility createResponsibility(Responsibility responsibility) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(responsibility, "responsibility");
        if (StringUtils.isNotBlank((String)responsibility.getId()) && this.getResponsibility(responsibility.getId()) != null) {
            throw new RiceIllegalStateException("the responsibility to create already exists: " + responsibility);
        }
        List<ResponsibilityAttributeBo> attrBos = Collections.emptyList();
        if (responsibility.getTemplate() != null) {
            attrBos = KimAttributeDataBo.createFrom(ResponsibilityAttributeBo.class, responsibility.getAttributes(), responsibility.getTemplate().getKimTypeId());
        }
        ResponsibilityBo bo = ResponsibilityBo.from(responsibility);
        bo.setAttributeDetails(attrBos);
        return ResponsibilityBo.to((ResponsibilityContract)this.getDataObjectService().save((Object)bo, new PersistenceOption[0]));
    }

    public Responsibility updateResponsibility(Responsibility responsibility) throws RiceIllegalArgumentException, RiceIllegalStateException {
        ResponsibilityBo bo;
        this.incomingParamCheck(responsibility, "responsibility");
        if (StringUtils.isBlank((String)responsibility.getId()) || this.getResponsibility(responsibility.getId()) == null) {
            throw new RiceIllegalStateException("the responsibility does not exist: " + responsibility);
        }
        List<ResponsibilityAttributeBo> attrBos = Collections.emptyList();
        if (responsibility.getTemplate() != null) {
            attrBos = KimAttributeDataBo.createFrom(ResponsibilityAttributeBo.class, responsibility.getAttributes(), responsibility.getTemplate().getKimTypeId());
        }
        if ((bo = ResponsibilityBo.from(responsibility)).getAttributeDetails() != null) {
            bo.getAttributeDetails().clear();
            bo.setAttributeDetails(attrBos);
        }
        return ResponsibilityBo.to((ResponsibilityContract)this.getDataObjectService().save((Object)bo, new PersistenceOption[0]));
    }

    public Responsibility getResponsibility(String id) throws RiceIllegalArgumentException {
        this.incomingParamCheck(id, "id");
        return ResponsibilityBo.to((ResponsibilityContract)this.getDataObjectService().find(ResponsibilityBo.class, (Object)id));
    }

    public Responsibility findRespByNamespaceCodeAndName(String namespaceCode, String name) throws RiceIllegalArgumentException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(name, "name");
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("namespaceCode", namespaceCode);
        criteria.put("name", name);
        criteria.put("active", Boolean.TRUE);
        QueryResults bos = this.getDataObjectService().findMatching(ResponsibilityBo.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        if (bos != null && bos.getResults() != null) {
            if (bos.getResults().size() > 1) {
                throw new RiceIllegalStateException("more than one Responsibility found with namespace code: " + namespaceCode + " and name: " + name);
            }
            Iterator i = bos.getResults().iterator();
            return i.hasNext() ? ResponsibilityBo.to((ResponsibilityContract)i.next()) : null;
        }
        return null;
    }

    public Template getResponsibilityTemplate(String id) throws RiceIllegalArgumentException {
        this.incomingParamCheck(id, "id");
        return ResponsibilityTemplateBo.to((TemplateContract)this.getDataObjectService().find(ResponsibilityTemplateBo.class, (Object)id));
    }

    public Template findRespTemplateByNamespaceCodeAndName(String namespaceCode, String name) throws RiceIllegalArgumentException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(name, "name");
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("namespaceCode", namespaceCode);
        criteria.put("name", name);
        criteria.put("active", Boolean.TRUE);
        QueryResults bos = this.getDataObjectService().findMatching(ResponsibilityTemplateBo.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        if (bos != null && bos.getResults() != null) {
            if (bos.getResults().size() > 1) {
                throw new RiceIllegalStateException("more than one Responsibility Template found with namespace code: " + namespaceCode + " and name: " + name);
            }
            Iterator i = bos.getResults().iterator();
            return i.hasNext() ? ResponsibilityTemplateBo.to((TemplateContract)i.next()) : null;
        }
        return null;
    }

    public boolean hasResponsibility(String principalId, String namespaceCode, String respName, Map<String, String> qualification) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(respName, "respName");
        this.incomingParamCheck(qualification, "qualification");
        List<Responsibility> responsibilities = Collections.singletonList(this.findRespByNamespaceCodeAndName(namespaceCode, respName));
        return this.hasResp(principalId, namespaceCode, responsibilities, qualification, null);
    }

    public boolean hasResponsibilityByTemplate(String principalId, String namespaceCode, String respTemplateName, Map<String, String> qualification, Map<String, String> responsibilityDetails) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(respTemplateName, "respTemplateName");
        this.incomingParamCheck(qualification, "qualification");
        this.incomingParamCheck(responsibilityDetails, "responsibilityDetails");
        List<Responsibility> responsibilities = this.findResponsibilitiesByTemplate(namespaceCode, respTemplateName);
        return this.hasResp(principalId, namespaceCode, responsibilities, qualification, responsibilityDetails);
    }

    private boolean hasResp(String principalId, String namespaceCode, List<Responsibility> responsibilities, Map<String, String> qualification, Map<String, String> responsibilityDetails) throws RiceIllegalArgumentException {
        ArrayList<String> ids = new ArrayList<String>();
        for (Responsibility r : this.getMatchingResponsibilities(responsibilities, responsibilityDetails)) {
            ids.add(r.getId());
        }
        List<String> roleIds = this.getRoleIdsForResponsibilities(ids);
        return this.roleService.principalHasRole(principalId, roleIds, qualification);
    }

    public List<ResponsibilityAction> getResponsibilityActions(String namespaceCode, String responsibilityName, Map<String, String> qualification) throws RiceIllegalArgumentException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(responsibilityName, "responsibilityName");
        this.incomingParamCheck(qualification, "qualification");
        if (LOG.isDebugEnabled()) {
            this.logResponsibilityCheck(namespaceCode, responsibilityName, qualification, Collections.emptyMap());
        }
        List<Responsibility> responsibilities = Collections.singletonList(this.findRespByNamespaceCodeAndName(namespaceCode, responsibilityName));
        return this.getRespActions(namespaceCode, responsibilities, qualification, null);
    }

    public List<ResponsibilityAction> getResponsibilityActionsByTemplate(String namespaceCode, String respTemplateName, Map<String, String> qualification, Map<String, String> responsibilityDetails) throws RiceIllegalArgumentException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(respTemplateName, "respTemplateName");
        this.incomingParamCheck(qualification, "qualification");
        if (LOG.isDebugEnabled()) {
            this.logResponsibilityCheck(namespaceCode, respTemplateName, qualification, responsibilityDetails);
        }
        List<Responsibility> responsibilities = this.findResponsibilitiesByTemplate(namespaceCode, respTemplateName);
        return this.getRespActions(namespaceCode, responsibilities, qualification, responsibilityDetails);
    }

    private List<ResponsibilityAction> getRespActions(String namespaceCode, List<Responsibility> responsibilities, Map<String, String> qualification, Map<String, String> responsibilityDetails) {
        List<Responsibility> applicableResponsibilities = this.getMatchingResponsibilities(responsibilities, responsibilityDetails);
        ArrayList<ResponsibilityAction> results = new ArrayList<ResponsibilityAction>();
        for (Responsibility r : applicableResponsibilities) {
            List<String> roleIds = this.getRoleIdsForResponsibility(r.getId());
            results.addAll(this.getActionsForResponsibilityRoles(r, roleIds, qualification));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found " + results.size() + " matching ResponsibilityAction objects"));
            if (LOG.isTraceEnabled()) {
                LOG.trace(results);
            }
        }
        return results;
    }

    private List<ResponsibilityAction> getActionsForResponsibilityRoles(Responsibility responsibility, List<String> roleIds, Map<String, String> qualification) {
        ArrayList<ResponsibilityAction> results = new ArrayList<ResponsibilityAction>();
        List roleMembers = this.roleService.getRoleMembers(roleIds, qualification);
        for (RoleMembership rm : roleMembers) {
            if (!StringUtils.isNotBlank((String)rm.getMemberId())) continue;
            List<RoleResponsibilityAction> roleResponsibilityActions = this.getResponsibilityActions(rm.getRoleId(), responsibility.getId(), rm.getId());
            for (RoleResponsibilityAction roleResponsibilityAction : roleResponsibilityActions) {
                ResponsibilityAction.Builder rai = ResponsibilityAction.Builder.create();
                rai.setMemberRoleId(rm.getEmbeddedRoleId() == null ? rm.getRoleId() : rm.getEmbeddedRoleId());
                rai.setRoleId(rm.getRoleId());
                rai.setQualifier(rm.getQualifier());
                ArrayList<DelegateType.Builder> bs = new ArrayList<DelegateType.Builder>();
                for (DelegateType d : rm.getDelegates()) {
                    bs.add(DelegateType.Builder.create((DelegateTypeContract)d));
                }
                rai.setDelegates(bs);
                rai.setResponsibilityId(responsibility.getId());
                rai.setResponsibilityName(responsibility.getName());
                rai.setResponsibilityNamespaceCode(responsibility.getNamespaceCode());
                if (MemberType.PRINCIPAL.equals((Object)rm.getType())) {
                    rai.setPrincipalId(rm.getMemberId());
                } else {
                    rai.setGroupId(rm.getMemberId());
                }
                rai.setActionTypeCode(roleResponsibilityAction.getActionTypeCode());
                rai.setActionPolicyCode(roleResponsibilityAction.getActionPolicyCode());
                rai.setPriorityNumber(roleResponsibilityAction.getPriorityNumber() == null ? DEFAULT_PRIORITY_NUMBER : roleResponsibilityAction.getPriorityNumber());
                rai.setForceAction(roleResponsibilityAction.isForceAction());
                rai.setParallelRoutingGroupingCode(rm.getRoleSortingCode() == null ? "" : rm.getRoleSortingCode());
                rai.setRoleResponsibilityActionId(roleResponsibilityAction.getId());
                results.add(rai.build());
            }
        }
        return Collections.unmodifiableList(results);
    }

    private List<RoleResponsibilityAction> getResponsibilityActions(String roleId, String responsibilityId, String roleMemberId) {
        ArrayList<RoleResponsibilityAction> responsibilityActions = new ArrayList<RoleResponsibilityAction>();
        Predicate roleResponsibilityPredicate = PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"responsibilityId", (Object)responsibilityId), PredicateFactory.equal((String)"roleId", (Object)roleId), PredicateFactory.equal((String)"active", (Object)Boolean.TRUE)});
        QueryByCriteria.Builder roleResponsibilityQueryBuilder = QueryByCriteria.Builder.create();
        roleResponsibilityQueryBuilder.setPredicates(new Predicate[]{roleResponsibilityPredicate});
        QueryResults roleResponsibilityResults = this.getDataObjectService().findMatching(RoleResponsibilityBo.class, roleResponsibilityQueryBuilder.build());
        List roleResponsibilityBos = roleResponsibilityResults.getResults();
        if (!CollectionUtils.isEmpty((Collection)roleResponsibilityBos)) {
            ArrayList<String> roleResponsibilityIds = new ArrayList<String>(roleResponsibilityBos.size());
            for (RoleResponsibilityBo roleResponsibilityBo : roleResponsibilityBos) {
                roleResponsibilityIds.add(roleResponsibilityBo.getRoleResponsibilityId());
            }
            Predicate roleResponsibilityActionPredicate = PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.in((String)"roleResponsibilityId", (Object[])roleResponsibilityIds.toArray()), PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.equal((String)"roleMemberId", (Object)roleMemberId), PredicateFactory.equal((String)"roleMemberId", (Object)"*")})}), PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"roleResponsibilityId", (Object)"*"), PredicateFactory.equal((String)"roleMemberId", (Object)roleMemberId)})});
            QueryByCriteria.Builder roleResponsibilityActionQueryBuilder = QueryByCriteria.Builder.create();
            roleResponsibilityActionQueryBuilder.setPredicates(new Predicate[]{roleResponsibilityActionPredicate});
            QueryResults roleResponsibilityActionResults = this.getDataObjectService().findMatching(RoleResponsibilityActionBo.class, roleResponsibilityActionQueryBuilder.build());
            List roleResponsibilityActionBos = roleResponsibilityActionResults.getResults();
            for (RoleResponsibilityActionBo roleResponsibilityActionBo : roleResponsibilityActionBos) {
                responsibilityActions.add(RoleResponsibilityActionBo.to(roleResponsibilityActionBo));
            }
        }
        return Collections.unmodifiableList(responsibilityActions);
    }

    public List<String> getRoleIdsForResponsibility(String id) throws RiceIllegalArgumentException {
        this.incomingParamCheck(id, "id");
        List<String> roleIds = this.getRoleIdsForPredicate(PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"responsibilityId", (Object)id), PredicateFactory.equal((String)"active", (Object)Boolean.TRUE)}));
        return Collections.unmodifiableList(roleIds);
    }

    public ResponsibilityQueryResults findResponsibilities(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        QueryResults results = this.getDataObjectService().findMatching(ResponsibilityBo.class, (QueryByCriteria)AttributeTransform.getInstance().apply((Object)queryByCriteria));
        ResponsibilityQueryResults.Builder builder = ResponsibilityQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Responsibility.Builder> ims = new ArrayList<Responsibility.Builder>();
        for (ResponsibilityBo bo : results.getResults()) {
            ims.add(Responsibility.Builder.create((ResponsibilityContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public TemplateQueryResults findResponsibilityTemplates(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        QueryResults results = this.getDataObjectService().findMatching(ResponsibilityTemplateBo.class, queryByCriteria);
        TemplateQueryResults.Builder builder = TemplateQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Template.Builder> ims = new ArrayList<Template.Builder>();
        for (ResponsibilityTemplateBo bo : results.getResults()) {
            ims.add(Template.Builder.create((TemplateContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    private List<Responsibility> getMatchingResponsibilities(List<Responsibility> responsibilities, Map<String, String> responsibilityDetails) {
        if (responsibilityDetails == null || responsibilityDetails.isEmpty()) {
            return responsibilities;
        }
        ArrayList applicableResponsibilities = new ArrayList();
        Map<String, ResponsibilityTypeService> responsibilityTypeServices = this.getResponsibilityTypeServicesByTemplateId(responsibilities);
        Map<String, List<Responsibility>> responsibilityMap = this.groupResponsibilitiesByTemplate(responsibilities);
        for (Map.Entry<String, List<Responsibility>> respEntry : responsibilityMap.entrySet()) {
            ResponsibilityTypeService responsibilityTypeService = responsibilityTypeServices.get(respEntry.getKey());
            List<Responsibility> responsibilityInfos = respEntry.getValue();
            if (responsibilityTypeService == null) {
                responsibilityTypeService = this.defaultResponsibilityTypeService;
            }
            applicableResponsibilities.addAll(responsibilityTypeService.getMatchingResponsibilities(responsibilityDetails, responsibilityInfos));
        }
        return Collections.unmodifiableList(applicableResponsibilities);
    }

    private Map<String, ResponsibilityTypeService> getResponsibilityTypeServicesByTemplateId(Collection<Responsibility> responsibilities) {
        HashMap<String, ResponsibilityTypeService> responsibilityTypeServices = new HashMap<String, ResponsibilityTypeService>(responsibilities.size());
        for (Responsibility responsibility : responsibilities) {
            Template t = responsibility.getTemplate();
            KimType type = this.kimTypeInfoService.getKimType(t.getKimTypeId());
            String serviceName = type.getServiceName();
            if (serviceName == null) continue;
            ResponsibilityTypeService responsibiltyTypeService = (ResponsibilityTypeService)GlobalResourceLoader.getService((QName)QName.valueOf(serviceName));
            if (responsibiltyTypeService != null) {
                responsibilityTypeServices.put(responsibility.getTemplate().getId(), responsibiltyTypeService);
                continue;
            }
            responsibilityTypeServices.put(responsibility.getTemplate().getId(), this.defaultResponsibilityTypeService);
        }
        return Collections.unmodifiableMap(responsibilityTypeServices);
    }

    private Map<String, List<Responsibility>> groupResponsibilitiesByTemplate(Collection<Responsibility> responsibilities) {
        HashMap<String, ArrayList<Responsibility>> results = new HashMap<String, ArrayList<Responsibility>>();
        for (Responsibility responsibility : responsibilities) {
            ArrayList<Responsibility> responsibilityInfos = (ArrayList<Responsibility>)results.get(responsibility.getTemplate().getId());
            if (responsibilityInfos == null) {
                responsibilityInfos = new ArrayList<Responsibility>();
                results.put(responsibility.getTemplate().getId(), responsibilityInfos);
            }
            responsibilityInfos.add(responsibility);
        }
        return Collections.unmodifiableMap(results);
    }

    private List<String> getRoleIdsForResponsibilities(Collection<String> ids) {
        List<String> roleIds = this.getRoleIdsForPredicate(PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.in((String)"responsibilityId", (Object[])ids.toArray()), PredicateFactory.equal((String)"active", (Object)Boolean.TRUE)}));
        return Collections.unmodifiableList(roleIds);
    }

    private List<String> getRoleIdsForPredicate(Predicate p) {
        QueryResults qr = this.getDataObjectService().findMatching(RoleResponsibilityBo.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{p}));
        ArrayList<String> roleIds = new ArrayList<String>();
        for (RoleResponsibilityBo bo : qr.getResults()) {
            roleIds.add(bo.getRoleId());
        }
        return Collections.unmodifiableList(roleIds);
    }

    public List<Responsibility> findResponsibilitiesByTemplate(String namespaceCode, String templateName) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("template.namespaceCode", namespaceCode);
        criteria.put("template.name", templateName);
        criteria.put("active", Boolean.TRUE);
        QueryResults bos = this.getDataObjectService().findMatching(ResponsibilityBo.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        ArrayList<Responsibility> ims = new ArrayList<Responsibility>();
        if (bos != null && bos.getResults() != null) {
            for (ResponsibilityBo bo : bos.getResults()) {
                if (bo == null) continue;
                ims.add(ResponsibilityBo.to(bo));
            }
        }
        return Collections.unmodifiableList(ims);
    }

    public void setDefaultResponsibilityTypeService(ResponsibilityTypeService defaultResponsibilityTypeService) {
        this.defaultResponsibilityTypeService = defaultResponsibilityTypeService;
    }

    public void setKimTypeInfoService(KimTypeInfoService kimTypeInfoService) {
        this.kimTypeInfoService = kimTypeInfoService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    protected void logResponsibilityCheck(String namespaceCode, String responsibilityName, Map<String, String> responsibilityDetails, Map<String, String> qualification) {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append("Get Resp Actions: ").append(namespaceCode).append("/").append(responsibilityName).append('\n');
        sb.append("             Details:\n");
        if (responsibilityDetails != null) {
            sb.append(responsibilityDetails);
        } else {
            sb.append("                         [null]\n");
        }
        sb.append("             Qualifiers:\n");
        if (qualification != null) {
            sb.append(qualification);
        } else {
            sb.append("                         [null]\n");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)sb.append(ExceptionUtils.getStackTrace((Throwable)new Throwable())));
        } else {
            LOG.debug((Object)sb.toString());
        }
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

