/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupContract;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.CodedAttributeContract;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationType;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierType;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleContract;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.framework.identity.EntityTypeEbo;
import org.kuali.rice.kim.framework.identity.address.EntityAddressTypeEbo;
import org.kuali.rice.kim.framework.identity.affiliation.EntityAffiliationTypeEbo;
import org.kuali.rice.kim.framework.identity.citizenship.EntityCitizenshipStatusEbo;
import org.kuali.rice.kim.framework.identity.email.EntityEmailTypeEbo;
import org.kuali.rice.kim.framework.identity.employment.EntityEmploymentStatusEbo;
import org.kuali.rice.kim.framework.identity.employment.EntityEmploymentTypeEbo;
import org.kuali.rice.kim.framework.identity.external.EntityExternalIdentifierTypeEbo;
import org.kuali.rice.kim.framework.identity.name.EntityNameTypeEbo;
import org.kuali.rice.kim.framework.identity.phone.EntityPhoneTypeEbo;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.identity.EntityTypeBo;
import org.kuali.rice.kim.impl.identity.address.EntityAddressTypeBo;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationTypeBo;
import org.kuali.rice.kim.impl.identity.citizenship.EntityCitizenshipStatusBo;
import org.kuali.rice.kim.impl.identity.email.EntityEmailTypeBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentStatusBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentTypeBo;
import org.kuali.rice.kim.impl.identity.external.EntityExternalIdentifierTypeBo;
import org.kuali.rice.kim.impl.identity.name.EntityNameTypeBo;
import org.kuali.rice.kim.impl.identity.phone.EntityPhoneTypeBo;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.service.impl.RemoteModuleServiceBase;

public class KimRemoteModuleService
extends RemoteModuleServiceBase {
    private PersonService personService;
    private RoleService kimRoleService;
    private GroupService groupService;
    private IdentityService identityService;
    private KimTypeInfoService kimTypeInfoService;

    public <T extends ExternalizableBusinessObject> T getExternalizableBusinessObject(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        if (Person.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("principalId")) {
                return (T)this.getPersonService().getPerson((String)fieldValues.get("principalId"));
            }
            if (fieldValues.containsKey("principalName")) {
                return (T)this.getPersonService().getPersonByPrincipalName((String)fieldValues.get("principalName"));
            }
        } else if (RoleContract.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("id")) {
                Role role = this.getKimRoleService().getRole((String)fieldValues.get("id"));
                return (T)((Object)RoleBo.from(role));
            }
        } else if (GroupContract.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("id")) {
                Group group = this.getGroupService().getGroup((String)fieldValues.get("id"));
                return (T)((Object)GroupBo.from(group));
            }
        } else if (EntityEmailTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                CodedAttribute codedAttribute = this.getIdentityService().getEmailType((String)fieldValues.get("code"));
                return (T)((Object)EntityEmailTypeBo.from(codedAttribute));
            }
        } else if (EntityAddressTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                CodedAttribute codedAttribute = this.getIdentityService().getAddressType((String)fieldValues.get("code"));
                return (T)((Object)EntityAddressTypeBo.from(codedAttribute));
            }
        } else if (EntityAffiliationTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                EntityAffiliationType codedAttribute = this.getIdentityService().getAffiliationType((String)fieldValues.get("code"));
                return (T)((Object)EntityAffiliationTypeBo.from(codedAttribute));
            }
        } else if (EntityCitizenshipStatusEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                CodedAttribute codedAttribute = this.getIdentityService().getCitizenshipStatus((String)fieldValues.get("code"));
                return (T)((Object)EntityCitizenshipStatusBo.from(codedAttribute));
            }
        } else if (EntityEmploymentStatusEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                CodedAttribute codedAttribute = this.getIdentityService().getEmploymentStatus((String)fieldValues.get("code"));
                return (T)((Object)EntityEmploymentStatusBo.from(codedAttribute));
            }
        } else if (EntityEmploymentTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                CodedAttribute codedAttribute = this.getIdentityService().getEmploymentType((String)fieldValues.get("code"));
                return (T)((Object)EntityEmploymentTypeBo.from(codedAttribute));
            }
        } else if (EntityNameTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                CodedAttribute codedAttribute = this.getIdentityService().getNameType((String)fieldValues.get("code"));
                return (T)((Object)EntityNameTypeBo.from(codedAttribute));
            }
        } else if (EntityTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                CodedAttribute codedAttribute = this.getIdentityService().getEntityType((String)fieldValues.get("code"));
                return (T)((Object)EntityTypeBo.from(codedAttribute));
            }
        } else if (EntityExternalIdentifierTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("code")) {
                EntityExternalIdentifierType codedAttribute = this.getIdentityService().getExternalIdentifierType((String)fieldValues.get("code"));
                return (T)((Object)EntityExternalIdentifierTypeBo.from(codedAttribute));
            }
        } else if (EntityPhoneTypeEbo.class.isAssignableFrom(businessObjectClass) && fieldValues.containsKey("code")) {
            CodedAttribute codedAttribute = this.getIdentityService().getPhoneType((String)fieldValues.get("code"));
            return (T)((Object)EntityPhoneTypeBo.from(codedAttribute));
        }
        return null;
    }

    public <T extends ExternalizableBusinessObject> List<T> getExternalizableBusinessObjectsList(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        QueryByCriteria.Builder queryBuilder = QueryByCriteria.Builder.create();
        Predicate predicate = PredicateUtils.convertObjectMapToPredicate(fieldValues);
        queryBuilder.setPredicates(new Predicate[]{predicate});
        return this.queryForEbos(businessObjectClass, queryBuilder.build(), fieldValues);
    }

    public boolean isExternalizableBusinessObjectLookupable(Class boClass) {
        return this.isExternalizable(boClass);
    }

    public boolean isExternalizableBusinessObjectInquirable(Class boClass) {
        return this.isExternalizable(boClass);
    }

    public boolean isExternalizable(Class boClazz) {
        if (boClazz == null) {
            return false;
        }
        if (RoleContract.class.isAssignableFrom(boClazz)) {
            return true;
        }
        if (GroupContract.class.isAssignableFrom(boClazz)) {
            return true;
        }
        if (Person.class.isAssignableFrom(boClazz)) {
            return true;
        }
        return ExternalizableBusinessObject.class.isAssignableFrom(boClazz);
    }

    public List<String> listPrimaryKeyFieldNames(Class boClass) {
        if (GroupContract.class.isAssignableFrom(boClass) || RoleContract.class.isAssignableFrom(boClass)) {
            return Collections.singletonList("id");
        }
        if (Person.class.isAssignableFrom(boClass)) {
            return Collections.singletonList("principalId");
        }
        if (CodedAttributeContract.class.isAssignableFrom(boClass)) {
            return Collections.singletonList("code");
        }
        return Collections.emptyList();
    }

    private <T extends ExternalizableBusinessObject> List<T> queryForEbos(Class<T> businessObjectClass, QueryByCriteria query, Map<String, Object> fieldValues) {
        if (Person.class.isAssignableFrom(businessObjectClass)) {
            return this.getPersonService().findPeople(fieldValues);
        }
        if (RoleContract.class.isAssignableFrom(businessObjectClass)) {
            List roles = this.getKimRoleService().findRoles(query).getResults();
            ArrayList<RoleBo> roleEbos = new ArrayList<RoleBo>(roles.size());
            for (Role role : roles) {
                roleEbos.add(RoleBo.from(role));
            }
            return roleEbos;
        }
        if (GroupContract.class.isAssignableFrom(businessObjectClass)) {
            List groups = this.getGroupService().findGroups(query).getResults();
            ArrayList<GroupBo> groupEbos = new ArrayList<GroupBo>(groups.size());
            for (Group group : groups) {
                groupEbos.add(GroupBo.from(group));
            }
            return groupEbos;
        }
        if (EntityEmailTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            List codedAttributes = this.getIdentityService().findAllEmailTypes();
            ArrayList<EntityEmailTypeBo> ebos = new ArrayList<EntityEmailTypeBo>();
            for (CodedAttribute attr : codedAttributes) {
                ebos.add(EntityEmailTypeBo.from(attr));
            }
            return ebos;
        }
        if (EntityAddressTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            List codedAttributes = this.getIdentityService().findAllAddressTypes();
            ArrayList<EntityAddressTypeBo> ebos = new ArrayList<EntityAddressTypeBo>();
            for (CodedAttribute attr : codedAttributes) {
                ebos.add(EntityAddressTypeBo.from(attr));
            }
            return ebos;
        }
        if (EntityAffiliationTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            List codedAttributes = this.getIdentityService().findAllAffiliationTypes();
            ArrayList<EntityAffiliationTypeBo> ebos = new ArrayList<EntityAffiliationTypeBo>();
            for (EntityAffiliationType attr : codedAttributes) {
                ebos.add(EntityAffiliationTypeBo.from(attr));
            }
            return ebos;
        }
        if (EntityCitizenshipStatusEbo.class.isAssignableFrom(businessObjectClass)) {
            List codedAttributes = this.getIdentityService().findAllCitizenshipStatuses();
            ArrayList<EntityCitizenshipStatusBo> ebos = new ArrayList<EntityCitizenshipStatusBo>();
            for (CodedAttribute attr : codedAttributes) {
                ebos.add(EntityCitizenshipStatusBo.from(attr));
            }
            return ebos;
        }
        if (EntityEmploymentStatusEbo.class.isAssignableFrom(businessObjectClass)) {
            List codedAttributes = this.getIdentityService().findAllEmploymentStatuses();
            ArrayList<EntityEmploymentStatusBo> ebos = new ArrayList<EntityEmploymentStatusBo>();
            for (CodedAttribute attr : codedAttributes) {
                ebos.add(EntityEmploymentStatusBo.from(attr));
            }
            return ebos;
        }
        if (EntityEmploymentTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            List codedAttributes = this.getIdentityService().findAllEmploymentTypes();
            ArrayList<EntityEmploymentTypeBo> ebos = new ArrayList<EntityEmploymentTypeBo>();
            for (CodedAttribute attr : codedAttributes) {
                ebos.add(EntityEmploymentTypeBo.from(attr));
            }
            return ebos;
        }
        if (EntityNameTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            List codedAttributes = this.getIdentityService().findAllNameTypes();
            ArrayList<EntityNameTypeBo> ebos = new ArrayList<EntityNameTypeBo>();
            for (CodedAttribute attr : codedAttributes) {
                ebos.add(EntityNameTypeBo.from(attr));
            }
            return ebos;
        }
        if (EntityTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            List codedAttributes = this.getIdentityService().findAllEntityTypes();
            ArrayList<EntityTypeBo> ebos = new ArrayList<EntityTypeBo>();
            for (CodedAttribute attr : codedAttributes) {
                ebos.add(EntityTypeBo.from(attr));
            }
            return ebos;
        }
        if (EntityExternalIdentifierTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            List codedAttributes = this.getIdentityService().findAllExternalIdendtifierTypes();
            ArrayList<EntityExternalIdentifierTypeBo> ebos = new ArrayList<EntityExternalIdentifierTypeBo>();
            for (EntityExternalIdentifierType attr : codedAttributes) {
                ebos.add(EntityExternalIdentifierTypeBo.from(attr));
            }
            return ebos;
        }
        if (EntityPhoneTypeEbo.class.isAssignableFrom(businessObjectClass)) {
            List codedAttributes = this.getIdentityService().findAllPhoneTypes();
            ArrayList<EntityPhoneTypeBo> ebos = new ArrayList<EntityPhoneTypeBo>();
            for (CodedAttribute attr : codedAttributes) {
                ebos.add(EntityPhoneTypeBo.from(attr));
            }
            return ebos;
        }
        return Collections.emptyList();
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = KimApiServiceLocator.getPersonService();
        }
        return this.personService;
    }

    protected RoleService getKimRoleService() {
        if (this.kimRoleService == null) {
            this.kimRoleService = KimApiServiceLocator.getRoleService();
        }
        return this.kimRoleService;
    }

    protected GroupService getGroupService() {
        if (this.groupService == null) {
            this.groupService = KimApiServiceLocator.getGroupService();
        }
        return this.groupService;
    }

    protected IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    protected KimTypeInfoService getTypeInfoService() {
        if (this.kimTypeInfoService == null) {
            this.kimTypeInfoService = KimApiServiceLocator.getKimTypeInfoService();
        }
        return this.kimTypeInfoService;
    }
}

