/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.services;

import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kim.impl.data.DataIntegrityService;
import org.kuali.rice.kim.impl.group.GroupInternalService;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityInternalService;
import org.kuali.rice.kim.impl.role.RoleDao;
import org.kuali.rice.kim.impl.role.RoleInternalService;
import org.springframework.cache.CacheManager;

public class KimImplServiceLocator {
    private static final Logger LOG = LogManager.getLogger(KimImplServiceLocator.class);
    public static final String KIM_RUN_MODE_PROPERTY = "kim.mode";
    public static final String RESPONSIBILITY_INTERNAL_SERVICE = "responsibilityInternalService";
    public static final String GROUP_INTERNAL_SERVICE = "groupInternalService";
    public static final String ROLE_INTERNAL_SERVICE = "kimRoleInternalService";
    public static final String LOCAL_CACHE_MANAGER = "kimLocalCacheManager";
    public static final String DEFAULT_ROLE_TYPE_SERVICE = "kimRoleTypeService";
    public static final String DATA_INTEGRITY_SERVICE = "kimDataIntegrityService";
    public static final String KIM_ROLE_DAO = "kimRoleDao";
    public static final String KIM_DATA_SOURCE = "kimDataSource";

    public static Object getService(String serviceName) {
        return KimImplServiceLocator.getBean(serviceName);
    }

    public static Object getBean(String serviceName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching service " + serviceName);
        }
        QName name = new QName(serviceName);
        RunMode kimRunMode = RunMode.valueOf((String)ConfigContext.getCurrentContextConfig().getProperty(KIM_RUN_MODE_PROPERTY));
        if (kimRunMode == RunMode.REMOTE || kimRunMode == RunMode.THIN) {
            name = new QName("KIM", serviceName);
        }
        return GlobalResourceLoader.getResourceLoader().getService(name);
    }

    public static ResponsibilityInternalService getResponsibilityInternalService() {
        return (ResponsibilityInternalService)KimImplServiceLocator.getService(RESPONSIBILITY_INTERNAL_SERVICE);
    }

    public static GroupInternalService getGroupInternalService() {
        return (GroupInternalService)KimImplServiceLocator.getService(GROUP_INTERNAL_SERVICE);
    }

    public static RoleInternalService getRoleInternalService() {
        return (RoleInternalService)KimImplServiceLocator.getService(ROLE_INTERNAL_SERVICE);
    }

    public static CacheManager getLocalCacheManager() {
        return (CacheManager)KimImplServiceLocator.getService(LOCAL_CACHE_MANAGER);
    }

    public static RoleTypeService getDefaultRoleTypeService() {
        return (RoleTypeService)KimImplServiceLocator.getService(DEFAULT_ROLE_TYPE_SERVICE);
    }

    public static DataIntegrityService getDataIntegrityService() {
        return (DataIntegrityService)KimImplServiceLocator.getService(DATA_INTEGRITY_SERVICE);
    }

    public static RoleDao getRoleDao() {
        return (RoleDao)KimImplServiceLocator.getService(KIM_ROLE_DAO);
    }

    public static DataSource getDataSource() {
        return (DataSource)KimImplServiceLocator.getService(KIM_DATA_SOURCE);
    }
}

