/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.document;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import javax.persistence.Transient;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.struts.upload.FormFile;
import org.kuali.rice.kns.bo.GlobalBusinessObject;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.krad.bo.DocumentAttachment;
import org.kuali.rice.krad.bo.MultiDocumentAttachment;
import org.kuali.rice.krad.bo.PersistableAttachment;
import org.kuali.rice.krad.bo.PersistableAttachmentBase;
import org.kuali.rice.krad.bo.PersistableAttachmentList;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectSerializerService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.ObjectUtils;

@Deprecated
public class MaintenanceDocumentBase
extends org.kuali.rice.krad.maintenance.MaintenanceDocumentBase
implements MaintenanceDocument {
    private static final Logger LOG = Logger.getLogger(MaintenanceDocumentBase.class);
    @Transient
    protected transient FormFile fileAttachment;

    public MaintenanceDocumentBase() {
    }

    public MaintenanceDocumentBase(String documentTypeName) {
        super(documentTypeName);
    }

    @Override
    public Object getDocumentBusinessObject() {
        return super.getDocumentDataObject();
    }

    @Override
    public boolean isOldBusinessObjectInDocument() {
        boolean isOldBusinessObjectInExistence = false;
        isOldBusinessObjectInExistence = this.getOldMaintainableObject() == null || this.getOldMaintainableObject().getBusinessObject() == null ? false : this.getOldMaintainableObject().isOldBusinessObjectInDocument();
        return isOldBusinessObjectInExistence;
    }

    @Override
    public Maintainable getNewMaintainableObject() {
        return (Maintainable)this.newMaintainableObject;
    }

    @Override
    public Maintainable getOldMaintainableObject() {
        return (Maintainable)this.oldMaintainableObject;
    }

    public FormFile getFileAttachment() {
        return this.fileAttachment;
    }

    public void setFileAttachment(FormFile fileAttachment) {
        this.fileAttachment = fileAttachment;
    }

    protected void refreshAttachment() {
        if (KRADUtils.isNull((Object)this.attachment)) {
            boolean isProxy;
            this.refreshReferenceObject("attachment");
            boolean bl = isProxy = this.attachment != null && ProxyHelper.isProxy((Object)this.attachment);
            if (isProxy && ProxyHelper.getRealObject((Object)this.attachment) == null) {
                this.attachment = null;
            }
        }
    }

    protected void refreshAttachmentList() {
        if (KRADUtils.isNull((Object)this.attachments)) {
            boolean isProxy;
            this.refreshReferenceObject("attachments");
            boolean bl = isProxy = this.attachments != null && ProxyHelper.isProxy((Object)this.attachments);
            if (isProxy && ProxyHelper.getRealObject((Object)this.attachments) == null) {
                this.attachments = null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void populateDocumentAttachment() {
        this.refreshAttachment();
        if (this.fileAttachment != null && StringUtils.isNotEmpty((String)this.fileAttachment.getFileName())) {
            if (this.attachment == null) {
                this.attachment = new DocumentAttachment();
            }
            try {
                byte[] fileContents = this.fileAttachment.getFileData();
                if (fileContents.length <= 0) return;
                this.attachment.setFileName(this.fileAttachment.getFileName());
                this.attachment.setContentType(this.fileAttachment.getContentType());
                this.attachment.setAttachmentContent(this.fileAttachment.getFileData());
                this.attachment.setObjectId(UUID.randomUUID().toString());
                PersistableAttachment boAttachment = (PersistableAttachment)this.newMaintainableObject.getDataObject();
                boAttachment.setAttachmentContent(null);
                this.attachment.setDocumentNumber(this.getDocumentNumber());
                return;
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)"Error while populating the Document Attachment", (Throwable)e);
                throw new RuntimeException("Could not populate DocumentAttachment object", e);
            }
            catch (IOException e) {
                LOG.error((Object)"Error while populating the Document Attachment", (Throwable)e);
                throw new RuntimeException("Could not populate DocumentAttachment object", e);
            }
        } else {
            PersistableAttachment boAttachment = (PersistableAttachment)this.newMaintainableObject.getDataObject();
            if (this.attachment != null || boAttachment == null || boAttachment.getAttachmentContent() == null) return;
            DocumentAttachment newAttachment = new DocumentAttachment();
            newAttachment.setDocumentNumber(this.getDocumentNumber());
            newAttachment.setAttachmentContent(boAttachment.getAttachmentContent());
            newAttachment.setContentType(boAttachment.getContentType());
            newAttachment.setFileName(boAttachment.getFileName());
            boAttachment.setAttachmentContent(null);
            this.attachment = newAttachment;
        }
    }

    public void populateAttachmentForBO() {
        this.refreshAttachment();
        PersistableAttachment boAttachment = (PersistableAttachment)this.newMaintainableObject.getDataObject();
        if (ObjectUtils.isNotNull(this.getAttachmentPropertyName())) {
            String attachmentPropNm = this.getAttachmentPropertyName();
            String attachmentPropNmSetter = "get" + attachmentPropNm.substring(0, 1).toUpperCase() + attachmentPropNm.substring(1, attachmentPropNm.length());
            if (boAttachment.getFileName() == null && boAttachment instanceof PersistableAttachment) {
                try {
                    Method[] methods;
                    for (Method method : methods = boAttachment.getClass().getMethods()) {
                        if (!method.getName().equals(attachmentPropNmSetter)) continue;
                        FormFile attachmentFromBusinessObject = (FormFile)boAttachment.getClass().getDeclaredMethod(attachmentPropNmSetter, new Class[0]).invoke((Object)boAttachment, new Object[0]);
                        if (attachmentFromBusinessObject != null) {
                            boAttachment.setFileName(attachmentFromBusinessObject.getFileName());
                            boAttachment.setContentType(attachmentFromBusinessObject.getContentType());
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Not able to get the attachment " + e.getMessage()));
                    throw new RuntimeException("Not able to get the attachment " + e.getMessage());
                }
            }
        }
        if (boAttachment.getFileName() == null && boAttachment instanceof PersistableAttachment && this.attachment != null && this.attachment.getFileName() != null) {
            boAttachment.setAttachmentContent(null);
            boAttachment.setFileName(this.attachment.getFileName());
            boAttachment.setContentType(this.attachment.getContentType());
        }
    }

    public void populateAttachmentBeforeSave() {
        PersistableAttachment boAttachment = (PersistableAttachment)this.newMaintainableObject.getDataObject();
        if (this.attachment != null && this.attachment.getAttachmentContent() != null) {
            boAttachment.setAttachmentContent(this.attachment.getAttachmentContent());
        } else {
            boAttachment.setAttachmentContent(null);
            boAttachment.setFileName(null);
            boAttachment.setContentType(null);
        }
    }

    public void populateBoAttachmentListBeforeSave() {
        String key;
        PersistableAttachmentList boAttachments = (PersistableAttachmentList)this.newMaintainableObject.getDataObject();
        if (CollectionUtils.isEmpty((Collection)this.attachments)) {
            boAttachments.setAttachments(Collections.emptyList());
            return;
        }
        HashMap<String, MultiDocumentAttachment> files = new HashMap<String, MultiDocumentAttachment>();
        for (MultiDocumentAttachment multiAttach : this.attachments) {
            key = new StringBuffer(multiAttach.getFileName()).append("|").append(multiAttach.getContentType()).toString();
            files.put(key, multiAttach);
        }
        if (CollectionUtils.isNotEmpty((Collection)boAttachments.getAttachments())) {
            for (PersistableAttachment attach : boAttachments.getAttachments()) {
                key = new StringBuffer(attach.getFileName()).append("|").append(attach.getContentType()).toString();
                if (!files.containsKey(key)) continue;
                attach.setAttachmentContent(((MultiDocumentAttachment)files.get(key)).getAttachmentContent());
                files.remove(key);
            }
        }
    }

    public void populateAttachmentListForBO() {
        this.refreshAttachmentList();
        PersistableAttachmentList boAttachments = (PersistableAttachmentList)this.newMaintainableObject.getDataObject();
        if (ObjectUtils.isNotNull(this.getAttachmentListPropertyName())) {
            String attachmentPropNm = this.getAttachmentListPropertyName();
            String attachmentPropNmSetter = "get" + attachmentPropNm.substring(0, 1).toUpperCase() + attachmentPropNm.substring(1, attachmentPropNm.length());
            for (PersistableAttachment persistableAttachment : boAttachments.getAttachments()) {
                if (persistableAttachment.getFileName() != null) continue;
                try {
                    FormFile attachmentFromBusinessObject = (FormFile)persistableAttachment.getClass().getDeclaredMethod(attachmentPropNmSetter, new Class[0]).invoke((Object)persistableAttachment, new Object[0]);
                    if (attachmentFromBusinessObject == null) continue;
                    persistableAttachment.setFileName(attachmentFromBusinessObject.getFileName());
                    persistableAttachment.setContentType(attachmentFromBusinessObject.getContentType());
                }
                catch (Exception e) {
                    LOG.error((Object)("Not able to get the attachment " + e.getMessage()));
                    throw new RuntimeException("Not able to get the attachment " + e.getMessage());
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)boAttachments.getAttachments()) && CollectionUtils.isNotEmpty((Collection)this.attachments)) {
            ArrayList<PersistableAttachment> attachmentList = new ArrayList<PersistableAttachment>();
            for (MultiDocumentAttachment multiAttach : this.attachments) {
                PersistableAttachment persistableAttachment;
                if (multiAttach.getAttachmentContent().length <= 0) continue;
                persistableAttachment = this.convertDocToBoAttachment(multiAttach, false);
                attachmentList.add(persistableAttachment);
            }
            boAttachments.setAttachments(attachmentList);
        }
    }

    private PersistableAttachment convertDocToBoAttachment(MultiDocumentAttachment multiAttach, boolean copyFile) {
        PersistableAttachmentBase persistableAttachment = new PersistableAttachmentBase();
        if (copyFile && multiAttach.getAttachmentContent() != null) {
            persistableAttachment.setAttachmentContent(multiAttach.getAttachmentContent());
        }
        persistableAttachment.setFileName(multiAttach.getFileName());
        persistableAttachment.setContentType(multiAttach.getContentType());
        return persistableAttachment;
    }

    public void populateDocumentAttachmentList() {
        this.refreshAttachmentList();
        String attachmentPropNm = this.getAttachmentListPropertyName();
        String attachmentPropNmSetter = "get" + attachmentPropNm.substring(0, 1).toUpperCase() + attachmentPropNm.substring(1, attachmentPropNm.length());
        PersistableAttachmentList boAttachmentList = (PersistableAttachmentList)this.newMaintainableObject.getDataObject();
        if (CollectionUtils.isNotEmpty((Collection)boAttachmentList.getAttachments())) {
            HashMap<String, MultiDocumentAttachment> md5Hashes = new HashMap<String, MultiDocumentAttachment>();
            if (CollectionUtils.isNotEmpty((Collection)this.attachments)) {
                for (MultiDocumentAttachment currentAttachment : this.attachments) {
                    md5Hashes.put(DigestUtils.md5Hex((byte[])currentAttachment.getAttachmentContent()), currentAttachment);
                }
            }
            this.attachments = new ArrayList();
            for (PersistableAttachment persistableAttachment : boAttachmentList.getAttachments()) {
                try {
                    FormFile attachmentFromBusinessObject = (FormFile)persistableAttachment.getClass().getDeclaredMethod(attachmentPropNmSetter, new Class[0]).invoke((Object)persistableAttachment, new Object[0]);
                    if (attachmentFromBusinessObject != null) {
                        String md5Hex = DigestUtils.md5Hex((InputStream)attachmentFromBusinessObject.getInputStream());
                        if (md5Hashes.containsKey(md5Hex)) {
                            String newFileName = attachmentFromBusinessObject.getFileName();
                            MultiDocumentAttachment multiAttach = (MultiDocumentAttachment)md5Hashes.get(md5Hex);
                            if (multiAttach.getFileName().equals(newFileName)) {
                                this.attachments.add(multiAttach);
                            } else {
                                multiAttach.setFileName(attachmentFromBusinessObject.getFileName());
                                multiAttach.setContentType(attachmentFromBusinessObject.getContentType());
                                this.attachments.add(multiAttach);
                            }
                            md5Hashes.remove(md5Hex);
                            continue;
                        }
                        MultiDocumentAttachment attach = new MultiDocumentAttachment();
                        attach.setFileName(attachmentFromBusinessObject.getFileName());
                        attach.setContentType(attachmentFromBusinessObject.getContentType());
                        attach.setAttachmentContent(attachmentFromBusinessObject.getFileData());
                        attach.setDocumentNumber(this.getDocumentNumber());
                        this.attachments.add(attach);
                        continue;
                    }
                    if (persistableAttachment.getFileName() == null || persistableAttachment.getAttachmentContent() == null) continue;
                    MultiDocumentAttachment attach = new MultiDocumentAttachment();
                    attach.setFileName(persistableAttachment.getFileName());
                    attach.setContentType(persistableAttachment.getContentType());
                    attach.setAttachmentContent(persistableAttachment.getAttachmentContent());
                    attach.setDocumentNumber(this.getDocumentNumber());
                    persistableAttachment.setAttachmentContent(null);
                    this.attachments.add(attach);
                }
                catch (Exception e) {
                    LOG.error((Object)("Not able to get the attachment " + e.getMessage()));
                    throw new RuntimeException("Not able to get the attachment " + e.getMessage());
                }
            }
        }
    }

    protected BusinessObjectSerializerService getBusinessObjectSerializerService() {
        return KRADServiceLocator.getBusinessObjectSerializerService();
    }

    public void postProcessSave(DocumentEvent event) {
        Object bo = this.getNewMaintainableObject().getDataObject();
        if (bo instanceof GlobalBusinessObject) {
            bo = KRADServiceLocatorWeb.getLegacyDataAdapter().save(bo);
            this.getNewMaintainableObject().setDataObject(bo);
        }
        if (!(event instanceof SaveDocumentEvent)) {
            this.getMaintenanceDocumentService().deleteLocks(this.getDocumentNumber());
            this.getMaintenanceDocumentService().storeLocks(this.getNewMaintainableObject().generateMaintenanceLocks());
        }
    }
}

