/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.kuali.rice.krad.data.util.ReferenceLinker;

public class ReferenceLinkerTest
extends TestCase {
    private ReferenceLinker referenceLinker = new ReferenceLinker();

    public void testDecomposePropertyPaths() throws Exception {
        HashSet<String> changes = new HashSet<String>();
        changes.add("a.b.c.e");
        changes.add("a.b2.c.e");
        changes.add("b.1.2.3");
        changes.add("c[0].a");
        changes.add("c[1].b");
        changes.add("c['2'].c");
        changes.add("c[\"a.b.c\"].b.a");
        Map decomposed = this.referenceLinker.decomposePropertyPaths(changes);
        ReferenceLinkerTest.assertTrue((boolean)decomposed.containsKey("a"));
        Set paths = (Set)decomposed.get("a");
        ReferenceLinkerTest.assertTrue((boolean)paths.contains("b.c.e"));
        ReferenceLinkerTest.assertTrue((boolean)paths.contains("b2.c.e"));
        ReferenceLinkerTest.assertEquals((int)2, (int)paths.size());
        ReferenceLinkerTest.assertTrue((boolean)decomposed.containsKey("b"));
        paths = (Set)decomposed.get("b");
        ReferenceLinkerTest.assertTrue((boolean)paths.contains("1.2.3"));
        ReferenceLinkerTest.assertEquals((int)1, (int)paths.size());
        ReferenceLinkerTest.assertTrue((boolean)decomposed.containsKey("c[0]"));
        ReferenceLinkerTest.assertTrue((boolean)decomposed.containsKey("c[1]"));
        ReferenceLinkerTest.assertTrue((boolean)decomposed.containsKey("c['2']"));
        ReferenceLinkerTest.assertTrue((boolean)decomposed.containsKey("c[\"a.b.c\"]"));
        paths = (Set)decomposed.get("c[0]");
        ReferenceLinkerTest.assertTrue((boolean)paths.contains("a"));
        ReferenceLinkerTest.assertEquals((int)1, (int)paths.size());
        paths = (Set)decomposed.get("c[1]");
        ReferenceLinkerTest.assertTrue((boolean)paths.contains("b"));
        ReferenceLinkerTest.assertEquals((int)1, (int)paths.size());
        paths = (Set)decomposed.get("c['2']");
        ReferenceLinkerTest.assertTrue((boolean)paths.contains("c"));
        ReferenceLinkerTest.assertEquals((int)1, (int)paths.size());
        paths = (Set)decomposed.get("c[\"a.b.c\"]");
        ReferenceLinkerTest.assertTrue((boolean)paths.contains("b.a"));
        ReferenceLinkerTest.assertEquals((int)1, (int)paths.size());
        ReferenceLinkerTest.assertEquals((int)6, (int)decomposed.size());
    }
}

