/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.provider.spring;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.krad.data.metadata.DataObjectMetadata;
import org.kuali.rice.krad.data.metadata.impl.DataObjectMetadataImpl;
import org.kuali.rice.krad.data.provider.impl.MetadataProviderBase;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.DefaultResourceLoader;

public class SpringMetadataProviderImpl
extends MetadataProviderBase {
    private static final Logger LOG = Logger.getLogger(SpringMetadataProviderImpl.class);
    protected List<String> resourceLocations;
    protected DefaultResourceLoader resourceLoader = new DefaultResourceLoader(ClassLoaderUtils.getDefaultClassLoader());
    protected DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();

    public SpringMetadataProviderImpl() {
        LOG.debug((Object)"Building SpringMetadataProviderImpl");
    }

    @Override
    public synchronized void initializeMetadata(Collection<Class<?>> types) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Loading Metadata Bean Definitions from Locations:");
            for (String loc : this.resourceLocations) {
                LOG.debug((Object)loc);
            }
        }
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.beanFactory);
        String[] configFileLocationsArray = new String[this.resourceLocations.size()];
        configFileLocationsArray = this.resourceLocations.toArray(configFileLocationsArray);
        xmlReader.loadBeanDefinitions(configFileLocationsArray);
        Map metadataObjects = this.beanFactory.getBeansOfType(DataObjectMetadata.class);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(metadataObjects.size() + " DataObjectMetadata objects in Spring configuration files"));
        }
        this.masterMetadataMap.clear();
        for (DataObjectMetadata metadata : metadataObjects.values()) {
            if (metadata.getType() != null) {
                if (metadata instanceof DataObjectMetadataImpl) {
                    ((DataObjectMetadataImpl)metadata).setProviderName(this.getClass().getSimpleName());
                }
                this.masterMetadataMap.put(metadata.getType(), metadata);
                continue;
            }
            LOG.error((Object)("Configuration Error.  MetadataObject in the Spring context contained a null DataObjectType reference: " + metadata));
        }
    }

    public List<String> getResourceLocations() {
        return this.resourceLocations;
    }

    public void setResourceLocations(List<String> resourceLocations) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resource locations set to: " + resourceLocations));
        }
        this.resourceLocations = resourceLocations;
    }

    public String toString() {
        return this.getClass().getName() + " : " + this.resourceLocations;
    }
}

