/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.platform;

import org.apache.commons.lang.StringUtils;

public final class DatabasePlatformInfo {
    private final String name;
    private final int majorVersion;

    public DatabasePlatformInfo(String name, int majorVersion) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("Name cannot be null or blank");
        }
        this.name = name;
        this.majorVersion = majorVersion;
    }

    public String getName() {
        return this.name;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DatabasePlatformInfo)) {
            return false;
        }
        DatabasePlatformInfo that = (DatabasePlatformInfo)object;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.majorVersion == that.majorVersion;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.majorVersion;
        return result;
    }

    public String toString() {
        return "DatabasePlatformInfo{name='" + this.name + '\'' + ", majorVersion=" + this.majorVersion + '}';
    }
}

