/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.devtools.doclet;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.javadoc.Main;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class KRADLibraryPropertiesDoclet {
    public static void main(String[] args) {
        Main.execute((String[])new String[]{"-doclet", "org.kuali.rice.krad.demo.uif.library.tools.KRADLibraryPropertiesDoclet", "-sourcepath", "C:/Java/Projects/Rice/Trunk/krad/krad-web-framework/src/main/java", "-subpackages", "org.kuali.rice.krad.uif:org.kuali.rice.krad.datadictionary.validation.constraint"});
    }

    public static boolean start(RootDoc root) {
        KRADLibraryPropertiesDoclet.storeToPropertyFile(root);
        return true;
    }

    private static void storeToPropertyFile(RootDoc root) {
        ClassDoc[] classes = root.classes();
        SortedProperties prop = new SortedProperties();
        for (ClassDoc classDoc : classes) {
            MethodDoc[] methods;
            if (!KRADLibraryPropertiesDoclet.isAnnotatedWith((ProgramElementDoc)classDoc, "org.kuali.rice.krad.datadictionary.parse.BeanTag", "org.kuali.rice.krad.datadictionary.parse.BeanTags")) continue;
            String className = classDoc.qualifiedName();
            String classDescription = classDoc.commentText();
            prop.setProperty(className, classDescription);
            for (MethodDoc methodDoc : methods = classDoc.methods()) {
                if (methodDoc.parameters().length != 0 || !methodDoc.name().startsWith("get") && !methodDoc.name().startsWith("is") || methodDoc.name().equals("get") || methodDoc.name().equals("is") || !KRADLibraryPropertiesDoclet.isAnnotatedWith((ProgramElementDoc)methodDoc, "org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute")) continue;
                String methodName = methodDoc.name().startsWith("get") ? methodDoc.name().replaceFirst("get", "") : methodDoc.name().replaceFirst("is", "");
                String propertyName = Character.toLowerCase(methodName.charAt(0)) + (methodName.length() > 1 ? methodName.substring(1) : "");
                String propertyType = methodDoc.returnType().typeName();
                String propertyDescription = KRADLibraryPropertiesDoclet.getDocText(methodDoc, root);
                prop.setProperty(className + "|" + propertyName + "|" + propertyType, propertyDescription);
            }
        }
        try {
            prop.store(new FileOutputStream("C:/Java/Projects/Rice/Trunk/sampleapp/src/main/resources/org/kuali/rice/devtools/krad/documentation/PropertiesDescription.properties"), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getDocText(MethodDoc method, RootDoc root) {
        if (method.commentText() != null && !method.commentText().equals("")) {
            return method.commentText();
        }
        String docText = method.getRawCommentText();
        if (docText != null && docText.contains("@see")) {
            String classMethodName = docText.replace("@see", "").replace("\n", "").replace(" ", "");
            String className = classMethodName.substring(0, classMethodName.indexOf("#"));
            String methodName = classMethodName.substring(classMethodName.indexOf("#") + 1).replace("()", "");
            ClassDoc classDoc = root.classNamed(className);
            if (classDoc == null) {
                System.err.println("warning - Comment on " + method.toString() + " does not have valid fully qualified " + "method in @see annotation.\n" + docText);
                return "";
            }
            MethodDoc methodDoc = KRADLibraryPropertiesDoclet.getNoParamMethodFromClassDocByName(classDoc, methodName);
            return methodDoc.commentText();
        }
        return "";
    }

    private static MethodDoc getNoParamMethodFromClassDocByName(ClassDoc classDoc, String methodName) {
        MethodDoc[] methods;
        for (MethodDoc methodDoc : methods = classDoc.methods()) {
            if (!methodDoc.name().equals(methodName) || methodDoc.parameters().length != 0) continue;
            return methodDoc;
        }
        return null;
    }

    private static boolean isAnnotatedWith(ProgramElementDoc elementDoc, String ... tagString) {
        AnnotationDesc[] annotations;
        for (AnnotationDesc annotation : annotations = elementDoc.annotations()) {
            if (!Arrays.asList(tagString).contains(annotation.annotationType().toString())) continue;
            return true;
        }
        return false;
    }

    static class SortedProperties
    extends Properties {
        SortedProperties() {
        }

        @Override
        public Enumeration keys() {
            Enumeration<Object> keysEnum = super.keys();
            Vector<String> keyList = new Vector<String>();
            while (keysEnum.hasMoreElements()) {
                keyList.add((String)keysEnum.nextElement());
            }
            Collections.sort(keyList);
            return keyList.elements();
        }
    }
}

