/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.devtools.pdle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversionDefaultImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.core.framework.persistence.ojb.conversion.OjbKualiEncryptDecryptFieldConversion;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.devtools.pdle.PostDataLoadEncryptionDao;
import org.kuali.rice.krad.devtools.pdle.PostDataLoadEncryptionService;
import org.kuali.rice.krad.exception.ClassNotPersistableException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.impl.PersistenceServiceImplBase;

public class PostDataLoadEncryptionServiceImpl
extends PersistenceServiceImplBase
implements PostDataLoadEncryptionService {
    protected Logger LOG = Logger.getLogger(PostDataLoadEncryptionServiceImpl.class);
    private BusinessObjectService businessObjectService;
    private EncryptionService encryptionService;
    private PostDataLoadEncryptionDao postDataLoadEncryptionDao;

    @Override
    public void checkArguments(Class<? extends PersistableBusinessObject> businessObjectClass, Set<String> attributeNames) {
        this.checkArguments(businessObjectClass, attributeNames, true);
    }

    @Override
    public void checkArguments(Class<? extends PersistableBusinessObject> businessObjectClass, Set<String> attributeNames, boolean checkOjbEncryptConfig) {
        ClassDescriptor classDescriptor;
        if (businessObjectClass == null || attributeNames == null) {
            throw new IllegalArgumentException("PostDataLoadEncryptionServiceImpl.encrypt does not allow a null business object Class or attributeNames Set");
        }
        try {
            classDescriptor = this.getClassDescriptor(businessObjectClass);
        }
        catch (ClassNotPersistableException e) {
            throw new IllegalArgumentException("PostDataLoadEncryptionServiceImpl.encrypt does not handle business object classes that do not have a corresponding ClassDescriptor defined in the OJB repository", e);
        }
        for (String attributeName : attributeNames) {
            if (classDescriptor.getFieldDescriptorByName(attributeName) == null) {
                throw new IllegalArgumentException(new StringBuffer("Attribute ").append(attributeName).append(" specified to PostDataLoadEncryptionServiceImpl.encrypt is not in the OJB repository ClassDescriptor for Class ").append(businessObjectClass).toString());
            }
            if (!checkOjbEncryptConfig || classDescriptor.getFieldDescriptorByName(attributeName).getFieldConversion() instanceof OjbKualiEncryptDecryptFieldConversion) continue;
            throw new IllegalArgumentException(new StringBuffer("Attribute ").append(attributeName).append(" of business object Class ").append(businessObjectClass).append(" specified to PostDataLoadEncryptionServiceImpl.encrypt is not configured for encryption in the OJB repository").toString());
        }
    }

    @Override
    public void createBackupTable(Class<? extends PersistableBusinessObject> businessObjectClass) {
        this.postDataLoadEncryptionDao.createBackupTable(this.getClassDescriptor(businessObjectClass).getFullTableName());
    }

    @Override
    public void prepClassDescriptor(Class<? extends PersistableBusinessObject> businessObjectClass, Set<String> attributeNames) {
        ClassDescriptor classDescriptor = this.getClassDescriptor(businessObjectClass);
        for (String attributeName : attributeNames) {
            classDescriptor.getFieldDescriptorByName(attributeName).setFieldConversionClassName(FieldConversionDefaultImpl.class.getName());
        }
    }

    @Override
    public void truncateTable(Class<? extends PersistableBusinessObject> businessObjectClass) {
        this.postDataLoadEncryptionDao.truncateTable(this.getClassDescriptor(businessObjectClass).getFullTableName());
    }

    @Override
    public void encrypt(PersistableBusinessObject businessObject, Set<String> attributeNames) {
        for (String attributeName : attributeNames) {
            try {
                PropertyUtils.setProperty((Object)businessObject, (String)attributeName, (Object)this.encryptionService.encrypt(PropertyUtils.getProperty((Object)businessObject, (String)attributeName)));
            }
            catch (Exception e) {
                throw new RuntimeException(new StringBuffer("PostDataLoadEncryptionServiceImpl caught exception while attempting to encrypt attribute ").append(attributeName).append(" of Class ").append(businessObject.getClass()).toString(), e);
            }
        }
        this.businessObjectService.save(businessObject);
    }

    @Override
    public void restoreClassDescriptor(Class<? extends PersistableBusinessObject> businessObjectClass, Set<String> attributeNames) {
        ClassDescriptor classDescriptor = this.getClassDescriptor(businessObjectClass);
        for (String attributeName : attributeNames) {
            classDescriptor.getFieldDescriptorByName(attributeName).setFieldConversionClassName(OjbKualiEncryptDecryptFieldConversion.class.getName());
        }
        this.businessObjectService.countMatching(businessObjectClass, Collections.emptyMap());
    }

    @Override
    public void restoreTableFromBackup(Class<? extends PersistableBusinessObject> businessObjectClass) {
        this.postDataLoadEncryptionDao.restoreTableFromBackup(this.getClassDescriptor(businessObjectClass).getFullTableName());
    }

    @Override
    public void dropBackupTable(Class<? extends PersistableBusinessObject> businessObjectClass) {
        this.postDataLoadEncryptionDao.dropBackupTable(this.getClassDescriptor(businessObjectClass).getFullTableName());
    }

    @Override
    public boolean doesBackupTableExist(String tableName) {
        return this.postDataLoadEncryptionDao.doesBackupTableExist(tableName);
    }

    @Override
    public void createBackupTable(String tableName) {
        this.postDataLoadEncryptionDao.createBackupTable(tableName);
        this.postDataLoadEncryptionDao.addEncryptionIndicatorToBackupTable(tableName);
    }

    @Override
    public void truncateTable(String tableName) {
        this.postDataLoadEncryptionDao.truncateTable(tableName);
    }

    @Override
    public List<Map<String, String>> retrieveUnencryptedColumnValuesFromBackupTable(String tableName, List<String> columnNames, int numberOfRowsToCommitAfter) {
        return this.postDataLoadEncryptionDao.retrieveUnencryptedColumnValuesFromBackupTable(tableName, columnNames, numberOfRowsToCommitAfter);
    }

    @Override
    public boolean performEncryption(String tableName, List<Map<String, String>> rowsToEncryptColumnsNameValueMap) throws Exception {
        ArrayList<Map<String, List<String>>> rowsToEncryptColumnNameOldNewValuesMap = new ArrayList<Map<String, List<String>>>();
        for (Map<String, String> columnsNameValueMap : rowsToEncryptColumnsNameValueMap) {
            rowsToEncryptColumnNameOldNewValuesMap.add(this.getColumnNamesEncryptedValues(tableName, columnsNameValueMap));
        }
        return this.postDataLoadEncryptionDao.performEncryption(tableName, rowsToEncryptColumnNameOldNewValuesMap);
    }

    public Map<String, List<String>> getColumnNamesEncryptedValues(String tableName, Map<String, String> columnNamesValues) {
        ArrayList<String> oldNewValues = new ArrayList<String>();
        HashMap<String, List<String>> columnNameOldNewValuesMap = new HashMap<String, List<String>>();
        for (String columnName : columnNamesValues.keySet()) {
            try {
                oldNewValues = new ArrayList();
                String columnOldValue = columnNamesValues.get(columnName);
                oldNewValues.add(0, columnOldValue);
                oldNewValues.add(1, this.encryptionService.encrypt((Object)columnOldValue));
                columnNameOldNewValuesMap.put(columnName, oldNewValues);
            }
            catch (Exception e) {
                throw new RuntimeException(new StringBuffer("PostDataLoadEncryptionServiceImpl caught exception while attempting to encrypt Column ").append(columnName).append(" of Table ").append(tableName).toString(), e);
            }
        }
        return columnNameOldNewValuesMap;
    }

    @Override
    public void restoreTableFromBackup(String tableName) {
        this.postDataLoadEncryptionDao.dropEncryptionIndicatorFromBackupTable(tableName);
        this.postDataLoadEncryptionDao.restoreTableFromBackup(tableName);
    }

    @Override
    public void dropBackupTable(String tableName) {
        this.postDataLoadEncryptionDao.dropBackupTable(tableName);
    }

    public void setPostDataLoadEncryptionDao(PostDataLoadEncryptionDao postDataLoadEncryptionDao) {
        this.postDataLoadEncryptionDao = postDataLoadEncryptionDao;
    }

    public void setEncryptionService(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

