/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.devtools.pdle;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.devtools.pdle.PostDataLoadEncryptionService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.springframework.core.io.FileSystemResource;

public class PostDataLoadEncryptionServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(PostDataLoadEncryptionServlet.class);
    private static final String ATTRIBUTES_TO_ENCRYPT_PROPERTIES = "attributesToEncryptProperties";
    private static final String CHECK_OJB_ENCRYPT_CONFIG = "checkOjbEncryptConfig";

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String attributesToEncryptPropertyFileName = request.getParameter(ATTRIBUTES_TO_ENCRYPT_PROPERTIES);
        if (StringUtils.isBlank((String)attributesToEncryptPropertyFileName)) {
            throw new IllegalArgumentException("No valid attributesToEncryptProperties parameter was passed to this Servlet.");
        }
        boolean checkOjbEncryptConfig = true;
        String checkOjbEncryptConfigValue = request.getParameter(CHECK_OJB_ENCRYPT_CONFIG);
        if (!StringUtils.isBlank((String)checkOjbEncryptConfigValue)) {
            checkOjbEncryptConfig = Boolean.valueOf(checkOjbEncryptConfigValue);
        }
        this.execute(attributesToEncryptPropertyFileName, checkOjbEncryptConfig);
        response.getOutputStream().write(("<html><body><p>Successfully encrypted attributes as defined in: " + attributesToEncryptPropertyFileName + "</p></body></html>").getBytes());
    }

    public void execute(String attributesToEncryptPropertyFileName, boolean checkOjbEncryptConfig) {
        PostDataLoadEncryptionService postDataLoadEncryptionService = (PostDataLoadEncryptionService)GlobalResourceLoader.getService((String)"postDataLoadEncryptionService");
        Properties attributesToEncryptProperties = new Properties();
        try {
            attributesToEncryptProperties.load(new FileSystemResource(attributesToEncryptPropertyFileName).getInputStream());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("PostDataLoadEncrypter requires the full, absolute path to a properties file where the keys are the names of the BusinessObject classes that should be processed and the values are the list of attributes on each that require encryption", e);
        }
        for (Map.Entry<Object, Object> entry : attributesToEncryptProperties.entrySet()) {
            HashSet<String> attributeNames;
            Class<?> businessObjectClass;
            try {
                businessObjectClass = Class.forName((String)entry.getKey());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(new StringBuffer("Unable to load Class ").append((String)entry.getKey()).append(" specified by name in attributesToEncryptProperties file ").append(attributesToEncryptProperties).toString(), e);
            }
            try {
                attributeNames = new HashSet<String>(Arrays.asList(StringUtils.split((String)((String)entry.getValue()), (String)",")));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(new StringBuffer("Unable to load attributeNames Set from comma-delimited list of attribute names specified as value for property with Class name ").append(entry.getKey()).append(" key in attributesToEncryptProperties file ").append(attributesToEncryptProperties).toString(), e);
            }
            postDataLoadEncryptionService.checkArguments(businessObjectClass, attributeNames, checkOjbEncryptConfig);
            postDataLoadEncryptionService.createBackupTable(businessObjectClass);
            BusinessObjectService businessObjectService = KRADServiceLocator.getBusinessObjectService();
            try {
                postDataLoadEncryptionService.prepClassDescriptor(businessObjectClass, attributeNames);
                Collection objectsToEncrypt = businessObjectService.findAll(businessObjectClass);
                for (Object businessObject : objectsToEncrypt) {
                    postDataLoadEncryptionService.encrypt((PersistableBusinessObject)businessObject, attributeNames);
                }
                postDataLoadEncryptionService.restoreClassDescriptor(businessObjectClass, attributeNames);
                LOG.info((Object)new StringBuffer("Encrypted ").append(entry.getValue()).append(" attributes of Class ").append(entry.getKey()));
            }
            catch (Exception e) {
                postDataLoadEncryptionService.restoreTableFromBackup(businessObjectClass);
                LOG.error((Object)new StringBuffer("Caught exception, while encrypting ").append(entry.getValue()).append(" attributes of Class ").append(entry.getKey()).append(" and restored table from backup"), (Throwable)e);
            }
            postDataLoadEncryptionService.dropBackupTable(businessObjectClass);
        }
    }
}

