/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.processor;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.validation.Address;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.BaseConstraintProcessorTest;
import org.kuali.rice.krad.datadictionary.validation.processor.CaseConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.ProcessorResult;

public class CaseConstraintProcessorTest
extends BaseConstraintProcessorTest<CaseConstraintProcessor> {
    private Address londonAddress = new Address("812 Maiden Lane", "", "London", "", "", "UK", null);
    private Address noStateAddress = new Address("893 Presidential Ave", "Suite 800", "Washington", "", "92342", "USA", null);

    @Test
    public void testCaseConstraintNotInvoked() {
        ProcessorResult processorResult = this.processRaw(this.londonAddress, "country", (Constraint)this.countryIsUSACaseConstraint);
        ConstraintValidationResult result = processorResult.getFirstConstraintValidationResult();
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.INAPPLICABLE, (Object)result.getStatus());
        Assert.assertEquals((Object)new CaseConstraintProcessor().getName(), (Object)result.getConstraintName());
        List constraints = processorResult.getConstraints();
        Assert.assertNotNull((Object)constraints);
        Assert.assertEquals((long)0L, (long)constraints.size());
    }

    @Test
    public void testCaseConstraintInvoked() {
        ProcessorResult processorResult = this.processRaw(this.noStateAddress, "country", (Constraint)this.countryIsUSACaseConstraint);
        List constraints = processorResult.getConstraints();
        Assert.assertNotNull((Object)constraints);
        Assert.assertEquals((long)1L, (long)constraints.size());
        Constraint constraint = (Constraint)constraints.get(0);
        Assert.assertTrue((boolean)(constraint instanceof PrerequisiteConstraint));
        PrerequisiteConstraint prerequisiteConstraint = (PrerequisiteConstraint)constraint;
        Assert.assertEquals((Object)"state", (Object)prerequisiteConstraint.getPropertyName());
        ConstraintValidationResult result = processorResult.getFirstConstraintValidationResult();
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new CaseConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Override
    protected CaseConstraintProcessor newProcessor() {
        return new CaseConstraintProcessor();
    }
}

