/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.processor;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.validation.Address;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validation.processor.BaseConstraintProcessorTest;
import org.kuali.rice.krad.datadictionary.validation.processor.MustOccurConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;

public class MustOccurConstraintProcessorTest
extends BaseConstraintProcessorTest<MustOccurConstraintProcessor> {
    private Address noPostalCodeAddress = new Address("893 Presidential Ave", "Suite 800", "Washington", "DC", "", "USA", null);
    private Address noStateOrPostalCodeAddress = new Address("893 Presidential Ave", "Suite 800", "Washington", "", "", "USA", null);
    private Address noCityStateAddress = new Address("893 Presidential Ave", "Suite 800", "", "", "12340", "USA", null);

    @Test
    public void testCityStateNoPostalSuccess() {
        ConstraintValidationResult result = this.process(this.noPostalCodeAddress, null, (Constraint)this.topLevelConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new MustOccurConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testCityNoStateNoPostalFailure() {
        ConstraintValidationResult result = this.process(this.noStateOrPostalCodeAddress, null, (Constraint)this.topLevelConstraint);
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new MustOccurConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testPostalNoCityStateSuccess() {
        ConstraintValidationResult result = this.process(this.noCityStateAddress, null, (Constraint)this.topLevelConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new MustOccurConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Override
    protected MustOccurConstraintProcessor newProcessor() {
        return new MustOccurConstraintProcessor();
    }
}

