/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.bo.ModuleConfiguration;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.util.MockModuleService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MockKualiModuleService
implements KualiModuleService,
ApplicationContextAware,
InitializingBean {
    private static MockKualiModuleService bootstrap;
    private static ApplicationContext applicationContext;
    private static Map<String, ModuleService> installedModuleServices;
    private Map<String, List<String>> resourceBundleNames;

    private static ModuleConfiguration createMockModuleConfiguration(String namespaceCode, Class<? extends ExternalizableBusinessObject> boClass) {
        ModuleConfiguration rv = new ModuleConfiguration();
        rv.setApplicationContext(applicationContext);
        rv.setDataDictionaryService(KRADServiceLocatorWeb.getDataDictionaryService());
        rv.setInitializeDataDictionary(false);
        rv.setNamespaceCode(namespaceCode);
        HashMap<Class<? extends ExternalizableBusinessObject>, Class<? extends ExternalizableBusinessObject>> externalizableBusinessObjectImplementations = new HashMap<Class<? extends ExternalizableBusinessObject>, Class<? extends ExternalizableBusinessObject>>();
        externalizableBusinessObjectImplementations.put(boClass, boClass);
        rv.setExternalizableBusinessObjectImplementations(externalizableBusinessObjectImplementations);
        ArrayList<String> packagePrefixes = new ArrayList<String>();
        packagePrefixes.add(boClass.getPackage().getName());
        rv.setPackagePrefixes(packagePrefixes);
        rv.setResourceBundleNames(MockKualiModuleService.bootstrap.resourceBundleNames.get(namespaceCode));
        return rv;
    }

    public static <T extends ExternalizableBusinessObject> void registerModuleService(String moduleId, String namespaceCode, Class<T> boClass, boolean lookupable, boolean inquirable, List<T> instances) {
        MockModuleService mockService = new MockModuleService(instances, lookupable ? Collections.singletonList(boClass) : Collections.emptyList(), inquirable ? Collections.singletonList(boClass) : Collections.emptyList());
        mockService.setKualiModuleService(bootstrap);
        mockService.setModuleConfiguration(MockKualiModuleService.createMockModuleConfiguration(namespaceCode, boClass));
        installedModuleServices.put(moduleId, (ModuleService)mockService);
    }

    public void afterPropertiesSet() throws Exception {
        bootstrap = this;
        if (this.resourceBundleNames == null) {
            this.resourceBundleNames = Collections.emptyMap();
        } else {
            for (Map.Entry<String, List<String>> resourceBundleEntry : this.resourceBundleNames.entrySet()) {
                MockKualiModuleService.registerModuleService(UUID.randomUUID().toString(), resourceBundleEntry.getKey(), MockBusinessObject.class, false, false, Collections.emptyList());
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        MockKualiModuleService.applicationContext = applicationContext;
    }

    public Map<String, List<String>> getResourceBundleNames() {
        return this.resourceBundleNames;
    }

    public void setResourceBundleNames(Map<String, List<String>> resourceBundleNames) {
        this.resourceBundleNames = resourceBundleNames;
    }

    public List<ModuleService> getInstalledModuleServices() {
        return new ArrayList<ModuleService>(installedModuleServices.values());
    }

    public ModuleService getModuleService(String moduleId) {
        return installedModuleServices.get(moduleId);
    }

    public ModuleService getModuleServiceByNamespaceCode(String namespaceCode) {
        for (ModuleService moduleService : installedModuleServices.values()) {
            if (!moduleService.getModuleConfiguration().getNamespaceCode().equals(namespaceCode)) continue;
            return moduleService;
        }
        return null;
    }

    public boolean isModuleServiceInstalled(String namespaceCode) {
        for (ModuleService moduleService : installedModuleServices.values()) {
            if (!moduleService.getModuleConfiguration().getNamespaceCode().equals(namespaceCode)) continue;
            return true;
        }
        return false;
    }

    public ModuleService getResponsibleModuleService(Class boClass) {
        for (ModuleService moduleService : installedModuleServices.values()) {
            if (!moduleService.isResponsibleFor(boClass)) continue;
            return moduleService;
        }
        return null;
    }

    public void setInstalledModuleServices(List<ModuleService> moduleServices) {
        throw new UnsupportedOperationException();
    }

    public List<String> getDataDictionaryPackages() {
        throw new UnsupportedOperationException();
    }

    public String getNamespaceName(String namespaceCode) {
        throw new UnsupportedOperationException();
    }

    public String getNamespaceCode(Class<?> documentOrStepClass) {
        throw new UnsupportedOperationException();
    }

    public String getComponentCode(Class<?> documentOrStepClass) {
        throw new UnsupportedOperationException();
    }

    static {
        installedModuleServices = new LinkedHashMap<String, ModuleService>();
    }

    public static class MockBusinessObject
    implements ExternalizableBusinessObject {
        public void refresh() {
        }
    }
}

