/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Assume;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.framework.config.property.SimpleConfig;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.uif.freemarker.FreeMarkerInlineRenderBootstrap;
import org.kuali.rice.krad.uif.util.MockViewAuthorizer;
import org.kuali.rice.krad.uif.view.ViewAuthorizer;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.mock.web.MockServletContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.StaticWebApplicationContext;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;
import org.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver;

public final class UifUnitTestUtils {
    private static final Logger LOG = Logger.getLogger(UifUnitTestUtils.class);
    private static final ThreadLocal<Properties> TL_CONFIG_PROPERTIES = new ThreadLocal();
    private static ConfigurableWebApplicationContext webApplicationContext;

    private static void configureKradWebApplicationContext() {
        MockServletContext sctx = new MockServletContext();
        StaticWebApplicationContext ctx = new StaticWebApplicationContext();
        ctx.setServletContext((ServletContext)sctx);
        MutablePropertyValues mpv = new MutablePropertyValues();
        mpv.add("preferFileSystemAccess", (Object)false);
        mpv.add("templateLoaderPath", (Object)"/krad-web");
        Properties props = new Properties();
        props.put("number_format", "computer");
        props.put("template_update_delay", "2147483647");
        mpv.add("freemarkerSettings", (Object)props);
        ctx.registerSingleton("freemarkerConfig", FreeMarkerConfigurer.class, mpv);
        mpv = new MutablePropertyValues();
        mpv.add("cache", (Object)true);
        mpv.add("prefix", (Object)"");
        mpv.add("suffix", (Object)".ftl");
        ctx.registerSingleton("viewResolver", FreeMarkerViewResolver.class, mpv);
        ctx.registerSingleton("freeMarkerInputBootstrap", FreeMarkerInlineRenderBootstrap.class);
        ctx.refresh();
        ctx.start();
        sctx.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)ctx);
        webApplicationContext = ctx;
    }

    public static Properties getConfigProperties() {
        return TL_CONFIG_PROPERTIES.get();
    }

    public static WebApplicationContext getWebApplicationContext() {
        return webApplicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void establishMockConfig(String applicationId) throws Exception {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            SimpleConfig config = new SimpleConfig();
            Properties configProperties = new Properties();
            URL defaultsUrl = loader.getResource("KRAD-UifDefaults.properties");
            URL rootUrl = new URL(defaultsUrl.toExternalForm().substring(0, defaultsUrl.toExternalForm().lastIndexOf(47)));
            configProperties.setProperty("root.url", rootUrl.toExternalForm());
            InputStream defaultPropertyResource = defaultsUrl.openStream();
            Assert.assertNotNull((String)"KRAD-UifDefaults.properties", (Object)defaultPropertyResource);
            configProperties.load(defaultPropertyResource);
            InputStream appPropertyResource = loader.getResourceAsStream(applicationId + ".properties");
            Assert.assertNotNull((String)(applicationId + ".properties"), (Object)appPropertyResource);
            configProperties.load(appPropertyResource);
            for (String string : configProperties.stringPropertyNames()) {
                String propValue = configProperties.getProperty(string);
                StringBuilder propBuilder = new StringBuilder(propValue);
                int exprStart = 0;
                int exprEnd = 0;
                while (exprStart != -1) {
                    String expr;
                    String exprValue;
                    exprStart = propBuilder.indexOf("${", exprEnd);
                    if (exprStart == -1 || (exprEnd = propBuilder.indexOf("}", exprStart)) - exprStart < 3 || (exprValue = configProperties.getProperty(expr = propBuilder.substring(exprStart + 2, exprEnd))) == null) continue;
                    propBuilder.delete(exprStart, exprEnd + 1);
                    propBuilder.insert(exprStart, exprValue);
                    configProperties.setProperty(string, propBuilder.toString());
                    exprEnd = exprStart + exprValue.length();
                }
            }
            String resourceBundles = configProperties.getProperty("test.resource.bundles");
            if (resourceBundles != null) {
                for (String resourceBundle : resourceBundles.split(",")) {
                    InputStream propertyResource = loader.getResourceAsStream(resourceBundle);
                    Assert.assertNotNull((String)resourceBundle, (Object)resourceBundle);
                    configProperties.load(propertyResource);
                    LOG.info((Object)("Added resource bundle " + resourceBundle));
                }
            }
            config.putProperties(configProperties);
            config.putProperty("application.id", applicationId);
            ConfigContext.init((Config)config);
            MockServletContext mockServletContext = new MockServletContext();
            GlobalResourceLoader.addResourceLoader((ResourceLoader)new SpringResourceLoader(new QName("KRAD-UifDefaults"), Arrays.asList("KRAD-UifDefaults-test-context.xml"), (ServletContext)mockServletContext));
            GlobalResourceLoader.addResourceLoader((ResourceLoader)new SpringResourceLoader(new QName(applicationId), Arrays.asList(applicationId + "-test-context.xml"), (ServletContext)mockServletContext));
            TL_CONFIG_PROPERTIES.set(ConfigContext.getCurrentContextConfig().getProperties());
            try {
                GlobalResourceLoader.start();
                Lifecycle viewService = (Lifecycle)GlobalResourceLoader.getService((String)"viewService");
                if (viewService != null) {
                    viewService.start();
                }
            }
            finally {
                TL_CONFIG_PROPERTIES.remove();
            }
            UifUnitTestUtils.configureKradWebApplicationContext();
        }
        catch (Throwable t) {
            LOG.error((Object)"Skipping tests, resource setup failed", t);
            Assume.assumeNoException((String)"Skipping tests, resource setup failed", (Throwable)t);
        }
    }

    public static void tearDownMockConfig() throws Exception {
        GlobalResourceLoader.stop();
    }

    public static void establishMockUserSession(String principalName) {
        UserSession session = new UserSession(principalName);
        GlobalVariables.setUserSession((UserSession)session);
    }

    public static void tearDownMockUserSession() {
        GlobalVariables.setUserSession(null);
        GlobalVariables.clear();
    }

    public static ViewAuthorizer getAllowMostViewAuthorizer() {
        return new MockViewAuthorizer();
    }
}

