/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.widget;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.datadictionary.Copyable;
import org.kuali.rice.krad.datadictionary.validation.Employee;
import org.kuali.rice.krad.lookup.LookupView;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.CollectionGroupBase;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.GroupBase;
import org.kuali.rice.krad.uif.field.DataFieldBase;
import org.kuali.rice.krad.uif.field.InputFieldBase;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.layout.TableLayoutManager;
import org.kuali.rice.krad.uif.layout.TableLayoutManagerBase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.UifUnitTestUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.RichTable;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.mockito.Mockito;

public class RichTableTest {
    public static final String S_TYPE = "{\"bSortable\": false,\"sType\": \"numeric\",\"sSortDataType\": \"dom-text\",\"aTargets\": [0]}";
    public static final String S_SORT_DATA_TARGETS_1 = "{\"sType\": \"string\",\"sSortDataType\": \"dom-text\",\"aTargets\": [1]}";
    public static final String S_SORT_DATA_TARGETS_2 = "{\"sType\": \"string\",\"sSortDataType\": \"dom-text\",\"aTargets\": [1]}".replace("1", "2");
    public static final String S_SORT_DATA_TARGETS_3 = "{\"sType\": \"string\",\"sSortDataType\": \"dom-text\",\"aTargets\": [1]}".replace("1", "3");
    public static final String EXPECTED = "{\"bSortable\": false,\"sType\": \"numeric\",\"sSortDataType\": \"dom-text\",\"aTargets\": [0]},{\"sType\": \"string\",\"sSortDataType\": \"dom-text\",\"aTargets\": [1]}," + S_SORT_DATA_TARGETS_2 + "," + S_SORT_DATA_TARGETS_3;
    public static final String B_VISIBLE_FALSE_TARGETS_1 = "{\"bVisible\": false,\"aTargets\": [1]}";
    public static final String B_SORTABLE_FALSE_TARGETS_3 = "{\"bSortable\": false,\"aTargets\": [3]}";
    private RichTable richTable;
    private CollectionGroup group;
    private LookupView mockView;

    @BeforeClass
    public static void setUpClass() throws Throwable {
        UifUnitTestUtils.establishMockConfig("KRAD-RichTableTest");
    }

    @AfterClass
    public static void tearDownClass() throws Throwable {
        GlobalResourceLoader.stop();
    }

    @Before
    public void setup() throws Throwable {
        this.richTable = new RichTable();
        this.richTable = (RichTable)Mockito.spy((Object)this.richTable);
        ConfigurationService configurationService = (ConfigurationService)Mockito.mock(ConfigurationService.class);
        ((RichTable)Mockito.doReturn((Object)configurationService).when((Object)this.richTable)).getConfigurationService();
        this.group = new CollectionGroupBase();
        this.group.setCollectionObjectClass(Employee.class);
        TableLayoutManagerBase layoutManager = new TableLayoutManagerBase();
        layoutManager.setRenderSequenceField(true);
        ArrayList<DataFieldBase> items = new ArrayList<DataFieldBase>(1);
        DataFieldBase name = new DataFieldBase();
        name.setPropertyName("employeeId");
        items.add(name);
        DataFieldBase number = new DataFieldBase();
        number.setPropertyName("positionTitle");
        items.add(number);
        DataFieldBase contactEmail = new DataFieldBase();
        contactEmail.setPropertyName("contactEmail");
        items.add(contactEmail);
        layoutManager = (TableLayoutManager)Mockito.spy((Object)layoutManager);
        ((TableLayoutManager)Mockito.doReturn(items).when((Object)layoutManager)).getFirstRowFields();
        ((TableLayoutManager)Mockito.doReturn((Object)layoutManager).when((Object)layoutManager)).clone();
        this.group.setLayoutManager((LayoutManager)layoutManager);
        this.group.setIncludeLineSelectionField(false);
        this.group.setRenderLineActions(false);
        this.group.setItems(items);
        this.mockView = (LookupView)Mockito.mock(LookupView.class);
        ViewHelperService mockViewHelperService = (ViewHelperService)Mockito.mock(ViewHelperService.class);
        Mockito.when((Object)this.mockView.getViewHelperService()).thenReturn((Object)mockViewHelperService);
        Mockito.when((Object)this.mockView.clone()).thenReturn((Object)this.mockView);
    }

    @Test
    public void testComponentOptionsDefault() throws Exception {
        this.assertRichTableComponentOptions(null, "[" + EXPECTED + "]", "aoColumnDefs");
    }

    @Test
    public void testComponentOptionsAoColumnsJSOptions() throws Exception {
        String innerColValues = "{bVisible: false}, null, null";
        this.assertRichTableComponentOptions("[" + innerColValues + "]", "[" + EXPECTED + "," + innerColValues + "]", "aoColumnDefs");
    }

    @Test
    public void testComponentOptionsHideColumnOnRichTable() {
        HashSet<String> hiddenColumns = new HashSet<String>();
        hiddenColumns.add("employeeId");
        HashSet<String> sortableColumns = new HashSet<String>();
        sortableColumns.add("positionTitle");
        this.richTable.setSortableColumns(sortableColumns);
        this.richTable.setHiddenColumns(hiddenColumns);
        String expected = "[{\"bSortable\": false,\"sType\": \"numeric\",\"sSortDataType\": \"dom-text\",\"aTargets\": [0]},{\"bVisible\": false,\"aTargets\": [1]}," + S_SORT_DATA_TARGETS_2 + "," + B_SORTABLE_FALSE_TARGETS_3 + "]";
        this.assertRichTableComponentOptions(null, expected, "aoColumnDefs");
    }

    @Test
    public void testComponentOptionsHideColumnOnLayoutManager() {
        HashSet<String> richTableHiddenColumns = new HashSet<String>();
        richTableHiddenColumns.add("employeeId");
        HashSet<String> sortableColumns = new HashSet<String>();
        sortableColumns.add("positionTitle");
        this.richTable.setSortableColumns(sortableColumns);
        this.richTable.setHiddenColumns(richTableHiddenColumns);
        HashSet<String> lmHiddenColumns = new HashSet<String>();
        lmHiddenColumns.add("contactEmail");
        HashSet<String> lmSortableColumns = new HashSet<String>();
        lmSortableColumns.add("employeeId");
        ((TableLayoutManager)this.group.getLayoutManager()).setSortableColumns(lmSortableColumns);
        ((TableLayoutManager)this.group.getLayoutManager()).setHiddenColumns(lmHiddenColumns);
        String expected = "[" + EXPECTED.replace("{\"sType\": \"string\",\"sSortDataType\": \"dom-text\",\"aTargets\": [1]},", "{\"bVisible\": false,\"aTargets\": [1]},") + "]";
        expected = expected.replace(S_SORT_DATA_TARGETS_3, B_SORTABLE_FALSE_TARGETS_3);
        this.assertRichTableComponentOptions(null, expected, "aoColumnDefs");
    }

    @Test
    public void testComponentOptionsDefaultSort() {
        Mockito.when((Object)this.mockView.isDefaultSortAscending()).thenReturn((Object)false);
        Mockito.when((Object)this.mockView.getDefaultSortAttributeNames()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"employeeId", "contactEmail"}));
        String expected = "[[1,'desc'],[3,'desc']]";
        this.assertRichTableComponentOptions(null, expected, "aaSorting");
    }

    @Test
    public void testComponentOptionsDefaultSortReverse() {
        Mockito.when((Object)this.mockView.isDefaultSortAscending()).thenReturn((Object)false);
        Mockito.when((Object)this.mockView.getDefaultSortAttributeNames()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"contactEmail", "employeeId"}));
        String expected = "[[3,'desc'],[1,'desc']]";
        this.assertRichTableComponentOptions(null, expected, "aaSorting");
    }

    @Test
    public void testComponentOptionsDefaultSortWithoutSequence() {
        Mockito.when((Object)this.mockView.isDefaultSortAscending()).thenReturn((Object)false);
        Mockito.when((Object)this.mockView.getDefaultSortAttributeNames()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"employeeId", "contactEmail"}));
        ((TableLayoutManager)this.group.getLayoutManager()).setRenderSequenceField(false);
        String expected = "[[0,'desc'],[2,'desc']]";
        this.assertRichTableComponentOptions(null, expected, "aaSorting");
    }

    @Test
    public void testComponentOptionsDefaultSortWithDetails() {
        Mockito.when((Object)this.mockView.isDefaultSortAscending()).thenReturn((Object)false);
        Mockito.when((Object)this.mockView.getDefaultSortAttributeNames()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"employeeId", "contactEmail"}));
        GroupBase rowDetailsGroup = new GroupBase();
        rowDetailsGroup.setItems((List)Lists.newArrayList((Object[])new InputFieldBase[]{new InputFieldBase()}));
        ((TableLayoutManager)this.group.getLayoutManager()).setRowDetailsGroup((Group)rowDetailsGroup);
        String expected = "[[2,'desc'],[4,'desc']]";
        this.assertRichTableComponentOptions(null, expected, "aaSorting");
    }

    @Test
    public void testComponentOptionsDefaultSortWithActionLeft() {
        Mockito.when((Object)this.mockView.isDefaultSortAscending()).thenReturn((Object)false);
        Mockito.when((Object)this.mockView.getDefaultSortAttributeNames()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"employeeId", "contactEmail"}));
        this.group.setRenderLineActions(true);
        ((TableLayoutManager)this.group.getLayoutManager()).setActionColumnPlacement("LEFT");
        String expected = "[[2,'desc'],[4,'desc']]";
        this.assertRichTableComponentOptions(null, expected, "aaSorting");
    }

    @Test
    public void testComponentOptionsDefaultSortWithActionRight() {
        Mockito.when((Object)this.mockView.isDefaultSortAscending()).thenReturn((Object)false);
        Mockito.when((Object)this.mockView.getDefaultSortAttributeNames()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"employeeId", "contactEmail"}));
        this.group.setRenderLineActions(true);
        ((TableLayoutManager)this.group.getLayoutManager()).setActionColumnPlacement("RIGHT");
        String expected = "[[1,'desc'],[3,'desc']]";
        this.assertRichTableComponentOptions(null, expected, "aaSorting");
    }

    @Test
    public void testComponentOptionsDefaultSortWithMultipleColumns() {
        Mockito.when((Object)this.mockView.isDefaultSortAscending()).thenReturn((Object)false);
        Mockito.when((Object)this.mockView.getDefaultSortAttributeNames()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"employeeId", "contactEmail"}));
        GroupBase rowDetailsGroup = new GroupBase();
        rowDetailsGroup.setItems((List)Lists.newArrayList((Object[])new InputFieldBase[]{new InputFieldBase()}));
        ((TableLayoutManager)this.group.getLayoutManager()).setRowDetailsGroup((Group)rowDetailsGroup);
        this.group.setRenderLineActions(true);
        ((TableLayoutManager)this.group.getLayoutManager()).setActionColumnPlacement("LEFT");
        String expected = "[[3,'desc'],[5,'desc']]";
        this.assertRichTableComponentOptions(null, expected, "aaSorting");
    }

    @Test
    public void testComponentOptionsDefaultSortWithActionMiddle() {
        Mockito.when((Object)this.mockView.isDefaultSortAscending()).thenReturn((Object)false);
        Mockito.when((Object)this.mockView.getDefaultSortAttributeNames()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"employeeId", "contactEmail"}));
        this.group.setRenderLineActions(true);
        ((TableLayoutManager)this.group.getLayoutManager()).setActionColumnPlacement("4");
        String expected = "[[1,'desc'],[4,'desc']]";
        this.assertRichTableComponentOptions(null, expected, "aaSorting");
    }

    private void assertRichTableComponentOptions(String optionsOnGroup, final String optionsOnRichTable, final String optionKey) {
        HashMap<String, String> templateOptions = this.richTable.getTemplateOptions();
        templateOptions = templateOptions == null ? new HashMap<String, String>() : new HashMap(templateOptions);
        templateOptions.put(optionKey, optionsOnGroup);
        this.richTable.setTemplateOptions(templateOptions);
        ViewLifecycle.encapsulateLifecycle((View)this.mockView, null, null, (Runnable)new Runnable(){

            @Override
            public void run() {
                RichTable mutableRichTable = (RichTable)RichTableTest.this.richTable.copy();
                mutableRichTable.performFinalize((Object)new UifFormBase(), (LifecycleElement)((Group)CopyUtils.copy((Copyable)RichTableTest.this.group)));
                Assert.assertEquals((Object)optionsOnRichTable, mutableRichTable.getTemplateOptions().get(optionKey));
            }
        });
    }
}

