/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DictionaryBeanProcessor;
import org.kuali.rice.krad.datadictionary.MessageBeanProcessor;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedArray;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;

public class DictionaryBeanFactoryPostProcessor {
    private static final Log LOG = LogFactory.getLog(DictionaryBeanFactoryPostProcessor.class);
    private DataDictionary dataDictionary;
    private ConfigurableListableBeanFactory beanFactory;
    private List<DictionaryBeanProcessor> beanProcessors;

    public DictionaryBeanFactoryPostProcessor(DataDictionary dataDictionary, ConfigurableListableBeanFactory beanFactory) {
        this.dataDictionary = dataDictionary;
        this.beanFactory = beanFactory;
        this.beanProcessors = new ArrayList<DictionaryBeanProcessor>();
        this.beanProcessors.add(new MessageBeanProcessor(dataDictionary, beanFactory));
    }

    public void postProcessBeanFactory() throws BeansException {
        boolean loadExternalMessages = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsBoolean("load.dictionary.external.messages");
        if (!loadExternalMessages) {
            return;
        }
        LOG.info((Object)"Beginning dictionary bean post processing");
        ArrayList<MessageBeanProcessor> beanProcessors = new ArrayList<MessageBeanProcessor>();
        beanProcessors.add(new MessageBeanProcessor(this.dataDictionary, this.beanFactory));
        String[] beanNames = this.beanFactory.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            String beanName = beanNames[i];
            BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(beanName);
            this.processRootBeanDefinition(beanName, beanDefinition);
        }
        LOG.info((Object)"Finished dictionary bean post processing");
    }

    protected void processRootBeanDefinition(String beanName, BeanDefinition beanDefinition) {
        for (DictionaryBeanProcessor beanProcessor : this.beanProcessors) {
            beanProcessor.processRootBeanDefinition(beanName, beanDefinition);
        }
        Stack<BeanDefinitionHolder> nestedBeanStack = new Stack<BeanDefinitionHolder>();
        nestedBeanStack.push(new BeanDefinitionHolder(beanDefinition, beanName));
        this.processBeanProperties(beanDefinition, nestedBeanStack);
    }

    public void processNestedBeanDefinition(String beanName, BeanDefinition beanDefinition, String nestedPropertyPath, boolean isCollectionBean, Stack<BeanDefinitionHolder> nestedBeanStack) {
        if (StringUtils.isNotBlank((String)beanName) && !StringUtils.contains((String)beanName, (String)"$") && !StringUtils.contains((String)beanName, (String)"#") && !this.beanFactory.containsBean(beanName)) {
            ((BeanDefinitionRegistry)this.beanFactory).registerBeanDefinition(beanName, beanDefinition);
        }
        for (DictionaryBeanProcessor beanProcessor : this.beanProcessors) {
            if (isCollectionBean) {
                beanProcessor.processCollectionBeanDefinition(beanName, beanDefinition, nestedPropertyPath, nestedBeanStack);
                continue;
            }
            beanProcessor.processNestedBeanDefinition(beanName, beanDefinition, nestedPropertyPath, nestedBeanStack);
        }
        BeanDefinitionHolder nestedBeanDefinitionHolder = new BeanDefinitionHolder(beanDefinition, beanName);
        nestedBeanStack.push(nestedBeanDefinitionHolder);
        this.processBeanProperties(beanDefinition, nestedBeanStack);
        nestedBeanStack.pop();
    }

    protected String processStringPropertyValue(String propertyName, String propertyValue, Stack<BeanDefinitionHolder> nestedBeanStack) {
        String processedStringValue = propertyValue;
        for (DictionaryBeanProcessor beanProcessor : this.beanProcessors) {
            processedStringValue = beanProcessor.processStringPropertyValue(propertyName, processedStringValue, nestedBeanStack);
        }
        return processedStringValue;
    }

    protected String processArrayStringPropertyValue(String propertyName, Object[] propertyValue, String elementValue, int elementIndex, Stack<BeanDefinitionHolder> nestedBeanStack, List<DictionaryBeanProcessor> beanProcessors) {
        String processedStringValue = elementValue;
        for (DictionaryBeanProcessor beanProcessor : beanProcessors) {
            processedStringValue = beanProcessor.processArrayStringPropertyValue(propertyName, propertyValue, elementValue, elementIndex, nestedBeanStack);
        }
        return processedStringValue;
    }

    protected String processListStringPropertyValue(String propertyName, List<?> propertyValue, String elementValue, int elementIndex, Stack<BeanDefinitionHolder> nestedBeanStack, List<DictionaryBeanProcessor> beanProcessors) {
        String processedStringValue = elementValue;
        for (DictionaryBeanProcessor beanProcessor : beanProcessors) {
            processedStringValue = beanProcessor.processListStringPropertyValue(propertyName, propertyValue, elementValue, elementIndex, nestedBeanStack);
        }
        return processedStringValue;
    }

    protected String processSetStringPropertyValue(String propertyName, Set<?> propertyValue, String elementValue, Stack<BeanDefinitionHolder> nestedBeanStack, List<DictionaryBeanProcessor> beanProcessors) {
        String processedStringValue = elementValue;
        for (DictionaryBeanProcessor beanProcessor : beanProcessors) {
            processedStringValue = beanProcessor.processSetStringPropertyValue(propertyName, propertyValue, elementValue, nestedBeanStack);
        }
        return processedStringValue;
    }

    protected String processMapStringPropertyValue(String propertyName, Map<?, ?> propertyValue, String elementValue, Object elementKey, Stack<BeanDefinitionHolder> nestedBeanStack, List<DictionaryBeanProcessor> beanProcessors) {
        String processedStringValue = elementValue;
        for (DictionaryBeanProcessor beanProcessor : beanProcessors) {
            processedStringValue = beanProcessor.processMapStringPropertyValue(propertyName, propertyValue, elementValue, elementKey, nestedBeanStack);
        }
        return processedStringValue;
    }

    protected void processBeanProperties(BeanDefinition beanDefinition, Stack<BeanDefinitionHolder> nestedBeanStack) {
        PropertyValue[] pvArray;
        MutablePropertyValues pvs = beanDefinition.getPropertyValues();
        for (PropertyValue pv : pvArray = pvs.getPropertyValues()) {
            Object newPropertyValue = null;
            newPropertyValue = this.isStringValue(pv.getValue()) ? this.processStringPropertyValue(pv.getName(), this.getString(pv.getValue()), nestedBeanStack) : this.visitPropertyValue(pv.getName(), pv.getValue(), nestedBeanStack);
            pvs.removePropertyValue(pv.getName());
            pvs.addPropertyValue(pv.getName(), newPropertyValue);
        }
    }

    protected Object visitPropertyValue(String propertyName, Object propertyValue, Stack<BeanDefinitionHolder> nestedBeanStack) {
        if (this.isBeanDefinitionValue(propertyValue)) {
            String beanName = this.getBeanName(propertyValue);
            BeanDefinition beanDefinition = this.getBeanDefinition(propertyValue);
            this.processNestedBeanDefinition(beanName, beanDefinition, propertyName, false, nestedBeanStack);
        } else if (this.isCollectionValue(propertyValue)) {
            this.visitCollection(propertyValue, propertyName, nestedBeanStack);
        }
        return propertyValue;
    }

    protected void visitCollection(Object value, String propertyName, Stack<BeanDefinitionHolder> nestedBeanStack) {
        if (value instanceof Object[] || value instanceof ManagedArray) {
            this.visitArray(value, propertyName, nestedBeanStack);
        } else if (value instanceof List) {
            this.visitList((List)value, propertyName, nestedBeanStack);
        } else if (value instanceof Set) {
            this.visitSet((Set)value, propertyName, nestedBeanStack);
        } else if (value instanceof Map) {
            this.visitMap((Map)value, propertyName, nestedBeanStack);
        }
    }

    protected void visitArray(Object array, String propertyName, Stack<BeanDefinitionHolder> nestedBeanStack) {
        Object[] arrayVal = null;
        arrayVal = array instanceof ManagedArray ? (Object[])((ManagedArray)array).getSource() : (Object[])array;
        Object[] newArray = new Object[arrayVal.length];
        for (int i = 0; i < arrayVal.length; ++i) {
            Object elem = arrayVal[i];
            elem = this.isStringValue(elem) ? this.processArrayStringPropertyValue(propertyName, arrayVal, this.getString(elem), i, nestedBeanStack, this.beanProcessors) : this.visitPropertyValue(propertyName, elem, nestedBeanStack);
            newArray[i] = elem;
        }
        if (array instanceof ManagedArray) {
            ((ManagedArray)array).setSource((Object)newArray);
        } else {
            array = newArray;
        }
    }

    protected void visitList(List<?> listVal, String propertyName, Stack<BeanDefinitionHolder> nestedBeanStack) {
        boolean isMergeEnabled = false;
        if (listVal instanceof ManagedList) {
            isMergeEnabled = ((ManagedList)listVal).isMergeEnabled();
        }
        ManagedList newList = new ManagedList();
        newList.setMergeEnabled(isMergeEnabled);
        for (int i = 0; i < listVal.size(); ++i) {
            Object elem = listVal.get(i);
            elem = this.isStringValue(elem) ? this.processListStringPropertyValue(propertyName, listVal, this.getString(elem), i, nestedBeanStack, this.beanProcessors) : this.visitPropertyValue(propertyName, elem, nestedBeanStack);
            newList.add(i, elem);
        }
        listVal.clear();
        listVal.addAll((Collection<?>)newList);
    }

    protected void visitSet(Set setVal, String propertyName, Stack<BeanDefinitionHolder> nestedBeanStack) {
        boolean isMergeEnabled = false;
        if (setVal instanceof ManagedSet) {
            isMergeEnabled = ((ManagedSet)setVal).isMergeEnabled();
        }
        ManagedSet newSet = new ManagedSet();
        newSet.setMergeEnabled(isMergeEnabled);
        for (Object elem : setVal) {
            elem = this.isStringValue(elem) ? this.processSetStringPropertyValue(propertyName, setVal, this.getString(elem), nestedBeanStack, this.beanProcessors) : this.visitPropertyValue(propertyName, elem, nestedBeanStack);
            newSet.add(elem);
        }
        setVal.clear();
        setVal.addAll(newSet);
    }

    protected void visitMap(Map<?, ?> mapVal, String propertyName, Stack<BeanDefinitionHolder> nestedBeanStack) {
        boolean isMergeEnabled = false;
        if (mapVal instanceof ManagedMap) {
            isMergeEnabled = ((ManagedMap)mapVal).isMergeEnabled();
        }
        ManagedMap newMap = new ManagedMap();
        newMap.setMergeEnabled(isMergeEnabled);
        for (Map.Entry<?, ?> entry : mapVal.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            val = this.isStringValue(val) ? this.processMapStringPropertyValue(propertyName, mapVal, this.getString(val), key, nestedBeanStack, this.beanProcessors) : this.visitPropertyValue(propertyName, val, nestedBeanStack);
            newMap.put(key, val);
        }
        mapVal.clear();
        mapVal.putAll((Map<?, ?>)newMap);
    }

    protected boolean isStringValue(Object value) {
        boolean isString = false;
        if (value instanceof TypedStringValue || value instanceof String) {
            isString = true;
        }
        return isString;
    }

    protected String getString(Object value) {
        String stringValue = null;
        if (value instanceof TypedStringValue || value instanceof String) {
            if (value instanceof TypedStringValue) {
                TypedStringValue typedStringValue = (TypedStringValue)value;
                stringValue = typedStringValue.getValue();
            } else {
                stringValue = (String)value;
            }
        }
        return stringValue;
    }

    protected boolean isBeanDefinitionValue(Object value) {
        boolean isBean = false;
        if (value instanceof BeanDefinition || value instanceof BeanDefinitionHolder) {
            isBean = true;
        }
        return isBean;
    }

    protected BeanDefinition getBeanDefinition(Object value) {
        BeanDefinition beanDefinition = null;
        if (value instanceof BeanDefinition || value instanceof BeanDefinitionHolder) {
            beanDefinition = value instanceof BeanDefinition ? (BeanDefinition)value : ((BeanDefinitionHolder)value).getBeanDefinition();
        }
        return beanDefinition;
    }

    protected String getBeanName(Object value) {
        String beanName = null;
        if (value instanceof BeanDefinitionHolder) {
            beanName = ((BeanDefinitionHolder)value).getBeanName();
        }
        return beanName;
    }

    protected boolean isCollectionValue(Object value) {
        boolean isCollection = false;
        if (value instanceof Object[] || value instanceof ManagedArray || value instanceof List || value instanceof Set || value instanceof Map) {
            isCollection = true;
        }
        return isCollection;
    }

    protected DataDictionaryService getDataDictionaryService() {
        return KRADServiceLocatorWeb.getDataDictionaryService();
    }
}

