/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.krad.datadictionary.validator.ValidationController;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.freemarker.LifecycleRenderingContext;
import org.kuali.rice.krad.uif.lifecycle.AsynchronousViewLifecycleProcessor;
import org.kuali.rice.krad.uif.lifecycle.ComponentPostMetadata;
import org.kuali.rice.krad.uif.lifecycle.LifecycleEventListener;
import org.kuali.rice.krad.uif.lifecycle.SynchronousViewLifecycleProcessor;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleBuild;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePreProcessBuild;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleProcessor;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.DefaultExpressionEvaluator;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.ExpressionEvaluatorFactory;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.web.form.UifFormBase;

public class ViewLifecycle
implements Serializable {
    private static Logger LOG = Logger.getLogger(ViewLifecycle.class);
    private static final long serialVersionUID = -4767600614111642241L;
    private static final ThreadLocal<ViewLifecycleProcessor> PROCESSOR = new ThreadLocal();
    private static Boolean strict;
    private static Boolean renderInLifecycle;
    private static Boolean trace;
    private final List<EventRegistration> eventRegistrations;
    private final View view;
    private final ComponentPostMetadata refreshComponentPostMetadata;
    final ViewHelperService helper;
    final Object model;
    final HttpServletRequest request;
    private ViewPostMetadata viewPostMetadata;
    private Set<String> visitedIds;
    private static String refreshComponentId;

    private ViewLifecycle(View view, Object model, ComponentPostMetadata refreshComponentPostMetadata, HttpServletRequest request) {
        this.view = view;
        this.model = model;
        this.request = request;
        this.refreshComponentPostMetadata = refreshComponentPostMetadata;
        this.helper = view.getViewHelperService();
        this.eventRegistrations = new ArrayList<EventRegistration>();
    }

    public static void encapsulateLifecycle(View view, Object model, HttpServletRequest request, Runnable lifecycleProcess) {
        ViewLifecycle.encapsulateLifecycle(view, model, null, null, request, lifecycleProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encapsulateLifecycle(View view, Object model, ViewPostMetadata viewPostMetadata, ComponentPostMetadata refreshComponentPostMetadata, HttpServletRequest request, Runnable lifecycleProcess) {
        ViewLifecycleProcessor processor = PROCESSOR.get();
        if (processor != null) {
            throw new IllegalStateException("Another lifecycle is already active on this thread");
        }
        try {
            ViewLifecycle viewLifecycle = new ViewLifecycle(view, model, refreshComponentPostMetadata, request);
            processor = ViewLifecycle.isAsynchronousLifecycle() ? new AsynchronousViewLifecycleProcessor(viewLifecycle) : new SynchronousViewLifecycleProcessor(viewLifecycle);
            PROCESSOR.set(processor);
            if (viewPostMetadata != null) {
                viewLifecycle.viewPostMetadata = viewPostMetadata;
            }
            lifecycleProcess.run();
        }
        finally {
            PROCESSOR.remove();
        }
    }

    public static void preProcess(View view) {
        ViewLifecycle.encapsulateLifecycle(view, null, null, new ViewLifecyclePreProcessBuild());
    }

    public static ViewPostMetadata buildView(View view, Object model, HttpServletRequest request, Map<String, String> parameters) {
        ViewPostMetadata postMetadata = new ViewPostMetadata(view.getId());
        ViewLifecycle.encapsulateLifecycle(view, model, postMetadata, null, request, new ViewLifecycleBuild(parameters, null));
        if (CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsBoolean("validate.views.onbuild")) {
            ValidationController validator = new ValidationController(true, true, true, true, false);
            Log tempLogger = LogFactory.getLog(ViewLifecycle.class);
            validator.validate(view, tempLogger, false);
        }
        return postMetadata;
    }

    public static Component performComponentLifecycle(View view, Object model, HttpServletRequest request, ViewPostMetadata viewPostMetadata, String componentId) {
        ComponentPostMetadata rootComponentPostMetadata;
        String rootPath;
        if (viewPostMetadata == null) {
            UifFormBase form = (UifFormBase)model;
            throw new RuntimeException("View post metadata is null which cannot occur for refresh. Form id: " + form.getFormKey() + ", requested form id: " + form.getRequestedFormKey());
        }
        refreshComponentId = componentId;
        ComponentPostMetadata componentPostMetadata = viewPostMetadata.getComponentPostMetadata(componentId);
        boolean componentPostMetadataInitialized = false;
        if (componentPostMetadata == null) {
            componentPostMetadata = viewPostMetadata.initializeComponentPostMetadata(componentId);
            componentPostMetadataInitialized = true;
        }
        if ((rootPath = componentPostMetadata.getRootObjectPath()) != null && !rootPath.equals(componentPostMetadata.getPath()) && (rootComponentPostMetadata = viewPostMetadata.getComponentPostMetadataForPath(rootPath)) != null && rootComponentPostMetadata.isDetachedComponent()) {
            ViewLifecycle.setupStandaloneComponentForRefresh(view, rootComponentPostMetadata.getId(), rootComponentPostMetadata);
        }
        if (componentPostMetadataInitialized || componentPostMetadata.isDetachedComponent()) {
            ViewLifecycle.setupStandaloneComponentForRefresh(view, componentId, componentPostMetadata);
        }
        Map<String, List<String>> refreshPathMappings = componentPostMetadata.getRefreshPathMappings();
        ViewLifecycle.encapsulateLifecycle(view, model, viewPostMetadata, componentPostMetadata, request, new ViewLifecycleBuild(null, refreshPathMappings));
        return (Component)ObjectPropertyUtils.getPropertyValue(view, componentPostMetadata.getPath());
    }

    protected static void setupStandaloneComponentForRefresh(View view, String componentId, ComponentPostMetadata componentPostMetadata) {
        Component refreshComponent = (Component)KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryBean(componentId);
        if (refreshComponent == null || !(refreshComponent instanceof Group)) {
            throw new RuntimeException("Refresh component was null or not a group instance");
        }
        ArrayList<Group> dialogs = new ArrayList<Group>();
        if (view.getDialogs() != null && !view.getDialogs().isEmpty()) {
            dialogs.addAll(view.getDialogs());
        }
        refreshComponent.addDataAttribute("detached", "true");
        dialogs.add((Group)refreshComponent);
        view.setDialogs(dialogs);
        String refreshPath = "dialogs[" + (view.getDialogs().size() - 1) + "]";
        componentPostMetadata.setPath(refreshPath);
        ArrayList<String> refreshPaths = new ArrayList<String>();
        refreshPaths.add(refreshPath);
        HashMap<String, List<String>> refreshPathMappings = new HashMap<String, List<String>>();
        refreshPathMappings.put("INITIALIZE", refreshPaths);
        refreshPathMappings.put("APPLY_MODEL", refreshPaths);
        refreshPathMappings.put("FINALIZE", refreshPaths);
        componentPostMetadata.setRefreshPathMappings(refreshPathMappings);
        componentPostMetadata.setDetachedComponent(true);
    }

    public static boolean isRefreshComponent(String viewPhase, String viewPath) {
        if (!ViewLifecycle.isRefreshLifecycle()) {
            return false;
        }
        return StringUtils.equals((String)ViewLifecycle.getRefreshComponentPhasePath(viewPhase), (String)viewPath);
    }

    public static String getRefreshComponentPhasePath(String viewPhase) {
        Map<String, String> phasePathMapping;
        if (!ViewLifecycle.isRefreshLifecycle()) {
            return null;
        }
        ComponentPostMetadata refreshComponentPostMetadata = ViewLifecycle.getRefreshComponentPostMetadata();
        if (refreshComponentPostMetadata == null) {
            return null;
        }
        String refreshPath = refreshComponentPostMetadata.getPath();
        if (refreshComponentPostMetadata.getPhasePathMapping() != null && (phasePathMapping = refreshComponentPostMetadata.getPhasePathMapping()).containsKey(viewPhase)) {
            refreshPath = phasePathMapping.get(viewPhase);
        }
        return refreshPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeEventListeners(LifecycleEvent event, View view, Object model, LifecycleElement eventElement) {
        List<EventRegistration> list = this.eventRegistrations;
        synchronized (list) {
            for (EventRegistration registration : this.eventRegistrations) {
                if (!registration.getEvent().equals((Object)event) || registration.getEventComponent() != eventElement) continue;
                registration.getEventListener().processEvent(event, view, model, eventElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLifecycleCompleteListener(Component eventComponent, LifecycleEventListener listenerComponent) {
        EventRegistration eventRegistration = new EventRegistration(LifecycleEvent.LIFECYCLE_COMPLETE, eventComponent, listenerComponent);
        List<EventRegistration> list = this.eventRegistrations;
        synchronized (list) {
            this.eventRegistrations.add(eventRegistration);
        }
    }

    public static boolean isStrict() {
        if (strict == null) {
            strict = ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.krad.lifecycle.strict", false);
        }
        return strict;
    }

    public static boolean isRenderInLifecycle() {
        if (renderInLifecycle == null) {
            renderInLifecycle = ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.krad.lifecycle.render", false);
        }
        return renderInLifecycle;
    }

    public static boolean isAsynchronousLifecycle() {
        Config config = ConfigContext.getCurrentContextConfig();
        return config != null && config.getBooleanProperty("rice.krad.lifecycle.asynchronous", false);
    }

    public static boolean isTrace() {
        if (trace == null) {
            Config config = ConfigContext.getCurrentContextConfig();
            if (config == null) {
                return false;
            }
            trace = config.getBooleanProperty("rice.krad.lifecycle.trace", false);
        }
        return trace;
    }

    public static void reportIllegalState(String message) {
        ViewLifecycle.reportIllegalState(message, null);
    }

    public static void reportIllegalState(String message, Throwable cause) {
        IllegalStateException illegalState = new IllegalStateException(message + "\nPhase: " + ViewLifecycle.getPhase(), cause);
        if (ViewLifecycle.isStrict()) {
            throw illegalState;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)illegalState.getMessage(), (Throwable)illegalState);
        }
    }

    public static ViewHelperService getHelper() {
        ViewLifecycle active = ViewLifecycle.getActiveLifecycle();
        if (active.helper == null) {
            throw new IllegalStateException("Context view helper is not available");
        }
        return active.helper;
    }

    public static View getView() {
        ViewLifecycle active = ViewLifecycle.getActiveLifecycle();
        if (active.view == null) {
            throw new IllegalStateException("Context view is not available");
        }
        return active.view;
    }

    public static ExpressionEvaluator getExpressionEvaluator() {
        ViewLifecycleProcessor processor = PROCESSOR.get();
        if (processor == null) {
            ExpressionEvaluatorFactory expressionEvaluatorFactory = KRADServiceLocatorWeb.getExpressionEvaluatorFactory();
            if (expressionEvaluatorFactory == null) {
                return new DefaultExpressionEvaluator();
            }
            return expressionEvaluatorFactory.createExpressionEvaluator();
        }
        return processor.getExpressionEvaluator();
    }

    public static Object getModel() {
        ViewLifecycle active = ViewLifecycle.getActiveLifecycle();
        if (active.model == null) {
            throw new IllegalStateException("Model is not available");
        }
        return active.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getVisitedIds() {
        ViewLifecycle active = ViewLifecycle.getActiveLifecycle();
        if (active.visitedIds == null) {
            ViewLifecycle viewLifecycle = active;
            synchronized (viewLifecycle) {
                if (active.visitedIds == null) {
                    active.visitedIds = Collections.synchronizedSet(new HashSet());
                }
            }
        }
        return active.visitedIds;
    }

    public static ViewPostMetadata getViewPostMetadata() {
        ViewLifecycle active = ViewLifecycle.getActiveLifecycle();
        if (active.model == null) {
            throw new IllegalStateException("Post Metadata is not available");
        }
        return active.viewPostMetadata;
    }

    public static ComponentPostMetadata getRefreshComponentPostMetadata() {
        ViewLifecycle active = ViewLifecycle.getActiveLifecycle();
        if (active == null) {
            throw new IllegalStateException("No lifecycle is active");
        }
        return active.refreshComponentPostMetadata;
    }

    public static boolean isRefreshLifecycle() {
        ViewLifecycle active = ViewLifecycle.getActiveLifecycle();
        if (active == null) {
            throw new IllegalStateException("No lifecycle is active");
        }
        return active.refreshComponentPostMetadata != null;
    }

    public static HttpServletRequest getRequest() {
        ViewLifecycle active = ViewLifecycle.getActiveLifecycle();
        if (active.model == null) {
            throw new IllegalStateException("Request is not available");
        }
        return active.request;
    }

    public static ViewLifecyclePhase getPhase() {
        ViewLifecycleProcessor processor = PROCESSOR.get();
        try {
            return processor == null ? null : processor.getActivePhase();
        }
        catch (IllegalStateException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No lifecycle phase is active on the current processor", (Throwable)e);
            }
            return null;
        }
    }

    public static LifecycleRenderingContext getRenderingContext() {
        ViewLifecycleProcessor processor = PROCESSOR.get();
        return processor == null ? null : processor.getRenderingContext();
    }

    public static ViewLifecycleProcessor getProcessor() {
        ViewLifecycleProcessor processor = PROCESSOR.get();
        if (processor == null) {
            throw new IllegalStateException("No view lifecycle is active on this thread");
        }
        return processor;
    }

    static void setProcessor(ViewLifecycleProcessor processor) {
        ViewLifecycleProcessor active = PROCESSOR.get();
        if (active != null && processor != null) {
            throw new IllegalStateException("Another lifecycle processor is already active on this thread");
        }
        if (processor == null) {
            PROCESSOR.remove();
        } else {
            PROCESSOR.set(processor);
        }
    }

    public static ViewLifecycle getActiveLifecycle() {
        return ViewLifecycle.getProcessor().getLifecycle();
    }

    public static boolean isActive() {
        return PROCESSOR.get() != null;
    }

    public static String getRefreshComponentId() {
        return refreshComponentId;
    }

    public static void setRefreshComponentId(String id) {
        refreshComponentId = id;
    }

    protected class EventRegistration
    implements Serializable {
        private static final long serialVersionUID = -5077429381388641016L;
        private LifecycleEvent event;
        private Component eventComponent;
        private LifecycleEventListener eventListener;

        private EventRegistration(LifecycleEvent event, Component eventComponent, LifecycleEventListener eventListener) {
            this.event = event;
            this.eventComponent = eventComponent;
            this.eventListener = eventListener;
        }

        public LifecycleEvent getEvent() {
            return this.event;
        }

        public Component getEventComponent() {
            return this.eventComponent;
        }

        public LifecycleEventListener getEventListener() {
            return this.eventListener;
        }

        public void setEvent(LifecycleEvent event) {
            this.event = event;
        }

        public void setEventComponent(Component eventComponent) {
            this.eventComponent = eventComponent;
        }

        public void setEventListener(LifecycleEventListener eventListener) {
            this.eventListener = eventListener;
        }
    }

    public static enum LifecycleEvent {
        LIFECYCLE_COMPLETE;

    }
}

